/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cms.jcajce;

import cn.topca.security.sm.CipherAgent;
import cn.topca.security.sm.SM2PrivateKey;
import com.itrus.cms.CMSEnvelopedAsymmetricDecryptor;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.RecipientId;

public class CMSEnvelopedSM2Decryptor
implements CMSEnvelopedAsymmetricDecryptor {
    private SM2PrivateKey privateKey;
    private X509Certificate certificate;

    public CMSEnvelopedSM2Decryptor(X509Certificate cert, SM2PrivateKey key) {
        this.privateKey = key;
        this.certificate = cert;
    }

    public boolean interested(RecipientId rid, AlgorithmIdentifier keyEncAlg) {
        return rid.match((Certificate)this.certificate);
    }

    public Key decrypt(byte[] encryptedKey, String keyAlgorithm) {
        byte[] keyBytes = null;
        try {
            CipherAgent cipher = CipherAgent.getInstance((String)"SM2");
            cipher.init(2, (Key)this.privateKey);
            cipher.update(encryptedKey);
            keyBytes = cipher.doFinal();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return new SecretKeySpec(keyBytes, keyAlgorithm);
    }
}

