/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cms.jcajce;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.operator.OperatorCreationException;

public class EasySignerInfoGenerator
extends SignerInfoGenerator {
    private X509Certificate _cert = null;
    private AlgorithmIdentifier _digestAlgId = null;
    private AlgorithmIdentifier _signatureAlgId = null;
    private byte[] _signature = null;

    public EasySignerInfoGenerator(X509Certificate cert, AlgorithmIdentifier digestAlgId, AlgorithmIdentifier signatureAlgId, byte[] signature) throws OperatorCreationException {
        super(null, null, null, true);
        this._cert = cert;
        this._digestAlgId = digestAlgId;
        this._signatureAlgId = signatureAlgId;
        this._signature = signature;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this._digestAlgId;
    }

    public OutputStream getCalculatingOutputStream() {
        return new ByteArrayOutputStream();
    }

    public SignerInfo generate(ASN1ObjectIdentifier asn1objectidentifier) throws CMSException {
        X500Name issuer = new X500Name(this._cert.getIssuerDN().toString());
        BigInteger serialNumber = this._cert.getSerialNumber();
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(issuer, serialNumber);
        return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), this._digestAlgId, null, this._signatureAlgId, (ASN1OctetString)new DEROctetString(this._signature), null);
    }
}

