/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cms.jcajce;

import cn.topca.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.operator.OperatorCreationException;

public class SM2SignerInfoGenerator
extends SignerInfoGenerator {
    private ByteArrayOutputStream _stream = null;
    private PrivateKey _key = null;
    private X509Certificate _cert = null;
    private AlgorithmIdentifier digestAlgId = null;
    private AlgorithmIdentifier signatureAlgId = null;

    public SM2SignerInfoGenerator(PrivateKey key, X509Certificate cert) throws OperatorCreationException {
        super(null, null, null, true);
        if (key == null || cert == null) {
            throw new OperatorCreationException("key and cert can not be null");
        }
        if (key.getAlgorithm() != cert.getPublicKey().getAlgorithm() || key.getAlgorithm() != "SM2") {
            throw new OperatorCreationException("Not a SM2 key or cert");
        }
        this._stream = new ByteArrayOutputStream();
        this._key = key;
        this._cert = cert;
        this.digestAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.SM3_oid.toString()));
        this.signatureAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.SM2_oid.toString()));
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgId;
    }

    public OutputStream getCalculatingOutputStream() {
        return this._stream;
    }

    public SignerInfo generate(ASN1ObjectIdentifier asn1objectidentifier) throws CMSException {
        try {
            Signature signature = Signature.getInstance("SM3withSM2");
            signature.initSign(this._key);
            signature.update(this._stream.toByteArray());
            byte[] abyte0 = signature.sign();
            X500Name issuer = new X500Name(this._cert.getIssuerDN().toString());
            BigInteger serialNumber = this._cert.getSerialNumber();
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(issuer, serialNumber);
            return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), this.digestAlgId, null, this.signatureAlgId, (ASN1OctetString)new DEROctetString(abyte0), null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("No Such Algorithm SM3withSM2", (Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("Invalid Key", (Exception)e);
        }
        catch (SignatureException e) {
            throw new CMSException("Calculate signature failed", (Exception)e);
        }
    }
}

