/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cryptorole;

import com.itrus.cert.X509Certificate;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WindowsCertStore {
    public static final int FindByIssuerDN = 0;
    public static final int FindBySerialNumber = 1;
    public static final int FindBySubjectDN = 2;
    public static final int FindByTimeValid = 3;
    public static final int FindByTimeNotYetValid = 4;
    public static final int FindByTimeExpired = 5;
    private String issuerDN = null;
    private String serialNumber = null;
    private String subjectDN = null;
    private Date time4Valid = null;
    private Date time4NotYetValid = null;
    private Date time4Expired = null;
    private Hashtable subjectAttrs = null;
    private KeyStore windowsKeyStore = null;

    public WindowsCertStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        if (this.windowsKeyStore == null) {
            this.windowsKeyStore = KeyStore.getInstance("Windows-MY");
        }
        this.windowsKeyStore.load(null, "123456".toCharArray());
        WindowsCertStore.fixAliases(this.windowsKeyStore);
    }

    public Provider getProvider() {
        if (this.windowsKeyStore != null) {
            return this.windowsKeyStore.getProvider();
        }
        return null;
    }

    public void setFilter(int findType, Object findValue) {
        switch (findType) {
            case 0: {
                this.issuerDN = (String)findValue;
                break;
            }
            case 1: {
                this.serialNumber = (String)findValue;
                break;
            }
            case 2: {
                this.subjectDN = (String)findValue;
                break;
            }
            case 3: {
                this.time4Valid = (Date)findValue;
                break;
            }
            case 4: {
                this.time4NotYetValid = (Date)findValue;
                break;
            }
            case 5: {
                this.time4Expired = (Date)findValue;
            }
        }
    }

    public void setSubjectAttrFilter(String attrName, String attrValue) {
        if (this.subjectAttrs == null) {
            this.subjectAttrs = new Hashtable();
        }
        this.subjectAttrs.put(attrName, attrValue);
    }

    public java.security.cert.X509Certificate getMyCertficates() throws Exception {
        Vector myCertficates = new Vector();
        Enumeration<String> aliases = this.windowsKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            java.security.cert.X509Certificate x509Cert = (java.security.cert.X509Certificate)this.windowsKeyStore.getCertificate(alias);
            System.out.println(x509Cert.getSubjectDN().getName());
        }
        return null;
    }

    public PrivateKey getPrivateKey(java.security.cert.X509Certificate x509Cert) throws CertificateEncodingException, CertificateException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        X509Certificate cert = X509Certificate.getInstance(x509Cert);
        String alias = cert.getIssuerDNString().concat("$").concat(cert.getHexSerialNumber());
        if (this.windowsKeyStore.isKeyEntry(alias)) {
            PrivateKey privateKey = (PrivateKey)this.windowsKeyStore.getKey(alias, null);
            return privateKey;
        }
        return null;
    }

    private static void fixAliases(KeyStore keyStore) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, CertificateEncodingException, CertificateException {
        Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
        field.setAccessible(true);
        KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
        if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreVeritable.getClass().getName())) {
            field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
            field.setAccessible(true);
            Collection entries = (Collection)field.get(keyStoreVeritable);
            for (Object entry : entries) {
                field = entry.getClass().getDeclaredField("certChain");
                field.setAccessible(true);
                java.security.cert.X509Certificate[] certificates = (java.security.cert.X509Certificate[])field.get(entry);
                X509Certificate cert = X509Certificate.getInstance(certificates[0]);
                field = entry.getClass().getDeclaredField("alias");
                field.setAccessible(true);
                field.set(entry, cert.getIssuerDNString().concat("$").concat(cert.getHexSerialNumber()));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        WindowsCertStore win = new WindowsCertStore();
        win.getMyCertficates();
    }
}

