/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cvm;

import com.itrus.cert.X509CRL;
import com.itrus.cvm.CRLContext;
import com.itrus.util.LdapUtils;
import com.itrus.util.RegexUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CRLDownloadThread
extends Thread {
    private static Log log = LogFactory.getLog((String)"ITRUS-CVM");
    private CRLContext m_CRLContext = null;

    public CRLDownloadThread(CRLContext crlContext) {
        this.m_CRLContext = crlContext;
    }

    private X509CRL downloadCRLInPolicy() {
        String alias = this.m_CRLContext.getCaAlias();
        this.m_CRLContext.setDownloading();
        int[] retryPolicy = this.m_CRLContext.getRetryPolicy();
        int retryPolicyLength = retryPolicy.length;
        int i = 0;
        while (i <= retryPolicyLength) {
            log.info((Object)("(" + alias + ")\u4e00\u5171\u5c1d\u8bd5" + (retryPolicyLength + 1) + "\u6b21\uff0c\u8fd9\u662f\u7b2c" + (i + 1) + "\u6b21\u4e0b\u8f7d\u3002"));
            X509CRL crl = this.downloadCRL();
            if (crl != null) {
                log.info((Object)("(" + alias + ")\u4e0b\u8f7dCRL\u6210\u529f\u3002"));
                this.m_CRLContext.setX509CRL(crl);
                this.m_CRLContext.setDownloaded();
                return crl;
            }
            if (i < retryPolicyLength) {
                int sleepSeconds = 0;
                try {
                    log.info((Object)("(" + alias + ")" + retryPolicy[i] + "\u79d2\u540e\u4f1a\u91cd\u65b0\u5c1d\u8bd5\u4e0b\u8f7d\u3002"));
                    sleepSeconds = retryPolicy[i] * 1000;
                    Thread.sleep(sleepSeconds);
                }
                catch (InterruptedException e) {
                    log.warn((Object)("(" + alias + ")CRL\u91cd\u8bd5\u66f4\u65b0\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff0c\u95f4\u9694\u65f6\u95f4\u4e3a" + retryPolicy[i] + "\u79d2\u3002\u5f02\u5e38:" + e.getMessage()));
                }
            }
            ++i;
        }
        return null;
    }

    public void run() {
        if (1 == this.m_CRLContext.getStatus()) {
            return;
        }
        String alias = this.m_CRLContext.getCaAlias();
        try {
            while (this.m_CRLContext.isTimingDownload()) {
                X509CRL crl = this.downloadCRLInPolicy();
                if (crl != null) {
                    Date now = new Date();
                    long waitMillis = crl.getNextUpdate().getTime() - now.getTime();
                    try {
                        log.info((Object)("(" + alias + ")\u5c06\u4e8e[" + crl.getNextUpdate().toString() + "]\u518d\u8fdb\u884c\u4e0b\u8f7d\u3002"));
                        Thread.sleep(waitMillis);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)("(" + alias + ")CRL\u66f4\u65b0\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff0c\u95f4\u9694\u65f6\u95f4\u4e3a" + waitMillis / 1000L + "\u79d2\u3002\u5f02\u5e38:" + e.getMessage()));
                    }
                }
                log.debug((Object)"\u672c\u8f6e\u91cd\u8bd5\u4e0b\u8f7d\u5931\u8d25\uff0c\u8fdb\u5165\u4e0b\u4e00\u8f6e\u91cd\u8bd5\u4e0b\u8f7d\u3002");
            }
            if (this.downloadCRLInPolicy() == null) {
                log.warn((Object)("(" + alias + ")\u7ecf\u8fc7\u591a\u6b21\u5c1d\u8bd5\uff0c\u5747\u6ca1\u80fd\u4e0b\u8f7d\u5230\u6709\u6548\u7684CRL\uff01\u4e0b\u8f7d\u7ebf\u7a0b\u7ec8\u6b62\uff0c\u7b49\u5f85\u4e0b\u6b21\u6fc0\u6d3b\u3002"));
            }
        }
        finally {
            this.m_CRLContext.setDownloaded();
        }
    }

    private X509CRL downloadCRL() {
        X509CRL x509CRL = null;
        String strCrlUrl = null;
        String alias = this.m_CRLContext.getCaAlias();
        if (this.m_CRLContext.getCrlUrl() != null && this.m_CRLContext.getCrlUrl().startsWith("ldap://")) {
            strCrlUrl = this.m_CRLContext.getCrlUrl();
            String crlAttrName = "certificateRevocationList;binary";
            if (RegexUtils.matches(this.m_CRLContext.getCrlUrl(), "^ldap://.*/.*@.+")) {
                crlAttrName = RegexUtils.exceptMatches(strCrlUrl, "^ldap://.*/.*@");
                strCrlUrl = RegexUtils.exceptMatches(strCrlUrl, "@" + crlAttrName);
            }
            try {
                byte[] crlBuf = LdapUtils.getEntryBinaryAttr(strCrlUrl, crlAttrName);
                x509CRL = X509CRL.getInstance(crlBuf);
            }
            catch (Exception e) {
                log.warn((Object)("(" + alias + ")\u4ece[" + strCrlUrl + "]\u4e0b\u8f7dCRL\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage()));
            }
        } else {
            strCrlUrl = this.m_CRLContext.getCrlUrl();
            if (strCrlUrl != null) {
                log.debug((Object)("(" + alias + ")\u4ece\u6307\u5b9a\u7684URL\u4e0b\u8f7dCRL\u3002"));
            } else {
                strCrlUrl = this.m_CRLContext.getUserCrlUrl();
                log.debug((Object)("(" + alias + ")\u4ece\u7528\u6237\u8bc1\u4e66\u7684URL\u5730\u5740\u3002"));
            }
            try {
                x509CRL = X509CRL.getInstanceFromURL(strCrlUrl);
            }
            catch (Exception e) {
                log.warn((Object)("(" + alias + ")\u4ece[" + strCrlUrl + "]\u4e0b\u8f7dCRL\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage()));
            }
        }
        if (x509CRL == null) {
            return null;
        }
        if (!this.m_CRLContext.isNotCheckCRL() && !this.m_CRLContext.isCRLIssuedByLegalCA(x509CRL, this.m_CRLContext.getCaCert())) {
            log.warn((Object)("(" + alias + ")\u4ece" + strCrlUrl + "\u4e0b\u8f7d\u5230\u7684CRL\u4e0d\u662f\u7531\u6307\u5b9a\u7684CA\u6240\u9881\u53d1\uff01"));
            return null;
        }
        if (!x509CRL.isOnValidPeriod()) {
            log.warn((Object)("(" + alias + ")\u4ece" + strCrlUrl + "\u4e0b\u8f7d\u5230\u7684CRL\u5df2\u8fc7\u671f\uff01ThisUpdate:" + x509CRL.getThisUpdate() + ", NextUpdate:" + x509CRL.getNextUpdate()));
            return null;
        }
        log.info((Object)("(" + alias + ")\u4ece" + strCrlUrl + "\u4e0b\u8f7d\u5230\u4e86\u6709\u6548\u7684CRL\u6587\u4ef6\uff01"));
        try {
            this.saveCRLToFile(x509CRL, this.m_CRLContext.getCrlFilePath());
            log.info((Object)("(" + alias + ")CRL\u6587\u4ef6\u5199\u5165\u6210\u529f\uff01" + this.m_CRLContext.getCrlFilePath()));
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
        return x509CRL;
    }

    private void saveCRLToFile(X509CRL x509CRL, String crlFilePath) throws IOException, CRLException, InterruptedException {
        byte[] bytesCRL = x509CRL.getEncoded();
        FileOutputStream fileOutputStream = new FileOutputStream(crlFilePath);
        fileOutputStream.write(bytesCRL);
        fileOutputStream.close();
    }
}

