/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.serviceframe;

import com.itrus.serviceframe.NVRepository;
import com.itrus.serviceframe.NameValuePair;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataPacket {
    private int m_status = 0;
    private NVRepository m_anvp;

    public int getVersion() {
        return this.m_anvp.getVersion();
    }

    public void setVersion(int version) {
        this.m_anvp.setVersion(version);
    }

    static void int2bytes(int n, byte[] ab) {
        ab[3] = (byte)(0xFF & n);
        ab[2] = (byte)((0xFF00 & n) >> 8);
        ab[1] = (byte)((0xFF0000 & n) >> 16);
        ab[0] = (byte)((0xFF000000 & n) >> 24);
    }

    static int byte2int(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    static int bytes2int(byte[] b) {
        int s = 0;
        s = (((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[3] & 0xFF;
        return s;
    }

    public DataPacket(int version) {
        this.m_anvp = new NVRepository(version);
    }

    public void setStatus(int s) {
        this.m_status = s;
    }

    public int getStatus() {
        return this.m_status;
    }

    public NVRepository getNVRepository() {
        return this.m_anvp;
    }

    public void setNVRepository(NVRepository m_anvp) {
        this.m_anvp = m_anvp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: " + Integer.toHexString(this.m_status).toUpperCase() + "\n");
        int iLimit = this.m_anvp.size();
        if (iLimit > 0) {
            int i = 0;
            while (i < iLimit) {
                sb.append(String.valueOf(this.m_anvp.elementAt(i).toString()) + "\n");
                ++i;
            }
        }
        return sb.toString();
    }

    public int serialize(OutputStream os) throws IOException {
        int nTotal = 4 + this.m_anvp.getSize();
        if (nTotal > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        byte[] ab = new byte[4];
        int version = this.getVersion();
        if (version == 1 || version == 2) {
            DataPacket.int2bytes(nTotal, ab);
        } else if (this.getVersion() == 3) {
            DataPacket.int2bytes(++nTotal, ab);
            ab[0] = (byte)(ab[0] | 0x80);
        } else {
            throw new IOException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7248\u672c\uff0cVersion=[" + version + "]\u3002");
        }
        os.write(ab);
        if (this.getVersion() == 3) {
            os.write(3);
        }
        NameValuePair.short2bytes(this.m_status, ab);
        os.write(ab, 0, 2);
        NameValuePair.short2bytes(this.m_anvp.size(), ab);
        os.write(ab, 0, 2);
        int i = 0;
        int iLast = this.m_anvp.size();
        while (i < iLast) {
            NameValuePair nvp = this.m_anvp.elementAt(i);
            nvp.setVersion(this.getVersion());
            nvp.serialize(os);
            ++i;
        }
        return nTotal;
    }

    public static DataPacket getInstance(InputStream is, boolean forceV2) throws IOException, EOFException {
        DataPacket dp = new DataPacket(0);
        byte[] ab = new byte[8192];
        NameValuePair.read(is, ab, 0, 4);
        int nTotal = 0;
        if ((ab[0] & 0x80) == 0) {
            if (forceV2) {
                dp.setVersion(2);
            } else {
                dp.setVersion(1);
            }
            nTotal = DataPacket.bytes2int(ab);
        } else {
            byte[] bVersion = new byte[1];
            NameValuePair.read(is, bVersion, 0, 1);
            int version = DataPacket.byte2int(bVersion[0]);
            if (version == 3) {
                dp.setVersion(3);
                ab[0] = (byte)(ab[0] & 0x7F);
                nTotal = DataPacket.bytes2int(ab);
            } else {
                throw new IOException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7248\u672c\uff0cVersion=[" + version + "]\u3002");
            }
        }
        if (nTotal > Integer.MAX_VALUE) {
            throw new IOException("\u63a5\u53d7\u6570\u636e\u5305\u957f\u5ea6\u8d85\u8fc72G\u9650\u5236\uff0cLength=[" + nTotal + "]\u3002");
        }
        if (ab.length > nTotal) {
            ab = null;
            ab = new byte[nTotal];
        }
        NameValuePair.read(is, ab, 0, 2);
        dp.m_status = NameValuePair.bytes2short(ab);
        NameValuePair.read(is, ab, 0, 2);
        int nvl = NameValuePair.bytes2short(ab);
        int i = 0;
        while (i < nvl) {
            NameValuePair nvp = NameValuePair.getInstance(is, dp.getVersion());
            dp.getNVRepository().add(nvp);
            ++i;
        }
        return dp;
    }

    public int getLength() throws IOException {
        int nTotal = 4 + this.m_anvp.getSize();
        if (nTotal > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int version = this.getVersion();
        if (version != 1 && version != 2) {
            if (this.getVersion() == 3) {
                ++nTotal;
            } else {
                throw new IOException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7248\u672c\uff0cVersion=[" + version + "]\u3002");
            }
        }
        return nTotal + 4;
    }

    public static String getValue(String name, DataPacket dp) {
        String value = null;
        NVRepository nvInput = dp.getNVRepository().find(name);
        if (nvInput.size() == 0) {
            return null;
        }
        value = new String(nvInput.elementAt(0).getValue());
        if (value.length() <= 0) {
            return null;
        }
        return value;
    }
}

