/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.serviceframe;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NameValuePair {
    private int version = 0;
    private String m_strName;
    private byte[] m_value;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    static void short2bytes(int n, byte[] ab) {
        ab[1] = (byte)(0xFF & n);
        ab[0] = (byte)((0xFF00 & n) >> 8);
    }

    static void int2bytes(int n, byte[] ab) {
        ab[3] = (byte)(0xFF & n);
        ab[2] = (byte)((0xFF00 & n) >> 8);
        ab[1] = (byte)((0xFF0000 & n) >> 16);
        ab[0] = (byte)((0xFF000000 & n) >> 24);
    }

    static short bytes2short(byte[] b) {
        int s = 0;
        s = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
        return (short)s;
    }

    static int bytes2int(byte[] b) {
        int s = 0;
        s = (((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[3] & 0xFF;
        return s;
    }

    public NameValuePair(String strName, byte[] value) {
        this.m_strName = strName;
        this.m_value = value;
    }

    public NameValuePair(String strName, String value) {
        this(strName, value.getBytes());
    }

    public NameValuePair(NameValuePair nvp) {
        this(nvp.m_strName, nvp.m_value);
    }

    public String getName() {
        return this.m_strName;
    }

    public void setName(String strName) {
        if (strName == null) {
            throw new IllegalArgumentException();
        }
        this.m_strName = strName;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public void setValue(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.m_value = value;
    }

    public void setValue(String strValue) {
        if (strValue == null) {
            throw new IllegalArgumentException();
        }
        this.setValue(strValue.getBytes());
    }

    public String toString() {
        if (this.m_value.length > 0x500000) {
            return String.valueOf(this.m_strName) + "\t" + "\u5927\u5b57\u6bb5";
        }
        return String.valueOf(this.m_strName) + "\t" + new String(this.m_value);
    }

    int getSize() throws IOException {
        int n = 0;
        if (this.version == 1) {
            n = 2 + this.m_strName.getBytes().length + 2 + this.m_value.length;
        } else if (this.version == 2 || this.version == 3) {
            n = 2 + this.m_strName.getBytes().length + 4 + this.m_value.length;
        } else {
            throw new IOException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7248\u672c\uff0cVersion=[" + this.version + "]\u3002");
        }
        if (n > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        return n;
    }

    int serialize(OutputStream os) throws IOException {
        byte[] ab = new byte[2];
        byte[] ab4 = new byte[4];
        byte[] ab2 = this.m_strName.getBytes();
        NameValuePair.short2bytes(ab2.length, ab);
        os.write(ab);
        os.write(ab2);
        if (this.version == 1) {
            NameValuePair.short2bytes(this.m_value.length, ab);
            os.write(ab);
            os.write(this.m_value);
            return 2 + ab2.length + 2 + this.m_value.length;
        }
        if (this.version == 2 || this.version == 3) {
            NameValuePair.int2bytes(this.m_value.length, ab4);
            os.write(ab4);
            os.write(this.m_value);
            return 2 + ab2.length + 4 + this.m_value.length;
        }
        throw new IOException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7248\u672c\uff0cVersion=[" + this.version + "]\u3002");
    }

    static void read(InputStream is, byte[] out, int off, int nLen) throws IOException, EOFException {
        int nRtn = -1;
        if (nLen <= 0) {
            return;
        }
        do {
            if ((nRtn = is.read(out, off, nLen)) == -1) {
                throw new EOFException();
            }
            off += nRtn;
        } while ((nLen -= nRtn) > 0);
    }

    static NameValuePair getInstance(InputStream is, int version) throws IOException, EOFException {
        int nRtn = -1;
        byte[] ab = new byte[2];
        NameValuePair.read(is, ab, 0, 2);
        int n = NameValuePair.bytes2short(ab);
        byte[] ab2 = new byte[n];
        NameValuePair.read(is, ab2, 0, n);
        if (version == 1) {
            NameValuePair.read(is, ab, 0, 2);
            n = NameValuePair.bytes2short(ab);
        } else if (version == 2 || version == 3) {
            byte[] ab4 = new byte[4];
            NameValuePair.read(is, ab4, 0, 4);
            n = NameValuePair.bytes2int(ab4);
        } else {
            throw new IOException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7248\u672c\uff0cVersion=[" + version + "]\u3002");
        }
        byte[] ab3 = new byte[n];
        NameValuePair.read(is, ab3, 0, n);
        NameValuePair nvp = new NameValuePair(new String(ab2), ab3);
        nvp.setVersion(version);
        return nvp;
    }
}

