/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.javahost;

import io.leopard.javahost.Dns;
import io.leopard.javahost.Hosts;
import io.leopard.javahost.impl.DnsImpl;
import io.leopard.javahost.impl.HostsCacheImpl;
import io.leopard.javahost.model.Host;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class JavaHost {
    private static Dns dns = new DnsImpl();
    private static Hosts hosts = new HostsCacheImpl();

    public static Dns getDns() {
        return dns;
    }

    public static Hosts getHosts() {
        return hosts;
    }

    public static boolean updateVirtualDns(String host, String ip) {
        return dns.update(host, ip);
    }

    public static boolean updateVirtualDns(String host, String[] ips) {
        return dns.update(host, ips);
    }

    public static int updateVirtualDns(Properties properties) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String host = ((String)entry.getKey()).trim();
            String ip = ((String)entry.getValue()).trim();
            if (JavaHost.isLocalHost(host)) continue;
            count += JavaHost.updateVirtualDnsByStrings(host, ip);
        }
        return count;
    }

    protected static int updateVirtualDnsByStrings(String host, String ipList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ip : ipList.split(",")) {
            if ((ip = ip.trim()).length() <= 0) continue;
            list.add(ip);
        }
        if (!list.isEmpty()) {
            String[] ips = new String[list.size()];
            list.toArray(ips);
            JavaHost.updateVirtualDns(host, ips);
        }
        return list.size();
    }

    public static void printAllVirtualDns() {
        List<Host> list = dns.list();
        for (Host host : list) {
            System.out.println(host);
        }
    }

    public static int updateVirtualDns(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String host = entry.getKey().trim();
            String ip = entry.getValue().trim();
            if (JavaHost.isLocalHost(host)) continue;
            count += JavaHost.updateVirtualDnsByStrings(host, ip);
        }
        return count;
    }

    public static String queryIp(String host) {
        InetAddress[] addresses;
        try {
            addresses = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException e) {
            return null;
        }
        if (addresses.length == 1) {
            return addresses[0].getHostAddress();
        }
        int random = new Random().nextInt(addresses.length);
        return addresses[random].getHostAddress();
    }

    public static String getIp(String host) {
        InetAddress address;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return address.getHostAddress();
    }

    public static String queryIpByLocalHosts(String host) {
        return hosts.query(host);
    }

    public static String queryIpByVirtualDns(String host) {
        return dns.queryIp(host);
    }

    public static boolean isLocalHost(String host) {
        return hosts.exist(host);
    }
}

