/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.javahost.impl;

import io.leopard.javahost.Dns;
import io.leopard.javahost.model.Host;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Map;

public abstract class AbstractDns
implements Dns {
    protected static final long ABOUT_YEAR = 31536000000L;
    private static final long EXPIRATION = 315360000000L;

    protected Map<String, Object> getAddressCache() {
        try {
            Field cacheField = InetAddress.class.getDeclaredField("addressCache");
            cacheField.setAccessible(true);
            Object addressCache = cacheField.get(InetAddress.class);
            Class<?> clazz = addressCache.getClass();
            Field cacheMapField = clazz.getDeclaredField("cache");
            cacheMapField.setAccessible(true);
            return (Map)cacheMapField.get(addressCache);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Host[] toHost(Object entry) {
        if (entry == null) {
            throw new NullPointerException("entry\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        try {
            Class<?> clazz = entry.getClass();
            Field field = clazz.getDeclaredField("expiration");
            field.setAccessible(true);
            long expiration = (Long)field.get(entry);
            Field field2 = clazz.getDeclaredField("addresses");
            field2.setAccessible(true);
            InetAddress[] addresses = (InetAddress[])field2.get(entry);
            Host[] hosts = new Host[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                InetAddress address = addresses[i];
                Host host = new Host();
                host.setExpiration(expiration);
                host.setHost(address.getHostName());
                host.setIp(address.getHostAddress());
                hosts[i] = host;
            }
            return hosts;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Object createCacheEntry(String host, String[] ips) {
        try {
            long expiration = System.currentTimeMillis() + 315360000000L;
            InetAddress[] addresses = new InetAddress[ips.length];
            for (int i = 0; i < addresses.length; ++i) {
                addresses[i] = InetAddress.getByAddress(host, InetAddress.getByName(ips[i]).getAddress());
            }
            String className = "java.net.InetAddress$CacheEntry";
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return constructor.newInstance(addresses, expiration);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

