/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.javahost.impl;

import io.leopard.javahost.impl.AbstractDns;
import io.leopard.javahost.model.Host;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class DnsImpl
extends AbstractDns {
    @Override
    public boolean update(String host, String ip) {
        return this.update(host, new String[]{ip});
    }

    @Override
    public boolean update(String host, String[] ips) {
        Object entry = this.createCacheEntry(host, ips);
        this.getAddressCache().put(host, entry);
        return true;
    }

    @Override
    public boolean remove(String host) {
        Object obj = this.getAddressCache().remove(host);
        return obj != null;
    }

    @Override
    public String queryIp(String host) {
        Host bean = this.query(host);
        if (bean == null) {
            return null;
        }
        return bean.getHost();
    }

    @Override
    public Host query(String host) {
        Object entry = this.getAddressCache().get(host);
        if (entry == null) {
            return null;
        }
        Host[] hosts = super.toHost(entry);
        Host bean = hosts[new Random().nextInt(hosts.length)];
        if (this.isVirtualDns(bean)) {
            return bean;
        }
        return null;
    }

    protected boolean isVirtualDns(Host host) {
        long millis = host.getExpiration() - System.currentTimeMillis();
        return millis > 31536000000L;
    }

    @Override
    public List<Host> list() {
        ArrayList<Host> list = new ArrayList<Host>();
        for (Map.Entry<String, Object> entry : this.getAddressCache().entrySet()) {
            Host[] hosts;
            for (Host host : hosts = super.toHost(entry.getValue())) {
                if (!this.isVirtualDns(host)) continue;
                list.add(host);
            }
        }
        return list;
    }

    @Override
    public List<Host> list(String host) {
        Object entry = this.getAddressCache().get(host);
        if (entry == null) {
            return null;
        }
        Host[] hosts = super.toHost(entry);
        ArrayList<Host> list = new ArrayList<Host>();
        for (Host bean : hosts) {
            if (!this.isVirtualDns(bean)) continue;
            list.add(bean);
        }
        return list;
    }
}

