/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.zzW4C;
import com.aspose.words.zzWpt;
import com.aspose.words.zzX5n;
import com.aspose.words.zzXf1;
import com.aspose.words.zzXvs;
import com.aspose.words.zzYJa;
import com.aspose.words.zzZ5X;
import com.aspose.words.zzZTI;
import com.aspose.words.zzZZr;
import com.aspose.words.zzZnP;

public class Cell
extends CompositeNode<Node>
implements zzWpt,
zzZ5X {
    private zzW4C zzYPM;
    private CellFormat zzbS;
    private ParagraphCollection zzZhY;
    private TableCollection zzhe;

    public Cell(DocumentBase doc) {
        this(doc, new zzW4C());
    }

    Cell(DocumentBase doc, zzW4C cellPr) {
        super(doc);
        this.zzYPM = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzWXb() {
        return (Cell)this.zzZLI();
    }

    public Row getParentRow() {
        return (Row)this.zzXuR();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzZZA() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzzD(this, true);
        }
        return -1;
    }

    final int zzX26() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzX26();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzbS == null) {
            this.zzbS = new CellFormat(this);
        }
        return this.zzbS;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzZhY == null) {
            this.zzZhY = new ParagraphCollection(this);
        }
        return this.zzZhY;
    }

    public TableCollection getTables() {
        if (this.zzhe == null) {
            this.zzhe = new TableCollection(this);
        }
        return this.zzhe;
    }

    final zzW4C zzY6R() {
        return this.zzYPM;
    }

    final void zzab(zzW4C zzW4C2) {
        this.zzYPM = zzW4C2;
    }

    @Override
    final Node zzab(boolean bl, zzZZr zzZZr2) {
        zzW4C zzW4C2;
        Cell cell = (Cell)super.zzab(bl, zzZZr2);
        zzW4C zzW4C3 = this.zzYPM;
        cell.zzYPM = zzW4C2 = (zzW4C)zzW4C3.zzY1s();
        cell.zzbS = null;
        cell.zzZhY = null;
        cell.zzhe = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzab(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzYCO(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzYJa.zzZNT(this);
    }

    @Override
    final boolean zzVQt(Node node) {
        return zzZTI.zzWsb(node);
    }

    final int zzXcq() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzZLI();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzYPM.zzYlJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzYPM.zzYlJ(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZnP zzZnP2 = zzYkh.zzab(object, zzZnP.class);
        if (zzZnP2 != null && zzZnP2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZpc(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzW4C.zzYtM(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzYPM.zzWmh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzYPM.clear();
    }

    private Object zzZpc(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzYkh.zzab((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzab(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXf1 getInsertRevision() {
        Cell cell = this;
        return cell.zzYPM.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXf1 value) {
        Cloneable cloneable = this;
        zzXf1 zzXf12 = value;
        cloneable = cloneable.zzYPM;
        ((zzXvs)cloneable).zzWmh(14, zzXf12);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXf1 getDeleteRevision() {
        Cell cell = this;
        return cell.zzYPM.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXf1 value) {
        Cloneable cloneable = this;
        zzXf1 zzXf12 = value;
        cloneable = cloneable.zzYPM;
        ((zzXvs)cloneable).zzWmh(12, zzXf12);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzX5n getMoveFromRevision() {
        Cell cell = this;
        return cell.zzYPM.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzX5n value) {
        Cloneable cloneable = this;
        zzX5n zzX5n2 = value;
        cloneable = cloneable.zzYPM;
        ((zzXvs)cloneable).zzWmh(13, zzX5n2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzX5n getMoveToRevision() {
        Cell cell = this;
        return cell.zzYPM.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzX5n value) {
        Cloneable cloneable = this;
        zzX5n zzX5n2 = value;
        cloneable = cloneable.zzYPM;
        ((zzXvs)cloneable).zzWmh(15, zzX5n2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzYPM.remove(13);
        cell = this;
        cell.zzYPM.remove(15);
    }

    final zzW4C zzZ9N(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzW4C zzW4C2 = new zzW4C();
        this.zzab(3120, zzW4C2);
        this.zzab(3140, zzW4C2);
        this.zzab(3110, zzW4C2);
        this.zzab(3130, zzW4C2);
        this.zzab(3090, zzW4C2);
        this.zzab(3100, zzW4C2);
        this.zzab(3070, zzW4C2);
        this.zzab(3080, zzW4C2);
        if (bl && (tableStyle = zzYkh.zzab((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYCO(this, zzW4C2);
        }
        this.zzYPM.zzYCO((zzXvs)zzW4C2);
        return zzW4C2;
    }

    private void zzab(int n, zzW4C zzW4C2) {
        zzW4C2.zzWmh(n, this.fetchInheritedCellAttr(n));
    }
}

