/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzYLT;
import com.aspose.words.internal.zzYkh;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWi3;
import com.aspose.words.zzXfD;
import com.aspose.words.zzZO2;
import com.aspose.words.zzZTI;
import com.aspose.words.zzZZr;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzXpX;
    private Node zzZ1e;
    private Node zzX2h;
    private int zzy9;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzzD(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzXpX == null) {
            return null;
        }
        if (this.zzXpX.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzXpX;
    }

    final CompositeNode zzXuR() {
        if (zzZTI.zzXuq(this.getParentNode())) {
            return this.getParentNode().zzXuR();
        }
        return this.getParentNode();
    }

    final CompositeNode zzZMM() {
        if (zzZTI.zzXuq(this.getParentNode()) || zzZTI.zzXap(this.getParentNode())) {
            return this.getParentNode().zzZMM();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzXpX != null) {
            return this.zzXpX.getDocument();
        }
        return null;
    }

    final Document zzoo() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzwe() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzY26();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzX2h;
    }

    final Node zzYfG() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzZTI.zzY0J((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzYaq() {
        Node node = zzZTI.zzYeB(this.getPreviousSibling(), false);
        if (node == null && zzZTI.zzXuq(this.getParentNode())) {
            node = this.getParentNode().zzYaq();
        }
        return node;
    }

    final Node zzXbi() {
        Node node = zzZTI.zzXAg(this.getNextSibling(), false);
        if (node == null && zzZTI.zzXuq(this.getParentNode())) {
            node = this.getParentNode().zzXbi();
        }
        return node;
    }

    final CompositeNode zzXxp() {
        Node node = this;
        while ((node = node.zzYaq()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZLI() {
        Node node = this;
        while ((node = node.zzXbi()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZ1e;
    }

    final Node zzZdB() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzZTI.zzY0J((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzWKy() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzY8r() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZBD() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzZTI.zzrj(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzYUC() {
        return this.zzZ1e;
    }

    final void zzWNc(Node node) {
        this.zzZ1e = node;
    }

    final Node zzZ3m() {
        return this.zzX2h;
    }

    final void zzVWQ(Node node) {
        this.zzX2h = node;
    }

    final Node zzWHu() {
        Node node = this;
        if (node.zzZ1e != null) {
            node = this;
            return node.zzZ1e;
        }
        return this.getParentNode();
    }

    final int zzXFk() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzZTI.zzXfn(this);
        boolean bl2 = zzZTI.zzWsb(this);
        boolean bl3 = zzZTI.zzYkG(this);
        boolean bl4 = zzZTI.zzZ8l(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzXFk() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzXFk() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzab(isCloneChildren, new zzab(this));
    }

    Node zzab(boolean bl, zzZZr zzZZr2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzXpX != null) {
            node.zzXpX = this.getDocument().zzYKN();
        }
        node.zzZ1e = null;
        node.zzX2h = null;
        if (zzZZr2 != null) {
            zzZZr2.zzWpk(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzY8T(StringBuilder stringBuilder) {
        zzYkh.zzYCO(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzX9W(Node node) {
        this.zzXpX = node != null ? node : this.getDocument().zzYKN();
    }

    final void zzzD(DocumentBase documentBase) {
        this.zzXpX = documentBase != null ? documentBase.zzYKN() : null;
    }

    final boolean zzYVR(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzPI() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzZ8X(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYWE(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzbR(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzY8T(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzXqQ(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzWi3 zzWi32 = zzZTI.zzYGU(saveFormat);
        return zzWi32.zzoX(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzWi3 zzWi32 = zzZTI.zzYCO(saveOptions);
        return zzWi32.zzoX(this);
    }

    final Node zzXxK(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzZTI.zzbu(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzXfD zzWVs() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzXfD.zzZBT(node);
        }
        return zzXfD.zzYXJ(this.getParentNode());
    }

    final zzXfD zzOQ() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzXfD.zzYXJ(node);
        }
        return zzXfD.zzZBT(this.getParentNode());
    }

    final boolean zzZ4B(Node node) {
        return Node.zzXRj(this, node);
    }

    final boolean zzYW() {
        return this.getAncestor(1) == null;
    }

    static Node zzZop(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzYLT<Node> zzYLT2 = Node.zzXuY(node);
        zzYLT<Node> zzYLT3 = Node.zzXuY(node2);
        return Node.zzab(zzYLT2, zzYLT3);
    }

    static boolean zzXRj(Node node, Node node2) {
        zzYLT<Node> zzYLT2;
        if (node == null || node2 == null) {
            return false;
        }
        zzYLT<Node> zzYLT3 = Node.zzXuY(node);
        Node node3 = Node.zzab(zzYLT3, zzYLT2 = Node.zzXuY(node2));
        if (node3 == null) {
            return false;
        }
        zzYLT<Node> zzYLT4 = zzYLT3;
        if (zzYLT4.size() == 0 || (zzYLT4 = zzYLT2).size() == 0) {
            zzYLT4 = zzYLT2;
            boolean bl = zzYLT4.size() > 0;
            return bl;
        }
        Object e = zzYLT3.peek();
        Object e2 = zzYLT2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzYLT<Node> zzXuY(Node node) {
        zzYLT<Node> zzYLT2 = new zzYLT<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzYLT2.push(node2);
        }
        return zzYLT2;
    }

    private static Node zzab(zzYLT<Node> zzYLT2, zzYLT<Node> zzYLT3) {
        Node node = null;
        while (zzYLT2.peek() == zzYLT3.peek()) {
            node = (Node)zzYLT2.pop();
            zzYLT3.pop();
            zzYLT<Node> zzYLT4 = zzYLT2;
            if (zzYLT4.size() != 0 && (zzYLT4 = zzYLT3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzy9;
    }

    public void setCustomNodeId(int value) {
        this.zzy9 = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzbu(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzZ8l(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWsb(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzZ8l(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzZ8l(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzab
    implements zzZZr {
        private Node zzZtt;
        private HashMap<Integer, Integer> zzYtA;

        zzab(Node node) {
            this.zzZtt = node;
        }

        @Override
        public final void zzWpk(Node node, Node node2) {
            if (node == this.zzZtt) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzZO2 zzZO22 = (zzZO2)((Object)node2);
            if (this.zzYtA == null) {
                this.zzYtA = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzYkh.zzab(this.zzYtA, Integer.valueOf(zzZO22.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzsY();
                zzYkh.zzYCO(this.zzYtA, Integer.valueOf(zzZO22.getIdInternal()), Integer.valueOf(n));
            }
            zzZO22.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzYkh.zzab(this.zzYtA, Integer.valueOf(zzZO22.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzZO22.setParentIdInternal(n2);
            }
        }
    }
}

