/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWt9;
import com.aspose.words.internal.zzXyw;

public abstract class SaveOptions {
    private boolean zzZM6;
    boolean zzYTf = false;
    boolean zzer = true;
    private IDocumentSavingCallback zzZfZ;
    private boolean zzZ3K = true;
    private boolean zzZGV = false;
    private boolean zz4d;
    private boolean zzZ9o = true;
    private boolean zzWnj;
    private String zzY0g;
    private boolean zzWiX;
    private boolean zzWdr = false;
    private int zzXsE = 1;
    private int zzZpt = 1;
    private int zzXr3 = 0;
    private String zzZay = "";
    private boolean zzZqA = true;
    private boolean zzWeS = true;
    private boolean zzWte;
    private boolean zzWLc;
    private int zzYlL = 0;
    private boolean zzWSz = true;
    private boolean zzYfx = false;

    protected SaveOptions() {
    }

    final boolean zzzX() {
        return this.zz4d;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzYCP() {
        return false;
    }

    boolean zzSa() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZ9o;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZ9o = value;
    }

    public String getTempFolder() {
        return this.zzY0g;
    }

    public void setTempFolder(String value) {
        this.zzY0g = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWnj;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWnj = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzWiX;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzWiX = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWdr;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWdr = value;
    }

    @Deprecated
    public boolean getUpdateSdtContent() {
        return this.zzYTf;
    }

    @Deprecated
    public void setUpdateSdtContent(boolean value) {
        this.zzYTf = value;
    }

    public int getDmlRenderingMode() {
        return this.zzXsE;
    }

    public void setDmlRenderingMode(int value) {
        this.zzXsE = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzXr3;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzXr3 = value;
    }

    public int getImlRenderingMode() {
        return this.zzZpt;
    }

    public void setImlRenderingMode(int value) {
        this.zzZpt = value;
    }

    public String getDefaultTemplate() {
        return this.zzZay;
    }

    public void setDefaultTemplate(String value) {
        this.zzZay = value;
    }

    public boolean getUpdateFields() {
        return this.zzZqA;
    }

    public void setUpdateFields(boolean value) {
        this.zzZqA = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWte;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWte = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzWLc;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzWLc = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYfx;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYfx = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzZGV;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzZGV = value;
    }

    final boolean zzWFD() {
        return this.zzWeS;
    }

    final boolean zzYw9() {
        return this.zzWSz;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYSh(zzWt9.zzWNs(zzXyw.zzW3(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYlL;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYlL = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzZfZ;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzZfZ = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZM6;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZM6 = value;
    }

    final boolean zzaU() {
        return this.zzZ3K;
    }
}

