/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzW1I;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYZ = new ArrayList();
    private final Map<String, DataColumn> zzW5M = new HashMap<String, DataColumn>();
    private DataTable zzWx9;

    DataColumnCollection(DataTable table) {
        this.zzWx9 = table;
    }

    public void add(DataColumn column) {
        if (zzW1I.zzW7X(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzrS(column.getColumnName());
        if (this.zzW5M.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzWpk(this.zzWx9);
        column.setOrdinal(this.zzYZ.size());
        this.zzYZ.add(column);
        this.zzW5M.put(string, column);
        this.zzWx9.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWx9);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzWx9);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzW1I.zzW7X(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzrS(columnName);
        DataColumn dataColumn = this.zzW5M.get(string);
        if (dataColumn != null) {
            int n = this.zzYZ.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYZ.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYZ.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYZ.remove(n);
            this.zzW5M.remove(DataColumnCollection.zzrS(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzWx9.getRows()) {
                dataRow.remove(n);
            }
            this.zzWx9.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYZ.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYZ.iterator();
    }

    public void clear() {
        this.zzW5M.clear();
        this.zzYZ.clear();
    }

    final DataColumn[] zzZlC() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYZ);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzab(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYZ.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYZ.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzrS(string);
            String string3 = DataColumnCollection.zzrS(dataColumn.getColumnName());
            this.zzW5M.remove(string3);
            this.zzW5M.put(string2, dataColumn);
            return;
        }
    }

    private static String zzrS(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

