/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.com.caucho.hessian.io;

import java.io.IOException;
import kd.bos.com.caucho.hessian.io.AbstractHessianInput;
import kd.bos.com.caucho.hessian.io.Deserializer;
import kd.bos.com.caucho.hessian.io.HessianProtocolException;

public abstract class AbstractDeserializer
implements Deserializer {
    @Override
    public Class getType() {
        return Object.class;
    }

    @Override
    public Object readObject(AbstractHessianInput in) throws IOException {
        Object obj = in.readObject();
        String className = this.getClass().getName();
        if (obj != null) {
            throw this.error(className + ": unexpected object " + obj.getClass().getName() + " (" + obj + ")");
        }
        throw this.error(className + ": unexpected null value");
    }

    @Override
    public Object readList(AbstractHessianInput in, int length) throws IOException {
        throw new UnsupportedOperationException(String.valueOf(this));
    }

    @Override
    public Object readLengthList(AbstractHessianInput in, int length) throws IOException {
        throw new UnsupportedOperationException(String.valueOf(this));
    }

    @Override
    public Object readMap(AbstractHessianInput in) throws IOException {
        Object obj = in.readObject();
        String className = this.getClass().getName();
        if (obj != null) {
            throw this.error(className + ": unexpected object " + obj.getClass().getName() + " (" + obj + ")");
        }
        throw this.error(className + ": unexpected null value");
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        throw new UnsupportedOperationException(String.valueOf(this));
    }

    protected HessianProtocolException error(String msg) {
        return new HessianProtocolException(msg);
    }

    protected String codeName(int ch) {
        if (ch < 0) {
            return "end of file";
        }
        return "0x" + Integer.toHexString(ch & 0xFF);
    }
}

