/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server;

import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.ConnectionProxy;
import kd.isc.iscb.util.connector.server.Initializer;
import kd.isc.iscb.util.connector.server.hub.ConnectorUtil;
import kd.isc.iscb.util.connector.server.param.ServiceRequest;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class ConnectorCallback {
    private static final ReadLockFreeMap<String, Triple<String, Long, Map<String, String>>> tokenCache;
    private static final ReadLockFreeMap<String, Map<String, String>> ierpLoginInfos;

    public static String getIerpServerURL(String dataCenter) {
        Map loginInfo = (Map)ierpLoginInfos.get((Object)dataCenter);
        if (loginInfo == null) {
            return null;
        }
        return ConnectorCallback.getIerpServerURL(loginInfo);
    }

    public static String lookupTargetOID(String dataCenter, String src_oid, String src_cn_number, String src_table, String target_cn_number, String tar_table) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("src_oid", src_oid);
        params.put("src_cn_number", src_cn_number);
        params.put("src_table", src_table);
        params.put("target_cn_number", target_cn_number);
        params.put("tar_table", tar_table);
        String id = D.s((Object)ConnectorCallback.call(dataCenter, "LookupTargetOIDService", params));
        return id;
    }

    public static String findMappingValue(String dataCenter, String ruleNumber, String value) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ruleNumber", ruleNumber);
        params.put("value", value);
        String id = D.s((Object)ConnectorCallback.call(dataCenter, "FindMappingValueService", params));
        return id;
    }

    public static Object call(String dataCenter, String iscService, Map<String, Object> params) {
        if (ConnectorUtil.supportMultiHub((String)dataCenter)) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u8fde\u63a5\u5668\u5f00\u542f\u4e86\u652f\u6301\u591a\u5957hub\u90e8\u7f72\uff0c\u4e8c\u5f00\u4ee3\u7801\u9700\u8981\u8c03\u6574\u4e3a\u4f7f\u7528kd.isc.iscb.util.connector.server.ConnectorCallback#callByIscHub\u65b9\u6cd5\u4ee5\u56de\u8c03\u7279\u5b9ahub\u670d\u52a1\u5668\u3002", (String)"ConnectorCallback19", (String)"isc-iscb-util", (Object[])new Object[0]);
            throw new IscBizException(msg);
        }
        Map<String, String> loginInfo = ConnectorCallback.getIerpLoginInfo(dataCenter);
        return ConnectorCallback.call(loginInfo, iscService, params);
    }

    public static Object callByIscHub(String dataCenter, String iscHub, String iscService, Map<String, Object> params) {
        if (ConnectorUtil.supportMultiHub((String)dataCenter)) {
            return ConnectorCallback.innerCallByIscHub(dataCenter, iscHub, iscService, params);
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u8c03\u7528callByIscHub\u65b9\u6cd5\u524d\uff0c\u8fde\u63a5\u5668\u5e94\u5148\u5f00\u542f\u652f\u6301\u591a\u5957hub\u90e8\u7f72\u53c2\u6570", (String)"ConnectorCallback20", (String)"isc-iscb-util", (Object[])new Object[0]));
    }

    private static Object innerCallByIscHub(String dataCenter, String iscHub, String iscService, Map<String, Object> params) {
        Map loginInfo = ConnectorUtil.getIerpLoginInfo((String)iscHub);
        if (loginInfo == null) {
            ConnectorCallback.init(dataCenter);
            loginInfo = ConnectorUtil.getIerpLoginInfo((String)iscHub);
        }
        if (loginInfo != null) {
            return ConnectorCallback.call(loginInfo, iscService, params);
        }
        String tips = ResManager.loadKDString((String)"\u6839\u636eisc_hub\u3010%1$s\u3011\u627e\u4e0d\u5230\u82cd\u7a79\u767b\u5f55\u4fe1\u606f\uff0c\u8bf7\u5728\u82cd\u7a79\u7aef\u5148\u90e8\u7f72\u8fde\u63a5\u5668\u518d\u4f7f\u7528", (String)"ConnectorCallback21", (String)"isc-iscb-util", (Object[])new Object[0]);
        throw new IscBizException(String.format(tips, iscHub));
    }

    public static <R> R call(String dataCenter, ServiceRequest<R> param) {
        String svc = param.getServiceName();
        Map params = param.getParams();
        Object result = ConnectorCallback.call(dataCenter, svc, (Map<String, Object>)params);
        return (R)param.parseResult(result);
    }

    public static Object call(Map<String, String> loginInfo, String iscService, Map<String, Object> params) {
        try {
            return ConnectorCallback.innerInvoke(loginInfo, iscService, params);
        }
        catch (Exception e) {
            String message = StringUtil.getMessage((Throwable)e);
            if (!message.contains("error_desc=\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002")) {
                if (message.contains("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef")) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d26\u5957: %1$s\uff08%2$s\uff09\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c\u8fde\u63a5\u914d\u7f6e\u201d\u56de\u8c03\u4ee3\u7406\u7528\u6237\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"ConnectorCallback_10", (String)"isc-iscb-util", (Object[])new Object[0]), loginInfo.get("accountId"), loginInfo.get("accountName")), (Throwable)e);
                }
                throw D.e((Throwable)e);
            }
            DbUtil.getLogger().error(ResManager.loadKDString((String)"\u7531\u4e8e\u7f13\u5b58\u7684accesstoken\u5df2\u5931\u6548\uff0c\u6e05\u9664\u7f13\u5b58\u5e76\u91cd\u8bd5\u8c03\u7528\u3002", (String)"ConnectorCallback_4", (String)"isc-iscb-util", (Object[])new Object[0]), (Throwable)e);
            ConnectorCallback.removeAccessToken(loginInfo);
            return ConnectorCallback.innerInvoke(loginInfo, iscService, params);
        }
    }

    private static Object innerInvoke(final Map<String, String> loginInfo, String iscService, Map<String, Object> params) {
        if ("true".equals(System.getProperty("ierp_token_on_url"))) {
            String token = ConnectorCallback.getAccessToken(loginInfo);
            String url = ConnectorCallback.getIerpServerURL(loginInfo) + "/kapi" + "/app/iscb/IscServiceDispatcher" + "?access_token=" + token;
            params.put("command", iscService);
            return NetUtil.asyncHttpInvoke(url, params);
        }
        NetUtil.ConnectionDecorator decorator = new NetUtil.ConnectionDecorator(){

            public void beforeSubmit(HttpURLConnection http) {
                String token = ConnectorCallback.getAccessToken(loginInfo);
                http.setRequestProperty("accesstoken", token);
            }

            public void afterSubmit(HttpURLConnection http) {
            }
        };
        String url = ConnectorCallback.getIerpServerURL(loginInfo) + "/kapi" + "/app/iscb/IscServiceDispatcher";
        params.put("command", iscService);
        return NetUtil.asyncHttpInvoke(url, params, decorator);
    }

    public static <R> R call(Map<String, String> loginInfo, ServiceRequest<R> param) {
        String svc = param.getServiceName();
        Map params = param.getParams();
        Object result = ConnectorCallback.call(loginInfo, svc, (Map<String, Object>)params);
        return (R)param.parseResult(result);
    }

    public static void removeAccessToken(Map<String, String> loginInfo) {
        String key = ConnectorCallback.generateAccessTokenKey(loginInfo);
        tokenCache.remove((Object)key);
    }

    public static String getAccessToken(Map<String, String> loginInfo) {
        String key = ConnectorCallback.generateAccessTokenKey(loginInfo);
        String access_token = ConnectorCallback.getCachedToken(key);
        if (access_token != null) {
            return access_token;
        }
        access_token = ConnectorCallback.getNewAccessToken(loginInfo);
        Triple value = new Triple((Object)access_token, (Object)System.currentTimeMillis(), loginInfo);
        tokenCache.put((Object)key, (Object)value);
        return access_token;
    }

    private static String generateAccessTokenKey(Map<String, String> loginInfo) {
        String key = Hash.mur2digital32((Object[])new Object[]{loginInfo.get("user"), loginInfo.get("accountId"), loginInfo.get("tenantid"), ConnectorCallback.getIerpServerURL(loginInfo)});
        return key;
    }

    public static String getNewAccessToken(Map<String, String> loginInfo) {
        String appToken = ConnectorCallback.getAppToken(loginInfo);
        return ConnectorCallback.getAccessToken(appToken, loginInfo);
    }

    public static Map<String, Object> getNewAccessTokenData(Map<String, String> loginInfo) {
        String appToken = ConnectorCallback.getAppToken(loginInfo);
        return ConnectorCallback.getAccessTokenData(appToken, loginInfo);
    }

    private static String getCachedToken(String key) {
        Triple p = (Triple)tokenCache.get((Object)key);
        if (p == null) {
            return null;
        }
        String access_token = (String)p.getA();
        if ((Long)p.getB() > System.currentTimeMillis() - 1800000L) {
            return access_token;
        }
        ConnectorCallback.doLogout(access_token, (Map)p.getC());
        tokenCache.remove((Object)key);
        return null;
    }

    private static void doLogout(String access_token, Map<String, String> loginInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("access_token", access_token);
        String json = Json.toString(map, (boolean)true);
        try {
            Reader reader = NetUtil.httpPost(ConnectorCallback.getIerpServerURL(loginInfo) + "/api/logout.do", json);
            ConnectorCallback.getData((Map)Script.parseJson((Reader)reader));
        }
        catch (Throwable e) {
            DbUtil.getLogger().error("doLogout", e);
        }
    }

    private static String getAccessToken(String appToken, Map<String, String> loginInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(loginInfo);
        params.put("apptoken", appToken);
        String json = Json.toString(params, (boolean)true);
        String url = ConnectorCallback.getIerpServerURL(loginInfo) + "/api/login.do";
        Reader reader = NetUtil.httpPost(url, json);
        String text = NetUtil.readText(reader);
        Map res = (Map)Script.parseJson((String)text);
        Map data = (Map)ConnectorCallback.getData(res);
        String access_token = D.s(data.get("access_token"));
        if (access_token == null) {
            String message = ResManager.loadKDString((String)"\u901a\u8fc7\u4ee5\u4e0bURL\u548c\u53c2\u6570\u83b7\u53d6\u4e0d\u5230access_token", (String)"ConnectorCallback_11", (String)"isc-iscb-util", (Object[])new Object[0]) + "\r\nURL=" + url + "\r\n" + String.format(ResManager.loadKDString((String)"\u7ed3\u679c%s", (String)"ConnectorCallback_12", (String)"isc-iscb-util", (Object[])new Object[0]), text);
            throw new IscBizException(message);
        }
        return access_token;
    }

    private static Map<String, Object> getAccessTokenData(String appToken, Map<String, String> loginInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(loginInfo);
        params.put("apptoken", appToken);
        String json = Json.toString(params, (boolean)true);
        String url = ConnectorCallback.getIerpServerURL(loginInfo) + "/api/login.do";
        Reader reader = NetUtil.httpPost(url, json);
        String text = NetUtil.readText(reader);
        Map res = (Map)Script.parseJson((String)text);
        Map data = (Map)ConnectorCallback.getData(res);
        String access_token = D.s(data.get("access_token"));
        if (access_token == null) {
            String message = ResManager.loadKDString((String)"\u901a\u8fc7\u4ee5\u4e0bURL\u548c\u53c2\u6570\u83b7\u53d6\u4e0d\u5230access_token", (String)"ConnectorCallback_11", (String)"isc-iscb-util", (Object[])new Object[0]) + "\r\nURL=" + url + "\r\n" + String.format(ResManager.loadKDString((String)"\u7ed3\u679c%s", (String)"ConnectorCallback_12", (String)"isc-iscb-util", (Object[])new Object[0]), text);
            throw new IscBizException(message);
        }
        return data;
    }

    private static String getAppToken(Map<String, String> loginInfo) {
        String json = Json.toString(loginInfo, (boolean)true);
        String url = ConnectorCallback.getIerpServerURL(loginInfo) + "/api/getAppToken.do";
        Reader reader = NetUtil.httpPost(url, json);
        String text = NetUtil.readText(reader);
        Map res = null;
        try {
            res = (Map)Script.parseJson((String)text);
        }
        catch (Throwable throwable) {
            throw new IscBizException("invalid json text : " + text, throwable);
        }
        Map data = (Map)ConnectorCallback.getData(res);
        String appToken = D.s(data.get("app_token"));
        if (appToken == null) {
            String message = ResManager.loadKDString((String)"\u901a\u8fc7\u4ee5\u4e0bURL\u548c\u53c2\u6570\u65e0\u6cd5\u83b7\u53d6\u5230app_token", (String)"ConnectorCallback_13", (String)"isc-iscb-util", (Object[])new Object[0]) + "\r\nURL=" + url + "\r\n" + String.format(ResManager.loadKDString((String)"\u7ed3\u679c=%s", (String)"ConnectorCallback_14", (String)"isc-iscb-util", (Object[])new Object[0]), text);
            throw new IscBizException(message);
        }
        return appToken;
    }

    private static Object getData(Map<String, Object> response) {
        if ("error".equals(response.get("state")) || "false".equals(D.s((Object)response.get("success")))) {
            throw new IscBizException(D.s((Object)response.get("errorMsg")) + "\r\n" + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7801\uff1a%s", (String)"ConnectorCallback_15", (String)"isc-iscb-util", (Object[])new Object[0]), response.get("errorCode")));
        }
        return response.get("data");
    }

    public static Map<String, String> getIerpLoginInfo(String dataCenter) {
        Map<String, String> map = ConnectorCallback.innerGetIerpLoginInfo(dataCenter);
        if (map != null) {
            return map;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d26\u5957\uff08%s\uff09\u6ca1\u6709\u914d\u7f6e\u96c6\u6210\u4e91\u3002", (String)"ConnectorCallback_16", (String)"isc-iscb-util", (Object[])new Object[0]), dataCenter));
    }

    private static Map<String, String> innerGetIerpLoginInfo(String dataCenter) {
        Map map = (Map)ierpLoginInfos.get((Object)dataCenter);
        if (map == null) {
            ConnectorCallback.init(dataCenter);
            map = (Map)ierpLoginInfos.get((Object)dataCenter);
        }
        return map;
    }

    public static void registerLoginInfo(String dataCenter, Map<String, String> loginInfo) {
        ierpLoginInfos.put((Object)dataCenter, Collections.unmodifiableMap(loginInfo));
    }

    public static void registerLoginInfo(String dataCenter, Map<String, String> loginInfo, String ierp_server_url, String permission_mode) {
        loginInfo.put("ierp_server_url", ierp_server_url);
        loginInfo.put("permission_mode", permission_mode);
        ierpLoginInfos.put((Object)dataCenter, loginInfo);
    }

    public static PermissionMode getPermissionMode(String dataCenter) {
        Map loginInfo = (Map)ierpLoginInfos.get((Object)dataCenter);
        return ConnectorCallback.getPermissionModeFromLoginInfo(loginInfo);
    }

    public static PermissionMode getPermissionModeFromLoginInfo(Map<String, String> loginInfo) {
        if (loginInfo == null) {
            return PermissionMode.DENY_ALL;
        }
        String mode = loginInfo.get("permission_mode");
        return mode == null ? PermissionMode.WHITE_LIST : PermissionMode.valueOf((String)mode);
    }

    public static String getIerpServerURL(Map<String, String> loginInfo) {
        String url = D.s((Object)loginInfo.get("ierp_server_url"));
        if (url == null) {
            url = ConnectionProxy.getIerpServerURL();
        }
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getIscHub(String datacenter) {
        Map map = (Map)ierpLoginInfos.get((Object)datacenter);
        if (map != null) {
            return (String)map.get("isc_hub");
        }
        return null;
    }

    public static void removeLoginInfo(String dataCenter) {
        ierpLoginInfos.remove((Object)dataCenter);
    }

    public static void clearTokenCache() {
        tokenCache.clear();
    }

    public static void init(String dataCenter) {
        ((Initializer)Initializer.INSTANCE.get()).init(dataCenter);
    }

    static {
        try {
            InputStream inputStream = ConnectorCallback.class.getClassLoader().getResourceAsStream("resources/META-INF/initial_class");
            String initialClassName = NetUtil.readText(inputStream);
            if (!StringUtil.isEmpty((String)initialClassName)) {
                Object o = ReflectionUtil.newInstance((String)initialClassName);
                Initializer.INSTANCE.set((Object)((Initializer)o));
            }
        }
        catch (Throwable e) {
            ((LoggerFactory)LoggerFactory.REF.get()).getLogger(ConnectorCallback.class).error("init Initializer instance error : ", e);
        }
        tokenCache = new ReadLockFreeMap();
        ierpLoginInfos = new ReadLockFreeMap();
    }
}

