/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.data.Null;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.SimpleFC;
import kd.isc.iscb.util.misc.https.TrustAnyHostVerifier;
import kd.isc.iscb.util.misc.https.TrustAnySSLFactory;
import kd.isc.iscb.util.script.CancelSignal;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.encoding.Hex;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;
import kd.isc.iscb.util.trace.TraceManager;
import kd.isc.iscb.util.trace.TraceOutput;
import kd.isc.iscb.util.trace.TraceTask;

public class NetUtil {
    private static String serverId;
    public static final int TIMEOUT;
    private static final String DEFAULT_CHARSET_STR = "UTF-8";
    private static final Charset DEFAULT_CHARSET;
    private static final String SUCCESS_STR = "success";
    private static final String ERROR_CODE_STR = "errorCode";
    private static final String CHARSET_TAG = "charset=";
    private static final boolean TRUST_ANY_HTTPS;

    private static String appendServerPort(String serverId) {
        String port = System.getenv("APP_SERVER_HTTP_PORT");
        if (port != null) {
            return serverId + ":" + port;
        }
        return serverId;
    }

    private static boolean shouldTrustAnyHttps() {
        try {
            return D.x((Object)System.getProperty("ISC_TRUST_ANY_HTTPS"));
        }
        catch (Throwable e) {
            ((LoggerFactory)LoggerFactory.REF.get()).getLogger(NetUtil.class).error(ResManager.loadKDString((String)"\u521d\u59cb\u5316ISC_TRUST_ANY_HTTPS\u53c2\u6570\u503c\u5931\u8d25\uff1a", (String)"NetUtil_9", (String)"isc-iscb-util", (Object[])new Object[0]), e);
            return false;
        }
    }

    public static String getServerId() {
        return serverId;
    }

    public static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            throw CommonError.LOCAL_HOST_LOOKUP_ERROR.wrap((Throwable)e);
        }
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw CommonError.LOCAL_HOST_LOOKUP_ERROR.wrap((Throwable)e);
        }
    }

    public static List<String> getIpAddresses() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> en2 = ni.getInetAddresses();
                while (en2.hasMoreElements()) {
                    InetAddress ia = en2.nextElement();
                    list.add(ia.getHostAddress());
                }
            }
            return list;
        }
        catch (Throwable e) {
            return new ArrayList<String>();
        }
    }

    public static InetAddress getLocalInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw CommonError.LOCAL_HOST_LOOKUP_ERROR.wrap((Throwable)e);
        }
    }

    public static InetAddress getInetAddress(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (UnknownHostException e) {
            throw CommonError.UNKNOWN_HOST_ERROR.create((Throwable)e, new String[]{name});
        }
    }

    public static Object asyncHttpInvoke(String url, Object data) {
        try {
            return NetUtil.asyncHttpInvoke(url, data, null);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public static Object asyncHttpInvoke(String url, Object data, ConnectionDecorator decorator) {
        Object result = NetUtil.httpInvoke(url, data, DEFAULT_CHARSET_STR, decorator);
        if (!(result instanceof Map)) {
            return result;
        }
        return NetUtil.handleAsyncResult(url, (Map)result, decorator);
    }

    private static Object handleAsyncResult(String url, Map<?, ?> result, ConnectionDecorator decorator) {
        Object returns = NetUtil.checkError(result);
        if (!(returns instanceof Map)) {
            return returns;
        }
        result = (Map)returns;
        if (D.x(result.get("$keep-waiting"))) {
            D.sleep((long)5000L);
            return NetUtil.loadResult(url, result, decorator);
        }
        return result;
    }

    public static Object loadResult(String url, Object result) {
        return NetUtil.loadResult(url, result, null);
    }

    public static Object loadResult(String url, Object result, ConnectionDecorator decorator) {
        int count = 0;
        while (true) {
            ((CancelSignal)CancelSignal.REF.get()).check();
            result = NetUtil.tryLoadResult(url, (Map)result, decorator);
            if (!(result instanceof Map)) {
                return result;
            }
            if (!D.x(((Map)result).get("$keep-waiting"))) break;
            count = NetUtil.checkMaxLimit(count, url);
        }
        return result;
    }

    private static int checkMaxLimit(int count, String url) {
        if (++count >= 20) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5c1d\u8bd520\u6b21\u4ecd\u7136\u65e0\u6cd5\u83b7\u53d6\u5230\u6267\u884c\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u76ee\u6807\u670d\u52a1\u5668\u7684\u7ebf\u7a0b\u662f\u5426\u5b58\u5728\u963b\u585e\u3002url=%s", (String)"NetUtil_5", (String)"isc-iscb-util", (Object[])new Object[0]), NetUtil.trim(url)));
        }
        NetUtil.sleepSeconds(count);
        return count;
    }

    private static void sleepSeconds(int count) {
        D.sleep((long)((long)count * 6000L));
    }

    private static Object tryLoadResult(String url, Map<?, ?> map, ConnectionDecorator decorator) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("command", "get_result");
        params.put("$id", (String)map.get("$id"));
        Object result = NetUtil.httpInvoke(url, params, DEFAULT_CHARSET_STR, decorator);
        return NetUtil.checkError(result);
    }

    public static void removeResult(String url, Map<String, Object> result) {
        NetUtil.removeResult(url, result, null);
    }

    public static void removeResult(String url, Map<String, Object> result, ConnectionDecorator decorator) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "remove_result");
        params.put("$id", result.get("$id"));
        try {
            NetUtil.httpInvoke(url, params, DEFAULT_CHARSET_STR, decorator);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public static String httpRead(String url, String charset) {
        return NetUtil.httpRead(url, charset, TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpRead(String url, String charset, int timeout) {
        Reader reader = NetUtil.httpAccess(url, null, charset, null, "GET", timeout);
        try {
            String string = NetUtil.readText(reader);
            return string;
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    public static Reader httpGet(String url, String charset) {
        return NetUtil.httpAccess(url, null, charset, null, "GET", TIMEOUT);
    }

    public static Reader httpGet(String url, String charset, ConnectionDecorator decorator) {
        return NetUtil.httpAccess(url, null, charset, decorator, "GET", TIMEOUT);
    }

    public static Object httpInvoke(String url) {
        return NetUtil.httpInvoke(url, null);
    }

    public static Object httpInvoke(String url, Object data) {
        try {
            return NetUtil.httpInvoke(url, data, DEFAULT_CHARSET_STR);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public static Object httpInvoke(String url, Object data, String charset) {
        return NetUtil.httpInvoke(url, data, charset, null);
    }

    public static Reader httpPost(String url, String data, String charset) {
        return NetUtil.httpPost(url, data, charset, null);
    }

    public static Object httpInvoke(String url, Object data, String charset, ConnectionDecorator decorator) {
        String json = Json.toString((Object)data, (boolean)true);
        Reader reader = NetUtil.httpPost(url, json, charset, decorator);
        String text = NetUtil.readText(reader);
        try {
            return Script.parseJson((String)text);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"JSON\u89e3\u6790\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u6587\u672c\u662f\uff1a%s", (String)"NetUtil_6", (String)"isc-iscb-util", (Object[])new Object[0]), text), (Throwable)e);
        }
    }

    public static Reader httpPost(String url, String data, String charset, ConnectionDecorator decorator) {
        return NetUtil.httpAccess(url, data, charset, decorator, null, TIMEOUT);
    }

    public static Reader httpPut(String url, String data, String charset, ConnectionDecorator decorator) {
        return NetUtil.httpAccess(url, data, charset, decorator, "PUT", TIMEOUT);
    }

    public static Reader httpAccess(String url, String data, String charset, ConnectionDecorator decorator, String method) {
        return NetUtil.httpAccess(url, data, charset, decorator, method, TIMEOUT);
    }

    public static Reader httpAccess(String url, String data, String charset, ConnectionDecorator decorator, String method, int timeout) {
        if (((TraceOutput)TraceOutput.INSTANCE.get()).isHttpTraceEnabled(url)) {
            return NetUtil.innerAccessWithTrace(url, data, charset, decorator, method, timeout);
        }
        return NetUtil.innerAccess(url, data, charset, decorator, method, timeout);
    }

    private static Reader innerAccessWithTrace(final String url, final String data, final String charset, final ConnectionDecorator decorator, final String method, final int timeout) {
        int i = url.indexOf(63);
        String number = i < 0 ? url : url.substring(0, i) + "?...";
        return (Reader)TraceManager.run((String)"HTTP", (String)number, (long)0L, (TraceTask)new TraceTask(){

            public Object invoke() {
                return NetUtil.innerAccess(url, data, charset, decorator, method, timeout);
            }
        });
    }

    private static Reader innerAccess(String url, String data, String charset, ConnectionDecorator decorator, String method, int timeout) {
        HttpURLConnection http = NetUtil.openConnection(url);
        NetUtil.setHeader(url, http, timeout);
        NetUtil.beforeSubmit(http, decorator);
        NetUtil.sendRequest(http, url, data, charset, method);
        return NetUtil.handleResponse(charset, decorator, http);
    }

    private static Reader handleResponse(String charset, ConnectionDecorator decorator, HttpURLConnection http) {
        int responseCode = NetUtil.getResponseCode(http);
        if (responseCode >= 200 && responseCode < 400) {
            NetUtil.afterSubmit(http, decorator);
            return NetUtil.getResultReader(http, charset);
        }
        throw NetUtil.createError(http, responseCode);
    }

    public static InputStream httpAccess(String url, String method, byte[] body, String contentType, ConnectionDecorator decorator, int timeout) {
        if (((TraceOutput)TraceOutput.INSTANCE.get()).isHttpTraceEnabled(url)) {
            return NetUtil.innerAccessWithTrace(url, method, body, contentType, decorator, timeout);
        }
        return NetUtil.innerAccess(url, method, body, contentType, decorator, timeout);
    }

    private static InputStream innerAccessWithTrace(final String url, final String method, final byte[] bytes, final String contentType, final ConnectionDecorator decorator, final int timeout) {
        int i = url.indexOf(63);
        String number = i < 0 ? url : url.substring(0, i) + "?...";
        return (InputStream)TraceManager.run((String)"HTTP", (String)number, (long)0L, (TraceTask)new TraceTask(){

            public Object invoke() {
                return NetUtil.innerAccess(url, method, bytes, contentType, decorator, timeout);
            }
        });
    }

    private static InputStream innerAccess(String url, String method, byte[] bytes, String contentType, ConnectionDecorator decorator, int timeout) {
        HttpURLConnection http = NetUtil.openConnection(url);
        NetUtil.setHeader(url, http, timeout);
        NetUtil.beforeSubmit(http, decorator);
        NetUtil.sendRequest(http, method, bytes, contentType);
        return NetUtil.handleResponse(decorator, http);
    }

    private static InputStream handleResponse(ConnectionDecorator decorator, HttpURLConnection http) {
        int responseCode = NetUtil.getResponseCode(http);
        if (responseCode >= 200 && responseCode < 400) {
            NetUtil.afterSubmit(http, decorator);
            return NetUtil.getInputStream(http);
        }
        throw NetUtil.createError(http, responseCode);
    }

    private static HttpURLConnection openConnection(String url) {
        String host = SimpleFC.visit((String)url);
        try {
            HttpURLConnection httpURLConnection = NetUtil.getHttpURLConnection(url, host);
            if (TRUST_ANY_HTTPS && httpURLConnection instanceof HttpsURLConnection) {
                NetUtil.ignoreHttpsVerify((HttpsURLConnection)httpURLConnection);
            }
            return httpURLConnection;
        }
        catch (MalformedURLException e) {
            throw CommonError.MALFORMED_URL.create((Throwable)e, new String[]{url});
        }
        catch (UnknownHostException e) {
            throw CommonError.UNKNOWN_HOST_ERROR.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
        catch (IOException e) {
            throw CommonError.CONNECTION_OPEN_ERROR.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
    }

    private static void ignoreHttpsVerify(HttpsURLConnection httpsURLConnection) {
        httpsURLConnection.setSSLSocketFactory(TrustAnySSLFactory.INSTANCE.getSSLSocketFactory());
        httpsURLConnection.setHostnameVerifier((HostnameVerifier)TrustAnyHostVerifier.INSTANCE);
    }

    private static HttpURLConnection getHttpURLConnection(String url, String host) throws IOException {
        if (!host.contains("=>")) {
            return (HttpURLConnection)new URL(url).openConnection();
        }
        return NetUtil.openConnectionWithProxy(url);
    }

    private static HttpURLConnection openConnectionWithProxy(String url) throws IOException {
        String proxyServer = NetUtil.getProxyServer(url);
        String realURL = NetUtil.excludeProxyServer(url, proxyServer);
        Proxy proxy = NetUtil.getProxy(proxyServer);
        return (HttpURLConnection)new URL(realURL).openConnection(proxy);
    }

    private static String excludeProxyServer(String url, String proxyServer) {
        int j = url.indexOf(proxyServer);
        String realURL = url.substring(0, j) + url.substring(j + proxyServer.length() + "=>".length());
        return realURL;
    }

    private static Proxy getProxy(String proxyServer) {
        int k = proxyServer.indexOf(58);
        String ip = proxyServer.substring(0, k);
        int port = D.i((Object)proxyServer.substring(k + 1));
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ip, port));
        return proxy;
    }

    private static String getProxyServer(String url) {
        int i = url.indexOf("://");
        int j = url.indexOf("=>");
        return url.substring(i + "://".length(), j);
    }

    private static String trim(String url) {
        int i = url.indexOf(47, "https://".length());
        int j = url.indexOf(47, i + 1);
        if (j < 0) {
            return url;
        }
        return url.substring(0, j + 1) + "...";
    }

    private static Reader getResultReader(HttpURLConnection http, String charset) {
        InputStream in = NetUtil.getInputStream(http);
        try {
            return new InputStreamReader(in, charset);
        }
        catch (UnsupportedEncodingException e) {
            DbUtil.close((InputStream)in);
            throw CommonError.INVALID_CHARSET.create((Throwable)e, new String[]{charset});
        }
    }

    private static InputStream getInputStream(HttpURLConnection http) {
        try {
            InputStream inputStream = http.getInputStream();
            String contentEncoding = http.getContentEncoding();
            return NetUtil.wrapInputStream(inputStream, contentEncoding);
        }
        catch (IOException e) {
            String url = http.getURL().toString();
            throw CommonError.CONNECTION_OPEN_ERROR.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
    }

    private static InputStream wrapInputStream(InputStream inputStream, String contentEncoding) {
        try {
            if (NetUtil.isGzipEncoding(contentEncoding) && !(inputStream instanceof GZIPInputStream)) {
                return new GZIPInputStream(inputStream);
            }
            if (NetUtil.isDeflateEncoding(contentEncoding) && !(inputStream instanceof DeflaterInputStream)) {
                return new InflaterInputStream(inputStream, new Inflater(true));
            }
            return inputStream;
        }
        catch (IOException e) {
            throw D.e((Throwable)e);
        }
    }

    private static boolean isDeflateEncoding(String contentEncoding) {
        return "deflate".equalsIgnoreCase(contentEncoding);
    }

    private static boolean isGzipEncoding(String contentEncoding) {
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    private static int getResponseCode(HttpURLConnection http) {
        try {
            return http.getResponseCode();
        }
        catch (IOException e) {
            throw NetUtil.handleIOException(e, http);
        }
    }

    private static void sendRequest(HttpURLConnection http, String url, String data, String charset, String method) {
        if (data == null) {
            NetUtil.setRequestMethod(http, method != null ? method : "GET");
        } else {
            byte[] bytes = NetUtil.getBytes(data, charset);
            String contentType = NetUtil.getContentType(data) + "; charset=" + charset;
            NetUtil.sendRequest(http, method != null ? method : "POST", bytes, contentType);
        }
    }

    private static void sendRequest(HttpURLConnection http, String method, byte[] bytes, String contentType) {
        NetUtil.setRequestMethod(http, method);
        if (bytes != null) {
            NetUtil.setContentType(http, contentType, bytes);
            NetUtil.sendRequestData(http, bytes);
        }
    }

    private static void setContentType(HttpURLConnection http, String contentType, byte[] bytes) {
        if (D.s((Object)contentType) != null && D.s((Object)http.getRequestProperty("Content-Type")) == null) {
            http.setRequestProperty("Content-Type", contentType);
        }
        http.setRequestProperty("Content-Length", String.valueOf(bytes.length));
    }

    private static void sendRequestData(HttpURLConnection http, byte[] bytes) {
        http.setDoOutput(true);
        try {
            OutputStream os = http.getOutputStream();
            try {
                os.write(bytes);
                os.flush();
            }
            finally {
                DbUtil.close((OutputStream)os);
            }
        }
        catch (IOException e) {
            throw NetUtil.handleIOException(e, http);
        }
    }

    private static IscBizException handleIOException(IOException e, HttpURLConnection http) {
        String url = http.getURL().toString();
        String message = e.getMessage();
        if (message == null) {
            throw CommonError.REQUEST_SEND_ERROR.create((Throwable)e, new String[]{NetUtil.trim(url), e.getClass().getName()});
        }
        if (message.contains("refused")) {
            throw CommonError.CONNECTION_REFUSED.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
        if (message.contains("requested address")) {
            throw CommonError.CANNOT_ASSIGN_REQUESTED_ADDRESS.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
        if (message.contains("unreachable")) {
            throw CommonError.NETWORK_UNREACHABLE.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
        if (message.contains("timed out")) {
            throw CommonError.READ_TIMED_OUT.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
        if (message.contains("plaintext connection")) {
            throw CommonError.PROTOCOL_NOT_MATCHED.create((Throwable)e, new String[]{NetUtil.trim(url)});
        }
        throw CommonError.REQUEST_SEND_ERROR.create((Throwable)e, new String[]{NetUtil.trim(url), message});
    }

    private static byte[] getBytes(String data, String charset) {
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw CommonError.INVALID_CHARSET.create((Throwable)e, new String[]{charset});
        }
    }

    private static void setRequestMethod(HttpURLConnection http, String method) {
        try {
            http.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            throw CommonError.PROTOCOL_ERROR.create((Throwable)e, new String[]{method});
        }
    }

    private static String getContentType(String data) {
        if (NetUtil.isJson(data)) {
            return "application/json";
        }
        if (NetUtil.isXml(data)) {
            return "text/xml";
        }
        if (data.length() == 0 || data.contains("=")) {
            return "application/x-www-form-urlencoded";
        }
        return "text/plain";
    }

    private static boolean isXml(String data) {
        return data.startsWith("<?xml") && data.endsWith(">");
    }

    private static boolean isJson(String data) {
        return data.startsWith("{") && data.endsWith("}") || data.startsWith("[") && data.endsWith("]") || data.startsWith("(") && data.endsWith(")") || data.startsWith("\"") && data.endsWith("\"") || data.startsWith("'") && data.endsWith("'") || "null".equals(data) || Hex.isNumber((String)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IscBizException createError(HttpURLConnection http, int responseCode) {
        InputStream err = NetUtil.wrapInputStream(http.getErrorStream(), http.getContentEncoding());
        try {
            String text = NetUtil.readText(err, NetUtil.getCharset(http));
            String url = NetUtil.trimURL(http.getURL().toString());
            String code = String.valueOf(responseCode);
            IscBizException iscBizException = CommonError.UNKNOWN_SERVER_ERROR.create(new String[]{text, url, code});
            return iscBizException;
        }
        finally {
            DbUtil.close((InputStream)err);
        }
    }

    private static String getCharset(HttpURLConnection http) {
        String contentType = D.s((Object)http.getContentType());
        if (contentType != null) {
            String[] split = contentType.split(";");
            for (int i = 0; i < split.length; ++i) {
                String s = D.s((Object)split[i]);
                if (s == null || !s.startsWith(CHARSET_TAG)) continue;
                return s.substring(CHARSET_TAG.length());
            }
        }
        return DEFAULT_CHARSET_STR;
    }

    private static String trimURL(String url) {
        int i;
        if (url != null && (i = url.indexOf(63)) > 0) {
            url = url.substring(0, i);
        }
        return url;
    }

    public static String readText(InputStream err) {
        return NetUtil.readText(err, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(InputStream is, String charset) {
        if (is == null) {
            return "";
        }
        Charset c = charset == null ? DEFAULT_CHARSET : Charset.forName(charset);
        try {
            InputStreamReader reader = new InputStreamReader(is, c);
            String string = NetUtil.readText(reader);
            return string;
        }
        finally {
            DbUtil.close((InputStream)is);
        }
    }

    private static void afterSubmit(HttpURLConnection http, ConnectionDecorator decorator) {
        if (decorator != null) {
            decorator.afterSubmit(http);
        }
    }

    private static void beforeSubmit(HttpURLConnection http, ConnectionDecorator decorator) {
        if (decorator != null) {
            decorator.beforeSubmit(http);
        }
    }

    public static Object checkError(Object response) {
        if (!(response instanceof Map)) {
            return response;
        }
        Map map = (Map)response;
        Object data = map.get("data");
        if (data instanceof Map) {
            NetUtil.tryThrowStdError((Map)data);
        }
        Object succStr = map.get(SUCCESS_STR);
        Object errCodeStr = map.get(ERROR_CODE_STR);
        if (data != null && Boolean.TRUE.equals(succStr) && SUCCESS_STR.equals(errCodeStr)) {
            return Null.unwrap(data);
        }
        NetUtil.tryThrowIerpError(map, succStr, errCodeStr);
        NetUtil.tryThrowStdError(map);
        return Null.unwrap((Object)response);
    }

    private static void tryThrowIerpError(Map<?, ?> map, Object succStr, Object errCodeStr) {
        if ("error".equals(map.get("state")) || "false".equals(D.s((Object)succStr))) {
            Object errorMsg = map.get("errorMsg");
            Object errorCode = errCodeStr;
            Object message = map.get("message");
            if (errorMsg != null && errorCode != null) {
                throw new IscBizException(D.s(errorMsg) + "\r\n" + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7801\uff1a%s", (String)"NetUtil_7", (String)"isc-iscb-util", (Object[])new Object[0]), errorCode) + "\r\n\r\n" + String.format(ResManager.loadKDString((String)"\u66f4\u591a\u4fe1\u606f\uff1a%s", (String)"NetUtil_8", (String)"isc-iscb-util", (Object[])new Object[0]), map));
            }
            if (message != null) {
                throw new IscBizException(D.s(message) + "\r\n\r\n" + String.format(ResManager.loadKDString((String)"\u66f4\u591a\u4fe1\u606f\uff1a%s", (String)"NetUtil_8", (String)"isc-iscb-util", (Object[])new Object[0]), map));
            }
            throw new IscBizException(map.toString());
        }
    }

    private static void tryThrowStdError(Map<?, ?> map) {
        if (map.containsKey("#message")) {
            String s = (String)map.get("#stack_trace");
            if (s == null) {
                s = (String)map.get("#message");
            }
            throw new IscBizException(s);
        }
    }

    public static Reader httpPost(String url, String data) {
        return NetUtil.httpPost(url, data, DEFAULT_CHARSET_STR);
    }

    public static String readText(Reader reader) {
        try {
            StringBuilder sb = new StringBuilder();
            int c = reader.read();
            while (c >= 0) {
                sb.append((char)c);
                c = reader.read();
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw CommonError.INPUT_READER_FAILURE.wrap((Throwable)e);
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    private static void setHeader(String url, HttpURLConnection http, int timeout) {
        int i = url.indexOf(63);
        String referer = i < 1 ? url : url.substring(0, i);
        http.setRequestProperty("Referer", referer);
        http.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)");
        if (timeout > 0) {
            http.setConnectTimeout(timeout);
            http.setReadTimeout(timeout);
        }
    }

    private static void initTracePatch() {
        if (System.getenv("HTTP_TRACE_REPLACED_AS_PATCH") != null || D.x((Object)System.getProperty("HTTP_TRACE_REPLACED_AS_PATCH"))) {
            try {
                Field f = HttpURLConnection.class.getDeclaredField("methods");
                f.setAccessible(true);
                String[] methods = (String[])f.get(null);
                for (int i = 0; i < methods.length; ++i) {
                    if (!"TRACE".equals(methods[i])) continue;
                    methods[i] = "PATCH";
                    break;
                }
            }
            catch (Throwable e) {
                ((LoggerFactory)LoggerFactory.REF.get()).getLogger(NetUtil.class).error("REPLACE_TRACE_AS_PATCH_FAILED", e);
            }
        }
    }

    static {
        DEFAULT_CHARSET = D.UTF_8;
        TIMEOUT = D.i((Object)System.getProperty("net_timeout", "300000"));
        TRUST_ANY_HTTPS = NetUtil.shouldTrustAnyHttps();
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            String name = runtime.getName();
            serverId = InetAddress.getLocalHost().getHostAddress();
            if (name.contains("@")) {
                serverId = name.substring(0, name.indexOf(64)) + '@' + serverId;
            }
            if ((serverId = NetUtil.appendServerPort(serverId)).length() > 50) {
                serverId = serverId.substring(0, 20) + "*" + serverId.substring(serverId.length() - 50 + 21);
            }
        }
        catch (Throwable e) {
            serverId = "127.0.0.1";
        }
        NetUtil.initTracePatch();
    }
}

