/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.PasswordEncryptUtil;
import kd.bos.util.SystemProperties;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.api.CommonApiDispatcher;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.SystemContext;

public class APITestFormPlugin
extends AbstractFormPlugin {
    private static final String URL_TAG = "url_tag";
    private static final String PARAM = "param";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String NOT_PUBLISH = "not_publish";
    private static final String INPUT_CACHE = "input_cache";
    private static final Log LOG = LogFactory.getLog(APITestFormPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (SystemContext.isProcEnv()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_token"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (!params.isEmpty()) {
            this.initInterface(params);
        }
        this.getPageCache().put(INPUT_CACHE, D.s(params.get(PARAM)));
        RequestContext r = RequestContext.get();
        String key = D.s((Object)r.getCurrUserId());
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("iscb.apitest");
        String redisValue = (String)cache.get(key);
        if (redisValue != null) {
            Map value = (Map)Json.toObject((String)Cipher.decrypt((String)redisValue));
            this.getModel().setValue("proxy_user_id", value.get("userId"));
            this.getModel().setValue("password", value.get("password"));
            this.getModel().setValue("proxy_user_pwd", value.get("userPassword"));
            long currUserId = RequestContext.get().getCurrUserId();
            this.getView().setVisible(Boolean.valueOf(currUserId != D.l(value.get("userId"))), new String[]{"proxy_user_pwd"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("proxy_user".equals(e.getProperty().getName())) {
            long currUserId = RequestContext.get().getCurrUserId();
            long chooseUserId = D.l((Object)this.getModel().getValue("proxy_user_id"));
            this.getView().setVisible(Boolean.valueOf(currUserId != chooseUserId), new String[]{"proxy_user_pwd"});
        }
    }

    private void initInterface(Map<String, Object> params) {
        String name = D.s((Object)params.get("name"));
        String url = D.s((Object)params.get("url"));
        this.getModel().setValue("name", (Object)name);
        this.getModel().setValue("url", (Object)this.trimUrl(url));
        this.getModel().setValue(URL_TAG, (Object)url);
        CodeEdit input = (CodeEdit)this.getView().getControl("input");
        input.setText(D.s((Object)params.get(PARAM)));
        this.getPageCache().put("initUrl", url);
        this.getPageCache().put(NOT_PUBLISH, D.s((Object)params.get(NOT_PUBLISH)));
        if (this.getModel().getValue("proxy_user") == null) {
            this.getModel().setValue("proxy_user", (Object)RequestContext.get().getCurrUserId());
            this.getView().setVisible(Boolean.FALSE, new String[]{"proxy_user_pwd"});
        }
        boolean urlEditable = D.x((Object)params.get("url_editable"));
        this.getView().setVisible(Boolean.TRUE, new String[]{"url", "btn_token"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"caller"});
        if (D.x((Object)params.get(NOT_PUBLISH))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"url", "btn_token"});
            if (urlEditable) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"caller"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(urlEditable), new String[]{"url"});
        }
    }

    private String trimUrl(String initUrl) {
        return initUrl.length() > 255 ? initUrl.substring(0, 255) : initUrl;
    }

    private DynamicObject getLink(Map<String, Object> params) {
        long id = D.l((Object)params.get("link_id"));
        if (id == 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"API\u6d4b\u8bd5\u9875\u9762\u8fde\u63a5\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u521d\u59cb\u5316\u53c2\u6570\uff0c\u4fdd\u8bc1link_id\u6709\u503c\u3002", (String)"APITestFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_database_link");
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
            return;
        }
        try {
            this.executeOperation(operateKey);
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw e;
            }
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void executeOperation(String operateKey) {
        if ("btnok".equals(operateKey)) {
            this.checkTestPassword();
            this.checkLoginPassword();
            this.executeTest();
            this.putPasswordIntoRedis();
        } else if ("get_access_token".equals(operateKey)) {
            this.checkLoginPassword();
            this.getView().showMessage(ACCESS_TOKEN, this.getAccessToken(), MessageTypes.Default);
        }
    }

    private void putPasswordIntoRedis() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("iscb.apitest");
        String userId = D.s((Object)this.getModel().getValue("proxy_user_id"));
        String password = D.s((Object)this.getModel().getValue("password"));
        String userPassword = D.s((Object)this.getModel().getValue("proxy_user_pwd"));
        HashMap<String, String> value = new HashMap<String, String>(3);
        value.put("userId", userId);
        value.put("password", password);
        value.put("userPassword", userPassword);
        RequestContext r = RequestContext.get();
        cache.put(D.s((Object)r.getCurrUserId()), (Object)Cipher.encrypt((String)Json.toString(value)), 1800);
    }

    private void checkTestPassword() {
        String password = D.s((Object)this.getModel().getValue("password"));
        String envPwd = D.s((Object)SystemProperties.getWithEnv((String)"ISC_TEST_PASSWORD"));
        if (password == null || !StringUtil.equals((String)password, (String)envPwd)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u6d4b\u8bd5\u5bc6\u7801\u4e3a\u7a7a\u6216\u4e0d\u6b63\u786e!", (String)"APITestFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkLoginPassword() {
        String userId = D.s((Object)this.getModel().getValue("proxy_user_id"));
        if (RequestContext.get().getCurrUserId() == D.l((Object)userId)) {
            return;
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)D.l((Object)userId), (String)"bos_user", (String)"password");
        String userPassword = D.s((Object)this.getModel().getValue("proxy_user_pwd"));
        String oldPassword = user.getString("password");
        boolean passed = PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt((String)userId), (String)userPassword, (String)oldPassword);
        if (!passed) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u7528\u6237\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"APITestFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void executeTest() {
        if (D.x((Object)this.getPageCache().get(NOT_PUBLISH))) {
            this.fakeInvokeWebApi();
        } else {
            try {
                this.invokeWebApi();
                this.recordLogs(null);
            }
            catch (Exception e) {
                this.recordLogs(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fakeInvokeWebApi() {
        RequestContext current = RequestContext.get();
        RequestContext new_rc = null;
        try {
            new_rc = ContextUtil.restoreAndGetContext((RequestContext)current, (String)D.s((Object)this.getModel().getValue("proxy_user_id")));
            this.invokeLocal();
        }
        catch (Exception e) {
            this.recordLogs(e);
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
        finally {
            if (new_rc != null) {
                RequestContextCreator.restoreForMQ((RequestContext)current);
            }
        }
    }

    private void invokeLocal() {
        String url = D.s((Object)this.getPageCache().get("initUrl"));
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf(63));
        }
        DynamicObject caller = (DynamicObject)this.getModel().getValue("caller");
        String callerNum = null;
        if (caller != null) {
            callerNum = caller.getString("number");
        }
        WebApiContext ctx = new WebApiContext();
        ctx.setRequestURL(url);
        HashMap<String, String> queryString = new HashMap<String, String>(1);
        queryString.put("caller", callerNum);
        ctx.setQueryString(queryString);
        CodeEdit input = (CodeEdit)this.getView().getControl("input");
        try {
            ctx.setData((Map)JSON.parseObject((String)D.s((Object)this.getInputParams(input))));
        }
        catch (Exception e) {
            this.recordLogs(e);
            FormOpener.showErrorMessage((IFormView)this.getView(), (String)String.format(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u5f02\u5e38:%s", (String)"APITestFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), (String)ShowStackTraceUtil.getErrorMsg((Throwable)e));
            return;
        }
        ApiResult result = new CommonApiDispatcher().doMicroService(ctx);
        if (result.getSuccess()) {
            String rt = JSON.toJSONString((Object)result.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
            CodeEdit output = (CodeEdit)this.getView().getControl("output");
            output.setText(rt);
            this.getView().updateView();
            this.recordLogs(null);
        } else {
            CodeEdit output = (CodeEdit)this.getView().getControl("output");
            output.setText(result.getMessage());
            this.recordLogs((Throwable)new IscBizException(result.getMessage()));
        }
        this.getView().updateView();
    }

    private String getInputParams(CodeEdit input) {
        String inputParams;
        if (input.getText() == null) {
            inputParams = this.getPageCache().get(INPUT_CACHE);
        } else {
            inputParams = input.getText();
            this.getPageCache().put(INPUT_CACHE, inputParams);
        }
        return inputParams;
    }

    private void invokeWebApi() {
        String url = D.s((Object)this.getModel().getValue(URL_TAG));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(ACCESS_TOKEN, this.getAccessToken());
        CodeEdit input = (CodeEdit)this.getView().getControl("input");
        String param = D.s((Object)this.getInputParams(input));
        HttpConnectionDecorator httpConnectionDecorator = new HttpConnectionDecorator(new HashMap(), header);
        Reader result = NetUtil.httpPost((String)url, (String)param, (String)"UTF-8", (NetUtil.ConnectionDecorator)httpConnectionDecorator);
        String readText = NetUtil.readText((Reader)result);
        Object txtObj = SerializationUtils.fromJsonString((String)readText, Map.class);
        String rt = JSON.toJSONString((Object)txtObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
        CodeEdit output = (CodeEdit)this.getView().getControl("output");
        output.setText(rt);
        this.getView().updateView();
    }

    private String getAccessToken() {
        String userId = D.s((Object)this.getModel().getValue("proxy_user_id"));
        DynamicObject user = BusinessDataServiceHelper.loadHead((Object)userId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_user"));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject link = this.getLink(params);
        Map loginInfo = ConnectorUtil.getThirdLoginInfo((DynamicObject)link, (DynamicObject)user);
        loginInfo.put("ierp_server_url", UrlService.getDomainContextUrl());
        if (ConnectorUtil.passwordRequired()) {
            String userPwd = D.s((Object)this.getModel().getValue("proxy_user_pwd"));
            Assert.notNull((Object)userPwd, (String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ee3\u7406\u7528\u6237\u5bc6\u7801\u540e\u518d\u8fdb\u884c\u6d4b\u8bd5\u3002", (String)"APITestFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            loginInfo.put("password", userPwd);
            loginInfo.put("logintype", "2");
        }
        return ConnectorCallback.getAccessToken((Map)loginInfo);
    }

    private void recordLogs(Throwable err) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String type = D.s(params.get("apiEntityType"));
        try {
            DynamicObject opLog = BusinessDataServiceHelper.newDynamicObject((String)"isc_operation_log");
            opLog.set("number", params.get("apiNumber"));
            opLog.set("name", params.get("name"));
            opLog.set("schemaid", params.get("apiPkValue"));
            if (err == null) {
                opLog.set("desc", (Object)ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f", (String)"APITestFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                opLog.set("desc", (Object)String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5931\u8d25\uff1a\u539f\u56e0%s", (String)"APITestFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)err), (int)800)));
            }
            opLog.set("type", (Object)type);
            opLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            opLog.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
            opLog.set("operation_code", (Object)"test");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{opLog});
        }
        catch (Exception e) {
            LOG.warn("\u8bb0\u5f55API\u6d4b\u8bd5\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff0c\u64cd\u4f5c\uff1a\u6d4b\u8bd5\uff0c\u5b9e\u4f53\uff1a+" + type + ", \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
    }
}

