/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.dc.DatabaseLinkUtil;
import kd.isc.iscb.formplugin.dc.cntype.DynamicConfigForCnType;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.InitBindDataUtil;
import kd.isc.iscb.formplugin.util.ResourceIsolateUtil;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.db_proxy.Util;
import kd.isc.iscb.platform.core.connector.ierp.IerpUtil;
import kd.isc.iscb.platform.core.connector.k3cloud.cookie.CookieCache;
import kd.isc.iscb.platform.core.connector.k3cloud.metadata.K3CloudUtil;
import kd.isc.iscb.platform.core.factory.FactoryManager;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class DatabaseLinkFormPlugin
extends AbstractFormPlugin {
    private static final String ENABLE = "enable";
    private static final String ISC_CONNECTION_TYPE = "isc_connection_type";
    private static final String NUMBER = "number";
    private static final String DB_LINK = "dblink";
    private static final String APPSECRET = "appsecret";
    private static final String APPSECRET_NEW = "appsecret_new";
    private static final String FIELD_SECRET_KEY = "password";
    private static final String DUM_LINK = "dum_link";
    private static final String TYPE_EAS = "eas";
    private static final String TYPE_DB_PROXY = "db_proxy";
    private static final String TYPE_SAP_PROXY = "SAP-RFC-Proxy";
    private static final String TYPE_IERP = "ierp";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static final String OP_CREATE_DATA_SOURCE = "create_data_source";
    private static final String USER = "user";
    private static final String NEW_CIPHER = "newpwd";
    private static final String STATE = "state";
    private static final String HTTP_PROTOCAL = "http_protocal";
    private static final String SERVER_PORT = "server_port";
    private static final String SERVER_IP = "server_ip";
    private static final String DATABASE_TYPE = "database_type";
    private static final String DATA_CENTER = "data_center";
    private static final String SELECT_DC = "select_dc";
    private static final int MAX_COUNT_OF_COMBO = 15;
    private static final Set<String> FIELDS_NEED_NOT_COMPARE = new HashSet<String>(Arrays.asList("has_assign_perm", "modifytime", "name", "license_info", "license_sn", "isv", "createtime", "creator", "modifier", "dum_link", "eas_tips"));

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        String number = D.s(params.get(NUMBER));
        if (StringUtils.isNotEmpty((String)number) && number.equals("K3Cloud-API")) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u661f\u7a7a\u4f01\u4e1a\u7248-API\u8fde\u63a5\u914d\u7f6e", (String)"DatabaseLinkFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit dum_link;
        super.registerListener(e);
        this.addClickListeners(new String[]{DATA_CENTER});
        if (this.isUserDefineDatabaseType()) {
            this.addClickListeners(new String[]{"edit_config_ap"});
        }
        if (this.isImapDatabaseType()) {
            this.addClickListeners(new String[]{"edit_config_iam"});
        }
        if ((dum_link = (BasedataEdit)this.getView().getControl(DUM_LINK)) != null) {
            dum_link.addBeforeF7ViewDetailListener((Consumer)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void click(EventObject evt) {
        block9: {
            super.click(evt);
            String type = (String)this.getModel().getValue(DATABASE_TYPE);
            Control src = (Control)evt.getSource();
            String key = src.getKey();
            if (DATA_CENTER.equals(key)) {
                try {
                    if (TYPE_EAS.equals(type)) {
                        HashMap<String, List> params = new HashMap<String, List>();
                        DynamicObject dataEntity = this.getModel().getDataEntity();
                        String server_ip = dataEntity.getString(SERVER_IP);
                        String server_port = dataEntity.getString(SERVER_PORT);
                        String protocal = dataEntity.getString(HTTP_PROTOCAL);
                        params.put("dc_list", kd.isc.iscb.platform.core.connector.eas.Util.getDataCenterList((String)protocal, (String)server_ip, (String)server_port));
                        FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_datacenter_list", (String)DatabaseLinkFormPlugin.getDataCenterListCaption(), params, (String)SELECT_DC);
                        break block9;
                    }
                    if ("k3cloud".equals(type)) {
                        HashMap<String, List> params = new HashMap<String, List>(12);
                        DynamicObject dataEntity = this.getModel().getDataEntity();
                        String ip = dataEntity.getString(SERVER_IP);
                        String port = dataEntity.getString(SERVER_PORT);
                        String protocal = dataEntity.getString(HTTP_PROTOCAL);
                        String app = dataEntity.getString("web_app");
                        params.put("dc_list", K3CloudUtil.getDataCenterList((String)protocal, (String)ip, (String)port, (String)app));
                        FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_datacenter_list", (String)DatabaseLinkFormPlugin.getDataCenterListCaption(), params, (String)SELECT_DC);
                        break block9;
                    }
                    this.getView().showMessage(ResManager.loadKDString((String)"\u975eEAS\u3001k3cloud\u8fde\u63a5\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u9009\u62e9\u6570\u636e\u4e2d\u5fc3\uff0c\u8bf7\u624b\u5de5\u8f93\u5165", (String)"DatabaseLinkFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable e) {
                    FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
                }
            } else if ("edit_config_ap".equals(key)) {
                this.handleExtendConfig();
            } else if ("edit_config_iam".equals(key)) {
                this.handleExtendConfig();
            }
        }
    }

    private void handleExtendConfig() {
        try {
            String configStr = D.s((Object)this.getModel().getValue("attr9"));
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("configuration", configStr);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            boolean edit = status == OperationStatus.ADDNEW || status == OperationStatus.EDIT;
            param.put("edit", edit);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_param_custom_config", null, param, (String)"config_str");
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String formId;
            String tenant;
            String account = D.s((Object)this.getModel().getValue("account"));
            if (ContextUtil.isCurrentContext((String)account, (String)(tenant = D.s((Object)this.getModel().getValue("tenant"))))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u914d\u7f6e\u9879\u4e3a\u5f53\u524d\u8d26\u5957\u548c\u79df\u6237\uff0c\u5efa\u7acb\u5f53\u524d\u8d26\u5957\u7c7b\u578b\u8fde\u63a5\u5373\u53ef\u3002", (String)"DatabaseLinkFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if ("isc_database_link_eas".equals(formId = this.getView().getFormShowParameter().getFormId())) {
                this.checkEASConfig(args);
            } else if ("isc_database_link_k3cloud".equals(formId)) {
                this.checkK3CloudLinkInfo(args);
            } else if ("isc_database_link_pgsql".equals(formId) || "isc_database_link_pgnew".equals(formId)) {
                this.checkPgSQLConfig(args);
            } else if ("isc_database_link_ierpapi".equals(formId)) {
                this.checkIerpApiConfig(args);
            } else if ("isc_database_link_dm".equals(formId)) {
                this.checkDmConfig(args);
            } else if ("isc_database_link_curdb".equals(formId)) {
                this.checkCurrentDBConfig(args);
            } else if ("isc_database_link_ierp".equals(formId)) {
                this.checkIerpConfig(args);
            } else if ("isc_database_link_self".equals(formId)) {
                this.checkIsExistsSelf(args);
            } else if ("isc_database_link_udf".equals(formId)) {
                this.checkUdfDbLinkConfig(args);
            } else if ("isc_database_link_pop3".equals(formId)) {
                this.checkPop3Config(args);
            } else if ("isc_database_link_imap".equals(formId)) {
                this.checkImapConfig(args);
            } else if ("isc_database_link_smtp".equals(formId)) {
                this.checkSmtpConfig(args);
            }
            if (!args.isCancel()) {
                this.getModel().setValue(STATE, null);
                this.getModel().setValue("has_assign_perm", (Object)false);
            }
            ConnectorUtil.setCurrentAccount((BeforeDoOperationEventArgs)args, (IDataModel)this.getModel());
            if (this.isCustomPage()) {
                this.setJsonDataToSave(args);
            } else if ("@#is_custom_page".equals(this.getModel().getValue("attr5"))) {
                this.getModel().setValue("attr5", (Object)"");
            }
        }
    }

    private void checkPop3Config(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || D.i((Object)this.getModel().getValue(SERVER_PORT)) == 0 || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr2"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(NEW_CIPHER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr5"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("charset"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr8")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u90ae\u4ef6\u670d\u52a1\u5668\u3001\u6536\u90ae\u4ef6\u7aef\u53e3\u53f7\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001\u6536\u90ae\u4ef6SSL\u3001\u90ae\u4ef6\u6253\u5f00\u65b9\u5f0f\u3001\u5b57\u7b26\u96c6\u3001\u6700\u5927\u53ef\u8bfb\u6587\u4ef6\u5927\u5c0f\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkImapConfig(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || D.i((Object)this.getModel().getValue(SERVER_PORT)) == 0 || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr2"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(NEW_CIPHER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr5"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("charset"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr8")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u90ae\u4ef6\u670d\u52a1\u5668\u3001\u6536\u90ae\u4ef6\u7aef\u53e3\u53f7\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001\u6536\u90ae\u4ef6SSL\u3001\u90ae\u4ef6\u6253\u5f00\u65b9\u5f0f\u3001\u5b57\u7b26\u96c6\u3001\u6700\u5927\u53ef\u8bfb\u6587\u4ef6\u5927\u5c0f\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkSmtpConfig(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || D.i((Object)this.getModel().getValue(SERVER_PORT)) == 0 || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr2"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("charset"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(NEW_CIPHER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u90ae\u4ef6\u670d\u52a1\u5668\u3001\u53d1\u90ae\u4ef6\u7aef\u53e3\u53f7\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001\u5b57\u7b26\u96c6\u3001\u53d1\u90ae\u4ef6SSL\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkUdfDbLinkConfig(BeforeDoOperationEventArgs args) {
        String jdbcUrl = D.s((Object)this.getModel().getValue("attr7"));
        String className = D.s((Object)this.getModel().getValue("attr8"));
        if (jdbcUrl == null || className == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"URL\u3001\u9a71\u52a8\u7c7b\u5168\u8def\u5f84\u540d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_43", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (jdbcUrl.startsWith("jdbc:postgresql://") || className.equals("org.postgresql.Driver")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528PostgreSQL\uff08\u65b0\u7248\uff09\u8fde\u63a5\u7c7b\u578b\u767b\u8bb0PG\u6570\u636e\u5e93\u8fde\u63a5\u3002", (String)"DatabaseLinkFormPlugin_44", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void checkIsExistsSelf(BeforeDoOperationEventArgs args) {
        if (D.l((Object)this.getModel().getValue("id")) != 0L) {
            return;
        }
        QFilter qFilter = new QFilter("dum_link.number", "=", (Object)"self");
        String source_app = D.s((Object)this.getView().getFormShowParameter().getCustomParam("source_app"));
        if (source_app != null) {
            qFilter.and("source_app", "=", (Object)source_app);
        } else {
            qFilter.and("source_app", "=", (Object)" ");
        }
        boolean isc_database_link = QueryServiceHelper.exists((String)ISC_DATABASE_LINK, (QFilter[])new QFilter[]{qFilter});
        if (isc_database_link) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f53\u524d\u8d26\u5957\u7684\u8fde\u63a5\u914d\u7f6e\uff0c\u8bf7\u590d\u7528\u8be5\u8fde\u63a5\u914d\u7f6e\u3002", (String)"DatabaseLinkFormPlugin_40", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkIerpConfig(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || D.i((Object)this.getModel().getValue(SERVER_PORT)) == 0 || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("account"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("tenant"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("appid"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(APPSECRET_NEW))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(NEW_CIPHER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("ierp_proxy_user")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u8d26\u5957ID\u3001\u79df\u6237ID\u3001\u5f00\u653e\u5e94\u7528\u7f16\u7801\u3001\u5f00\u653e\u5e94\u7528\u5bc6\u7801\u3001\u8fdc\u7aef\u82cd\u7a79\u767b\u5f55\u7528\u6237\u3001\u8fdc\u7aef\u82cd\u7a79\u7528\u6237\u5bc6\u7801\u3001\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setJsonDataToSave(BeforeDoOperationEventArgs eventArgs) {
        String json = this.getJsonDataFromPage();
        int length = json.length();
        if (length > 2000) {
            String title = String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u9274\u6743\u53c2\u6570\u7684\u957f\u5ea6\u603b\u548c\u4e0d\u80fd\u8d85\u8fc72000\uff0c\u5f53\u524d%s\u3002", (String)"DatabaseLinkFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), length) + "\n" + ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u8be6\u60c5\u67e5\u770b\u89e3\u51b3\u529e\u6cd5", (String)"DatabaseLinkFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            String detail = String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u9274\u6743\u53c2\u6570\u7684key\u548cvalue\u7ec4\u6210\u7684json\u4e32\u957f\u5ea6\u603b\u548c\u4e0d\u80fd\u8d85\u8fc72000\uff0c\u5f53\u524d%s\u3002", (String)"DatabaseLinkFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), length) + "\n" + ResManager.loadKDString((String)"\u5efa\u8bae:", (String)"DatabaseLinkFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u8fde\u63a5\u7c7b\u578b\u53c2\u6570\u5206\u5f55\u7684\u7f16\u7801\u8bbe\u7f6e\u4e0d\u8981\u8fc7\u957f\u3002", (String)"DatabaseLinkFormPlugin_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u8fde\u63a5\u914d\u7f6e\u586b\u5199\u7684\u53c2\u6570\u4e2d\u82e5\u6709\u7a7a\u683c\u548c\u56de\u8f66\uff0c\u53ef\u6e05\u9664\u540e\u518d\u5c1d\u8bd5\u4fdd\u5b58", (String)"DatabaseLinkFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            FormOpener.showErrorMessage((IFormView)this.getView(), (String)title, (String)detail);
            eventArgs.setCancel(true);
        } else {
            this.getModel().setValue("attr_e1", (Object)json);
            this.getModel().setValue("attr5", (Object)"@#is_custom_page");
        }
    }

    private String getJsonDataFromPage() {
        String id = this.getCnTypeID();
        DynamicConfigForCnType config = new DynamicConfigForCnType(id);
        Map map = config.collectConfigData(this.getModel());
        return Json.toString((Object)map);
    }

    private String getCnTypeID() {
        String id = D.s(this.getView().getFormShowParameter().getCustomParams().get(DUM_LINK));
        if (id == null) {
            id = this.getTypeIDFromCache();
        }
        return id;
    }

    private String getTypeIDFromCache() {
        String id;
        IFormView view = this.getView();
        if (view != null && (id = view.getPageCache().get(DUM_LINK)) != null) {
            return id;
        }
        return this.getTypeIDByLinkID();
    }

    private String getTypeIDByLinkID() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object linkID = billShowParameter.getPkId();
        DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)linkID, (String)ISC_DATABASE_LINK);
        String id = D.s((Object)link.getDynamicObject(DUM_LINK).getPkValue());
        this.getView().getPageCache().put(DUM_LINK, id);
        return id;
    }

    private void checkDmConfig(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || D.i((Object)this.getModel().getValue(SERVER_PORT)) == 0 || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(NEW_CIPHER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkCurrentDBConfig(BeforeDoOperationEventArgs args) {
        if (StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("attr1")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u5668\uff1a\u5206\u5e93\u6807\u8bc6\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkIerpApiConfig(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("appid"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("account"))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u82cd\u7a79-API\u8fde\u63a5\u5668\uff1a\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u5f00\u653e\u5e94\u7528\u7f16\u7801\u3001\u8d26\u5957ID\u3001\u767b\u5f55\u7528\u6237\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkPgSQLConfig(BeforeDoOperationEventArgs args) {
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || D.i((Object)this.getModel().getValue(SERVER_PORT)) == 0 || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(NEW_CIPHER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("sql_database")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001\u6570\u636e\u5e93\u540d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_42", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkEASConfig(BeforeDoOperationEventArgs args) {
        long ierpProxyUser;
        if (StringUtils.isEmpty((String)D.s((Object)this.getModel().getValue(SERVER_IP))) || D.i((Object)this.getModel().getValue(SERVER_PORT)) == 0 || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(DATA_CENTER))) || StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(USER)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u6570\u636e\u4e2d\u5fc3\u3001\u767b\u5f55\u7528\u6237\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DatabaseLinkFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ((ierpProxyUser = D.l((Object)this.getModel().getValue("ierp_proxy_user_id"))) > 0L) {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)ierpProxyUser, (String)"bos_user", (String)"username");
            if (StringUtil.isEmpty((String)D.s((Object)user.get("username")))) {
                this.getModel().setValue("ierp_proxy_user", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ee3\u7406\u7528\u6237\u65e0\u7528\u6237\u540d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DatabaseLinkFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237\u3002", (String)"DatabaseLinkFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void checkK3CloudLinkInfo(BeforeDoOperationEventArgs args) {
        this.cleanK3CloudCookies();
        this.checkK3CloudDBLink(args);
    }

    private void checkK3CloudDBLink(BeforeDoOperationEventArgs args) {
        Object server_ip = this.getModel().getValue(SERVER_IP);
        Object server_port = this.getModel().getValue(SERVER_PORT);
        Object user = this.getModel().getValue(USER);
        String newpwd = (String)this.getModel().getValue(NEW_CIPHER);
        Object dc = this.getModel().getValue(DATA_CENTER);
        Object web_app = this.getModel().getValue("web_app");
        if (ObjectUtils.isEmpty((Object)server_ip) || ObjectUtils.isEmpty((Object)server_port) || ObjectUtils.isEmpty((Object)user) || ObjectUtils.isEmpty((Object)newpwd) || ObjectUtils.isEmpty((Object)dc) || ObjectUtils.isEmpty((Object)web_app)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001\u6570\u636e\u4e2d\u5fc3\u3001web\u5e94\u7528\u540d\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u68c0\u67e5\u5b58\u5728\u672a\u586b\u9009\u9879\u3002", (String)"DatabaseLinkFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void cleanK3CloudCookies() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null) {
            CookieCache.remove((DynamicObject)dataEntity);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        try {
            String operateKey = args.getOperateKey();
            if ("view_access_key".equals(operateKey)) {
                this.getAccessKey();
            } else if ("test".equals(operateKey)) {
                this.testConnection();
            } else if ("get_datacenter_list".equals(operateKey)) {
                this.openDataCenterListForm();
            } else if ("save".equals(operateKey) || "delete".equals(operateKey)) {
                IscLicenseUtil.refreshCache();
                if ("save".equals(operateKey) && this.isSuccess(args)) {
                    this.checkLicense();
                    this.openDetailForm();
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.dealGuideMode(params, operateKey);
                    this.setCallbackVisible(this.getModel().getValue(DATABASE_TYPE));
                    this.saveDataSource();
                    this.saveIscxConnector();
                }
            } else if (OP_CREATE_DATA_SOURCE.equals(operateKey)) {
                this.autoCreateDataSource();
            } else if ("modify".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.dealGuideMode(params, operateKey);
            } else if ("get_sp_time".equals(operateKey)) {
                this.getConnectorInfo();
            } else if ("check_deploy_info".equals(operateKey)) {
                this.showDeployInfo(args);
            } else if ("getcallbackurl".equals(operateKey)) {
                Object res = DispatchServiceHelper.invokeBizService((String)"isc", (String)"kem", (String)"kemEncryptionService", (String)"getBaseAuthUrl", (Object[])new Object[]{this.getModel().getValue("id")});
                String url = D.s((Object)res);
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("content", url);
                FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_text_content_dialog", (String)ResManager.loadKDString((String)"\u56de\u8c03\u5730\u5740", (String)"DatabaseLinkListPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), p, null);
            } else if ("callback_test".equals(operateKey)) {
                DatabaseLinkUtil.callbackTest((AbstractFormPlugin)this, (AfterDoOperationEventArgs)args);
            }
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private String getFilterNumber() {
        String number = D.s((Object)this.getModel().getValue(NUMBER));
        String source_app = D.s((Object)this.getModel().getValue("source_app"));
        if (source_app != null) {
            return number + '_' + source_app;
        }
        return number;
    }

    private void saveIscxConnector() {
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("autoCreateIscxConnector"))) {
            return;
        }
        String number = this.getFilterNumber();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"iscx_connector", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
        if (obj == null) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"iscx_connector");
            obj.set(NUMBER, (Object)number);
            obj.set("name", (Object)D.s((Object)this.getModel().getValue("name")));
            obj.set("type", (Object)ISC_DATABASE_LINK);
            obj.set("connection", (Object)D.l((Object)this.getModel().getValue("id")));
            obj.set("source_app", (Object)D.s((Object)this.getModel().getValue("source_app")));
            obj.set("creator", (Object)RequestContext.get().getCurrUserId());
            obj.set("id", (Object)IDService.get().genLongId());
            ConnectorUtil.save((DynamicObject)obj);
        }
    }

    private void saveDataSource() {
        if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("autoCreateDataSource"))) {
            return;
        }
        String number = this.getFilterNumber();
        DynamicObject datacource = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
        if (datacource == null) {
            datacource = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_source");
            datacource.set(NUMBER, (Object)number);
            datacource.set("name", this.getModel().getValue("name"));
            datacource.set("type", (Object)ISC_DATABASE_LINK);
            datacource.set("dblink_id", (Object)D.l((Object)this.getModel().getValue("id")));
            datacource.set("connection_type", (Object)D.s((Object)this.getView().getFormShowParameter().getCustomParam(NUMBER)));
            datacource.set("isv", this.getModel().getValue("isv"));
            datacource.set(ENABLE, (Object)1);
            datacource.set("status", (Object)"C");
            datacource.set("source_app", (Object)D.s((Object)this.getModel().getValue("source_app")));
            datacource.set("creator", (Object)RequestContext.get().getCurrUserId());
            datacource.set("id", (Object)IDService.get().genLongId());
            ConnectorUtil.save((DynamicObject)datacource);
        }
    }

    private void showDeployInfo(AfterDoOperationEventArgs args) {
        long dblinkId = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, (AfterDoOperationEventArgs)args));
        if (dblinkId != 0L) {
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("id", dblinkId);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_connector_info", (String)ResManager.loadKDString((String)"\u68c0\u67e5\u90e8\u7f72\u4fe1\u606f", (String)"DatabaseLinkListPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    private void dealGuideMode(Map<String, Object> params, String key) {
        if (D.x((Object)params.get("is_guide_mode"))) {
            if ("save".equals(key)) {
                this.getView().getParentView().getPageCache().put("wizard_data_base_link_id", D.s((Object)this.getModel().getValue("id")));
                this.getView().getParentView().getPageCache().put("current_mode", "view_link_form");
                this.getView().getParentView().getPageCache().put("pageid", this.getView().getPageId());
                this.getView().getParentView().getPageCache().put("teststate", "false");
            } else if ("modify".equals(key)) {
                this.getView().getParentView().getPageCache().put("wizard_data_base_link_id", null);
                this.getView().getParentView().getPageCache().put("current_mode", "edit_link");
            }
            if ("test_link".equals(this.getView().getParentView().getPageCache().get("current_mode"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"test_connection"});
            } else {
                if (!D.x((Object)params.get("update"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_save"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_save"});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"test_connection"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_close"});
        }
    }

    private boolean isSuccess(AfterDoOperationEventArgs args) {
        return args.getOperationResult() != null && args.getOperationResult().isSuccess();
    }

    private void openDataCenterListForm() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<String> dataCenterList = this.getDataCenterList();
        String type = (String)this.getModel().getValue(DATABASE_TYPE);
        if (TYPE_EAS.equals(type)) {
            params.put("dc_list", dataCenterList);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_datacenter_list", (String)DatabaseLinkFormPlugin.getDataCenterListCaption(), params, (String)SELECT_DC);
        } else {
            params.put("content", StringUtil.join(this.getDataCenterList(), (String)"\n"));
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_text_content_dialog", (String)DatabaseLinkFormPlugin.getDataCenterListCaption(), params, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if (action.equals(SELECT_DC) && data instanceof Map) {
            this.getModel().setValue(DATA_CENTER, ((Map)data).get("datacenter"));
        } else if ("config_str".equals(action) && data instanceof String) {
            this.getModel().setValue("attr9", data);
        }
    }

    private void openDetailForm() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (ISC_DATABASE_LINK.equals(formId)) {
            BillShowParameter param = new BillShowParameter();
            String type = D.s((Object)this.getModel().getValue(DATABASE_TYPE));
            param.setFormId(DatabaseType.getForm((String)type));
            param.setPkId(this.getModel().getValue("id"));
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            param.setParentPageId(this.getView().getParentView().getPageId());
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void getAccessKey() {
        Object pk = this.getModel().getValue("id");
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)pk, (String)ISC_DATABASE_LINK);
        Object type = cfg.get(DATABASE_TYPE);
        HashMap<String, String> params = new HashMap<String, String>();
        if (TYPE_EAS.equals(type)) {
            params.put("content", kd.isc.iscb.platform.core.connector.eas.Util.getEasAccessKey((DynamicObject)cfg));
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_text_content_dialog", (String)ResManager.loadKDString((String)"EAS\u8bbf\u95ee\u952e", (String)"DatabaseLinkFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        } else if (TYPE_DB_PROXY.equals(type)) {
            String accessKey = Util.getDbProxyAccessKey((DynamicObject)cfg);
            params.put("content", accessKey);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_text_content_dialog", (String)ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4ee3\u7406\u8bbf\u95ee\u952e", (String)"DatabaseLinkFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        } else if (TYPE_SAP_PROXY.equals(type)) {
            String accessKey = Util.getDbProxyAccessKey((DynamicObject)cfg);
            params.put("content", accessKey);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_text_content_dialog", (String)ResManager.loadKDString((String)"SAP-RFC\u4ee3\u7406\u8bbf\u95ee\u952e", (String)"DatabaseLinkFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        } else if (TYPE_IERP.equals(type)) {
            String accessKey = IerpUtil.getIerpAccessKey((DynamicObject)cfg);
            params.put("content", accessKey);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_text_content_dialog", (String)ResManager.loadKDString((String)"\u8fdc\u7aef\u82cd\u7a79\u8bbf\u95ee\u952e", (String)"DatabaseLinkFormPlugin_41", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    private void testConnection() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (D.l((Object)dataEntity.getPkValue()) == 0L || this.hasPageModified(dataEntity.getPkValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e!", (String)"DatabaseLinkFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            DatabaseLinkUtil.testConnection((Map)params, (IFormView)this.getView(), (DynamicObject)dataEntity);
        }
    }

    private void getConnectorInfo() {
        String type = D.s((Object)this.getModel().getValue(DATABASE_TYPE));
        if (TYPE_EAS.equals(type)) {
            DynamicObject dbLink = this.getModel().getDataEntity();
            HashMap<String, StringBuilder> params = new HashMap<String, StringBuilder>();
            params.put("content", kd.isc.iscb.platform.core.connector.eas.Util.getConnectorInfo((DynamicObject)dbLink));
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_text_content_dialog", (String)ResManager.loadKDString((String)"sp\u5305\u6784\u5efa\u4fe1\u606f", (String)"DatabaseLinkFormPlugin_39", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\uff1a%1$s\uff0c\u4e0d\u652f\u6301\u67e5\u770bsp\u5305\u6784\u5efa\u65f6\u95f4\u3002", (String)"DatabaseLinkFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type));
        }
    }

    private boolean hasPageModified(Object pkValue) {
        DynamicObject dbLink = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)ISC_DATABASE_LINK);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ISC_DATABASE_LINK);
        for (Map.Entry entry : entityType.getAllFields().entrySet()) {
            Object dbValue;
            Object modelValue;
            String field = (String)entry.getKey();
            if (FIELDS_NEED_NOT_COMPARE.contains(field)) continue;
            DynamicProperty property = entityType.getProperty(field);
            if (property instanceof BasedataProp) {
                DynamicObject modelObj = this.getModel().getDataEntity(true).getDynamicObject(field);
                DynamicObject dbObj = dbLink.getDynamicObject(field);
                modelValue = modelObj != null ? modelObj.getPkValue() : Long.valueOf(0L);
                dbValue = dbObj != null ? dbObj.getPkValue() : Long.valueOf(0L);
            } else {
                modelValue = this.getModel().getValue(field);
                dbValue = dbLink.get(field);
            }
            if (this.isPwdField(field) && this.isEmpty((String)modelValue, (String)dbValue) || modelValue == null || modelValue.equals(dbValue) || DUM_LINK.equals(field)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(String modelValue, String dbValue) {
        return ConnectionConfig.isEmptyPassword((String)modelValue) && ConnectionConfig.isEmptyPassword((String)dbValue);
    }

    private boolean isPwdField(String field) {
        return field.equals(FIELD_SECRET_KEY) || field.equals(NEW_CIPHER) || field.equals(APPSECRET) || field.equals(APPSECRET_NEW) || field.equals("attr_e1") || field.equals("attr_e2");
    }

    private void autoCreateDataSource() {
        long linkId = D.l((Object)this.getModel().getValue("id"));
        if (linkId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"DatabaseLinkFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            Object[] ds = BusinessDataServiceHelper.load((String)"isc_data_source", (String)DB_LINK, (QFilter[])new QFilter[]{new QFilter(DB_LINK, "=", (Object)linkId)});
            if (!CollectionUtils.isEmpty((Object[])ds)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OP_CREATE_DATA_SOURCE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8fde\u63a5\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u6e90\uff0c\u662f\u5426\u7ee7\u7eed\u521b\u5efa?", (String)"DatabaseLinkFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            } else {
                this.openCreateDataSourceForm();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (OP_CREATE_DATA_SOURCE.equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.openCreateDataSourceForm();
        }
    }

    private void openCreateDataSourceForm() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DB_LINK, this.getModel().getValue("id"));
        params.put(NUMBER, this.getModel().getValue(NUMBER));
        params.put("name", this.getModel().getValue("name"));
        params.put("connection_type", this.getModel().getValue(DATABASE_TYPE));
        params.put("isv", this.getModel().getValue("isv"));
        params.put("source_app", this.getModel().getValue("source_app"));
        FormOpener.showAddNew((AbstractFormPlugin)this, (String)"isc_data_source", params);
    }

    private boolean isAddNew() {
        return this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{DATABASE_TYPE});
        this.getView().setVisible(Boolean.TRUE, new String[]{DUM_LINK});
        if (!this.hasModifyPermit()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_modify"});
        }
        if (this.isCustomPage()) {
            this.addFieldToPage();
        }
    }

    private void addFieldToPage() {
        String id = this.getCnTypeID();
        DynamicConfigForCnType config = new DynamicConfigForCnType(id);
        FlexPanelAp panelAP = config.getFlexPanelAP();
        List controlList = ((Container)panelAP.buildRuntimeControl()).getItems();
        Container myFldPanel = (Container)this.getView().getControl("params_pane");
        myFldPanel.getItems().addAll(controlList);
        this.getView().createControlIndex(myFldPanel.getItems());
        config.setDefaultFiledInfo(this.getView(), this.getModel());
        this.showJsonDataToPage(config);
    }

    private void showJsonDataToPage(DynamicConfigForCnType config) {
        String json = D.s((Object)this.getModel().getValue("attr_e1"));
        if (json != null) {
            Map map = (Map)Json.toObject((String)json);
            config.setDynamicFieldValues(this.getModel(), map);
        }
    }

    private boolean hasModifyPermit() {
        String databaseType = D.s((Object)this.getModel().getValue(DATABASE_TYPE));
        if (databaseType == null) {
            return true;
        }
        QFilter filter = new QFilter(NUMBER, "=", (Object)databaseType);
        DynamicObject dt = QueryServiceHelper.queryOne((String)ISC_CONNECTION_TYPE, (String)"permit", (QFilter[])new QFilter[]{filter});
        if (dt == null) {
            return true;
        }
        String permit = dt.getString("permit");
        return permit != null && permit.contains("UPDATE");
    }

    private boolean supportsEvent() {
        String type = D.s((Object)this.getModel().getValue(DATABASE_TYPE));
        return TYPE_EAS.equals(type) || TYPE_IERP.equals(type) || TYPE_DB_PROXY.equals(type);
    }

    private boolean hasPermitField() {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)ISC_CONNECTION_TYPE).getProperties();
        return properties.containsKey((Object)"permit");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String number = D.s(params.get(NUMBER));
        String new_type = D.s(params.get(DUM_LINK));
        if (number != null) {
            this.getModel().setValue(DATABASE_TYPE, (Object)number);
            this.getModel().setValue(DUM_LINK, (Object)new_type);
            this.getView().setEnable(Boolean.FALSE, new String[]{DATABASE_TYPE, DUM_LINK});
        }
        ResourceIsolateUtil.setSourceApp((IFormView)this.getView(), (IDataModel)this.getModel());
        IDataModel model = this.getModel();
        Object type = model.getValue(DATABASE_TYPE);
        if (TYPE_EAS.equals(type)) {
            this.getModel().setValue("eas_tips", (Object)ResManager.loadKDString((String)"\u3010EAS\u767b\u5f55\u7528\u6237\u3011\u6216\u3010\u5f53\u524d\u8d26\u5957\u56de\u8c03\u4ee3\u7406\u7528\u6237\u3011\u4e24\u8005\u7684\u5bc6\u7801\u4fee\u6539\u4f1a\u5bfc\u81f4\u5f53\u524dEAS\u8fde\u63a5\u5f02\u5e38\uff0c\u9700\u91cd\u65b0\u5728\u5217\u8868\u90e8\u7f72\u8be5EAS\u8fde\u63a5\u914d\u7f6e\u3002", (String)"DatabaseLinkFormPlugin_50", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if ("isc_hub".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{OP_CREATE_DATA_SOURCE, "bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, "name"});
        }
        this.setBtnGetDataCenterListState(type);
        if (!this.isAddNew()) {
            this.checkLicense();
        }
        this.migratePwd();
        if (this.supportsEvent()) {
            this.getView().setVisible(Boolean.valueOf(ConnectorUtil.passwordRequired()), new String[]{"attr_e1"});
        }
        this.dealGuideMode(params, null);
        this.setCallbackVisible(type);
        this.getView().setVisible(Boolean.valueOf(TYPE_EAS.equals(type)), new String[]{"callback_test"});
    }

    private void setCallbackVisible(Object type) {
        long pk = D.l((Object)this.getModel().getValue("id"));
        boolean alreadySave = pk > 0L;
        QFilter filter = new QFilter(NUMBER, "=", type);
        DynamicObject connType = BusinessDataServiceHelper.loadSingle((String)ISC_CONNECTION_TYPE, (String)"factory_class", (QFilter[])new QFilter[]{filter});
        if (connType == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"getcallbackurl"});
        } else {
            boolean supportWebhook = "kd.isc.iscb.platform.core.connector.webapi.SupportWebhookWebApiFactory".equals(connType.get("factory_class"));
            this.getView().setVisible(Boolean.valueOf(supportWebhook && alreadySave), new String[]{"getcallbackurl"});
        }
    }

    private void migratePwd() {
        String appsecretNew;
        IDataModel model = this.getModel();
        String newpwd = (String)model.getValue(NEW_CIPHER);
        if (ConnectionConfig.isEmptyPassword((String)newpwd)) {
            model.setValue(NEW_CIPHER, model.getValue(FIELD_SECRET_KEY));
            model.setValue(FIELD_SECRET_KEY, (Object)"");
        }
        if (ConnectionConfig.isEmptyPassword((String)(appsecretNew = (String)this.getModel().getValue(APPSECRET_NEW)))) {
            model.setValue(APPSECRET_NEW, model.getValue(APPSECRET));
            model.setValue(APPSECRET, (Object)"");
        }
    }

    private void setBtnGetDataCenterListState(Object type) {
        if (TYPE_EAS.equals(type) || TYPE_IERP.equals(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_get_datacenter_list"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_get_datacenter_list"});
        }
    }

    private void checkLicense() {
        if (this.isExpired()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u68c0\u67e5\u5230\u8bb8\u53ef\u5931\u6548\uff0c\u8bf7\u53ca\u65f6\u7eed\u671f\u6216\u8005\u8d2d\u4e70\u8bb8\u53ef\u3002", (String)"DatabaseLinkFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private boolean isExpired() {
        return IscLicenseUtil.getTenantLicenseInfo().isExpired();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        if (HTTP_PROTOCAL.equals(prop)) {
            this.setDefaultPortWhenProtocalChanged(e);
        }
        if (DATABASE_TYPE.equals(prop)) {
            this.databaseTypeChanged();
        } else if (SERVER_PORT.equals(prop)) {
            Object newValue2 = e.getChangeSet()[0].getNewValue();
            int port = D.i((Object)newValue2);
            if (port == 443) {
                this.getModel().setValue(HTTP_PROTOCAL, (Object)"https");
            } else if (port == 80) {
                this.getModel().setValue(HTTP_PROTOCAL, (Object)"http");
            }
        } else if (HTTP_PROTOCAL.equals(prop)) {
            if (this.getView().getControl(HTTP_PROTOCAL) != null && "http".equals(this.getModel().getValue(HTTP_PROTOCAL))) {
                this.getView().showMessage(ResManager.loadKDString((String)"http\u662f\u4e0d\u5b89\u5168\u534f\u8bae\uff0c\u4f7f\u7528\u8be5\u534f\u8bae\u5728\u7f51\u7edc\u4e0a\u4f20\u8f93\u6570\u636e\u65f6\u53ef\u80fd\u53d1\u751f\u4fe1\u606f\u6cc4\u9732\uff0c\u8bf7\u614e\u91cd\u8bc4\u4f30\u76f8\u5173\u98ce\u9669\u3002", (String)"DatabaseLinkFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if (SERVER_IP.equals(prop) && !StringUtil.isEmpty((String)D.s((Object)(newValue = e.getChangeSet()[0].getNewValue()))) && Pattern.matches("\\d+\\.\\d+\\.\\d+\\.\\d+", D.s((Object)newValue))) {
            this.getModel().setValue(HTTP_PROTOCAL, (Object)"http");
        }
    }

    private void setDefaultPortWhenProtocalChanged(PropertyChangedArgs e) {
        int port = D.i((Object)this.getModel().getValue(SERVER_PORT));
        if (port <= 0) {
            ChangeData[] changeSet = e.getChangeSet();
            String protocol = D.s((Object)changeSet[0].getNewValue());
            if ("https".equals(protocol)) {
                this.getModel().setValue(SERVER_PORT, (Object)443);
            } else {
                this.getModel().setValue(SERVER_PORT, (Object)80);
            }
        }
    }

    private void setDefaultLink() {
        DynamicObject[] types = BusinessDataServiceHelper.load((String)ISC_CONNECTION_TYPE, (String)"number,name,index", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")});
        List items = InitBindDataUtil.getComboItems((DynamicObject[])types, ConnectionFactory.class);
        Object databaseType = this.getModel().getValue(DATABASE_TYPE);
        if (databaseType == null) {
            return;
        }
        for (ComboItem item : items) {
            if (!databaseType.equals(item.getValue())) continue;
            DynamicObject type = BusinessDataServiceHelper.loadSingle((String)ISC_CONNECTION_TYPE, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", databaseType)});
            this.getModel().setValue(DUM_LINK, (Object)type);
            this.getView().updateView(DUM_LINK);
        }
    }

    private Map<String, String> getAvailableDataType() {
        DynamicObject[] types = BusinessDataServiceHelper.load((String)ISC_CONNECTION_TYPE, (String)"number,name", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")});
        if (types.length == 0) {
            return null;
        }
        HashMap<String, String> items = new HashMap<String, String>(types.length);
        for (DynamicObject i : types) {
            String number = i.getString(NUMBER);
            String name = i.getString("name");
            if (!(FactoryManager.find((String)number) instanceof ConnectionFactory)) continue;
            items.put(number, name);
        }
        return items;
    }

    private List<String> getDataCenterList() {
        String type = (String)this.getModel().getValue(DATABASE_TYPE);
        if (TYPE_EAS.equals(type)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String server_ip = dataEntity.getString(SERVER_IP);
            String server_port = dataEntity.getString(SERVER_PORT);
            String protocal = dataEntity.getString(HTTP_PROTOCAL);
            return kd.isc.iscb.platform.core.connector.eas.Util.getDataCenterList((String)protocal, (String)server_ip, (String)server_port);
        }
        if (TYPE_IERP.equals(type)) {
            return this.getIerpDataCenters();
        }
        return null;
    }

    private List<String> getIerpDataCenters() {
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        ArrayList<String> list = new ArrayList<String>(accounts.size());
        list.add(String.format(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u4ee5\u4e0b\u4e3a%s\u73af\u5883\u4e0b\u7684\u8d26\u5957\u548c\u79df\u6237\uff0c\u5176\u4ed6\u73af\u5883\u9700\u8981\u767b\u5f55\u76f8\u5e94\u82cd\u7a79\u7cfb\u7edf\uff0c\u5728\u8fde\u63a5\u914d\u7f6e\u5217\u8868\u754c\u9762\u83b7\u53d6\u8d26\u5957\u4fe1\u606f\uff0c\u6216\u76f4\u63a5\u5411\u8fd0\u7ef4\u4eba\u5458\u7d22\u53d6\u3002", (String)"DatabaseLinkFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), UrlService.getDomainContextUrl()));
        list.add(ResManager.loadKDString((String)"\u8d26\u5957ID\uff08\u8d26\u5957\u540d\uff09 | \u79df\u6237ID : ", (String)"DatabaseLinkFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        for (Account c : accounts) {
            list.add(c.getAccountId() + "( " + c.getAccountName() + " ) | " + c.getTenantId());
        }
        return list;
    }

    private void databaseTypeChanged() {
        IDataModel model = this.getModel();
        String type = (String)model.getValue(DATABASE_TYPE);
        this.setBtnGetDataCenterListState(type);
        if (!"sqlserver".equals(type) && !"mysql".equals(type)) {
            model.setValue("sql_database", null);
        } else if ("sqlserver".equals(type)) {
            model.setValue(SERVER_PORT, (Object)1433);
        } else {
            model.setValue(SERVER_PORT, (Object)3306);
            model.setValue("charset", (Object)"utf8");
        }
        if (!"oracle".equals(type)) {
            model.setValue("oracle_service", null);
        } else {
            model.setValue(SERVER_PORT, (Object)1521);
            model.setValue("oracle_service", (Object)"orcl");
        }
        if ("self".equals(type)) {
            model.setValue(SERVER_IP, null);
            model.setValue(SERVER_PORT, null);
            model.setValue(USER, null);
            model.setValue(FIELD_SECRET_KEY, null);
        }
        if (!TYPE_EAS.equals(type)) {
            model.setValue(DATA_CENTER, null);
        } else {
            model.setValue(USER, (Object)TYPE_DB_PROXY);
            model.setValue(SERVER_PORT, (Object)6888);
        }
        if (TYPE_IERP.equals(type)) {
            model.setValue(USER, null);
            model.setValue(SERVER_PORT, null);
        }
        if ("PostgreSQL".equals(type) || "PostgreSQL_New".equals(type)) {
            model.setValue("charset", (Object)"utf8");
            model.setValue(SERVER_PORT, (Object)5432);
        }
        if ("FTP".equals(type) || "FTP(apache)".equals(type)) {
            model.setValue(SERVER_PORT, (Object)21);
            model.setValue("charset", (Object)"UTF-8");
            model.setValue("attr8", (Object)"50M");
            model.setValue("attr9", (Object)"Passive");
        }
        if ("SFTP(jsch)".equals(type)) {
            model.setValue(SERVER_PORT, (Object)22);
            model.setValue("charset", (Object)"UTF-8");
            model.setValue("attr8", (Object)"50M");
        }
        if ("TMS_KD100".equals(type)) {
            model.setValue(SERVER_IP, (Object)"www.kuaidi100.com");
            model.setValue(SERVER_PORT, (Object)443);
        }
        if ("DM".equals(type)) {
            model.setValue(SERVER_PORT, (Object)5236);
        }
        if ("KD_pop3".equals(type) || "KD_imap".equals(type)) {
            model.setValue("charset", (Object)"utf-8");
            model.setValue("attr5", (Object)"1M");
            model.setValue("attr8", (Object)"READ_WRITE");
        }
        if ("KD_smtp".equals(type)) {
            model.setValue("charset", (Object)"utf-8");
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter billShowParameter = (FormShowParameter)e.getSource();
        if ("isc_database_link_common".equals(billShowParameter.getFormId())) {
            String typeID = D.s(billShowParameter.getCustomParams().get(DUM_LINK));
            if (typeID == null) {
                Object linkID = ((BillShowParameter)billShowParameter).getPkId();
                DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)linkID, (String)ISC_DATABASE_LINK);
                typeID = D.s((Object)link.getDynamicObject(DUM_LINK).getPkValue());
            }
            DynamicConfigForCnType config = new DynamicConfigForCnType(typeID);
            FlexPanelAp panelAP = config.getFlexPanelAP();
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", "params_pane");
            mapHead.put("items", (String)panelAP.createControl().get("items"));
            e.getItems().add(mapHead);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.isCustomPage()) {
            MainEntityType oldMainType = e.getOriginalEntityType();
            MainEntityType newMainType = null;
            try {
                newMainType = (MainEntityType)oldMainType.clone();
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
            }
            this.registerDynamicProps(newMainType);
            e.setNewEntityType(newMainType);
        }
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        String id = this.getCnTypeID();
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_CONNECTION_TYPE);
        DynamicObjectCollection collection = cnType.getDynamicObjectCollection("entryentity");
        DynamicConfigForCnType config = new DynamicConfigForCnType(collection);
        config.initFieldPropMap();
        for (DynamicObject object : collection) {
            DynamicProperty fieldProp = config.getFieldProp(D.s((Object)object.get("params_number")));
            if (fieldProp == null) continue;
            String params_type = D.s((Object)object.get("params_type"));
            if ("ref".equals(params_type)) {
                newMainType.registerComplexProperty((DynamicComplexProperty)((BasedataProp)fieldProp));
                DynamicProperty prop = config.getFieldProp(D.s((Object)object.get("params_number")) + "_id");
                newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
                continue;
            }
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String id;
        DynamicConfigForCnType config;
        FieldEdit fieldEdit;
        if (this.isCustomPage() && e.getKey().startsWith("config_") && (fieldEdit = (config = new DynamicConfigForCnType(id = this.getCnTypeID())).getFieldEditByKey(e.getKey())) != null) {
            fieldEdit.setView(this.getView());
            e.setControl((Control)fieldEdit);
        }
    }

    private boolean isCustomPage() {
        return "isc_database_link_common".equals(this.getView().getFormShowParameter().getFormId());
    }

    private static String getDataCenterListCaption() {
        return ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u5217\u8868", (String)"DatabaseLinkFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    private boolean isUserDefineDatabaseType() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "isc_database_link_udf".equals(formId);
    }

    private boolean isImapDatabaseType() {
        String formId = this.getView().getFormShowParameter().getFormId();
        return "isc_database_link_imap".equals(formId);
    }
}

