/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.apic.IscApiMeta;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.apic.ScriptApiMeta;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;

public abstract class AbstractApiDispatcher
implements IBillWebApiPlugin {
    private static final String CALLER = "caller";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResult doCustomService(WebApiContext ctx) {
        Map data = ctx.getData();
        Map query = ctx.getQueryString();
        String url = ctx.getRequestURL();
        String apiNumber = url.substring(url.lastIndexOf(47) + 1);
        String caller = null;
        if (!CollectionUtils.isEmpty((Map)query)) {
            caller = D.s(query.get(CALLER));
        }
        ScriptApiMeta.setWebContext((WebApiContext)ctx);
        try {
            ApiResult apiResult = this.handleRequest(apiNumber, caller, data);
            return apiResult;
        }
        finally {
            ScriptApiMeta.removeWebContext();
        }
    }

    public ApiResult handleRequest(String apiNumber, String caller, Map<String, Object> data) {
        String entity = this.getEntityNumber();
        ApiResult apiResult = UserPermissionUtil.checkAPIPermByParam(entity, "4TAR7QONT/3J");
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        DynamicObject metaApi = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id,number,enable,record_log,not_publish", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)apiNumber)});
        ApiResult re = this.validateData(apiNumber, metaApi);
        if (!re.getSuccess()) {
            return re;
        }
        try {
            return this.dispatchService(apiNumber, caller, data);
        }
        catch (Exception e) {
            return IscApiResult.ex((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResult dispatchService(String number, String caller, Map<String, Object> data) {
        DataSourceResource.createConnectionPool();
        try {
            IscApiMeta schema = this.getIscApiSchema(number);
            Object result = IscApicUtil.invoke(schema, data, caller);
            result = AbstractApiDispatcher.resultToMap(schema, result);
            ApiResult apiResult = ApiResult.success((Object)result);
            return apiResult;
        }
        finally {
            DataSourceResource.disposeConnectionPool();
        }
    }

    public static Object resultToMap(IscApiMeta schema, Object result) {
        if (!(result instanceof Map) && schema.getOutputs().fieldCount() == 1) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put(schema.getOutputs().getField(0).getName(), result);
            return map;
        }
        return result;
    }

    public String getVersion() {
        return "1.1";
    }

    protected abstract String getEntityNumber();

    protected abstract IscApiMeta getIscApiSchema(String var1);

    protected abstract ApiResult validateData(String var1, DynamicObject var2);
}

