/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.CheckApiParamUtil;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchemaApi;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.apic.doc.meta.MetaApiDocBuilder;
import kd.isc.iscb.platform.core.connector.ischub.HubApiService;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.dc.e.ServiceUtil;
import kd.isc.iscb.platform.core.dc.e.p.ViewUtil;
import kd.isc.iscb.platform.core.dc.e.v.ExprEvaluator;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.runtime.n.DataRetrieverApplication;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.data.ValueRange;
import kd.isc.iscb.util.trace.TraceTask;

public class IntegrateObjectApiDispatcher
implements IBillWebApiPlugin {
    private static final String FILTER_LINK = "filter_link";
    private static final String FILTER_RIGHT_BRACKET = "filter_right_bracket";
    private static final String FILTER_COMPARE = "filter_compare";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_VALUE = "filter_value";
    private static final String FILTER_LEFT_BRACKET = "filter_left_bracket";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final String FIELD_MAX_COUNT = "max_count";
    private static final String FIELD_TABLE_NAME = "table_name";
    private static final Log LOG = LogFactory.getLog(IntegrateObjectApiDispatcher.class);
    private static final String META_ENTITY = "isc_metadata_schema";
    private static final String API_META_ENTITY = "isc_apic_by_meta_schema";
    private static final String API_META_ID = "apiMetaNumber";
    private static final String FULL_NAME = "full_name";
    private static final String NUMBER_STR = "number";
    private static final String OUTPUTS = "outputs";
    private static final String OUTPUT_FIELD = "output_field";
    private static final String OUTPUT_DATA_TYPE = "output_data_type";
    private static final String CALLER = "caller";
    private static final String ISC_OBJECT_API_SERVICE_URL = "/app/iscb/IntegrateObjectApiDispatcher";
    private static final String ITEM_VIEW = "QXX0001";

    public ApiResult doCustomService(WebApiContext ctx) {
        HashMap<String, Object> data = ctx.getData();
        HashMap query = ctx.getQueryString();
        if (data == null) {
            data = new HashMap<String, Object>(1);
        }
        if (query == null) {
            query = new HashMap(1);
        }
        Object apiMetaId = query.get(API_META_ID);
        String caller = D.s(query.get(CALLER));
        return IntegrateObjectApiDispatcher.handle(apiMetaId, caller, data);
    }

    public static ApiResult handle(Object apiNumber, final String caller, final Map<String, Object> data) {
        ApiResult permResult = UserPermissionUtil.checkAPIPermByParam(API_META_ENTITY, "4TAR7QONT/3J");
        if (!permResult.getSuccess()) {
            return permResult;
        }
        if (apiNumber == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"IntegrateObjectApiDispatcher_26", (String)"isc-iscb-platform-core", (Object[])new Object[0]), API_META_ID));
        }
        final DynamicObject metaApi = MetaDataSchemaApi.getByNumber((String)D.s((Object)apiNumber));
        if (metaApi == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61API\u4e0d\u5b58\u5728", (String)"IntegrateObjectApiDispatcher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!"1".equals(metaApi.get("enable"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61API\u5df2\u7981\u7528\uff0c\u7981\u6b62\u8bbf\u95ee", (String)"IntegrateObjectApiDispatcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        final String operation = metaApi.getString("operation");
        final DynamicObject meta = MetaDataSchema.get((long)metaApi.getLong("metadata_id"));
        if (meta == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"IntegrateObjectApiDispatcher_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        final String type = meta.getString("type");
        final MetaType metaType = MetaType.valueOf((String)type);
        final Map<String, Object> outputMap = IntegrateObjectApiDispatcher.getOutputParams(metaApi, operation, metaType);
        DynamicObject log = IscApicUtil.invokeBegin(metaApi, API_META_ENTITY, caller, data);
        try {
            Object result = log == null ? TraceStack.run((TraceType)TraceType.EXE_APIF, (String)("isc_apic_by_meta_schema/" + apiNumber), (long)metaApi.getLong("id"), (TraceTask)new TraceTask(){

                public Object invoke() {
                    return IntegrateObjectApiDispatcher.invokeApi(caller, data, metaApi, operation, meta, type, metaType, outputMap);
                }
            }) : TraceStack.run((TraceType)TraceType.EXE_APIL, (DynamicObject)log, (TraceTask)new TraceTask(){

                public Object invoke() {
                    return IntegrateObjectApiDispatcher.invokeApi(caller, data, metaApi, operation, meta, type, metaType, outputMap);
                }
            });
            ApiResult apiResult = ApiResult.success((Object)result);
            IscApicUtil.invokeEnd(log, result, metaApi);
            return apiResult;
        }
        catch (Exception e) {
            IscApicUtil.invokeEnd(log, e, metaApi);
            return IscApiResult.ex((Throwable)e);
        }
    }

    private static Object invokeApi(String caller, Map<String, Object> data, DynamicObject metaApi, String operation, DynamicObject meta, String type, MetaType metaType, Map<String, Object> outputMap) {
        TraceUtil.checkDisableTrace((DynamicObject)metaApi);
        IscApicUtil.checkCaller(metaApi, API_META_ENTITY, caller);
        CheckApiParamUtil.checkMetaInput((DynamicObject)metaApi, data);
        Object result = IntegrateObjectApiDispatcher.handleInvoke(data, metaApi, operation, meta, type, metaType, outputMap);
        return result;
    }

    private static Object handleInvoke(Map<String, Object> data, DynamicObject metaApi, String operation, DynamicObject meta, String type, MetaType metaType, Map<String, Object> outputMap) {
        try (ConnectionWrapper cn = IntegrateObjectApiDispatcher.createConnection(meta);){
            Object result;
            ConnectionFactory factory = cn.getFactory();
            switch (metaType) {
                case TABLE: {
                    result = IntegrateObjectApiDispatcher.handleTable(metaApi, operation, data, meta, cn, factory, outputMap);
                    break;
                }
                case ENTITY: {
                    result = IntegrateObjectApiDispatcher.handleEntity(metaApi, operation, data, meta, cn, factory, outputMap);
                    break;
                }
                case VIEW: {
                    result = IntegrateObjectApiDispatcher.handleView(metaApi, operation, data, meta, cn, outputMap);
                    break;
                }
                case SERVICE: {
                    result = IntegrateObjectApiDispatcher.handleExecute(metaApi, cn, operation, data, meta, MetaType.SERVICE);
                    break;
                }
                case QUERY: {
                    result = IntegrateObjectApiDispatcher.handleExecute(metaApi, cn, operation, data, meta, MetaType.QUERY);
                    break;
                }
                case EVT_RSC: {
                    result = IntegrateObjectApiDispatcher.handleRaiseUserDefinedEvent(meta, operation, data);
                    break;
                }
                default: {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a%s", (String)"IntegrateObjectApiDispatcher_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
                }
            }
            Object object = result;
            return object;
        }
    }

    private static Object handleRaiseUserDefinedEvent(DynamicObject meta, String operation, Map<String, Object> data) {
        String fullName = meta.getString(FULL_NAME);
        if (!fullName.startsWith("isc_user_defined_event/")) {
            throw new IscBizException(ResManager.loadKDString((String)"\u53ea\u6709\u81ea\u5b9a\u4e49\u7684\u4e8b\u4ef6\u6e90\u5bf9\u8c61\u624d\u5141\u8bb8API\u89e6\u53d1", (String)"IntegrateObjectApiDispatcher_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return HubApiService.raiseEvent((String)fullName.substring("isc_user_defined_event/".length()), (String)operation, data);
    }

    private static Map<String, Object> getOutputParams(DynamicObject metaApi, String operation, MetaType metaType) {
        DynamicObjectCollection outputs = metaApi.getDynamicObjectCollection(OUTPUTS);
        HashMap<String, Object> outputMap = new HashMap<String, Object>(outputs.size());
        if (OPERATION.QUERY.name().equals(operation) && MetaType.ENTITY.equals((Object)metaType)) {
            MetaApiDocBuilder.existInputsOrOutputs((DynamicObjectCollection)outputs, outputMap, (String)OUTPUT_DATA_TYPE, (String)OUTPUT_FIELD);
        } else {
            for (DynamicObject output : outputs) {
                outputMap.put(output.getString(OUTPUT_FIELD), output.getString(OUTPUT_DATA_TYPE));
            }
        }
        return outputMap;
    }

    private static Object handleTable(DynamicObject metaApi, String operation, Map<String, Object> data, DynamicObject meta, ConnectionWrapper cn, ConnectionFactory factory, Map<String, Object> outputMap) {
        TableAction action;
        String tableName = meta.getString(FIELD_TABLE_NAME);
        Table table = ConnectionManager.getTable((ConnectionWrapper)cn, (String)tableName);
        int maxCount = D.i((Object)metaApi.get(FIELD_MAX_COUNT));
        if (0 == maxCount) {
            maxCount = 1000;
        }
        if (OPERATION.SQL_EXECUTE_CU.name().equals(operation)) {
            action = TableAction._SAVE;
        } else {
            if (OPERATION.SQL_EXECUTE_R.name().equals(operation)) {
                return IntegrateObjectApiDispatcher.doQuery(metaApi, data, meta, cn, outputMap, tableName, table, maxCount);
            }
            if (OPERATION.SQL_EXECUTE_D.name().equals(operation)) {
                action = TableAction._DELETE;
            } else {
                throw new IscBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u8868\u64cd\u4f5c\u7c7b\u578b", (String)"IntegrateObjectApiDispatcher_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
        }
        if (IntegrateObjectApiDispatcher.isBatch(metaApi, data)) {
            List batch = (List)data.get("data");
            if (batch.size() > maxCount) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u6570\u636e\u8d85\u8fc7\u884c\u6570\u9650\u5236", (String)"IntegrateObjectApiDispatcher_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            return IntegrateObjectApiDispatcher.doBatchDataAction(cn, batch, IntegrateObjectApiDispatcher.getMetaApiJudgeKey(metaApi), table, action);
        }
        return factory.doDataAction(cn, data, table, IntegrateObjectApiDispatcher.getMetaEntryTables(cn, meta), IntegrateObjectApiDispatcher.getMetaApiJudgeKey(metaApi), Collections.singletonList(action.name()));
    }

    public static boolean isBatch(DynamicObject api, Map<String, Object> data) {
        return data.get("data") instanceof List && data.size() == 1;
    }

    private static Object doQuery(DynamicObject metaApi, Map<String, Object> data, DynamicObject meta, ConnectionWrapper cn, Map<String, Object> outputMap, String tableName, Table table, int maxCount) {
        DynamicObjectCollection filterEntries = metaApi.getDynamicObjectCollection(FILTER_ENTRIES);
        if (filterEntries == null || filterEntries.isEmpty()) {
            StringBuilder sql = new StringBuilder("select ");
            boolean first = true;
            for (String key : outputMap.keySet()) {
                if (first) {
                    first = false;
                } else {
                    sql.append(", ");
                }
                Column c = table.getField(key);
                sql.append(c.getBinding());
            }
            sql.append(" from ").append(table.getQuotedName());
            int size = (int)data.values().stream().filter(Objects::nonNull).count();
            ArrayList<Integer> types = new ArrayList<Integer>(size);
            ArrayList<Object> values = new ArrayList<Object>(size);
            IntegrateObjectApiDispatcher.generateSelectSQL(data, table, sql, types, values);
            ObjectReader reader = cn.executeQuery(sql.toString(), values, types);
            return IntegrateObjectApiDispatcher.getResult(reader, maxCount);
        }
        return IntegrateObjectApiDispatcher.handleSqlQuery(cn, meta, metaApi, data, outputMap);
    }

    private static void generateSelectSQL(Map<String, Object> data, Table table, StringBuilder sql, List<Integer> types, List<Object> values) {
        boolean first = true;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getValue() == null || DataRetrieverApplication.isIgnoredFilterItem((Object)entry.getValue())) continue;
            if (first) {
                first = false;
                sql.append(" where ");
            } else {
                sql.append(" and ");
            }
            Column c = table.getField(entry.getKey());
            sql.append(c.getBinding()).append(" = ? ");
            values.add(c.narrow(c.unwrap(entry.getValue())));
            types.add(IntegrateObjectApiDispatcher.getType(table, entry.getKey()));
        }
    }

    private static Object handleSqlQuery(ConnectionWrapper cn, DynamicObject metaSchema, DynamicObject metaApi, Map<String, Object> inputMap, Map<String, Object> outputMap) {
        Schema schema;
        String tableName;
        String metaType = metaSchema.getString("type");
        int maxCount = D.i((Object)metaApi.get(FIELD_MAX_COUNT));
        if (0 == maxCount) {
            maxCount = 1000;
        }
        if (MetaType.TABLE.name().equals(metaType)) {
            tableName = D.s((Object)metaSchema.get(FIELD_TABLE_NAME));
            schema = ConnectionManager.getTable((ConnectionWrapper)cn, (String)tableName);
            tableName = schema.getQuotedName();
        } else {
            schema = ViewUtil.getSchema((DynamicObject)metaSchema, (ConnectionWrapper)cn);
            tableName = "(" + ViewUtil.getSQL((DynamicObject)metaSchema) + ") ISC_SOURCE_VIEW ";
        }
        String select = IntegrateObjectApiDispatcher.createSelect(schema, outputMap);
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        String filter = IntegrateObjectApiDispatcher.createFilter(schema, types, values, inputMap, metaApi);
        String sql = DataRetrieverApplication.getSqlStr((String)select, (String)filter, (String)"", (String)tableName);
        ObjectReader reader = cn.executeQuery(sql, values, types);
        return IntegrateObjectApiDispatcher.getResult(reader, maxCount);
    }

    private static String createFilter(Schema schema, List<Integer> types, List<Object> values, Map<String, Object> inputMap, DynamicObject metaApi) {
        StringBuilder filter = new StringBuilder();
        DynamicObjectCollection filterEntries = metaApi.getDynamicObjectCollection(FILTER_ENTRIES);
        for (int i = 0; i < filterEntries.size(); ++i) {
            DynamicObject obj = (DynamicObject)filterEntries.get(i);
            Object filterLeftBracket = obj.get(FILTER_LEFT_BRACKET);
            filter.append(filterLeftBracket == null ? "" : filterLeftBracket);
            String filterValueName = obj.getString(FILTER_VALUE);
            Object value = inputMap.get(filterValueName);
            value = ExprEvaluator.calc((Object)value, null, null, null);
            if (DataRetrieverApplication.isIgnoredFilterItem((Object)value)) {
                filter.append(" 1=1 ");
            } else {
                Column field = DataRetrieverApplication.getFilterField((Schema)schema, (String)D.s((Object)obj.get(FILTER_COLUMN)));
                filter.append(field.getBinding());
                if (value instanceof List) {
                    DataRetrieverApplication.handleListTypeParam((StringBuilder)filter, values, (Column)field, (List)((List)value), types, (String)D.s((Object)obj.get(FILTER_COMPARE)));
                } else if (DataRetrieverApplication.isArray((Object)value)) {
                    List list = (List)JSON.parseObject((String)value.toString(), List.class);
                    DataRetrieverApplication.handleListTypeParam((StringBuilder)filter, values, (Column)field, (List)list, types, (String)D.s((Object)obj.get(FILTER_COMPARE)));
                } else {
                    DataRetrieverApplication.handleBaseTypeParam((StringBuilder)filter, values, (String)obj.getString(FILTER_COMPARE), (Column)field, (Object)value, types);
                }
            }
            Object filterRightBracket = obj.get(FILTER_RIGHT_BRACKET);
            filter.append(filterRightBracket == null ? "" : filterRightBracket);
            if (i >= filterEntries.size() - 1) continue;
            filter.append("OR".equals(obj.get(FILTER_LINK)) ? " OR " : " AND ");
        }
        return filter.toString().trim();
    }

    private static String createSelect(Schema schema, Map<String, Object> outputMap) {
        StringBuilder select = new StringBuilder();
        HashSet fieldSet = new HashSet();
        outputMap.forEach((k, v) -> {
            if (k != null && k.indexOf(46) < 0) {
                DataRetrieverApplication.appendColumnFormMasterTable((Schema)schema, (StringBuilder)select, (Set)fieldSet, (String)k);
            }
        });
        String primaryKeyName = schema.getPrimaryKeyName();
        if (primaryKeyName != null) {
            DataRetrieverApplication.appendColumnFormMasterTable((Schema)schema, (StringBuilder)select, fieldSet, (String)primaryKeyName);
        }
        return select.toString();
    }

    private static int getType(Table table, String columnField) {
        Column field = table.getField(columnField);
        return field.getSqlType();
    }

    public static int getType(Object v) {
        if (v instanceof Integer) {
            return 4;
        }
        if (v instanceof Long) {
            return -5;
        }
        if (v instanceof BigDecimal) {
            return 3;
        }
        if (v instanceof Double) {
            return 8;
        }
        if (v instanceof Float) {
            return 6;
        }
        if (v instanceof BigInteger) {
            return -5;
        }
        if (v instanceof Byte) {
            return -6;
        }
        if (v instanceof Short) {
            return 5;
        }
        return 12;
    }

    private static Object handleEntity(DynamicObject metaApi, String operation, Map<String, Object> data, DynamicObject meta, ConnectionWrapper cn, ConnectionFactory factory, Map<String, Object> outputMap) {
        String entity = meta.getString(FULL_NAME);
        int maxCount = D.i((Object)metaApi.get(FIELD_MAX_COUNT));
        if (0 == maxCount) {
            maxCount = 1000;
        }
        if (OPERATION.QUERY.name().equals(operation)) {
            DynamicObjectCollection filterEntries = metaApi.getDynamicObjectCollection(FILTER_ENTRIES);
            ArrayList<Map<String, Object>> filter = new ArrayList<Map<String, Object>>();
            if (filterEntries == null || filterEntries.isEmpty()) {
                IntegrateObjectApiDispatcher.handleSimpleEntityFilter(data, filter);
            } else {
                IntegrateObjectApiDispatcher.handleGeneralEntityFilter(data, filterEntries, filter);
            }
            DataRetrieverApplication.removeIgnoredItems(filter);
            ObjectReader reader = factory.query(cn, entity, outputMap, filter, Collections.emptyList());
            return IntegrateObjectApiDispatcher.getResult(reader, maxCount);
        }
        if (IntegrateObjectApiDispatcher.isBatch(metaApi, data)) {
            List batch = (List)data.get("data");
            if (batch.size() > maxCount) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u6570\u636e\u8d85\u8fc7\u884c\u6570\u9650\u5236", (String)"IntegrateObjectApiDispatcher_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            return factory.doBatchBizAction(cn, entity, batch, IntegrateObjectApiDispatcher.getPrimaryKey(metaApi), IntegrateObjectApiDispatcher.getMetaApiJudgeKey(metaApi), operation, null);
        }
        return factory.doBizAction(cn, entity, data, IntegrateObjectApiDispatcher.getMetaApiJudgeKey(metaApi), Collections.singletonList(operation), null);
    }

    private static void handleGeneralEntityFilter(Map<String, Object> data, DynamicObjectCollection filterEntries, List<Map<String, Object>> filter) {
        for (DynamicObject entry : filterEntries) {
            Object filterColumn = entry.get(FILTER_COLUMN);
            if (filterColumn == null) continue;
            Object compare = entry.get(FILTER_COMPARE);
            String filterValueName = entry.getString(FILTER_VALUE);
            Object filterValue = data.get(filterValueName);
            filterValue = ExprEvaluator.calc((Object)filterValue, null, null, null);
            DataRetrieverApplication.checkFilterValue((Object)filterColumn, (Object)compare, (Object)filterValue);
            if (filterValue instanceof ValueRange) {
                IntegrateObjectApiDispatcher.handleValueRange(filter, entry, filterColumn, (ValueRange)filterValue);
                continue;
            }
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(FILTER_LEFT_BRACKET, entry.get(FILTER_LEFT_BRACKET));
            item.put(FILTER_COLUMN, filterColumn);
            item.put(FILTER_COMPARE, compare);
            item.put(FILTER_VALUE, filterValue);
            item.put(FILTER_RIGHT_BRACKET, entry.get(FILTER_RIGHT_BRACKET));
            item.put(FILTER_LINK, entry.get(FILTER_LINK));
            filter.add(item);
        }
    }

    private static void handleSimpleEntityFilter(Map<String, Object> data, List<Map<String, Object>> filter) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (DataRetrieverApplication.isIgnoredFilterItem((Object)entry.getValue())) continue;
            HashMap<String, Object> f = new HashMap<String, Object>(3);
            f.put(FILTER_COLUMN, entry.getKey());
            f.put(FILTER_COMPARE, "=");
            f.put(FILTER_VALUE, entry.getValue());
            filter.add(f);
        }
    }

    private static Object handleView(DynamicObject metaApi, String operation, Map<String, Object> data, DynamicObject meta, ConnectionWrapper cn, Map<String, Object> outputMap) {
        int maxCount = D.i((Object)metaApi.get(FIELD_MAX_COUNT));
        if (0 == maxCount) {
            maxCount = 1000;
        }
        if (OPERATION.QUERY.name().equals(operation)) {
            DynamicObjectCollection filterEntries = metaApi.getDynamicObjectCollection(FILTER_ENTRIES);
            if (filterEntries == null || filterEntries.isEmpty()) {
                StringBuilder sql = new StringBuilder("select ").append(String.join((CharSequence)",", outputMap.keySet())).append(" from (").append(ViewUtil.getSQL((DynamicObject)meta)).append(") v ");
                int size = (int)data.values().stream().filter(Objects::nonNull).count();
                ArrayList<Integer> types = new ArrayList<Integer>(size);
                ArrayList<Object> values = new ArrayList<Object>(size);
                IntegrateObjectApiDispatcher.generateViewQuerySQL(sql, data, types, values);
                ObjectReader reader = cn.executeQuery(sql.toString(), values, types);
                return IntegrateObjectApiDispatcher.getResult(reader, maxCount);
            }
            return IntegrateObjectApiDispatcher.handleSqlQuery(cn, meta, metaApi, data, outputMap);
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u89c6\u56fe\u64cd\u4f5c\u7c7b\u578b", (String)"IntegrateObjectApiDispatcher_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private static void generateViewQuerySQL(StringBuilder sql, Map<String, Object> data, List<Integer> types, List<Object> values) {
        boolean first = true;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getValue() == null || DataRetrieverApplication.isIgnoredFilterItem((Object)entry.getValue())) continue;
            if (first) {
                first = false;
                sql.append(" where ");
            } else {
                sql.append(" and ");
            }
            sql.append("v.").append(entry.getKey()).append(" = ? ");
            values.add(entry.getValue());
            types.add(IntegrateObjectApiDispatcher.getType(entry.getValue()));
        }
    }

    private static Object handleExecute(DynamicObject metaApi, ConnectionWrapper cn, String operation, Map<String, Object> data, DynamicObject meta, MetaType metaType) {
        if (OPERATION.EXECUTE.name().equals(operation)) {
            Object result = ServiceUtil.callService((ConnectionWrapper)cn, (DynamicObject)meta, data, null);
            if (result instanceof ObjectReader) {
                int maxCount = D.i((Object)metaApi.get(FIELD_MAX_COUNT));
                if (0 == maxCount) {
                    maxCount = 1000;
                }
                ObjectReader reader = (ObjectReader)result;
                result = IntegrateObjectApiDispatcher.getResult(reader, maxCount);
            }
            return result;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684%s\u64cd\u4f5c\u7c7b\u578b", (String)"IntegrateObjectApiDispatcher_28", (String)"isc-iscb-platform-core", (Object[])new Object[0]), metaType.name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Object getResult(ObjectReader<T> reader, int maxCount) {
        ArrayList<Object> rowList;
        Assert.isTrue((maxCount <= 10000 ? 1 : 0) != 0, (String)ResManager.loadKDString((String)"\u6700\u5927\u53d6\u6570\u884c\u6570\u4e0d\u8d85\u8fc710000\u884c", (String)"IntegrateObjectApiDispatcher_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        try {
            rowList = new ArrayList<Object>();
            Object row = reader.read();
            for (int count = 1; row != null && count <= maxCount; ++count) {
                rowList.add(row);
                row = reader.read();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return rowList;
    }

    public String getVersion() {
        return "1.1";
    }

    public static void handleValueRange(List<Map<String, Object>> filter, DynamicObject entry, Object filterColumn, ValueRange value) {
        ValueRange range = value;
        HashMap<String, Object> item = new HashMap<String, Object>(5);
        String leftBracket = D.s((Object)entry.get(FILTER_LEFT_BRACKET));
        String rightBracket = D.s((Object)entry.get(FILTER_RIGHT_BRACKET));
        item.put(FILTER_LEFT_BRACKET, leftBracket == null ? "(" : "(" + leftBracket);
        item.put(FILTER_COLUMN, filterColumn);
        item.put(FILTER_COMPARE, ">=");
        item.put(FILTER_VALUE, range.getLBound());
        item.put(FILTER_LINK, "AND");
        filter.add(item);
        item = new HashMap(5);
        item.put(FILTER_COLUMN, filterColumn);
        item.put(FILTER_COMPARE, "<=");
        item.put(FILTER_VALUE, range.getUBound());
        item.put(FILTER_RIGHT_BRACKET, rightBracket == null ? ")" : rightBracket + ")");
        item.put(FILTER_LINK, entry.get(FILTER_LINK));
        filter.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionWrapper createConnection(DynamicObject meta) {
        ConnectionManager.pushResLicense((boolean)IscLicenseUtil.resHasLicense((DynamicObject)meta));
        try {
            long dataSourceId = meta.getLong("group_id");
            DataSource dataSource = DataSource.get((long)dataSourceId);
            ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)dataSource.getDbLink());
            return connectionWrapper;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private static Map<String, Pair<Table, String>> getMetaEntryTables(ConnectionWrapper cn, DynamicObject meta) {
        Collection<DynamicObject> metaEntities = IntegrateObjectApiDispatcher.getMetaEntities(meta, IntegrateObjectApiDispatcher.getMetaEntityNumbers(meta));
        HashMap<String, Pair<Table, String>> entryTables = new HashMap<String, Pair<Table, String>>(metaEntities.size());
        for (DynamicObject metaEntity : metaEntities) {
            Table entityTable = ConnectionManager.getTable((ConnectionWrapper)cn, (String)metaEntity.getString(FIELD_TABLE_NAME));
            entryTables.put(metaEntity.getString(FULL_NAME), (Pair<Table, String>)new Pair((Object)entityTable, (Object)"fmasterid"));
        }
        return entryTables;
    }

    private static String getPrimaryKey(DynamicObject metaApi) {
        DynamicObjectCollection inputs = metaApi.getDynamicObjectCollection("inputs");
        String pk = null;
        for (DynamicObject input : inputs) {
            String inputField;
            if (!input.getBoolean("input_is_pk") || (inputField = input.getString("input_field")).contains(".")) continue;
            if (pk == null || inputField.equals(pk)) {
                pk = inputField;
                continue;
            }
            return null;
        }
        return pk;
    }

    private static Map<String, List<String>> getMetaApiJudgeKey(DynamicObject metaApi) {
        HashMap<String, List<String>> judgeMap = new HashMap<String, List<String>>();
        DynamicObjectCollection inputs = metaApi.getDynamicObjectCollection("inputs");
        for (DynamicObject input : inputs) {
            ArrayList<String> judgeList;
            if (!input.getBoolean("input_is_judge_key")) continue;
            String inputField = input.getString("input_field");
            String key = "$";
            String value = inputField;
            if (inputField.contains(".")) {
                int lastIndexOf = inputField.lastIndexOf(46);
                key = inputField.substring(0, lastIndexOf);
                value = inputField.substring(lastIndexOf + 1);
            }
            if ((judgeList = (ArrayList<String>)judgeMap.get(key)) == null) {
                judgeList = new ArrayList<String>();
                judgeList.add(value);
                judgeMap.put(key, judgeList);
                continue;
            }
            judgeList.add(value);
        }
        return judgeMap;
    }

    private static List<String> getMetaEntityNumbers(DynamicObject meta) {
        DynamicObjectCollection collection = meta.getDynamicObjectCollection("prop_entryentity");
        ArrayList<String> entityNumberList = new ArrayList<String>();
        for (DynamicObject item : collection) {
            if (!"ENTRIES".equals(item.getString("data_type"))) continue;
            entityNumberList.add(item.getString("data_schema"));
        }
        return entityNumberList;
    }

    private static Collection<DynamicObject> getMetaEntities(DynamicObject meta, List<String> numberList) {
        if (numberList.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("group", "=", (Object)meta.getLong("group_id")).and(NUMBER_STR, "in", numberList);
        DynamicObject[] objList = BusinessDataServiceHelper.load((String)META_ENTITY, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (objList != null && objList.length > 0) {
            ArrayList<Object> pkList = new ArrayList<Object>(objList.length);
            for (DynamicObject obj : objList) {
                pkList.add(obj.get("id"));
            }
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])pkList.toArray(), (String)META_ENTITY);
            return map.values();
        }
        return Collections.emptyList();
    }

    private static Object doBatchDataAction(ConnectionWrapper cn, List<Map<String, Object>> batch, Map<String, List<String>> judgeFieldMap, Table table, TableAction action) {
        List<String> judgeFields = judgeFieldMap.get("$");
        if (CollectionUtils.isEmpty(judgeFields)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5019\u9009\u952e\u4e0d\u80fd\u4e3a\u7a7a", (String)"IntegrateObjectApiDispatcher_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        ArrayList<Map<String, Object>> for_insert = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> for_update = new ArrayList<Map<String, Object>>();
        if (judgeFields.size() == 1) {
            IntegrateObjectApiDispatcher.handleOneKey(for_insert, for_update, judgeFields.get(0), table, batch, cn);
        } else {
            IntegrateObjectApiDispatcher.handleMultiKey(for_insert, for_update, judgeFields, table, batch, cn);
        }
        return IntegrateObjectApiDispatcher.doBatchAction(for_insert, for_update, action, table, cn, judgeFields, batch.get(0).keySet());
    }

    private static void handleOneKey(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update, String key_field, Table table, List<Map<String, Object>> batch, ConnectionWrapper cn) {
        Column key_column = table.getField(key_field);
        Map<Object, Map<String, Object>> id_mapping = IntegrateObjectApiDispatcher.constructKeyMapping(key_field, key_column, batch);
        ArrayList<Map.Entry<Object, Map<String, Object>>> list = new ArrayList<Map.Entry<Object, Map<String, Object>>>(id_mapping.entrySet());
        int total = list.size();
        int max = 500;
        int sum = total / max + 1;
        for (int i = 0; i < sum; ++i) {
            int toIndex = i + 1 == sum ? total : (i + 1) * max;
            List batchData = list.subList(i * max, toIndex);
            if (batchData.isEmpty()) continue;
            HashMap<Object, Map<String, Object>> batchMap = new HashMap<Object, Map<String, Object>>(batchData.size());
            for (Map.Entry entry : batchData) {
                batchMap.put(entry.getKey(), (Map<String, Object>)entry.getValue());
            }
            IntegrateObjectApiDispatcher.spiltHandleOneKey(for_insert, for_update, table, cn, key_column, batchMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void spiltHandleOneKey(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update, Table table, ConnectionWrapper cn, Column key_column, Map<Object, Map<String, Object>> id_mapping) {
        try (ObjectReader<DataRow> reader = IntegrateObjectApiDispatcher.queryExistsKeys(id_mapping, table, key_column, cn);){
            DataRow item = (DataRow)reader.read();
            while (item != null) {
                Map<String, Object> data = id_mapping.remove(item.getValue(0));
                if (data != null) {
                    for_update.add(data);
                }
                item = (DataRow)reader.read();
            }
            for_insert.addAll(id_mapping.values());
        }
    }

    private static void handleMultiKey(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update, List<String> judgeFields, Table table, List<Map<String, Object>> batch, ConnectionWrapper cn) {
        List<Column> fields = IntegrateObjectApiDispatcher.getJudgeFields(table, judgeFields);
        cn.classify(table, batch, fields, for_insert, for_update);
    }

    private static List<Response> doBatchAction(List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update, TableAction tableAction, Table table, ConnectionWrapper cn, List<String> judgeFields, Set<String> inputFields) {
        ArrayList<Response> responses = new ArrayList<Response>(for_insert.size() + for_update.size());
        switch (tableAction) {
            case _SAVE: {
                IntegrateObjectApiDispatcher.batchInsert(for_insert, table, cn, responses, judgeFields);
                IntegrateObjectApiDispatcher.batchUpdate(for_update, table, cn, judgeFields, inputFields, responses);
                break;
            }
            case _DELETE: {
                IntegrateObjectApiDispatcher.batchDelete(for_update, table, cn, judgeFields, responses);
                IntegrateObjectApiDispatcher.batchIgnore(for_insert, responses, table, judgeFields);
                break;
            }
            default: {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a%s", (String)"IntegrateObjectApiDispatcher_27", (String)"isc-iscb-platform-core", (Object[])new Object[0]), tableAction));
            }
        }
        return responses;
    }

    private static void batchIgnore(List<Map<String, Object>> ignoreDataList, List<Response> responses, Table table, List<String> judgeFields) {
        if (ignoreDataList.size() == 0) {
            return;
        }
        List<Column> judgeFieldList = IntegrateObjectApiDispatcher.getJudgeFields(table, judgeFields);
        IntegrateObjectApiDispatcher.setResponse(ignoreDataList, responses, judgeFieldList, SaveDataType.NOP);
    }

    private static void batchDelete(List<Map<String, Object>> for_delete, Table table, ConnectionWrapper cn, List<String> judgeFields, List<Response> responses) {
        if (for_delete.size() == 0) {
            return;
        }
        List<Column> judgeFieldList = IntegrateObjectApiDispatcher.getJudgeFields(table, judgeFields);
        if (judgeFieldList.size() == 1) {
            IntegrateObjectApiDispatcher.oneKeyDel(for_delete, table, cn, judgeFields.get(0), responses, judgeFieldList.get(0));
        } else {
            IntegrateObjectApiDispatcher.multiKeyDel(for_delete, table, cn, judgeFields, responses, judgeFieldList);
        }
    }

    private static void oneKeyDel(List<Map<String, Object>> for_update, Table table, ConnectionWrapper cn, String key_field, List<Response> responses, Column key_column) {
        int total = for_update.size();
        int max = 500;
        int sum = total / max + 1;
        ArrayList<Object> success = new ArrayList<Object>(total);
        for (int i = 0; i < sum; ++i) {
            int toIndex = i + 1 == sum ? total : (i + 1) * max;
            List<Map<String, Object>> batchData = for_update.subList(i * max, toIndex);
            if (batchData.isEmpty()) continue;
            List<Object> values = null;
            try {
                values = IntegrateObjectApiDispatcher.batchDel(batchData, table, cn, key_field, key_column);
                success.addAll(values);
                continue;
            }
            catch (Exception e) {
                responses.add(new Response(values == null ? IntegrateObjectApiDispatcher.getColumnValue(batchData, key_field, key_column).toString() : values.toString(), (Throwable)e));
            }
        }
        if (!success.isEmpty()) {
            responses.add(new Response(((Object)success).toString(), SaveDataType.DELETE, null));
        }
    }

    private static List<Object> batchDel(List<Map<String, Object>> for_update, Table table, ConnectionWrapper cn, String key_field, Column key_column) {
        ArrayList<Integer> types = new ArrayList<Integer>(for_update.size());
        String sql = IntegrateObjectApiDispatcher.generateJudgeDelSQL(table, key_column, for_update, types);
        List<Object> values = IntegrateObjectApiDispatcher.getColumnValue(for_update, key_field, key_column);
        cn.executeUpdate(sql, values, types);
        return values;
    }

    private static List<Object> getColumnValue(List<Map<String, Object>> for_update, String key_field, Column key_column) {
        ArrayList<Object> values = new ArrayList<Object>(for_update.size());
        for (Map<String, Object> data : for_update) {
            Object value = data.get(key_field);
            values.add(key_column.narrow(value));
        }
        return values;
    }

    private static String generateJudgeDelSQL(Table tar_table, Column key_column, List<Map<String, Object>> for_delete, List<Integer> types) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ");
        sb.append(tar_table.getQuotedName());
        sb.append(" where ");
        sb.append(key_column.getBinding());
        sb.append(" in ( ");
        for (int i = 0; i < for_delete.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            types.add(key_column.getSqlType());
            sb.append(" ? ");
        }
        sb.append(')');
        return sb.toString();
    }

    private static void multiKeyDel(List<Map<String, Object>> for_update, Table table, ConnectionWrapper cn, List<String> judgeFields, List<Response> responses, List<Column> judgeFieldList) {
        Column judgeField = table.findField(judgeFields.size() == 1 ? judgeFields.get(0) : null);
        String sql = IntegrateObjectApiDispatcher.prepareDeleteSQL(judgeFieldList, judgeField, table);
        ArrayList<Column> params = new ArrayList<Column>(judgeFieldList.size());
        if (judgeField != null) {
            params.add(judgeField);
        } else {
            params.addAll(judgeFieldList);
        }
        ArrayList batch = new ArrayList(for_update.size());
        for (Map<String, Object> data : for_update) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            for (Column f : params) {
                Object value = TableUtil.getValue(data, (Column)f);
                row.add(value);
            }
            batch.add(row);
        }
        ArrayList<Integer> types = new ArrayList<Integer>(params.size());
        for (Column f : params) {
            types.add(f.getSqlType());
        }
        cn.executeBatch(sql, batch, types);
        IntegrateObjectApiDispatcher.setResponse(for_update, responses, judgeFieldList, SaveDataType.DELETE);
    }

    private static void batchUpdate(List<Map<String, Object>> for_update, Table table, ConnectionWrapper cn, List<String> judgeFields, Set<String> inputFields, List<Response> responses) {
        if (for_update.size() == 0) {
            return;
        }
        HashSet<String> columns = new HashSet<String>(inputFields);
        columns.removeAll(judgeFields);
        IntegrateObjectApiDispatcher.removePrimaryKeys(columns, table);
        if (columns.size() == 0) {
            return;
        }
        List<Column> judgeFieldList = IntegrateObjectApiDispatcher.getJudgeFields(table, judgeFields);
        Column judgeField = table.findField(judgeFields.size() == 1 ? judgeFields.get(0) : null);
        String[] fields = columns.toArray(new String[0]);
        String sql = IntegrateObjectApiDispatcher.prepareUpdateSQL(judgeFieldList, judgeField, fields, table);
        ArrayList<Column> params = new ArrayList<Column>(fields.length + judgeFieldList.size());
        for (String field : fields) {
            Column f = table.getField(field);
            params.add(f);
        }
        if (judgeField != null) {
            params.add(judgeField);
        } else {
            params.addAll(judgeFieldList);
        }
        ArrayList batch = new ArrayList(for_update.size());
        for (Map<String, Object> data : for_update) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            for (Column f : params) {
                Object value = TableUtil.getValue(data, (Column)f);
                row.add(value);
            }
            batch.add(row);
        }
        ArrayList<Integer> types = new ArrayList<Integer>(params.size());
        for (Column f : params) {
            types.add(f.getSqlType());
        }
        cn.executeBatch(sql, batch, types);
        IntegrateObjectApiDispatcher.setResponse(for_update, responses, judgeFieldList, SaveDataType.UPDATE);
    }

    private static String prepareDeleteSQL(List<Column> judgeFields, Column judgeField, Table table) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(table.getQuotedName()).append(" WHERE ");
        if (judgeField != null) {
            sql.append(judgeField.getBinding()).append("=?");
        } else {
            for (int i = 0; i < judgeFields.size(); ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(judgeFields.get(i).getBinding()).append("=?");
            }
        }
        return sql.toString();
    }

    private static String prepareUpdateSQL(List<Column> judgeFields, Column judgeField, String[] fields, Table tar_table) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tar_table.getQuotedName()).append(" SET ");
        for (i = 0; i < fields.length; ++i) {
            String name = fields[i];
            Column c = tar_table.getField(name);
            if (i > 0) {
                sql.append(',');
            }
            sql.append(c.getBinding()).append("=?");
        }
        sql.append(" WHERE ");
        if (judgeField != null) {
            sql.append(judgeField.getBinding()).append("=?");
        } else {
            for (i = 0; i < judgeFields.size(); ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(judgeFields.get(i).getBinding()).append("=?");
            }
        }
        return sql.toString();
    }

    private static void removePrimaryKeys(Set<String> columns, Table table) {
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Column c = table.getField(i);
            if (!c.isPrimaryKey()) continue;
            columns.remove(c.getName());
        }
    }

    private static void batchInsert(List<Map<String, Object>> for_insert, Table table, ConnectionWrapper cn, List<Response> responses, List<String> judgeFields) {
        if (for_insert.size() == 0) {
            return;
        }
        String sql = TableUtil.prepareInsertSQL((Table)table);
        ArrayList<Column> params = new ArrayList<Column>(table.getFieldCount());
        ArrayList<Integer> types = new ArrayList<Integer>(table.getFieldCount());
        for (int i = 0; i < table.getFieldCount(); ++i) {
            Column f = table.getField(i);
            params.add(f);
            types.add(f.getSqlType());
        }
        ArrayList batch = new ArrayList(for_insert.size());
        for (Map map : for_insert) {
            ArrayList<Object> row = new ArrayList<Object>(params.size());
            for (Column f : params) {
                String pkName = table.getPrimaryKeyName();
                if (pkName != null && map.get(pkName) == null) {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e3b\u952e%s\u672a\u8d4b\u503c", (String)"IntegrateObjectApiDispatcher_29", (String)"isc-iscb-platform-core", (Object[])new Object[0]), pkName));
                }
                Object value = TableUtil.getValue((Map)map, (Column)f);
                row.add(value);
            }
            batch.add(row);
        }
        cn.executeBatch(sql, batch, types);
        List<Column> judgeFieldList = IntegrateObjectApiDispatcher.getJudgeFields(table, judgeFields);
        IntegrateObjectApiDispatcher.setResponse(for_insert, responses, judgeFieldList, SaveDataType.INSERT);
    }

    private static void setResponse(List<Map<String, Object>> dataList, List<Response> responses, List<Column> judgeFieldList, SaveDataType saveDataType) {
        ArrayList<String> ids = new ArrayList<String>(judgeFieldList.size());
        for (Map<String, Object> data : dataList) {
            StringBuilder sb = new StringBuilder();
            for (Column f : judgeFieldList) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(TableUtil.getValue(data, (Column)f));
            }
            if (saveDataType == SaveDataType.NOP) {
                data.put("$reason", ResManager.loadKDString((String)"\u5f85\u5220\u9664\u7684\u6570\u636e\u5728\u76ee\u6807\u4e2d\u4e0d\u5b58\u5728\uff0c\u6545\u5ffd\u7565\u3002", (String)"IntegrateObjectApiDispatcher_40", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
            ids.add(sb.toString());
        }
        responses.add(new Response(((Object)ids).toString(), saveDataType, null));
    }

    private static List<Column> getJudgeFields(Table table, List<String> judgeFields) {
        ArrayList<Column> fields = new ArrayList<Column>();
        for (String name : judgeFields) {
            Column field = table.getField(name);
            if (field != null) {
                fields.add(field);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5019\u9009\u952e\u5b57\u6bb5\uff08%1$s\uff09\u5728\u6570\u636e\u8868\uff08%2$s\uff09\u4e2d\u4e0d\u5b58\u5728\uff01", (String)"IntegrateObjectApiDispatcher_30", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, table));
        }
        return fields;
    }

    private static Map<Object, Map<String, Object>> constructKeyMapping(String key_field, Column key_column, List<Map<String, Object>> batch) {
        HashMap<Object, Map<String, Object>> id_mapping = new HashMap<Object, Map<String, Object>>(batch.size());
        for (Map<String, Object> data : batch) {
            Object value = data.get(key_field);
            Map<String, Object> dup = id_mapping.put(key_column.narrow(value), data);
            if (dup == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5b57\u6bb5\uff08%s\uff09\u5bf9\u5165\u53c2\u6570\u636e\u8fdb\u884c\u552f\u4e00\u6027\u68c0\u67e5\uff0c\u53d1\u73b0\u5176\u4e2d\u5b58\u5728\u91cd\u590d\u503c\u3002", (String)"IntegrateObjectApiDispatcher_31", (String)"isc-iscb-platform-core", (Object[])new Object[0]), key_field));
        }
        return id_mapping;
    }

    private static ObjectReader<DataRow> queryExistsKeys(Map<Object, Map<String, Object>> id_mapping, Table tar_table, Column key_column, ConnectionWrapper cn) {
        ArrayList<Integer> types = new ArrayList<Integer>(id_mapping.size());
        ArrayList<Object> values = new ArrayList<Object>(id_mapping.keySet());
        String sql = IntegrateObjectApiDispatcher.generateJudgeSQL(tar_table, key_column, id_mapping, types);
        return cn.executeQuery(sql, values, types);
    }

    private static String generateJudgeSQL(Table tar_table, Column key_column, Map<Object, Map<String, Object>> id_mapping, List<Integer> types) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(key_column.getBinding());
        sb.append(" from ");
        sb.append(tar_table.getQuotedName());
        sb.append(" where ");
        sb.append(key_column.getBinding());
        sb.append(" in ( ");
        for (int i = 0; i < id_mapping.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            types.add(key_column.getSqlType());
            sb.append(" ? ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static void registerApiService() {
        QFilter filter = new QFilter(NUMBER_STR, "=", (Object)"IntegrateObjectApiDispatcher");
        DynamicObject svc = BusinessDataServiceHelper.loadSingle((String)"open_apiservice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (svc != null) {
            return;
        }
        svc = BusinessDataServiceHelper.newDynamicObject((String)"open_apiservice");
        svc.set(NUMBER_STR, (Object)"IntegrateObjectApiDispatcher");
        svc.set("name", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61API\u8f6c\u53d1", (String)"IntegrateObjectApiDispatcher_25", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        svc.set("appid", (Object)"TV3/VDJ86RC");
        svc.set("apiservicetype", (Object)2);
        svc.set("enable", (Object)1);
        svc.set("status", (Object)"C");
        svc.set("urlformat", (Object)ISC_OBJECT_API_SERVICE_URL);
        svc.set("reqtype", (Object)0);
        svc.set("reptype", (Object)0);
        svc.set("httpmethod", (Object)1);
        svc.set("contenttype", (Object)0);
        svc.set("creator", (Object)1);
        svc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        String plugin = "[{\"Type\":0,\"_Type_\":\"Plugin\",\"ClassName\":\"kd.isc.iscb.platform.core.api.IntegrateObjectApiDispatcher\",\"Enabled\":true,\"rowKey\":null}]";
        svc.set("plugin", (Object)plugin);
        ExecutionData.execute((DynamicObject)svc, (String)"save");
    }

    static {
        try {
            IntegrateObjectApiDispatcher.registerApiService();
        }
        catch (Exception e) {
            LOG.warn("init integrate object api dispatcher failed.");
        }
    }

    public static enum OPERATION {
        QUERY(new MultiLangEnumBridge("\u67e5\u8be2", "IntegrateObjectApiDispatcher_32", "isc-iscb-platform-core")),
        EXECUTE(new MultiLangEnumBridge("\u6267\u884c", "IntegrateObjectApiDispatcher_33", "isc-iscb-platform-core")),
        SQL_EXECUTE_R(new MultiLangEnumBridge("\u8bfb\u53d6", "IntegrateObjectApiDispatcher_34", "isc-iscb-platform-core")),
        SQL_EXECUTE_CU(new MultiLangEnumBridge("\u4fdd\u5b58", "IntegrateObjectApiDispatcher_35", "isc-iscb-platform-core")),
        SQL_EXECUTE_D(new MultiLangEnumBridge("\u5220\u9664", "IntegrateObjectApiDispatcher_36", "isc-iscb-platform-core"));

        private final MultiLangEnumBridge desc;

        private OPERATION(MultiLangEnumBridge desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }
    }
}

