/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.api.IscApiResult;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.cache.data.ServiceFlowApi;
import kd.isc.iscb.platform.core.connector.self.ExecutionData;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.trace.TraceUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.trace.TraceTask;

public class ServiceFlowApiDispatcher
implements IBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(ServiceFlowApiDispatcher.class);
    private static final String API_NUMBER = "apiNumber";
    private static final String CALLER = "caller";

    public static ApiResult handle(String apiNumber, final String caller, final Map<String, Object> data) {
        ApiResult permResult = UserPermissionUtil.checkAPIPermByParam("isc_apic_by_sf", "4TAR7QONT/3J");
        if (!permResult.getSuccess()) {
            return permResult;
        }
        final DynamicObject api = ServiceFlowApi.getByNumber((String)D.s((Object)apiNumber));
        DynamicObject log = IscApicUtil.invokeBegin(api, "isc_apic_by_sf", caller, data);
        try {
            Object output = log == null ? TraceStack.run((TraceType)TraceType.EXE_APIF, (String)("isc_apic_by_sf/" + apiNumber), (long)api.getLong("id"), (TraceTask)new TraceTask(){

                public Object invoke() {
                    return ServiceFlowApiDispatcher.invokeApi(caller, data, api);
                }
            }) : TraceStack.run((TraceType)TraceType.EXE_APIL, (DynamicObject)log, (TraceTask)new TraceTask(){

                public Object invoke() {
                    return ServiceFlowApiDispatcher.invokeApi(caller, data, api);
                }
            });
            IscApicUtil.invokeEnd(log, output, api);
            return ApiResult.success((Object)output);
        }
        catch (Exception e) {
            IscApicUtil.invokeEnd(log, e, api);
            return IscApiResult.ex((Throwable)e);
        }
    }

    private static Map<String, Object> invokeApi(String caller, Map<String, Object> data, DynamicObject api) {
        TraceUtil.checkDisableTrace((DynamicObject)api);
        ServiceFlowApiDispatcher.checkApiEnabled(api);
        IscApicUtil.checkCaller(api, "isc_apic_by_sf", caller);
        long defineId = api.getLong("service_flow_id");
        ServiceFlowApiDispatcher.checkServiceFlowEnabled(defineId);
        ServiceFlowApiDispatcher.checkServiceFlowReleased(api);
        long flowId = ServiceFlowParser.findReleasedFlowId((long)defineId);
        return ServiceFlowApiDispatcher.getApiResult(data, api, flowId);
    }

    private static void checkApiEnabled(DynamicObject api) {
        if ("0".equals(api.get("enable"))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u662f%1$s\u7684\u670d\u52a1\u6d41\u7a0bAPI\u5df2\u7981\u7528\uff0c\u7981\u6b62\u8bbf\u95ee\u3002", (String)"ServiceFlowApiDispatcher_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), api.getString("number")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> getApiResult(Map<String, Object> data, DynamicObject api, long flowId) {
        DataSourceResource.createConnectionPool();
        try {
            Map<String, Object> output;
            boolean isAsyn = api.getBoolean("asyn");
            if (isAsyn) {
                ServiceFlowApiDispatcher.checkAsynAndWithoutProcInst(api);
                output = ServiceFlowApiDispatcher.getAsynOutputData(data, flowId);
            } else {
                Pair<Long, Object[]> pair = ServiceFlowApiDispatcher.executeServiceFlow(data, api, flowId);
                output = ServiceFlowApiDispatcher.getOutput(flowId, pair);
            }
            Map<String, Object> map = output;
            return map;
        }
        finally {
            DataSourceResource.disposeConnectionPool();
        }
    }

    public static Map<String, Object> getOutput(long flowId, Pair<Long, Object[]> pair) {
        Map<String, Object> outVar = ServiceFlowApiDispatcher.getSyncOutputVar(flowId, pair);
        return ServiceFlowApiDispatcher.getSyncOutputData(pair, outVar);
    }

    public static Map<String, Object> getSyncOutputData(Pair<Long, Object[]> pair, Map<String, Object> outVar) {
        HashMap<String, Object> output = new HashMap<String, Object>(2);
        output.put("id", pair.getKey());
        output.put("output", outVar);
        return output;
    }

    private static Map<String, Object> getAsynOutputData(Map<String, Object> data, long flowId) {
        long procInst = ServiceFlowEngine.createAndStart((long)flowId, (Object[])ServiceFlowApiDispatcher.getInputs(data, flowId).toArray());
        HashMap<String, Object> output = new HashMap<String, Object>(1);
        output.put("id", procInst);
        return output;
    }

    private static void checkAsynAndWithoutProcInst(DynamicObject api) {
        if (api.getBoolean("no_proc_inst")) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u662f%1$s\u7684\u670d\u52a1\u6d41\u7a0bAPI\u5728\u5f02\u6b65\u6a21\u5f0f\u4e0b\u4e0d\u5141\u8bb8\u6253\u5f00\u65e0\u5b9e\u4f8b\u6a21\u5f0f\u3002", (String)"ServiceFlowApiDispatcher_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), api.getString("number")));
        }
    }

    private static Map<String, Object> getSyncOutputVar(long flowId, Pair<Long, Object[]> pair) {
        List variables = ServiceFlowParser.getFlow((long)flowId).getOutputVariables();
        LinkedHashMap<String, Object> outVar = new LinkedHashMap<String, Object>();
        if (pair.getValue() == null) {
            outVar.put("state", ResManager.loadKDString((String)"\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u4e2d\u662f\u5426\u5305\u542b\u65f6\u95f4\u7b49\u5f85\u8282\u70b9\u3001\u4e8b\u4ef6\u7b49\u5f85\u8282\u70b9\u548c\u5b50\u6d41\u7a0b\u8282\u70b9\u7b49\u5f02\u6b65\u5904\u7406\u8282\u70b9\uff0c\u6216\u5728\u8282\u70b9\u4e0a\u542f\u7528\u4e86\u9519\u8bef\u65f6\u81ea\u52a8\u91cd\u8bd5\u673a\u5236\u3002", (String)"ServiceFlowApiDispatcher_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        } else {
            for (int i = 0; i < variables.size(); ++i) {
                outVar.put(((Variable)variables.get(i)).getName(), ((Object[])pair.getValue())[i]);
            }
        }
        return outVar;
    }

    private static Pair<Long, Object[]> executeServiceFlow(Map<String, Object> data, DynamicObject api, long flowId) {
        boolean withoutProcInst = api.getBoolean("no_proc_inst");
        List<Object> inputs = ServiceFlowApiDispatcher.getInputs(data, flowId);
        return ServiceFlowApiDispatcher.executeServiceFlow(flowId, inputs, withoutProcInst);
    }

    public static Pair<Long, Object[]> executeServiceFlow(long flowId, List<Object> inputs, boolean withoutProcInst) {
        if (withoutProcInst) {
            Object[] result = ServiceFlowEngine.executeWithoutProcInst((long)flowId, (Object[])inputs.toArray(), Collections.emptyMap());
            return new Pair((Object)0L, (Object)result);
        }
        return ServiceFlowEngine.createAndExecute((long)flowId, (Object[])inputs.toArray(), Collections.emptyMap());
    }

    private static List<Object> getInputs(Map<String, Object> data, long flowId) {
        Flow flow = ServiceFlowParser.getFlow((long)flowId);
        List vars = flow.getInputVariables();
        ArrayList<Object> inputs = new ArrayList<Object>(vars.size());
        for (Variable v : vars) {
            inputs.add(data.get(v.getName()));
        }
        return inputs;
    }

    private static void checkServiceFlowReleased(DynamicObject api) {
        long flowId = api.getLong("service_flow_id");
        DynamicObject flow = ServiceFlow.get((long)flowId);
        if (!flow.getBoolean("is_released")) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u662f%s\u672a\u53d1\u5e03\uff0c\u8bf7\u5148\u53d1\u5e03\u670d\u52a1\u6d41\u7a0b\u3002", (String)"ServiceFlowApiDispatcher_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flow.getString("number")));
        }
    }

    private static void checkServiceFlowEnabled(long defineId) {
        DynamicObject flow = ServiceFlow.get((long)defineId);
        if (!flow.getBoolean("enable") && AppParameterServiceHelper.isEnableControl()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s\u7684\u670d\u52a1\u6d41\u7a0b\u672a\u542f\u7528.", (String)"ServiceFlowApiDispatcher_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flow.getString("number")));
        }
    }

    public static void registerApiService() {
        QFilter filter = new QFilter("number", "=", (Object)"SFApiOutputDispatcher");
        DynamicObject svc = BusinessDataServiceHelper.loadSingle((String)"open_apiservice", (String)"id", (QFilter[])new QFilter[]{filter});
        if (svc != null) {
            return;
        }
        svc = BusinessDataServiceHelper.newDynamicObject((String)"open_apiservice");
        svc.set("number", (Object)"SFApiOutputDispatcher");
        svc.set("name", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0bAPI\u8f93\u51fa\u7ed3\u679c\u8f6c\u53d1", (String)"ServiceFlowApiDispatcher_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        svc.set("appid", (Object)"TV3/VDJ86RC");
        svc.set("apiservicetype", (Object)2);
        svc.set("enable", (Object)1);
        svc.set("status", (Object)"C");
        svc.set("urlformat", (Object)"/app/iscb/SFApiOutputDispatcher");
        svc.set("reqtype", (Object)0);
        svc.set("httpmethod", (Object)1);
        svc.set("contenttype", (Object)0);
        svc.set("creator", (Object)1);
        svc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        svc.set("modifier", (Object)1);
        svc.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        if (svc.getDataEntityType().getProperties().get((Object)"discription") != null) {
            svc.set("discription", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0bAPI\u8f93\u51fa\u7ed3\u679c\u8f6c\u53d1", (String)"ServiceFlowApiDispatcher_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        String plugin = "[{\"Type\":0,\"_Type_\":\"Plugin\",\"ClassName\":\"kd.isc.iscb.platform.core.api.ServiceFlowApiOutputDispatcher\",\"Enabled\":true,\"rowKey\":null}]";
        svc.set("plugin", (Object)plugin);
        ExecutionData.execute((DynamicObject)svc, (String)"save");
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        Map<String, Object> data = this.getStringData(ctx);
        Map<String, Object> query = this.getStringQuery(ctx);
        String apiNumber = D.s((Object)query.get(API_NUMBER));
        String caller = D.s((Object)query.get(CALLER));
        return ServiceFlowApiDispatcher.handle(apiNumber, caller, data);
    }

    private Map<String, Object> getStringQuery(WebApiContext ctx) {
        Map query = ctx.getQueryString();
        if (query == null || query.get(API_NUMBER) == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"ServiceFlowApiDispatcher_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), API_NUMBER));
        }
        return query;
    }

    private Map<String, Object> getStringData(WebApiContext ctx) {
        HashMap data = ctx.getData();
        if (data == null) {
            data = new HashMap(1);
        }
        return data;
    }

    public String getVersion() {
        return "1.1";
    }

    static {
        try {
            ServiceFlowApiDispatcher.registerApiService();
        }
        catch (Exception e) {
            LOG.warn("init ServiceFlowOutput api dispatcher failed." + e);
        }
    }
}

