/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.api;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.isc.iscb.platform.core.app.AppParameterServiceHelper;
import kd.isc.iscb.util.dt.D;

public class UserPermissionUtil {
    public static final String API_EXECUTE_PERMITEM = "4TAR7QONT/3J";
    public static final String ISC_INNER_DISPATCHER = "4TASW06SC8=5";

    public static void checkUserPermission() {
        long userId = D.l((Object)RequestContext.get().getUserId());
        List userBizApps = PermissionServiceHelper.getUserBizApps((Long)userId);
        if (!userBizApps.contains("TV3/VDJ86RC")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4eba\u5458id\u4e3a\uff1a%s \u7684\u7528\u6237\u4e0d\u5177\u5907\u96c6\u6210\u4e91\u4e1a\u52a1\u64cd\u4f5c\u6743\u9650\uff01", (String)"UserPermissionUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), userId));
        }
    }

    public static ApiResult checkAPIPermByParam(String entity, String permItemID) {
        long currUserId;
        boolean isPermission;
        AppParam appParam = AppParameterServiceHelper.getAppParam();
        int isApiPermission = D.i((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"isc_api_check_perm"));
        if (isApiPermission > 0 && !(isPermission = PermissionServiceHelper.checkPermission((Long)(currUserId = RequestContext.get().getCurrUserId()), (String)"iscb", (String)entity, (String)permItemID))) {
            String kds = API_EXECUTE_PERMITEM.equals(permItemID) ? ResManager.loadKDString((String)"\u7528\u6237%1$s\u6ca1\u6709\u5bf9\u5e94\u5b9e\u4f53\u5143\u6570\u636e%2$s\u7684\u201c\u96c6\u6210\u4e91API\u8c03\u7528\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\u3002", (String)"UserPermissionUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : (ISC_INNER_DISPATCHER.equals(permItemID) ? ResManager.loadKDString((String)"\u7528\u6237%1$s\u6ca1\u6709\u5bf9\u5e94\u5b9e\u4f53\u5143\u6570\u636e%2$s\u7684\u201c\u96c6\u6210\u4e91\u5185\u90e8\u8bbf\u95ee\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\u3002", (String)"UserPermissionUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7528\u6237%1$s\u6ca1\u6709\u5bf9\u5e94\u5b9e\u4f53\u5143\u6570\u636e%2$s\u7684\u8bbf\u95ee\u6743\u9650", (String)"UserPermissionUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            return ApiResult.fail((String)String.format(kds, RequestContext.get().getUserName(), EntityMetadataCache.getDataEntityType((String)entity).getDisplayName()), (String)"403");
        }
        if (isApiPermission == 0) {
            UserPermissionUtil.saveApiPermLog(entity, permItemID);
        }
        return ApiResult.success(null);
    }

    private static void saveApiPermLog(String entity, String permItemID) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId).and("type", "=", (Object)entity).and("permitemid", "=", (Object)permItemID);
        if (!QueryServiceHelper.exists((String)"isc_api_perm_log", (QFilter[])new QFilter[]{qFilter})) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"isc_api_perm_log");
            object.set("type", (Object)entity);
            object.set("creator", (Object)RequestContext.get().getCurrUserId());
            object.set("permitemid", (Object)permItemID);
            object.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    public static void assignPermAndUpdate(DynamicObject cfg) {
        if (!D.x((Object)cfg.get("has_assign_perm")) && cfg.get("ierp_proxy_user") != null && UserPermissionUtil.assignPerm(cfg)) {
            cfg.set("has_assign_perm", (Object)1);
            SaveServiceHelper.update((DynamicObject)cfg);
        }
    }

    private static boolean assignPerm(DynamicObject cfg) {
        DynamicObject proxyUser = cfg.getDynamicObject("ierp_proxy_user");
        long proxyUserId = D.l((Object)proxyUser.getPkValue());
        boolean permission = PermissionServiceHelper.checkPermission((Long)proxyUserId, (String)"iscb", (String)"isc_api_authentication", (String)ISC_INNER_DISPATCHER);
        if (!permission) {
            permission = UserPermissionUtil.DirectAssignDefaultPerm(proxyUserId);
        }
        return permission;
    }

    private static boolean DirectAssignDefaultPerm(Long userId) {
        ArrayList<String> innerDispatcher = new ArrayList<String>(1);
        innerDispatcher.add(ISC_INNER_DISPATCHER);
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>(1);
        map.put("isc_api_authentication", innerDispatcher);
        HashMap<String, HashMap<String, ArrayList<String>>> appEntityPermItemMap = new HashMap<String, HashMap<String, ArrayList<String>>>(1);
        appEntityPermItemMap.put("TV3/VDJ86RC", map);
        String dimType = "DIM_ORG";
        Long dimObjId = OrgUnitServiceHelper.getRootOrgId();
        boolean addOrRemove = true;
        boolean isIncludeSub = false;
        return PermissionServiceHelper.userDirectAssignPerm((Long)userId, (String)dimType, (Long)dimObjId, appEntityPermItemMap, (boolean)addOrRemove, (boolean)isIncludeSub);
    }
}

