/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.eas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.connector.AttachUtil;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorVersion;
import kd.isc.iscb.platform.core.connector.HttpConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.WorkflowInfo;
import kd.isc.iscb.platform.core.connector.eas.EasProxyContext;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.InitResult;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.connector.client.RemoteSystem;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.AbstractInputStream;
import kd.isc.iscb.util.io.AbstractOutputStream;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public final class EasProxyConnectionFactory
implements JdbcConnectionFactory,
HttpConnectionFactory {
    public boolean supportsTransaction() {
        return false;
    }

    public JdbcConnectionWrapper create(DynamicObject cfg) {
        EasProxyContext ctx = new EasProxyContext(cfg);
        Connection cn = RemoteSystem.getConnection((RemoteContext)ctx);
        return new JdbcConnectionWrapper(cn, (JdbcConnectionFactory)this, cfg);
    }

    public Table getTable(JdbcConnectionWrapper cn, String table_name) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getTable((RemoteContext)ctx, (String)table_name);
    }

    public Map<String, Index> getIndexInfo(JdbcConnectionWrapper cn, String table_name) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getIndexInfo((RemoteContext)ctx, (String)table_name);
    }

    public void classify(JdbcConnectionWrapper cn, Table table, List<Map<String, Object>> rows, List<Column> judgeFields, List<Map<String, Object>> for_insert, List<Map<String, Object>> for_update) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        RemoteSystem.classify((RemoteContext)ctx, (Table)table, judgeFields, rows, for_insert, for_update);
    }

    public Map<String, MetaType> getMetaList(ConnectionWrapper cn) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getMetaList((RemoteContext)ctx);
    }

    public void test(ConnectionWrapper cn) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        RemoteSystem.test((RemoteContext)ctx);
    }

    public List<Map<String, Object>> getEntityInfo(ConnectionWrapper cn, String name) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getEntityInfo((RemoteContext)ctx, (String)name);
    }

    public Map<String, Object> getEnumInfo(ConnectionWrapper cn, String name) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getEnumInfo((RemoteContext)ctx, (String)name);
    }

    public Map<String, Object> getTableInfo(JdbcConnectionWrapper cn, String table_name) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getTableInfo((RemoteContext)ctx, (String)table_name);
    }

    public Map<String, Object> getServiceInfo(ConnectionWrapper cn, String service_name) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getServiceInfo((RemoteContext)ctx, (String)service_name);
    }

    public ObjectReader<Map<String, Object>> query(ConnectionWrapper cn, String entity, Map<String, Object> requires, List<Map<String, Object>> filter, List<Map<String, String>> orderBy) {
        Util.checkEntityName((String)entity);
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.retrieveData((RemoteContext)ctx, (String)entity, requires, filter, orderBy);
    }

    public Response doBizAction(ConnectionWrapper cn, String entity, Map<String, Object> data, Map<String, List<String>> judgeFields, List<String> actions, String proxy_user) {
        Util.checkEntityName((String)entity);
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.doBizAction((RemoteContext)ctx, (String)entity, data, judgeFields, actions, (String)proxy_user);
    }

    public Response doDataAction(ConnectionWrapper cn, Map<String, Object> data, Table mainTable, Map<String, Pair<Table, String>> entryTables, Map<String, List<String>> judgeFields, List<String> actions) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.doDataAction((RemoteContext)ctx, data, (String)mainTable.getName(), entryTables, judgeFields, actions);
    }

    public Response callDataHandler(ConnectionWrapper cn, String targetDataHandler, Map<String, Object> data, Map<String, List<String>> judgeFields, String proxy_user) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.callDataHandler((RemoteContext)ctx, (String)targetDataHandler, data, judgeFields, (String)proxy_user);
    }

    public void detachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        RemoteSystem.detachEvents((RemoteContext)ctx, (String)iscHub, (EventBindingUtil.TriggerType)type, (long)triggerId, (String)entity);
    }

    public void attachEvents(ConnectionWrapper cn, String iscHub, EventBindingUtil.TriggerType type, long triggerId, String entity, String[] events, Map<String, Object> requires) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        RemoteSystem.attachEvents((RemoteContext)ctx, (String)iscHub, (EventBindingUtil.TriggerType)type, (long)triggerId, (String)entity, (String[])events, requires);
    }

    public void deploy(ConnectionWrapper cn, String ierpServerURL, String adminPassword, PermissionMode mode) {
        DynamicObject cfg = cn.getConfig();
        UserPermissionUtil.assignPermAndUpdate(cfg);
        Util.deploy((DynamicObject)cfg, (String)D.s((Object)ierpServerURL), (String)adminPassword, (PermissionMode)mode);
        String url = Util.generateVersionURL((DynamicObject)cfg);
        ConnectorVersion.remove((String)url);
    }

    public void pushPermission(ConnectionWrapper cn, Map<Object, Object> permission, String adminPassword) {
        DynamicObject cfg = cn.getConfig();
        Util.pushPermission((DynamicObject)cfg, permission, (String)adminPassword);
    }

    public Object callService(ConnectionWrapper cn, String service, Map<String, Object> params, String proxyUser) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.callService((RemoteContext)ctx, (String)service, params, (String)proxyUser);
    }

    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return "SELECT TOP " + topN + " " + sql.substring("SELECT".length());
        }
        throw new IllegalArgumentException(sql);
    }

    public char getQuot() {
        return ' ';
    }

    public boolean supportsRemoteDeploy() {
        return true;
    }

    public boolean supportsEvent() {
        return true;
    }

    public void rePushEventData(ConnectionWrapper cn, List<Object> ids) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        RemoteSystem.rePushEventData((RemoteContext)ctx, ids);
    }

    public Map<String, InitResult> checkInitState(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        String key = Util.generateKey((String)adminPassword, (String)Util.getAlgorithm((DynamicObject)cn.getConfig()));
        String encryptData = Cipher.encrypt((String)JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (String)key);
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return (Map)JSON.parseObject((String)RemoteSystem.checkInitState((RemoteContext)ctx, (String)encryptData), (TypeReference)new TypeReference<Map<String, InitResult>>(){}, (Feature[])new Feature[0]);
    }

    public Map<String, InitResult> initEnv(ConnectionWrapper cn, Map<String, Object> data, String adminPassword) {
        String key = Util.generateKey((String)adminPassword, (String)Util.getAlgorithm((DynamicObject)cn.getConfig()));
        String encryptData = Cipher.encrypt((String)JSON.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (String)key);
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        if (ctx.getVersion() >= 3.1) {
            return (Map)JSON.parseObject((String)RemoteSystem.initEnv((RemoteContext)ctx, (String)encryptData), (TypeReference)new TypeReference<Map<String, InitResult>>(){}, (Feature[])new Feature[0]);
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u66f4\u65b0eas\u8fde\u63a5\u5668\u76f8\u5173jar\u5305\u518d\u4f7f\u7528\u73af\u5883\u521d\u59cb\u5316\u529f\u80fd", (String)"EasProxyConnectionFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    public void invokeCallbackHandler(ConnectionWrapper cn, String callbackHandler, Map<String, Object> response) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        RemoteSystem.invokeCallbackHandler((RemoteContext)ctx, (String)callbackHandler, response);
    }

    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        if ("$FILE_LIST".equals(metaFullname)) {
            return false;
        }
        switch (MetaType.valueOf((String)type)) {
            case ENTITY: {
                return true;
            }
            case ENUM: {
                return true;
            }
            case TABLE: {
                return true;
            }
            case SERVICE: {
                return true;
            }
            case VIEW: {
                return true;
            }
            case QUERY: {
                return true;
            }
        }
        return false;
    }

    public void raiseEvent(ConnectionWrapper cn, String handler, Map<String, Object> data) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        RemoteSystem.raiseEvent((RemoteContext)ctx, (String)handler, data);
    }

    public AbstractInputStream getAttachmentReader(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getAttachmentReader((RemoteContext)ctx, fileInfo);
    }

    public AbstractOutputStream getAttachmentWriter(ConnectionWrapper cn, Map<String, Object> fileInfo) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.getAttachmentWriter((RemoteContext)ctx, fileInfo, (int)AttachUtil.getBlockSize());
    }

    public boolean supportsAttachment(ConnectionWrapper cn) {
        return true;
    }

    public boolean isAttachmentChanged(ConnectionWrapper cn, Map<String, Object> fileInfo, String md5Code) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.isAttachmentChanged((RemoteContext)ctx, fileInfo, (String)md5Code);
    }

    public List<Map<String, Object>> retrieveAttachList(ConnectionWrapper cn, Map<String, Object> invokeParam) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.retrieveAttachList((RemoteContext)ctx, invokeParam);
    }

    public int removeLogs(ConnectionWrapper cn, Map<String, Object> params) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.removeLogs((RemoteContext)ctx, params);
    }

    public String netSpeedTest(ConnectionWrapper cn) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.netSpeedTest((RemoteContext)ctx);
    }

    public List<String> invokeBotp(ConnectionWrapper cn, String botpNumber, List<String> idList, String proxyUser, Map<String, Object> extendInfo) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.invokeBotp((RemoteContext)ctx, (String)botpNumber, idList, (String)proxyUser, extendInfo);
    }

    public List<WorkflowInfo> initiateWorkflow(ConnectionWrapper cn, String entity, String operation, List<String> idList, String proxyUser, Map<String, Object> extendInfo) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        List list = RemoteSystem.initiateWorkflow((RemoteContext)ctx, (String)entity, (String)operation, idList, (String)proxyUser, extendInfo);
        return WorkflowInfo.toList((List)list);
    }

    public List<WorkflowInfo> queryWorkflowState(ConnectionWrapper cn, String entity, String operation, List<String> idList) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        List list = RemoteSystem.queryWorkflowState((RemoteContext)ctx, (String)entity, (String)operation, idList);
        return WorkflowInfo.toList((List)list);
    }

    public List<WorkflowInfo> getWorkflowState(ConnectionWrapper cn, List<String> workflowInstanceIdList) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        List list = RemoteSystem.getWorkflowState((RemoteContext)ctx, workflowInstanceIdList);
        return WorkflowInfo.toList((List)list);
    }

    public String getHttpURL(DynamicObject dynamicObject) {
        String protocal = D.s((Object)dynamicObject.getString("http_protocal"));
        if (protocal == null) {
            protocal = "http";
        }
        String url = protocal + "://" + dynamicObject.getString("server_ip") + ":" + dynamicObject.getString("server_port") + "/isc/proxy";
        return url;
    }

    public void undeploy(ConnectionWrapper cn, String iscHub, String ierpServerURL, String adminPassword) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        String accessKey = Util.getEasAccessKey((DynamicObject)cn.getConfig());
        String key = Util.generateKey((String)adminPassword, (String)Util.getAlgorithm((DynamicObject)cn.getConfig()));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("h", Hash.md5((String)(ierpServerURL + accessKey)));
        m.put("t", System.currentTimeMillis());
        String data = Cipher.encrypt((String)Json.toString(m), (String)key);
        if (!(ctx.getVersion() >= 4.1)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f53\u524dEAS\u670d\u52a1\u5668\u4e0a\u7684\u8fde\u63a5\u5668sp\u5305\u4e0d\u652f\u6301\u201c\u53cd\u90e8\u7f72\u201d\u529f\u80fd\uff0c\u8bf7\u5347\u7ea7EAS\u8fde\u63a5\u5668sp\u5305\u3002\uff08\u8fde\u63a5\u5668sp\u5305\u4e0b\u8f7d\u5730\u5740\uff1ahttps://club.kdcloud.com/article/146134\uff09", (String)"EasProxyConnectionFactory_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        RemoteSystem.undeploy((RemoteContext)ctx, (String)iscHub, (String)data);
    }

    public boolean supportsBizBatchAction(ConnectionWrapper cn) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return ctx.getVersion() >= 5.0;
    }

    public List<Response> doBatchBizAction(ConnectionWrapper cn, String entity, List<Map<String, Object>> batch, String pk, Map<String, List<String>> judgeFields, String action, String proxy_user) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        return RemoteSystem.doBatchBizAction((RemoteContext)ctx, (String)entity, batch, (String)pk, judgeFields, (String)action, (String)proxy_user);
    }

    public void callbackTest(ConnectionWrapper cn) {
        EasProxyContext ctx = new EasProxyContext(cn.getConfig());
        if (!(ctx.getVersion() >= 6.1)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f53\u524dEAS\u670d\u52a1\u5668\u4e0a\u7684\u8fde\u63a5\u5668sp\u5305\u4e0d\u652f\u6301\u201c\u56de\u8c03\u6d4b\u8bd5\u201d\u529f\u80fd\uff0c\u8bf7\u5347\u7ea7EAS\u8fde\u63a5\u5668sp\u5305\u3002\uff08\u8fde\u63a5\u5668sp\u5305\u4e0b\u8f7d\u5730\u5740\uff1ahttps://club.kdcloud.com/article/146134\uff09", (String)"EasProxyConnectionFactory_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        RemoteSystem.callbackTest((RemoteContext)ctx);
    }
}

