/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MsgRehandleTask;
import kd.isc.iscb.platform.core.dc.mq.PublishedMessage;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceTask;

public class MQUtil {
    private static final String ENTITY_ISC_MQ_PUBLISHER = "isc_mq_publisher";
    private static final String ENTITY_ISC_MQ_SUBSCRIBER = "isc_mq_subscriber";
    private static final String ENTITY_ISC_MQ_DATA_RECEIVED = "isc_mq_data_received";
    private static final String ENTITY_ISC_MQ_DATA_PUBLISHED = "isc_mq_data_published";
    private static final String STACK_TRACE_TAG = "stack_trace_tag";
    private static final String STACK_TRACE = "stack_trace";
    private static final String STATE = "state";
    private static final String RETRY_COUNT = "retry_count";

    public static long publish(String s, MessageQueueServer server, DynamicObject publisher, String data_producer) {
        DynamicObject msg = MQUtil.createData(s, server.getConfig(), publisher, data_producer);
        long id = msg.getLong("id");
        TraceStack.run((TraceType)TraceType.XMQP, (String)MQUtil.getNumber(msg), (long)id, (TraceTask)new /* Unavailable Anonymous Inner Class!! */);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerPublish(String messageTag, MessageQueueServer server, DynamicObject publisher, long dataId) {
        Charset charset = Charset.forName(publisher.getString("charset"));
        byte[] data = messageTag.getBytes(charset);
        PublishedMessage msg = new PublishedMessage(dataId, data, charset);
        if (!publisher.getBoolean("enable")) {
            msg.setFailed((Throwable)new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u53d1\u5e03\u4e3b\u9898\u672a\u542f\u7528\uff0c\u53d1\u9001\u5931\u8d25", (String)"MQUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), publisher.getString("number"))));
            return;
        }
        String topic = D.s((Object)publisher.getString("number"));
        String customConfig = D.s((Object)publisher.get("custom_config"));
        try {
            if (StringUtil.isEmpty((String)customConfig)) {
                server.publish(topic, msg);
            } else {
                server.publish(topic, msg, customConfig);
            }
        }
        finally {
            MQUtil.refreshCounter(data);
        }
    }

    private static void refreshCounter(byte[] data) {
        IscRuntimeInfo info = IscRuntimeInfo.get();
        info.addMqPublishedBytes(data.length);
        info.incMqPublishedCount();
    }

    public static void republish(List<Object> dataIds) {
        for (Object dataId : dataIds) {
            MQUtil.republish(dataId);
        }
    }

    public static void republish(Object dataId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)ENTITY_ISC_MQ_DATA_PUBLISHED);
        MQUtil.republish(obj);
    }

    public static void republish(DynamicObject obj) {
        MQUtil.updateObjForRepublish(obj);
        MQUtil.doRepublish(obj);
    }

    public static void doRepublish(DynamicObject obj) {
        MessageQueueServer server = MessageQueueManager.get((long)obj.getLong("message_server_id"));
        DynamicObject publisher = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("message_queue_id"), (String)ENTITY_ISC_MQ_PUBLISHER);
        TraceStack.run((TraceType)TraceType.XMQP2, (String)MQUtil.getNumber(obj), (long)obj.getLong("id"), (TraceTask)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void reconsume(List<Object> dataIds) {
        for (Object dataId : dataIds) {
            MQUtil.reconsume(dataId);
        }
    }

    private static void reconsume(Object dataId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)ENTITY_ISC_MQ_DATA_RECEIVED);
        MQUtil.reconsumeHelp(obj);
    }

    public static void reconsumeHelp(DynamicObject obj) {
        MQUtil.updateObjForReconsume(obj);
        DynamicObject subscriber = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("message_queue_id"), (String)ENTITY_ISC_MQ_SUBSCRIBER);
        String topic = subscriber.getString("number");
        String script = D.s((Object)subscriber.get("parse_script_tag"));
        if (script == null) {
            script = D.s((Object)subscriber.get("parse_script"));
        }
        LightTaskManager.submit((LightTask)new MsgRehandleTask(obj, subscriber, topic, script));
    }

    private static DynamicObject updateObjForReconsume(DynamicObject obj) {
        obj.set(RETRY_COUNT, (Object)(obj.getInt(RETRY_COUNT) + 1));
        obj.set(STATE, (Object)"R");
        obj.set(STACK_TRACE, null);
        obj.set(STACK_TRACE_TAG, null);
        Util.save((DynamicObject)obj);
        return obj;
    }

    private static DynamicObject updateObjForRepublish(DynamicObject obj) {
        obj.set(RETRY_COUNT, (Object)(obj.getInt(RETRY_COUNT) + 1));
        obj.set("published_time", (Object)new Timestamp(System.currentTimeMillis()));
        obj.set("publisher_server", (Object)NetUtil.getServerId());
        obj.set(STACK_TRACE, null);
        obj.set(STACK_TRACE_TAG, null);
        obj.set(STATE, (Object)"C");
        Util.save((DynamicObject)obj);
        return obj;
    }

    private static DynamicObject createData(String s, DynamicObject server, DynamicObject publisher, String data_producer) {
        long id = IDService.get().genLongId();
        DynamicObject bo = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_MQ_DATA_PUBLISHED);
        bo.set("id", (Object)id);
        bo.set(STATE, (Object)"C");
        bo.set("published_time", (Object)new Timestamp(System.currentTimeMillis()));
        bo.set("message_server", (Object)server);
        bo.set("message_queue", (Object)publisher);
        bo.set("data", (Object)StringUtil.trim((String)s, (int)50));
        bo.set("data_tag", (Object)s);
        bo.set("publisher_server", (Object)NetUtil.getServerId());
        bo.set("data_producer", (Object)data_producer);
        bo.set("msg_digest", MQUtil.parseMsgDigest(s, publisher.getString("msg_digest")));
        return bo;
    }

    static String getNumber(DynamicObject msg) {
        String s = D.s((Object)msg.getString("msg_digest"));
        if (s == null) {
            s = msg.getString("data");
        }
        return s;
    }

    public static Object parseMsgDigest(String msgData, String msgDigest, Object originData) {
        if (StringUtil.isEmpty((String)msgData)) {
            return " ";
        }
        if (StringUtil.isEmpty((String)msgDigest)) {
            return StringUtil.trim((String)StringUtil.trim((String)msgData, (int)100), (String)" ");
        }
        try {
            HashMap<String, Object> ctx = new HashMap<String, Object>(1);
            ctx.put("$data", originData != null ? originData : Json.toObject((String)msgData));
            String data = Format.parse((String)msgDigest, ctx).translate(ctx);
            return StringUtil.trim((String)StringUtil.trim((String)data, (int)100), (String)" ");
        }
        catch (Exception e) {
            return StringUtil.trim((String)StringUtil.trim((Object)e, (int)100), (String)" ");
        }
    }

    public static Object parseMsgDigest(String msgData, String msgDigest) {
        return MQUtil.parseMsgDigest(msgData, msgDigest, null);
    }

    static /* synthetic */ void access$000(String x0, MessageQueueServer x1, DynamicObject x2, long x3) {
        MQUtil.innerPublish(x0, x1, x2, x3);
    }
}

