/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.GroupCategory;
import kd.isc.iscb.platform.core.license.n.GroupInfo;
import kd.isc.iscb.platform.core.license.n.TenantInfo;

public class AccountInfo {
    private TenantInfo tenant;
    private String accountId;
    private String accountName;
    private Map<GroupCategory, GroupInfo> groups = new LinkedHashMap<GroupCategory, GroupInfo>();

    public AccountInfo(TenantInfo tenant, String accountId, String accountName) {
        this.tenant = tenant;
        this.accountId = accountId;
        this.accountName = accountName;
    }

    public TenantInfo getTenant() {
        return this.tenant;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public Map<GroupCategory, GroupInfo> getGroups() {
        return Collections.unmodifiableMap(this.groups);
    }

    GroupInfo getOrCreateGroup(String connectionType, boolean isMQ) {
        GroupCategory category = GroupCategory.getCategory((String)connectionType, (boolean)isMQ, (String)this.accountId);
        GroupInfo group = this.groups.get(category);
        if (group == null) {
            group = new GroupInfo(this, category);
            this.groups.put(category, group);
        }
        return group;
    }

    public ConnectionInfo getSystemConnection(long connectionId) {
        for (GroupInfo g : this.groups.values()) {
            ConnectionInfo cn = g.getSystemConnection(connectionId);
            if (cn == null) continue;
            return cn;
        }
        return null;
    }

    public ConnectionInfo getMqConnection(long connectionId) {
        for (GroupInfo g : this.groups.values()) {
            ConnectionInfo cn = g.getMqConnection(connectionId);
            if (cn == null) continue;
            return cn;
        }
        return null;
    }

    public ConnectionInfo getConnectionInfo(long connectionId) {
        for (GroupInfo g : this.groups.values()) {
            ConnectionInfo cn = g.getConnectionInfo(connectionId);
            if (cn == null) continue;
            return cn;
        }
        return null;
    }
}

