/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.connector.webapi.DynamicObjectContext;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.FlowTrace;
import kd.isc.iscb.util.flow.trace.FlowDebuggerResource;
import kd.isc.iscb.util.flow.trace.FlowDebuggerTrace;
import kd.isc.iscb.util.flow.trace.LineCollector;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.trace.TraceTask;

public class ProcessRuntime
implements Const {
    public static FlowRuntime loadRuntime(long id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_sf_proc_inst");
        String text = obj.getString("context_tag");
        Map json = (Map)Json.toObject((String)text);
        Flow flow = ServiceFlowParser.getFlow((long)obj.getLong("flow_id"));
        FlowRuntime runtime = flow.fromJson(json);
        runtime.setTransientProperty("$process", (Object)new DynamicObjectContext(obj));
        runtime.setTransientProperty("PROCESS_STATE", obj.get("state"));
        ProcessRuntime.prepareFlowDebugger(runtime);
        return runtime;
    }

    public static DynamicObject getProcessObj(FlowRuntime runtime) {
        DynamicObjectContext ctx = (DynamicObjectContext)runtime.getTransientProperty("$process");
        return ctx.getDynamicObject();
    }

    public static DynamicObjectContext getProcessObjContext(FlowRuntime runtime) {
        return (DynamicObjectContext)runtime.getTransientProperty("$process");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setRunning(long id, ProcessState currentState) {
        String sql = "UPDATE t_isc_sf_proc_inst SET fserver_instance=?, fstate=?,fmodified_time=?  where fid=? and (fstate=? or fstate = 'Interrupted' or fstate='" + ProcessState.Failed + "' or (fstate='" + ProcessState.Running + "' and fmodified_time<?))";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Timestamp deadline = new Timestamp(System.currentTimeMillis() - 65000L);
            int affected = DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(TaskManager.getInstanceId(), ProcessState.Running.name(), now, id, currentState.name(), deadline), Arrays.asList(12, 12, 93, -5, 12, 93));
            boolean bl = affected == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static String getNumber(FlowRuntime runtime) {
        return D.s((Object)runtime.getProperty("number"));
    }

    public static DynamicObject create(long flowId, Object[] inputs) {
        return ProcessRuntime.create(flowId, inputs, Collections.emptyMap());
    }

    public static DynamicObject create(long flowId, Object[] inputs, Map<String, Object> data) {
        return ProcessRuntime.create(flowId, inputs, data, Collections.emptyMap());
    }

    public static DynamicObject create(long flowId, Object[] inputs, Map<String, Object> data, Map<String, Object> properties) {
        return ProcessRuntime.create(flowId, inputs, data, properties, 0L, null, null);
    }

    public static DynamicObject createProcById(long flowId, Object[] inputs, Map<String, Object> data, Map<String, Object> properties, long procInstId) {
        return ProcessRuntime.createProcById(flowId, inputs, data, properties, 0L, null, null, procInstId);
    }

    public static DynamicObject create(long flowId, Object[] inputs, Map<String, Object> data, Map<String, Object> properties, long parent_proc_id, String parent_execution_id, String parent_execution_name) {
        long procInstId = IDService.get().genLongId();
        return ProcessRuntime.createProcById(flowId, inputs, data, properties, parent_proc_id, parent_execution_id, parent_execution_name, procInstId);
    }

    private static DynamicObject createProcById(long flowId, Object[] inputs, Map<String, Object> data, Map<String, Object> properties, long parent_proc_id, String parent_execution_id, String parent_execution_name, long procInstId) {
        String number = Hash.longToDigital32((long)procInstId);
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_sf_proc_inst");
        ProcessRuntime.setBasics(obj, flowId, number, procInstId);
        properties = ProcessRuntime.prepareParentProcProperties(properties, parent_proc_id, parent_execution_id);
        ProcessRuntime.setRuntimeContext(flowId, inputs, data, procInstId, number, obj, properties);
        ProcessRuntime.setUserAndTime(obj);
        ProcessRuntime.setProcParent(obj, parent_proc_id, parent_execution_id, parent_execution_name);
        TraceStack.run((TraceType)TraceType.NEW_SFP, (DynamicObject)obj, (TraceTask)new /* Unavailable Anonymous Inner Class!! */);
        IscRuntimeInfo.get().incServiceFlowTotalCount();
        return obj;
    }

    private static Map<String, Object> prepareParentProcProperties(Map<String, Object> properties, long parent_proc_id, String parent_execution_id) {
        if (parent_proc_id != 0L) {
            if (properties == null || properties.isEmpty()) {
                properties = new HashMap<String, Object>(8);
            }
            properties.put("parent_proc_id", parent_proc_id);
            properties.put("parent_execution_id", parent_execution_id);
        }
        return properties;
    }

    private static void setProcParent(DynamicObject obj, long parent_proc_id, String parent_execution_id, String parent_execution_name) {
        obj.set("parent_proc_id", (Object)parent_proc_id);
        obj.set("parent_execution_id", (Object)parent_execution_id);
        obj.set("parent_execution_name", (Object)StringUtil.trim((String)parent_execution_name, (int)50));
    }

    private static void setRuntimeContext(long flowId, Object[] inputs, Map<String, Object> data, long procInstId, String number, DynamicObject obj, Map<String, Object> properties) {
        FlowRuntime runtime = ProcessRuntime.newInstance(flowId, procInstId, number, inputs, data);
        ProcessRuntime.setProperties(runtime, properties);
        Map json = runtime.toJson();
        obj.set("context_tag", (Object)Json.toString((Object)json, (boolean)true));
    }

    private static void setProperties(FlowRuntime runtime, Map<String, Object> properties) {
        if (properties != null) {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                runtime.setProperty(e.getKey(), e.getValue());
            }
        }
    }

    public static FlowRuntime newInstance(long flowId, Object[] inputs, Map<String, Object> data) {
        long procInstId = IDService.get().genLongId();
        String number = Hash.mur32((Object[])new Object[]{procInstId});
        return ProcessRuntime.newInstance(flowId, procInstId, number, inputs, data);
    }

    private static FlowRuntime newInstance(long flowId, long procInstId, String number, Object[] inputs, Map<String, Object> data) {
        Flow flow = ServiceFlowParser.getFlow((long)flowId);
        FlowRuntime runtime = flow.newInstance(String.valueOf(procInstId));
        runtime.setProperty("number", (Object)number);
        ProcessRuntime.prepareFlowVariables(inputs, data, runtime);
        return runtime;
    }

    private static void prepareFlowDebugger(FlowRuntime runtime) {
        String mode = D.s((Object)runtime.getProperty("#DEBUG"));
        if (mode == null) {
            return;
        }
        FlowDebuggerResource res = new FlowDebuggerResource(runtime.getFlow(), LineCollector.valueOf((String)mode));
        runtime.setFlowTrace((FlowTrace)new FlowDebuggerTrace(res));
        res.attachBreakpoint(runtime);
        runtime.setTransientProperty("#flush", (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void setBasics(DynamicObject obj, long flowId, String number, long procInstId) {
        obj.set("id", (Object)procInstId);
        obj.set("flow", (Object)flowId);
        obj.set("state", (Object)ProcessState.Created.name());
        obj.set("number", (Object)number);
    }

    private static void prepareFlowVariables(Object[] inputs, Map<String, Object> data, FlowRuntime runtime) {
        for (Map.Entry<String, Object> e : data.entrySet()) {
            runtime.set(e.getKey(), e.getValue());
        }
        runtime.prepare(inputs);
    }

    private static void setUserAndTime(DynamicObject obj) {
        long user = D.l((Object)RequestContext.get().getUserId());
        obj.set("creator", (Object)user);
        obj.set("modifier", (Object)user);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        obj.set("created_time", (Object)time);
        obj.set("modified_time", (Object)time);
    }

    public static void saveState(long id, FlowRuntime runtime) {
        ProcessState state = ProcessRuntime.getState(runtime, null);
        ProcessRuntime.saveState(id, runtime, state);
    }

    public static void saveState(long id, FlowRuntime runtime, Throwable e) {
        ProcessRuntime.saveErrorLog(id, e, null);
        ProcessState state = ProcessRuntime.getState(runtime, e);
        ProcessRuntime.saveState(id, runtime, state, e);
    }

    public static int saveState(long id, FlowRuntime runtime, ProcessState state) {
        return ProcessRuntime.saveState(id, runtime, state, null);
    }

    public static int saveState(long id, FlowRuntime runtime, ProcessState state, Throwable err) {
        try {
            return ProcessRuntime.innerSaveState(id, runtime, state, err);
        }
        catch (Throwable e) {
            return ProcessRuntime.innerSaveState(id, runtime, state, e);
        }
    }

    private static int innerSaveState(long id, FlowRuntime runtime, ProcessState state, Throwable e) {
        int length;
        long createdTime;
        if (runtime != null && ServiceFlowEngine.withoutProcInst((FlowRuntime)runtime)) {
            return -1;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_sf_proc_inst");
        obj.set("state", (Object)state.name());
        long currentTime = System.currentTimeMillis();
        obj.set("modified_time", (Object)new Timestamp(currentTime));
        obj.set("modifier", (Object)D.l((Object)RequestContext.get().getUserId()));
        obj.set("server_instance", (Object)TaskManager.getInstanceId());
        obj.set("exec_time", (Object)0);
        if ((ProcessState.Failed == state || ProcessState.Complete == state) && (createdTime = D.l((Object)obj.getDate("created_time"))) > 0L) {
            obj.set("exec_time", (Object)Math.max(D.i((Object)(currentTime - createdTime)), 1));
        }
        if (e != null) {
            String cascadeMessage = StringUtil.getCascadeMessage((Throwable)e);
            obj.set("error_message", (Object)StringUtil.trim((String)cascadeMessage, (int)83));
        }
        if (ProcessState.Complete == state) {
            obj.set("error_message", null);
        }
        if (runtime != null) {
            obj.set("context", (Object)StringUtil.trim((String)ProcessRuntime.generateDigest(runtime), (int)100));
            String s = Json.toString((Object)runtime.toJson(), (boolean)true);
            obj.set("context_tag", (Object)s);
            length = s.length();
            obj.set("context_length", (Object)length);
        } else {
            obj.set("context", (Object)"...");
            length = 0;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        return length;
    }

    public static String generateDigest(FlowRuntime runtime) {
        Format format = ServiceFlowParser.getProcessDigest((Flow)runtime.getFlow());
        if (format == null) {
            return "...";
        }
        return ProcessRuntime.formatDigest(runtime, format);
    }

    private static String formatDigest(FlowRuntime runtime, Format format) {
        try {
            return format.translate((Context)runtime);
        }
        catch (Exception e) {
            ProcessRuntime.saveWarnLog(Long.parseLong(runtime.getId()), e, ResManager.loadKDString((String)"\u6d41\u7a0b\u6458\u8981", (String)"ProcessRuntime_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            return "..";
        }
    }

    public static ProcessState getState(FlowRuntime runtime) {
        return ProcessRuntime.getState(runtime, null);
    }

    private static ProcessState getState(FlowRuntime runtime, Throwable e) {
        if (e instanceof TaskCancelException) {
            return ProcessState.Terminated;
        }
        if (e != null || runtime == null || runtime.isSuspended()) {
            return ProcessState.Failed;
        }
        if (runtime.isTerminated()) {
            return ProcessState.Terminated;
        }
        if (!runtime.isClosed()) {
            return ProcessState.Waiting;
        }
        if (ProcessRuntime.isCancelling(runtime)) {
            return ProcessState.Terminated;
        }
        return ProcessState.Complete;
    }

    private static boolean isCancelling(FlowRuntime runtime) {
        return D.x((Object)runtime.getTransientProperty("is_cancelling"));
    }

    public static void setCancelling(FlowRuntime runtime) {
        runtime.setTransientProperty("is_cancelling", (Object)Boolean.TRUE);
    }

    public static int getCurrentLogTotalCount(FlowRuntime runtime) {
        return D.i((Object)runtime.getTransientProperty("CURRENT_TOTAL_COUNT"));
    }

    public static int increaseLogCountAndGet(FlowRuntime runtime) {
        int logCount = D.i((Object)runtime.getTransientProperty("CURRENT_TOTAL_COUNT"));
        runtime.setTransientProperty("CURRENT_TOTAL_COUNT", (Object)(++logCount));
        return logCount;
    }

    public static void saveControlLog(long procInstId, String text) {
        ProcessRuntime.saveLog(procInstId, "CONTROL", text);
    }

    public static void saveErrorLog(long procInstId, Throwable e, String node) {
        if (e instanceof TaskCancelException) {
            ProcessRuntime.saveLog(procInstId, "CONTROL", ProcessRuntime.toString(node, e));
        } else {
            ProcessRuntime.saveLog(procInstId, "ERROR", ProcessRuntime.toString(node, e));
        }
    }

    private static void saveLog(long procInstId, String type, String text) {
        DynamicObject obj = ProcessRuntime.buildNewProcLog(procInstId, type, text);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    private static DynamicObject buildNewProcLog(long procInstId, String type, String text) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_sf_proc_log");
        obj.set("host", (Object)StringUtil.trim((String)NetUtil.getServerId(), (int)50));
        obj.set("proc_inst", (Object)procInstId);
        obj.set("type", (Object)type);
        obj.set("content", (Object)StringUtil.trim((String)text, (int)50));
        if (text != null && text.length() > 50) {
            obj.set("content_tag", (Object)text);
        }
        obj.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        return obj;
    }

    public static void batchSaveErrorLog(List<Long> procInstIds, String text) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(procInstIds.size());
        for (Long procInstId : procInstIds) {
            DynamicObject obj = ProcessRuntime.buildNewProcLog(procInstId, "ERROR", text);
            list.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public static void saveWarnLog(long procInstId, Throwable e, String node) {
        ProcessRuntime.saveLog(procInstId, "WARN", ProcessRuntime.toString(node, e));
    }

    public static void saveInfoLog(long procInstId, String text) {
        ProcessRuntime.saveLog(procInstId, "INFO", text);
    }

    private static String toString(String node, Throwable e) {
        String text = StringUtil.toString((Throwable)e);
        if (node != null) {
            text = node + "\uff1a" + text;
        }
        if (e instanceof IscBizException) {
            text = text + "\r\n\r\n" + ((IscBizException)e).getData();
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateProgress(FlowRuntime runtime) {
        long procInstId = D.l((Object)runtime.getId());
        String sql = "UPDATE t_isc_sf_proc_inst SET fmodified_time=? where fid=? and fstate=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            int affected = DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(now, procInstId, ProcessState.Running.name()), Arrays.asList(93, -5, 12));
            boolean bl = affected == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

