/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.api.UserPermissionUtil;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.task.LightTask;

public class ProxyUserPermTask
implements LightTask {
    private static final String LICENSE_SN = "license_sn";
    private static final String LICENSE_INFO = "license_info";
    private DynamicObject[] databaseLinks;
    private DynamicObject[] isc_mq_servers;
    private String accountId;

    public ProxyUserPermTask(DynamicObject[] databaseLinks, DynamicObject[] isc_mq_servers, String accountId) {
        this.databaseLinks = databaseLinks;
        this.accountId = accountId;
        this.isc_mq_servers = isc_mq_servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            AccountInfo account = LicenseCache.getTenant().getCurrentAccount();
            this.updateLicenseInfo(account, this.databaseLinks);
            this.updateLicenseInfo(account, this.isc_mq_servers);
        }
        finally {
            for (DynamicObject databaseLink : this.databaseLinks) {
                UserPermissionUtil.assignPermAndUpdate(databaseLink);
            }
        }
    }

    private void updateLicenseInfo(AccountInfo account, DynamicObject[] list) {
        ArrayList<DynamicObject> servers = new ArrayList<DynamicObject>();
        for (DynamicObject obj : list) {
            long id = obj.getLong("id");
            ConnectionInfo cn = account.getConnectionInfo(id);
            String state = cn.getStateString();
            int sn = cn.getLicenseSN();
            if (Objects.equals(obj.get(LICENSE_INFO), state) && Objects.equals(obj.get(LICENSE_SN), sn)) continue;
            obj.set(LICENSE_INFO, (Object)state);
            obj.set(LICENSE_SN, (Object)sn);
            servers.add(obj);
        }
        if (!servers.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])servers.toArray(new DynamicObject[0]));
        }
    }

    public String getId() {
        return "ProxyUserPermTask_" + this.accountId;
    }
}

