/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.filesystem.manager.AbstractQingFile;
import com.kingdee.bos.qing.filesystem.manager.AppLocalTempQingFile;
import com.kingdee.bos.qing.filesystem.manager.ScheduleFailedManager;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.localimpl.AbstractFileFilter;
import com.kingdee.bos.qing.filesystem.manager.localimpl.DirUtil;
import com.kingdee.bos.qing.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.localimpl.filter.FileOverdueFilter;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.filesystem.stream.LocalFileQingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.SeekableInputStream;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AppLocalTempQingFile
extends AbstractQingFile {
    private static ConcurrentHashMap<String, TTLEntry> cache = new ConcurrentHashMap();
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static long ttlIntervalMillis = TimeUnit.DAYS.toMillis(1L);
    private static Runnable task;
    private static final String TEMPDIR = "QingLocalTemp";
    protected String DIRECTORY_PATH = AppLocalTempQingFile.getFolderPath() + File.separator;
    private File _file;

    private static void createRootDir() {
        File tempDir = new File(AppLocalTempQingFile.getFolderPath());
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    private static void cleanResidualTemp() {
        File[] childDirs;
        File tempDir = new File(AppLocalTempQingFile.getFolderPath());
        if (!tempDir.exists()) {
            return;
        }
        for (File childDir : childDirs = tempDir.listFiles()) {
            FileOverdueFilter filter = new FileOverdueFilter();
            DirUtil.delFolder((String)(AppLocalTempQingFile.getFolderPath() + childDir.getName()), (AbstractFileFilter)filter);
        }
    }

    public static void stop() {
        scheduler.shutdown();
    }

    private static String getFolderPath() {
        String folder = System.getProperty("java.io.tmpdir");
        String tempDirPath = folder.endsWith(File.separator) ? folder + TEMPDIR : folder + File.separator + TEMPDIR;
        return tempDirPath;
    }

    private static void cleanDeleteFailedFile() {
        ScheduleFailedManager scheduleFailedManager = new ScheduleFailedManager();
        try {
            scheduleFailedManager.cleanDeleteFailedFile();
        }
        catch (Exception e) {
            LogUtil.error((String)("\u5220\u9664\u5931\u8d25\u6587\u4ef6\u51fa\u9519\uff1a" + e));
        }
    }

    private static void cleanup() {
        Iterator<Map.Entry<String, TTLEntry>> iterator = cache.entrySet().iterator();
        ArrayList<String> fileToRemove = new ArrayList<String>(cache.size());
        while (iterator.hasNext()) {
            Map.Entry<String, TTLEntry> entry = iterator.next();
            if (entry.getValue().isLive()) continue;
            iterator.remove();
            fileToRemove.add(entry.getKey());
        }
        int failCount = 0;
        for (String file : fileToRemove) {
            if (new File(file).delete()) continue;
            ++failCount;
        }
        if (failCount > 0) {
            LogUtil.warn((String)("QingLocalTempFile Failed to remove " + failCount + "files"));
        }
    }

    public AppLocalTempQingFile(QingAppLocalTempFileType fileType) {
        super((AbstractQingFileType)fileType);
        FileSysUtil.createAbsolutePathDir((String)this.DIRECTORY_PATH);
        String fullPath = this.getFullPath();
        this._file = new File(fullPath);
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    protected AppLocalTempQingFile(QingAppLocalTempFileType fileType, String name) {
        super((AbstractQingFileType)fileType, name);
        FileSysUtil.createAbsolutePathDir((String)this.DIRECTORY_PATH);
        String fullPath = this.getFullPath();
        this._file = new File(fullPath);
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    public String getFullPath() {
        return this.getFullPath(this.getPath());
    }

    public String getFullPath(String filePath) {
        return this.checkPath(this.DIRECTORY_PATH + filePath);
    }

    private String checkPath(String path) {
        return path.replace("../", "#");
    }

    public boolean exists() {
        if (this.getName() == null || "".equals(this.getName().trim())) {
            return false;
        }
        if (this._file == null) {
            return false;
        }
        return this._file.exists();
    }

    public long getLength() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this._file.length();
    }

    public long getLastModifiedTimes() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this._file.lastModified();
    }

    public File getLocalFileSystemFile() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this._file;
    }

    public String getLocalFullPath() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this._file.getCanonicalPath();
    }

    protected boolean doCreateNewFile() throws IOException {
        File parentFile = this._file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return this._file.createNewFile();
    }

    protected boolean doDelete() {
        if (this.exists()) {
            if (this._file.delete()) {
                this._file = null;
                return true;
            }
            LogUtil.error((String)("delete file fail, fileName:" + this._file.getPath()));
            ScheduleFailedManager scheduleFailedManager = new ScheduleFailedManager();
            scheduleFailedManager.logDeleteFailedFile(this._fileType, this._file.getName(), QingContext.getCurrent().getAccountId());
        } else {
            LogUtil.error((String)("delete file is not exists, fileName:" + this._file.getPath()));
        }
        return false;
    }

    public QingInputStream getInputStream() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return new QingInputStream(this._file.length(), (SeekableInputStream)new LocalFileQingInputStream(this._file));
    }

    protected IQingFileWriter doCreateWriter() {
        return new LocalQingFileWriter(this._fileResourceService, this._fileResourceInfo, this.getFullPath());
    }

    public IQingFileUpdater findFile(AbstractQingFileType fileType, String name) {
        return new AppLocalTempQingFile((QingAppLocalTempFileType)fileType, name);
    }

    static /* synthetic */ void access$000() {
        AppLocalTempQingFile.cleanup();
    }

    static /* synthetic */ void access$100() {
        AppLocalTempQingFile.cleanDeleteFailedFile();
    }

    static {
        AppLocalTempQingFile.createRootDir();
        AppLocalTempQingFile.cleanResidualTemp();
        task = new /* Unavailable Anonymous Inner Class!! */;
        scheduler.scheduleAtFixedRate(task, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
    }
}

