/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.fileresource.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourcePO;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class FileResourceDao {
    private IDBExcuter dbExcuter;

    public FileResourceDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public BigDecimal findSumFileSizeByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        return (BigDecimal)this.dbExcuter.query("SELECT SUM(FFILESIZE) as SUMFILESIZE FROM T_QING_FILE_RESOURCE WHERE FUSERID=?", new Object[]{userId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public BigDecimal findSumTenantUseFileSizeByTenantId(String tenantId, long userFreeFileSizeByte) throws AbstractQingIntegratedException, SQLException {
        return (BigDecimal)this.dbExcuter.query("SELECT SUM(a.userFileSumSize) as SUMFILESIZE  FROM ( SELECT (sum(FFILESIZE)-?) as userFileSumSize FROM T_QING_FILE_RESOURCE WHERE FTENANTID=? group by FUSERID) a where a.userFileSumSize>0", new Object[]{userFreeFileSizeByte, tenantId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void insert(FileResourcePO resourceFile) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_FILE_RESOURCE (FID, FTENANTID, FUSERID, FFROMID, FFROMTYPE, FFILETYPESUBFOLDER, FDISPLAYNAME, FFILENAME, FFILESIZE, FCREATEDATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Object[] params = new Object[10];
        String id = this.dbExcuter.genStringId("T_QING_FILE_RESOURCE");
        params[0] = id;
        params[1] = resourceFile.getTenantId();
        params[2] = resourceFile.getUserId();
        params[3] = resourceFile.getFromId();
        params[4] = resourceFile.getFromType().name();
        params[5] = resourceFile.getFileTypeSubFolder();
        params[6] = resourceFile.getDisplayName();
        params[7] = resourceFile.getFileName();
        params[8] = resourceFile.getFileSize();
        params[9] = resourceFile.getCreateDate();
        this.dbExcuter.execute(sql, params);
    }

    public List<FileResourceVO> findResourceFileListByUserId(String userId, String sortField, String sortOrder) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT fr.FFROMID, fr.FDISPLAYNAME, fr.FFROMTYPE, fr.FCREATEDATE, fr.FFILESIZE, ISNULL (t.FNAME, p.FNAME) as FROMNAME FROM T_QING_FILE_RESOURCE fr LEFT JOIN t_qing_theme t ON fr.FFROMID=t.FID LEFT JOIN t_qing_publish p ON fr.FFROMID=p.FID WHERE fr.FUSERID =?";
        sql = "displayName".equals(sortField) ? sql + " ORDER BY fr.FDISPLAYNAME " + sortOrder : ("fromName".equals(sortField) ? sql + " ORDER BY FROMNAME " + sortOrder : ("fromType".equals(sortField) ? sql + " ORDER BY fr.FFROMTYPE " + sortOrder : ("fileSize".equals(sortField) ? sql + " ORDER BY fr.FFILESIZE " + sortOrder : ("createDate".equals(sortField) ? sql + " ORDER BY fr.FCREATEDATE " + sortOrder : sql + " ORDER BY fr.FFILESIZE DESC"))));
        List list = (List)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return list;
    }

    public List<FileResourcePO> findFileListByUserIdAndFromId(String userId, String formId) throws AbstractQingIntegratedException, SQLException {
        List list = (List)this.dbExcuter.query("SELECT FFILENAME, FFILETYPESUBFOLDER FROM T_QING_FILE_RESOURCE WHERE FUSERID=? AND FFROMID=?", new Object[]{userId, formId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return list;
    }

    public void deleteFileByUserIdAndFromId(String userId, String formId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_FILE_RESOURCE WHERE FUSERID=? AND FFROMID=?";
        this.dbExcuter.execute(sql, new Object[]{userId, formId});
    }

    public void deleteFileByFileTypeSubFolderAndFileName(String userId, String fileTypeSubFolder, String fileName) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_FILE_RESOURCE WHERE FUSERID=? AND FFILETYPESUBFOLDER=? AND FFILENAME=?";
        this.dbExcuter.execute(sql, new Object[]{userId, fileTypeSubFolder, fileName});
    }

    public void deleteFileByFileTypeSubFolderAndFileName(String fileTypeSubFolder, String fileName) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_FILE_RESOURCE WHERE FFILETYPESUBFOLDER=? AND FFILENAME=?";
        this.dbExcuter.execute(sql, new Object[]{fileTypeSubFolder, fileName});
    }

    public Integer getFileResourceCountByUserIdAndFileName(String userId, String fileUrl) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS COUNT_FILE_RESOURCE FROM T_QING_FILE_RESOURCE FR WHERE FR.FUSERID = ? AND FFILENAME = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(fileUrl);
        return (Integer)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("count_file_resource");
                }
                return 0;
            }
        });
    }
}

