/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl;

import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.localimpl.AbstractLocalQingFile;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalTempQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class LocalTempQingFile
extends AbstractLocalQingFile {
    private static final String TEMPDIR = "QingTemp";
    private static ConcurrentHashMap<String, TTLEntry> cache = new ConcurrentHashMap();
    public static final long ttlIntervalMillis = TimeUnit.HOURS.toMillis(SystemPropertyUtil.getLong("qing.localtempfile.ttl", 12L));

    private static void cleanup() {
        Iterator<Map.Entry<String, TTLEntry>> iterator = cache.entrySet().iterator();
        ArrayList<String> fileToRemove = new ArrayList<String>(cache.size());
        while (iterator.hasNext()) {
            Map.Entry<String, TTLEntry> entry = iterator.next();
            if (entry.getValue().isLive()) continue;
            iterator.remove();
            fileToRemove.add(entry.getKey());
        }
        int failCount = 0;
        for (String file : fileToRemove) {
            if (new File(file).delete()) continue;
            ++failCount;
        }
        if (failCount > 0) {
            LogUtil.warn((String)("QingLocalTempFile Failed to remove " + failCount + "files"));
        }
    }

    public LocalTempQingFile(QingTempFileType fileType) {
        super((AbstractQingFileType)fileType);
        String fullPath = this.getFullPath();
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    private LocalTempQingFile(QingTempFileType fileType, String name) {
        super((AbstractQingFileType)fileType, name);
        String fullPath = this.getFullPath();
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    public String getRootDir() {
        return TEMPDIR;
    }

    protected boolean doDelete() {
        if (super.doDelete()) {
            cache.remove(this.getFullPath());
            return true;
        }
        return false;
    }

    public IQingFileUpdater findFile(AbstractQingFileType fileType, String name) {
        return new LocalTempQingFile((QingTempFileType)fileType, name);
    }

    public static void addTempFileCache(String fullPath) {
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    public void copyTo(IQingFile qingFile, boolean autoDeleteIfFailed) throws IOException {
        if (qingFile instanceof LocalTempQingFile) {
            LocalTempQingFile tempQingFile = (LocalTempQingFile)qingFile;
            try {
                IOUtil.copyFile((File)this.file, (File)tempQingFile.file);
            }
            catch (IOException e) {
                if (autoDeleteIfFailed) {
                    tempQingFile.file.deleteOnExit();
                }
            }
        } else {
            super.copyTo(qingFile, autoDeleteIfFailed);
        }
    }

    static /* synthetic */ void access$000() {
        LocalTempQingFile.cleanup();
    }

    static {
        1 cleanResidualTempTask = new /* Unavailable Anonymous Inner Class!! */;
        ThreadPoolManage.schedule((Runnable)cleanResidualTempTask, (long)0L, (TimeUnit)TimeUnit.MILLISECONDS);
        2 cleanupTask = new /* Unavailable Anonymous Inner Class!! */;
        ThreadPoolManage.scheduleAtFixRate((Runnable)cleanupTask, (long)ttlIntervalMillis, (long)ttlIntervalMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

