/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.resource;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.FileTypeUtil;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.ResourceManagerFactory;
import com.kingdee.bos.qing.resource.domain.ResourceInfoDomain;
import com.kingdee.bos.qing.resource.exception.DownloadFileException;
import com.kingdee.bos.qing.resource.exception.UploadFileException;
import com.kingdee.bos.qing.resource.model.QueryResourceVo;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResourceService
implements IQingContextable,
IDBAccessable {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private ResourceInfoDomain resourceInfoDomain;
    private ExceptionLogDomain exceptionLogDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private ResourceInfoDomain getResourceInfoDomain() {
        if (this.resourceInfoDomain == null) {
            AbstractResourceManager resourceManager = ResourceManagerFactory.createResourceManager((QingContext)this.qingContext);
            this.resourceInfoDomain = new ResourceInfoDomain(resourceManager, this.qingContext, this.dbExcuter);
        }
        return this.resourceInfoDomain;
    }

    private ExceptionLogDomain getExceptionLogDomain() {
        if (this.exceptionLogDomain == null) {
            this.exceptionLogDomain = new ExceptionLogDomain(this.tx, this.dbExcuter);
        }
        return this.exceptionLogDomain;
    }

    public byte[] hasResourceManager(Map<String, String> params) {
        ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getResourceInfoDomain().hasResourceManager());
        return ResponseUtil.output((IResponseWrap)wrap);
    }

    public byte[] resourceInfoStatistics(Map<String, String> params) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getResourceInfoDomain().resourceInfoStatistics());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Throwable)e);
        }
    }

    public byte[] getFileUsageInfoByPaging(Map<String, String> params) {
        String resourceType = params.get("resourceType");
        Integer pageSize = Integer.parseInt(params.get("pageSize"));
        Integer targetPage = Integer.parseInt(params.get("targetPage"));
        String sortField = params.get("sortField");
        String sortOrder = params.get("sortOrder");
        String searchText = params.get("searchText");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getResourceInfoDomain().getFileUsageInfoByPaging(resourceType, targetPage, pageSize, sortField, sortOrder, searchText));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Throwable)e);
        }
    }

    public byte[] getTodayScheduleInfoByPaging(Map<String, String> params) {
        String resourceType = params.get("resourceType");
        Integer pageSize = Integer.parseInt(params.get("pageSize"));
        Integer targetPage = Integer.parseInt(params.get("targetPage"));
        String sortField = params.get("sortField");
        String sortOrder = params.get("sortOrder");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getResourceInfoDomain().getTodayScheduleInfoByPaging(resourceType, targetPage, pageSize, sortField, sortOrder));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Throwable)e);
        }
    }

    public byte[] getAllResourceInfoDetailListByPagination(Map<String, String> params) {
        Integer pageSize = Integer.parseInt(params.get("pageSize"));
        Integer targetPage = Integer.parseInt(params.get("targetPage"));
        String sortField = params.get("sortField");
        String sortOrder = params.get("sortOrder");
        QueryResourceVo queryResourceVo = (QueryResourceVo)JsonUtil.decodeFromString((String)params.get("queryParams"), QueryResourceVo.class);
        IIntegratedHelperStrategy integratedHelper = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
        Date startDate = integratedHelper.convertToTimeZoneDate(params.get("timeZone"), new Date(queryResourceVo.getStartDateTimeStamp()));
        Date endDate = integratedHelper.convertToTimeZoneDate(params.get("timeZone"), new Date(queryResourceVo.getEndDateTimeStamp()));
        queryResourceVo.setStartDateTimeStamp(Long.valueOf(startDate.getTime()));
        queryResourceVo.setEndDateTimeStamp(Long.valueOf(endDate.getTime()));
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getResourceInfoDomain().getAllScheduleTypeResourceInfoList(targetPage, pageSize, sortField, sortOrder, queryResourceVo));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Throwable)e);
        }
    }

    public byte[] loadExceptionLog(Map<String, String> params) {
        String id = params.get("id");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getExceptionLogDomain().selectByBizIdAndBizType(id, ExceptionLogBizTypeEnum.SCHEDULE_EXECUTE));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileData(Map<String, String> params) {
        int len;
        byte[] result;
        QingInputStream inputStream;
        block7: {
            String fileName = params.get("fileName");
            String typeIndexString = params.get("typeIndex");
            Integer typeIndex = Integer.valueOf(typeIndexString);
            AbstractQingFileType fileType = FileTypeUtil.getInstanceByTypeIndex((int)typeIndex);
            long offset = Long.parseLong(params.get("offset"));
            inputStream = null;
            result = new byte[65536];
            len = -1;
            IQingFileVisitor exportFile = FileFactory.newFileVisitor((AbstractQingFileType)fileType, (String)fileName);
            inputStream = exportFile.getInputStream();
            inputStream.seek(offset);
            len = inputStream.read(result);
            if (len != -1) break block7;
            byte[] byArray = null;
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            return byArray;
        }
        try {
            result = Arrays.copyOf(result, len);
        }
        catch (IOException e) {
            try {
                DownloadFileException downloadFileException = new DownloadFileException((Throwable)e);
                result = ResponseUtil.output((Throwable)downloadFileException);
                len = -1;
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(len > 0 ? 0 : 1);
        try {
            outputStream.write(result);
        }
        catch (IOException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    public byte[] uploadPiece(String fileNameKey, byte[] bytes, int index) {
        String name = fileNameKey + "." + index;
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
        QingSessionUtil.set((String)name, (String)qingFile.getName());
        try {
            qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new BufferedInputStream(new ByteArrayInputStream(bytes)), false), true);
        }
        catch (IOException e) {
            UploadFileException uploadFileException = new UploadFileException((Throwable)e);
            return ResponseUtil.output((Throwable)uploadFileException);
        }
        return null;
    }

    public byte[] combineUpload(String fileNameKey, int fileCount) {
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.UPLOAD);
        try {
            qingFile.write((IWriteCall)new /* Unavailable Anonymous Inner Class!! */, true);
            String fileName = qingFile.getName();
            String userId = this.qingContext.getUserId();
            String cacheKey = "upload-" + userId + "-" + fileName;
            QingSessionUtil.set((String)cacheKey, (String)fileName);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)fileName));
        }
        catch (IOException e) {
            UploadFileException uploadFileException = new UploadFileException((Throwable)e);
            return ResponseUtil.output((Throwable)uploadFileException);
        }
    }

    public void deleteFile(String fileNameKey, int typeIndex) {
        AbstractQingFileType fileType = FileTypeUtil.getInstanceByTypeIndex((int)typeIndex);
        IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)fileType, (String)fileNameKey);
        fileUpdater.delete();
    }

    public void delayedDeleteFile(final String fileNameKey, final int typeIndex, long delayMillis) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ResourceService.this.deleteFile(fileNameKey, typeIndex);
            }
        };
        ThreadPoolManage.schedule((Runnable)runnable, (long)delayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

