/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.Properties;
import java.util.Set;

public class SystemPropertyUtil {
    public static void setProperty(Properties properties) {
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            if (!(key instanceof String)) continue;
            String keyString = (String)key;
            SystemPropertyUtil.setPropertyIfNotExist(keyString, properties.getProperty(keyString));
        }
    }

    public static void setPropertyIfNotExist(String key, String newValue) {
        String oldValue = SystemPropertyUtil.getString(key);
        if (oldValue == null || "".equals(oldValue.trim())) {
            SystemPropertyUtil.setString(key, newValue);
        }
    }

    public static String getString(String key) {
        return System.getProperty(key);
    }

    public static void setString(String key, String value) {
        System.setProperty(key, value);
    }

    public static String getString(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    public static int getInt(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static long getLong(String key, long defaultValue) {
        String value = System.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static String getTenantId() {
        IIntegratedHelperStrategy integratedHelperStrategy = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
        if (integratedHelperStrategy != null) {
            return integratedHelperStrategy.getTenantId();
        }
        return null;
    }

    public static int getTenantInt(String key, int defaultValue) {
        String tenantValue = SystemPropertyUtil.getTenantProperty(key, String.valueOf(defaultValue));
        try {
            return Integer.parseInt(tenantValue);
        }
        catch (Exception e) {
            LogUtil.warn((String)("\u73af\u5883\u53d8\u91cf\u503c\u8f6c\u6362\u4e3aint\u5931\u8d25: " + tenantValue));
            return defaultValue;
        }
    }

    public static String getTenantProperty(String key) {
        return SystemPropertyUtil.getTenantProperty(key, null, true);
    }

    public static String getTenantProperty(String key, String defaultValue) {
        return SystemPropertyUtil.getTenantProperty(key, defaultValue, true);
    }

    public static String getTenantProperty(String key, String defaultValue, boolean includeCluster) {
        String value = System.getProperty(SystemPropertyUtil.getTenantId() + "_" + key);
        if (value == null && includeCluster) {
            value = System.getProperty(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getTenantBoolean(String key, boolean defaultValue) {
        String tenantValue = SystemPropertyUtil.getTenantProperty(key, String.valueOf(defaultValue));
        try {
            return Boolean.parseBoolean(tenantValue);
        }
        catch (Exception e) {
            LogUtil.warn((String)("\u73af\u5883\u53d8\u91cf\u503c\u8f6c\u6362\u4e3aboolean\u5931\u8d25: " + tenantValue));
            return defaultValue;
        }
    }
}

