/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.ChartType;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.AnalyticalPreferences;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.RollFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.SquareChartType;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Area;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Line;
import com.kingdee.bos.qing.core.model.analysis.square.chart.PercentArea;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.DialChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.preferences.SquarePreperences;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelBook {
    private static final String VERSION = "20241119";
    private Meta meta;
    private List<ModelPage> pages;
    private Boolean isTooModern;

    public void fixReferences(List<OutsideReference> refItems) {
        for (ModelPage page : this.pages) {
            page.getModel().fixReferences(refItems);
        }
    }

    public List<OutsideReference> pickReferences() {
        ArrayList<OutsideReference> allRefItems = new ArrayList<OutsideReference>();
        for (ModelPage page : this.pages) {
            List refItems = page.getModel().pickReferences();
            if (refItems == null) continue;
            allRefItems.addAll(refItems);
        }
        return allRefItems;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public List<ModelPage> getPages() {
        return this.pages;
    }

    public void setPages(List<ModelPage> pages) {
        this.pages = pages;
    }

    public ModelPage getSingleModelPage() {
        if (this.pages != null && this.pages.size() == 1) {
            return this.pages.get(0);
        }
        throw new RuntimeException("ModelPage is not single.");
    }

    public Set<String> lookupUsedMetaFields() {
        this.meta.fixMetaFieldOwner();
        this.meta.fixExprAndDependents();
        HashSet<String> all = new HashSet<String>();
        for (ModelPage page : this.pages) {
            IQingModel model = page.getModel();
            model.bindMeta(this.meta);
            all.addAll(model.lookupUsedMetaFields());
        }
        return all;
    }

    public IXmlElement toXml() {
        IXmlElement root = XmlUtil.createNode((String)"Qing");
        root.setAttribute("version", VERSION);
        this.meta.writeXmlToParent(root);
        for (ModelPage page : this.pages) {
            IXmlElement nodePage = XmlUtil.createNode((String)"Page");
            page.toXml(nodePage);
            root.addChild(nodePage);
        }
        return root;
    }

    public void fromXml(IXmlElement root) throws PersistentModelParseException, PersistentModelTooModernException {
        int modelVersion = this.checkVersion(root);
        try {
            this.meta = new Meta();
            this.meta.readXmlFromParent(root);
            List pageNodes = XmlUtil.getChildren((IXmlElement)root, (String)"Page");
            this.pages = new ArrayList<ModelPage>(pageNodes.size());
            for (IXmlElement nodePage : pageNodes) {
                ModelPage page = new ModelPage();
                page.fromXml(nodePage);
                this.pages.add(page);
            }
        }
        catch (PersistentModelParseException ex) {
            if (this.isTooModern == Boolean.TRUE) {
                throw new PersistentModelTooModernException(VERSION, Integer.toString(modelVersion));
            }
            throw ex;
        }
        this.upgradeModel(modelVersion);
    }

    private int checkVersion(IXmlElement root) throws PersistentModelParseException {
        int modelVersion;
        String version;
        try {
            version = XmlUtil.readAttrNotNull((IXmlElement)root, (String)"version");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException("The attribute 'version' is missing.");
        }
        int runtimeVersion = Integer.parseInt(VERSION);
        try {
            modelVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException ex) {
            throw new PersistentModelParseException("Invalid version: " + version);
        }
        if (modelVersion > runtimeVersion) {
            this.isTooModern = Boolean.TRUE;
        } else {
            if (modelVersion <= 20170228) {
                this.upgradeXml20170228(root);
            }
            if (modelVersion <= 20220401) {
                this.upgradeXml20220401(root);
            }
        }
        return modelVersion;
    }

    private void upgradeXml20170228(IXmlElement root) {
        IXmlElement nodeAnalyticalModel = root.getChild("AnalyticalModel");
        IXmlElement nodePreferences = root.getChild("Preferences");
        IXmlElement nodePage = XmlUtil.createNode((String)"Page");
        root.removeChild(nodeAnalyticalModel);
        nodePage.addChild(nodeAnalyticalModel);
        if (nodePreferences != null) {
            root.removeChild(nodePreferences);
            nodePage.addChild(nodePreferences);
        }
        root.addChild(nodePage);
    }

    private void upgradeXml20220401(IXmlElement root) {
        IXmlElement nodeChart;
        IXmlElement nodePage = root.getChild("Page");
        IXmlElement nodeSquare = nodePage.getChild("SquareModel");
        if (nodeSquare != null && "Gauge".equals((nodeChart = nodeSquare.getChild("Chart")).getAttribute("type"))) {
            nodeChart.setAttribute("type", "Dial");
            IXmlElement nodeProperty = nodeChart.getChild("Property");
            nodeChart.removeChild(nodeProperty);
            nodeProperty = DialChartProperty.upgradeGauge((IXmlElement)nodeProperty);
            nodeChart.addChild(nodeProperty);
        }
    }

    private void upgradeModel(int modelVersion) {
        if (modelVersion <= 20170520) {
            this.upgradeModel20170520();
        }
        if (modelVersion < 20180323) {
            this.upgradeModelTo20180323();
        }
        if (modelVersion <= 20221215) {
            this.upgradeModel20221215();
        }
        if (modelVersion < 20230808) {
            this.upgradeModelTo20230808();
        }
        if (modelVersion < 20241119) {
            this.upgradeModelTo20241119();
        }
    }

    private void upgradeModel20170520() {
        Map metaFields = this.meta.createSearchingMap();
        AnalyticalModel model = (AnalyticalModel)this.getPages().get(0).getModel();
        FilterFieldSet filterFieldSet = model.getFilterFieldSet();
        int c = filterFieldSet.getFieldCount();
        for (int i = 0; i < c; ++i) {
            AnalyticalField field = filterFieldSet.getField(i);
            String fieldName = field.getName();
            MetaField mf = (MetaField)metaFields.get(fieldName);
            if (mf == null || DataType.DATE != mf.getDataType() || PartValue.DATE_YEAR == field.getPartValue() || PartValue.DATE_DAY == field.getPartValue()) continue;
            DiscreteFilter filter = (DiscreteFilter)filterFieldSet.getFilters().get(i);
            filter.setSelecteds(new ArrayList());
            filter.setFullValue(true);
        }
    }

    private void upgradeModelTo20180323() {
        AnalyticalModel model = (AnalyticalModel)this.getPages().get(0).getModel();
        this.upgragePartValueRelativeFormatString((AbstractFieldSet)model.getRow());
        this.upgragePartValueRelativeFormatString((AbstractFieldSet)model.getColumn());
        this.upgragePartValueRelativeFormatString((AbstractFieldSet)model.getMarkFieldSet());
        this.upgragePartValueRelativeFormatString((AbstractFieldSet)model.getFilterFieldSet());
    }

    private void upgragePartValueRelativeFormatString(AbstractFieldSet fieldSet) {
        int c = fieldSet.getFieldCount();
        block5: for (int i = 0; i < c; ++i) {
            AnalyticalField field = fieldSet.getField(i);
            PartValue partValue = field.getPartValue();
            if (partValue == null) continue;
            switch (partValue) {
                case DATE_YEAR: {
                    field.setDateFormat("yyyy");
                    continue block5;
                }
                case DATE_QUARTER: {
                    field.setDateFormat("\u7b2cq\u5b63\u5ea6");
                    continue block5;
                }
                case DATE_DAY: {
                    field.setDateFormat("d");
                    continue block5;
                }
            }
        }
    }

    private void upgradeModel20221215() {
        SquareModel squareModel;
        SquareChartType chartType;
        IQingModel model = this.getPages().get(0).getModel();
        if (model instanceof SquareModel && ((chartType = (squareModel = (SquareModel)model).getChartModel().getChartType()) == SquareChartType.Dial || chartType == SquareChartType.ProgressCircle)) {
            squareModel.getChartModel().getChartProperty().setAnimation(true);
        }
    }

    private void upgradeModelTo20230808() {
        block11: {
            IQingModel model;
            block10: {
                AnalyticalField field;
                model = this.getPages().get(0).getModel();
                if (!(model instanceof AnalyticalModel)) break block10;
                AnalyticalModel analyticalModel = (AnalyticalModel)model;
                ChartType chartType = analyticalModel.getChartType();
                if (chartType != ChartType.Line && chartType != ChartType.MultiLine && chartType != ChartType.Area) break block11;
                int count = analyticalModel.getColumn().getFieldCount();
                AnalyticalField analyticalField = field = count > 0 ? analyticalModel.getColumn().getField(count - 1) : null;
                if (field == null) break block11;
                this.upgradeModelTo20230808(field);
                break block11;
            }
            if (model instanceof SquareModel) {
                RollFieldSet rollFieldSet;
                FieldSet fieldSet;
                AbstractChart chart = ((SquareModel)model).getChartModel();
                if (chart instanceof Line) {
                    fieldSet = ((Line)chart).getXAxis();
                } else if (chart instanceof Area) {
                    fieldSet = ((Area)chart).getXAxis();
                } else if (chart instanceof PercentArea) {
                    fieldSet = ((PercentArea)chart).getXAxis();
                } else {
                    return;
                }
                if (fieldSet.getFieldCount() > 0) {
                    this.upgradeModelTo20230808(fieldSet.getField(0));
                }
                if ((rollFieldSet = chart.getRoll()) != null) {
                    for (int i = 0; i < rollFieldSet.getFieldCount(); ++i) {
                        this.upgradeModelTo20230808(rollFieldSet.getField(i));
                    }
                }
            }
        }
    }

    private void upgradeModelTo20230808(AnalyticalField field) {
        if (field.isDimension() && field.getPartValue() != null) {
            switch (field.getPartValue()) {
                case DATE_QUARTER: {
                    field.setPartValue(PartValue.DATE_YQ);
                    break;
                }
                case DATE_MONTH: {
                    field.setPartValue(PartValue.DATE_YM);
                    break;
                }
                case DATE_DAY: {
                    field.setPartValue(PartValue.DATE_YMD);
                    break;
                }
            }
        }
    }

    private void upgradeModelTo20241119() {
        IQingModel model = this.getPages().get(0).getModel();
        if (model instanceof AnalyticalModel) {
            AnalyticalModel analyticalModel = (AnalyticalModel)model;
            FilterFieldSet filterFieldSet = analyticalModel.getFilterFieldSet();
            for (int i = filterFieldSet.getFieldCount() - 1; i >= 0; --i) {
                AbstractAnalyticalFilter filter = filterFieldSet.getFilter(i);
                if (!(filter instanceof ContinuousFilter)) continue;
                AnalyticalField field = filterFieldSet.getField(i);
                field.setContinuous(true);
            }
        }
    }

    public static ModelBook createFromOneModel(Meta meta, IQingModel model) {
        ModelPage modelPage = new ModelPage();
        modelPage.setModel(model);
        ArrayList<ModelPage> pages = new ArrayList<ModelPage>(1);
        pages.add(modelPage);
        ModelBook modelBook = new ModelBook();
        modelBook.setMeta(meta);
        modelBook.setPages(pages);
        return modelBook;
    }

    public static class ModelPage {
        private String type;
        private IQingModel model;
        private IPreferences preferences;
        private String name;
        private Boolean current;

        public IQingModel getModel() {
            return this.model;
        }

        public void setModel(IQingModel model) {
            this.model = model;
            if (this.model instanceof AnalyticalModel) {
                this.type = "L";
            } else if (this.model instanceof SquareModel) {
                this.type = "S";
            } else {
                throw new RuntimeException("Unknow model type.");
            }
        }

        public IPreferences getPreferences() {
            return this.preferences;
        }

        public void toXml(IXmlElement node) {
            IXmlElement nodeModel;
            XmlUtil.writeAttrWhenExist((IXmlElement)node, (String)"name", (String)this.name);
            XmlUtil.writeAttrDefaultFalse((IXmlElement)node, (String)"current", (boolean)(this.current == null ? false : this.current));
            if (this.model instanceof AnalyticalModel) {
                nodeModel = XmlUtil.createNode((String)"AnalyticalModel");
            } else if (this.model instanceof SquareModel) {
                nodeModel = XmlUtil.createNode((String)"SquareModel");
            } else {
                throw new RuntimeException("Modify here.");
            }
            this.model.toXml(nodeModel);
            node.addChild(nodeModel);
            if (this.preferences != null) {
                IXmlElement nodePreferences = XmlUtil.createNode((String)"Preferences");
                this.preferences.toXml(nodePreferences);
                node.addChild(nodePreferences);
            }
        }

        public void fromXml(IXmlElement node) throws PersistentModelParseException {
            AnalyticalModel qingModel;
            this.name = XmlUtil.readAttrWhenExist((IXmlElement)node, (String)"name");
            this.current = XmlUtil.readAttrDefaultFalse((IXmlElement)node, (String)"current") ? Boolean.TRUE : null;
            IXmlElement nodeModel = XmlUtil.getChild((IXmlElement)node, (String)"AnalyticalModel");
            if (nodeModel == null) {
                nodeModel = XmlUtil.getChild((IXmlElement)node, (String)"SquareModel");
                if (nodeModel == null) {
                    throw new PersistentModelParseException("Model node not found in page.");
                }
                qingModel = new SquareModel();
                this.preferences = new SquarePreperences();
            } else {
                qingModel = new AnalyticalModel();
                this.preferences = new AnalyticalPreferences();
            }
            qingModel.fromXml(nodeModel);
            this.setModel((IQingModel)qingModel);
            IXmlElement nodePreferences = XmlUtil.getChild((IXmlElement)node, (String)"Preferences");
            if (nodePreferences != null) {
                this.preferences.fromXml(nodePreferences);
            }
        }

        public static void prepareForExecuting(Meta meta, IQingModel model, IPreferences preferences) {
            meta.fixMetaFieldOwner();
            meta.fixExprAndDependents();
            model.bindMeta(meta);
            model.bindPreferences(preferences);
        }
    }
}

