/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.accessanalysis.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.InSqlConditionBuilder;
import com.kingdee.bos.qing.manage.accessanalysis.model.DataAccessModel;
import com.kingdee.bos.qing.manage.accessanalysis.model.OperationRecordVo;
import com.kingdee.bos.qing.manage.accessanalysis.model.UserAccessModel;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import com.kingdee.bos.qing.publish.target.email.model.EmailNameRule;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccessAnalysisDao {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private Map<Integer, AbstractPublishTargetDomain> publishTargetDomainMap;
    private Set<String> sortField = new HashSet<String>(18);

    public AccessAnalysisDao(IDBExcuter dbExcuter, QingContext qingContext) {
        this.sortField.addAll(Arrays.asList("qing_visit", "qing_export", "qing_print", "qing_publish", "qing_push", "qing_total", "operationTime", "operationType", "createTime"));
        this.dbExcuter = dbExcuter;
        this.qingContext = qingContext;
    }

    private String getSortField(String field, String defaultField) {
        if (this.sortField.contains(field)) {
            return field;
        }
        return defaultField;
    }

    private String getSortDirection(String direction) {
        String defaultSortDirection = "DESC";
        if (StringUtils.isNotEmpty((CharSequence)direction) && !defaultSortDirection.equals(direction.toUpperCase())) {
            return "ASC";
        }
        return defaultSortDirection;
    }

    public Integer getNumberOfOperationsCountByAggUser(List<String> userIds, Date startTime, Date endTime) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS ACCESS_COUNT  FROM  ( SELECT R.FUSERID   FROM  ( SELECT FSOURCEID, FUSERID     FROM T_QING_OPERATION_RECORD     WHERE #1 (FOPERATIONTIME BETWEEN ? AND ?) AND FOPERATIONTYPE != '1'     AND FAPPTYPE = '0' AND FSOURCETYPE = '0'   ) R INNER JOIN   ( SELECT FID     FROM T_QING_PUBLISH      #2   ) P ON R.FSOURCEID = P.FID   GROUP BY R.FUSERID  ) R";
        if (userIds.size() <= 0) {
            sql = sql.replace("#1", "");
        } else {
            InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(userIds.size());
            sql = sql.replace("#1", inSqlConditionBuilder.build("FUSERID") + "AND");
        }
        sql = sql.replace("#2", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(userIds.size() + 2);
        params.addAll(userIds);
        params.add(startTime);
        params.add(endTime);
        return (Integer)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("ACCESS_COUNT");
                }
                return 0;
            }
        });
    }

    public List<UserAccessModel> getNumberOfOperationsByAggUser(List<String> userIds, Date startTime, Date endTime, String field, String order, Integer offset, final Integer pageSize) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT TOP %s,%s R.FUSERID, COUNT(CASE WHEN FOPERATIONTYPE = '0' THEN 1 ELSE NULL END) AS QING_VISIT, COUNT(CASE WHEN FOPERATIONTYPE = '2' THEN 1 ELSE NULL END) AS QING_EXPORT, COUNT(CASE WHEN FOPERATIONTYPE = '3' THEN 1 ELSE NULL END) AS QING_PRINT, COUNT(CASE WHEN FOPERATIONTYPE = '4' THEN 1 ELSE NULL END) AS QING_PUBLISH, COUNT(CASE WHEN FOPERATIONTYPE = '5' THEN 1 ELSE NULL END) AS QING_PUSH, COUNT(CASE WHEN FOPERATIONTYPE != '1' THEN 1 ELSE NULL END) AS QING_TOTAL FROM   ( SELECT FSOURCEID, FUSERID, FOPERATIONTYPE    FROM T_QING_OPERATION_RECORD    WHERE #1 (FOPERATIONTIME BETWEEN ? AND ?) AND FOPERATIONTYPE != '1'    AND FAPPTYPE = '0' AND FSOURCETYPE = '0'  ) R INNER JOIN  ( SELECT FID    FROM T_QING_PUBLISH    #2  ) P ON R.FSOURCEID = P.FID  GROUP BY R.FUSERID ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "qing_visit"), this.getSortDirection(order));
        if (userIds.size() <= 0) {
            sql = sql.replace("#1", "");
        } else {
            InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(userIds.size());
            sql = sql.replace("#1", inSqlConditionBuilder.build("FUSERID") + "AND");
        }
        sql = sql.replace("#2", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(userIds.size() + 2);
        params.addAll(userIds);
        params.add(startTime);
        params.add(endTime);
        List userAccessModels = (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<UserAccessModel>>(){

            public List<UserAccessModel> handle(ResultSet rs) throws SQLException {
                ArrayList<UserAccessModel> userAccessModels = new ArrayList<UserAccessModel>(pageSize);
                while (rs.next()) {
                    UserAccessModel userAccessModel = new UserAccessModel();
                    userAccessModel.setUserId(rs.getString("FUSERID"));
                    userAccessModel.setVisit(rs.getInt("QING_VISIT"));
                    userAccessModel.setExport(rs.getInt("QING_EXPORT"));
                    userAccessModel.setPrint(rs.getInt("QING_PRINT"));
                    userAccessModel.setPublish(rs.getInt("QING_PUBLISH"));
                    userAccessModel.setPush(rs.getInt("QING_PUSH"));
                    userAccessModel.setTotal(rs.getInt("QING_TOTAL"));
                    userAccessModels.add(userAccessModel);
                }
                return userAccessModels;
            }
        });
        HashSet<Long> fixUserIds = new HashSet<Long>(userAccessModels.size());
        for (UserAccessModel userAccessModel : userAccessModels) {
            fixUserIds.add(Long.parseLong(userAccessModel.getUserId()));
        }
        Map nameAndUserName = IntegratedHelper.getUserAndName(new ArrayList(fixUserIds));
        for (UserAccessModel userAccessModel : userAccessModels) {
            Map nameAndUserNameMap = (Map)nameAndUserName.get(userAccessModel.getUserId());
            userAccessModel.setUserName(nameAndUserNameMap.get("name") + "(" + nameAndUserNameMap.get("username") + ")");
        }
        return userAccessModels;
    }

    public Integer getNumberOfOperationsCountBySingleUserAggPublish(String userId, Date startTime, Date endTime) throws AbstractQingIntegratedException, SQLException {
        String sql = this.getAccessAnalysisAggPublishCountSql();
        ArrayList<Object> params = new ArrayList<Object>(9);
        sql = sql.replace("#P", "FUSERID = ? AND ");
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        sql = sql.replace("#E", "FUSERID = ? AND ");
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        sql = sql.replace("#L", "FUSERID = ? AND ");
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        String presetAuthFilter = this.addPresetAuthFilter("FCREATORID");
        sql = StringUtils.isNotEmpty((CharSequence)presetAuthFilter) ? sql.replace("#2", presetAuthFilter + "AND") : sql.replace("#2", "");
        return (Integer)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("ACCESS_COUNT");
                }
                return 0;
            }
        });
    }

    public List<DataAccessModel> getNumberOfOperationsBySingleUserAggPublish(String userId, Date startTime, Date endTime, String field, String order, Integer offset, final Integer pageSize) throws AbstractQingIntegratedException, SQLException {
        String sql = this.getAccessAnalysisAggPublishSql();
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "qing_visit"), this.getSortDirection(order));
        ArrayList<Object> params = new ArrayList<Object>(9);
        sql = sql.replace("#P", "FUSERID = ? AND ");
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        sql = sql.replace("#E", "FUSERID = ? AND ");
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        sql = sql.replace("#L", "FUSERID = ? AND ");
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        String presetAuthFilter = this.addPresetAuthFilter("FCREATORID");
        sql = StringUtils.isNotEmpty((CharSequence)presetAuthFilter) ? sql.replace("#2", presetAuthFilter + "AND") : sql.replace("#2", "");
        return (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<DataAccessModel>>(){

            public List<DataAccessModel> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<DataAccessModel> dataAccessModels = new ArrayList<DataAccessModel>(pageSize);
                while (rs.next()) {
                    DataAccessModel dataAccessModel = new DataAccessModel();
                    dataAccessModel.setId(rs.getString("FID"));
                    dataAccessModel.setPubName(rs.getString("FNAME"));
                    dataAccessModel.setPubPath(rs.getString("FPATH"));
                    if ("emailTimedPush".equals(dataAccessModel.getPubPath())) {
                        byte[] emailNameRuleBytes = rs.getBytes("FEMAILNAMERULE");
                        if (null != emailNameRuleBytes) {
                            dataAccessModel.setPubName(AccessAnalysisDao.this.bytes2EmailNameRule(emailNameRuleBytes));
                        }
                    } else if ("lappTimedPush".equals(dataAccessModel.getPubPath()) && StringUtils.isNotEmpty((CharSequence)rs.getString("flappnamerule"))) {
                        dataAccessModel.setPubName(rs.getString("FNAME") + "-" + Messages.getMLS((String)"systemDate", (String)"\u7cfb\u7edf\u65e5\u671f", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                    }
                    dataAccessModel.setPubType(rs.getString("FTYPE"));
                    dataAccessModel.setCreatorId(rs.getString("FCREATORID"));
                    long createtime = rs.getTimestamp("CREATETIME").getTime();
                    dataAccessModel.setCreateTime(createtime);
                    String createTimeFormat = IntegratedHelper.formatDateTime(new Date(createtime));
                    dataAccessModel.setCreateTimeFormat(createTimeFormat);
                    dataAccessModel.setSourceType(rs.getString("SOURCETYPE"));
                    dataAccessModel.setVisit(rs.getInt("QING_VISIT"));
                    dataAccessModel.setExport(rs.getInt("QING_EXPORT"));
                    dataAccessModel.setPrint(rs.getInt("QING_PRINT"));
                    dataAccessModel.setPublish(rs.getInt("QING_PUBLISH"));
                    dataAccessModel.setPush(rs.getInt("QING_PUSH"));
                    dataAccessModel.setTotal(rs.getInt("QING_TOTAL"));
                    String pubPathName = AccessAnalysisDao.this.fixPublishPathNames(dataAccessModel.getId(), dataAccessModel.getPubType(), dataAccessModel.getPubPath());
                    dataAccessModel.setPubPathName(pubPathName);
                    dataAccessModels.add(dataAccessModel);
                }
                return dataAccessModels;
            }
        });
    }

    public Integer getOperationRecordCountBySingleUserAndOperationType(String userId, String operationType, Date startTime, Date endTime) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS ACCESS_COUNT FROM  ( SELECT FSOURCEID    FROM T_QING_OPERATION_RECORD    WHERE #1 #2 (FOPERATIONTIME BETWEEN ? AND ?) AND FAPPTYPE = '0'    AND FSOURCETYPE = '0'  ) R INNER JOIN  ( SELECT FID    FROM T_QING_PUBLISH    #3  ) P ON R.FSOURCEID = P.FID ";
        sql = sql.replace("#1", "FUSERID = ? AND ");
        sql = this.addOperationTypeFilter(sql, "#2", operationType);
        sql = sql.replace("#3", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        return (Integer)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("ACCESS_COUNT");
                }
                return 0;
            }
        });
    }

    public List<OperationRecordVo> getOperationRecordBySingleUserAndOperationType(String userId, String operationType, Date startTime, Date endTime, String field, String order, Integer offset, final Integer pageSize) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT QOR.FSOURCEID, QOR.OPERATIONTIME, QOR.FOPERATIONTYPE, QOR.FNAME, QOR.FTYPE, QOR.FPATH, QOR.FCREATORID, QTN.FLAPPNAME, QTN.FLAPPNAMERULE, QTN.FEMAILNAMERULE FROM  ( SELECT TOP %s,%s R.FSOURCEID, R.FOPERATIONTIME AS OPERATIONTIME, R.FOPERATIONTYPE, P.FNAME, P.FTYPE, P.FPATH, P.FCREATORID    FROM    ( SELECT FSOURCEID, FOPERATIONTIME, FOPERATIONTYPE      FROM T_QING_OPERATION_RECORD      WHERE #1 FUSERID = ? AND (FOPERATIONTIME BETWEEN ? AND ?) AND FAPPTYPE = '0'      AND FSOURCETYPE = '0'    ) R INNER JOIN    ( SELECT FID, FNAME, FTYPE, FPATH, FCREATORID      FROM T_QING_PUBLISH      #2    ) P ON R.FSOURCEID = P.FID   ORDER BY %s %s  ) QOR LEFT JOIN  ( SELECT EL.FPUBLISHID, NULL FLAPPNAME, NULL FLAPPNAMERULE, EC.FNAMERULE AS FEMAILNAMERULE    FROM T_QING_PUB_EMAIL_CONF EC LEFT JOIN T_QING_PUB_EMAIL_SEND_LOG EL ON EC.FID = EL.FCONFIGID    WHERE EL.FPUBLISHID IS NOT NULL AND EL.FPUBLISHID != ' '    UNION ALL   SELECT LR.FPUBLISHID, LC.FNAME AS FLAPPNAME, LC.FNAMERULE AS FLAPPNAMERULE, NULL FEMAILNAMERULE    FROM T_QING_PUSH_CONFIG_INFO LC LEFT JOIN T_QING_PUSH_RECORD LR ON LC.FID = LR.FCONFIGID    WHERE LR.FPUBLISHID IS NOT NULL AND LR.FPUBLISHID != ' '  ) QTN ON QOR.FSOURCEID = QTN.FPUBLISHID ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "operationTime"), this.getSortDirection(order), this.getSortField(field, "operationTime"), this.getSortDirection(order));
        sql = this.addOperationTypeFilter(sql, "#1", operationType);
        sql = sql.replace("#2", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        return (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<OperationRecordVo>>(){

            public List<OperationRecordVo> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<OperationRecordVo> operationRecordVos = new ArrayList<OperationRecordVo>(pageSize);
                while (rs.next()) {
                    OperationRecordVo operationRecordVo = new OperationRecordVo();
                    operationRecordVo.setSourceId(rs.getString("FSOURCEID"));
                    long operationtime = rs.getTimestamp("OPERATIONTIME").getTime();
                    operationRecordVo.setOperationTime(operationtime);
                    String operationTimeFormat = IntegratedHelper.formatDateTime(new Date(operationtime));
                    operationRecordVo.setOperationTimeFormat(operationTimeFormat);
                    operationRecordVo.setOperationType(rs.getString("FOPERATIONTYPE"));
                    operationRecordVo.setPubName(rs.getString("FNAME"));
                    operationRecordVo.setPubType(rs.getString("FTYPE"));
                    operationRecordVo.setPubPath(rs.getString("FPATH"));
                    operationRecordVo.setCreatorId(rs.getString("FCREATORID"));
                    if (6 == Integer.parseInt(operationRecordVo.getPubType())) {
                        byte[] emailNameRuleBytes = rs.getBytes("FEMAILNAMERULE");
                        if (null != emailNameRuleBytes) {
                            operationRecordVo.setPubName(AccessAnalysisDao.this.bytes2EmailNameRule(emailNameRuleBytes));
                        }
                    } else if (2 == Integer.parseInt(operationRecordVo.getPubType()) && !"lightapp".equals(operationRecordVo.getPubPath())) {
                        if (StringUtils.isNotEmpty((CharSequence)rs.getString("FLAPPNAMERULE"))) {
                            operationRecordVo.setPubName(rs.getString("FLAPPNAME") + "-" + Messages.getMLS((String)"systemDate", (String)"\u7cfb\u7edf\u65e5\u671f", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                        } else {
                            operationRecordVo.setPubName(rs.getString("FLAPPNAME"));
                        }
                    }
                    String pubPathName = AccessAnalysisDao.this.fixPublishPathNames(operationRecordVo.getSourceId(), operationRecordVo.getPubType(), operationRecordVo.getPubPath());
                    operationRecordVo.setPubPathName(pubPathName);
                    operationRecordVos.add(operationRecordVo);
                }
                return operationRecordVos;
            }
        });
    }

    public Integer getNumberOfOperationsCountByAggPublish(List<String> publishIds, List<String> emailPublishIds, List<String> lappPublishIds, boolean isSelect, Date startTime, Date endTime) throws AbstractQingIntegratedException, SQLException {
        String sql = this.getAccessAnalysisAggPublishCountSql();
        ArrayList<Object> params = new ArrayList<Object>();
        if (!isSelect) {
            sql = sql.replace("#P", "");
            params.add(startTime);
            params.add(endTime);
            sql = sql.replace("#E", "");
            params.add(startTime);
            params.add(endTime);
            sql = sql.replace("#L", "");
            params.add(startTime);
            params.add(endTime);
        } else {
            if (publishIds != null && publishIds.size() > 0) {
                InSqlConditionBuilder publishIdBuilder = new InSqlConditionBuilder(publishIds.size());
                sql = sql.replace("#P", publishIdBuilder.build("R.FSOURCEID") + "AND");
                params.addAll(publishIds);
            } else {
                sql = sql.replace("#P", " R.FSOURCEID IS NULL AND ");
            }
            params.add(startTime);
            params.add(endTime);
            if (emailPublishIds != null && emailPublishIds.size() > 0) {
                InSqlConditionBuilder emailPublishIdBuilder = new InSqlConditionBuilder(emailPublishIds.size());
                sql = sql.replace("#E", emailPublishIdBuilder.build("R.FSOURCEID") + "AND");
                params.addAll(emailPublishIds);
            } else {
                sql = sql.replace("#E", " R.FSOURCEID IS NULL AND ");
            }
            params.add(startTime);
            params.add(endTime);
            if (lappPublishIds != null && lappPublishIds.size() > 0) {
                InSqlConditionBuilder lappPublishIdBuilder = new InSqlConditionBuilder(lappPublishIds.size());
                sql = sql.replace("#L", lappPublishIdBuilder.build("R.FSOURCEID") + "AND");
                params.addAll(lappPublishIds);
            } else {
                sql = sql.replace("#L", " R.FSOURCEID IS NULL AND ");
            }
            params.add(startTime);
            params.add(endTime);
        }
        String presetAuthFilter = this.addPresetAuthFilter("FCREATORID");
        sql = StringUtils.isNotEmpty((CharSequence)presetAuthFilter) ? sql.replace("#2", presetAuthFilter + "AND") : sql.replace("#2", "");
        return (Integer)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("ACCESS_COUNT");
                }
                return 0;
            }
        });
    }

    public List<DataAccessModel> getNumberOfOperationsByAggPublish(List<String> publishIds, List<String> emailPublishIds, List<String> lappPublishIds, boolean isSelect, Date startTime, Date endTime, String field, String order, Integer offset, final Integer pageSize) throws AbstractQingIntegratedException, SQLException {
        String sql = this.getAccessAnalysisAggPublishSql();
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "qing_visit"), this.getSortDirection(order));
        ArrayList<Object> params = new ArrayList<Object>();
        if (!isSelect) {
            sql = sql.replace("#P", "");
            params.add(startTime);
            params.add(endTime);
            sql = sql.replace("#E", "");
            params.add(startTime);
            params.add(endTime);
            sql = sql.replace("#L", "");
            params.add(startTime);
            params.add(endTime);
        } else {
            if (publishIds != null && publishIds.size() > 0) {
                InSqlConditionBuilder publishIdBuilder = new InSqlConditionBuilder(publishIds.size());
                sql = sql.replace("#P", publishIdBuilder.build("R.FSOURCEID") + "AND");
                params.addAll(publishIds);
            } else {
                sql = sql.replace("#P", " R.FSOURCEID IS NULL AND ");
            }
            params.add(startTime);
            params.add(endTime);
            if (emailPublishIds != null && emailPublishIds.size() > 0) {
                InSqlConditionBuilder emailPublishIdBuilder = new InSqlConditionBuilder(emailPublishIds.size());
                sql = sql.replace("#E", emailPublishIdBuilder.build("R.FSOURCEID") + "AND");
                params.addAll(emailPublishIds);
            } else {
                sql = sql.replace("#E", " R.FSOURCEID IS NULL AND ");
            }
            params.add(startTime);
            params.add(endTime);
            if (lappPublishIds != null && lappPublishIds.size() > 0) {
                InSqlConditionBuilder lappPublishIdBuilder = new InSqlConditionBuilder(lappPublishIds.size());
                sql = sql.replace("#L", lappPublishIdBuilder.build("R.FSOURCEID") + "AND");
                params.addAll(lappPublishIds);
            } else {
                sql = sql.replace("#L", " R.FSOURCEID IS NULL AND ");
            }
            params.add(startTime);
            params.add(endTime);
        }
        String presetAuthFilter = this.addPresetAuthFilter("FCREATORID");
        sql = StringUtils.isNotEmpty((CharSequence)presetAuthFilter) ? sql.replace("#2", presetAuthFilter + "AND") : sql.replace("#2", "");
        List dataAccessModels = (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<DataAccessModel>>(){

            public List<DataAccessModel> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<DataAccessModel> dataAccessModels = new ArrayList<DataAccessModel>(pageSize);
                while (rs.next()) {
                    DataAccessModel dataAccessModel = new DataAccessModel();
                    dataAccessModel.setId(rs.getString("FID"));
                    dataAccessModel.setPubName(rs.getString("FNAME"));
                    dataAccessModel.setPubPath(rs.getString("FPATH"));
                    if ("emailTimedPush".equals(dataAccessModel.getPubPath())) {
                        byte[] emailNameRuleBytes = rs.getBytes("FEMAILNAMERULE");
                        if (null != emailNameRuleBytes) {
                            dataAccessModel.setPubName(AccessAnalysisDao.this.bytes2EmailNameRule(emailNameRuleBytes));
                        }
                    } else if ("lappTimedPush".equals(dataAccessModel.getPubPath()) && StringUtils.isNotEmpty((CharSequence)rs.getString("flappnamerule"))) {
                        dataAccessModel.setPubName(rs.getString("FNAME") + "-" + Messages.getMLS((String)"systemDate", (String)"\u7cfb\u7edf\u65e5\u671f", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                    }
                    dataAccessModel.setPubType(rs.getString("FTYPE"));
                    dataAccessModel.setCreatorId(rs.getString("FCREATORID"));
                    long createtime = rs.getTimestamp("CREATETIME").getTime();
                    dataAccessModel.setCreateTime(createtime);
                    String createTimeFormat = IntegratedHelper.formatDateTime(new Date(createtime));
                    dataAccessModel.setCreateTimeFormat(createTimeFormat);
                    dataAccessModel.setSourceType(rs.getString("SOURCETYPE"));
                    dataAccessModel.setVisit(rs.getInt("QING_VISIT"));
                    dataAccessModel.setExport(rs.getInt("QING_EXPORT"));
                    dataAccessModel.setPrint(rs.getInt("QING_PRINT"));
                    dataAccessModel.setPublish(rs.getInt("QING_PUBLISH"));
                    dataAccessModel.setPush(rs.getInt("QING_PUSH"));
                    dataAccessModel.setTotal(rs.getInt("QING_TOTAL"));
                    String pubPathName = AccessAnalysisDao.this.fixPublishPathNames(dataAccessModel.getId(), dataAccessModel.getPubType(), dataAccessModel.getPubPath());
                    dataAccessModel.setPubPathName(pubPathName);
                    dataAccessModels.add(dataAccessModel);
                }
                return dataAccessModels;
            }
        });
        HashSet<Long> userIds = new HashSet<Long>(dataAccessModels.size());
        for (DataAccessModel dataAccessModel : dataAccessModels) {
            userIds.add(Long.valueOf(dataAccessModel.getCreatorId()));
        }
        String presetUserId = IntegratedHelper.getPresetUserId();
        Map nameAndUserName = IntegratedHelper.getUserAndName(new ArrayList(userIds));
        for (DataAccessModel dataAccessModel : dataAccessModels) {
            Map nameAndUserNameMap = (Map)nameAndUserName.get(dataAccessModel.getCreatorId());
            if (presetUserId.equals(dataAccessModel.getCreatorId())) {
                dataAccessModel.setCreatorName((String)nameAndUserNameMap.get("name"));
                continue;
            }
            dataAccessModel.setCreatorName(nameAndUserNameMap.get("name") + "(" + nameAndUserNameMap.get("username") + ")");
        }
        return dataAccessModels;
    }

    public Integer getNumberOfOperationsCountBySinglePublishAggUser(List<String> publishIds, Date startTime, Date endTime) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS ACCESS_COUNT  FROM  ( SELECT R.FUSERID   FROM  ( SELECT FSOURCEID, FUSERID     FROM T_QING_OPERATION_RECORD     WHERE #1 (FOPERATIONTIME BETWEEN ? AND ?) AND FOPERATIONTYPE != '1'     AND FAPPTYPE = '0' AND FSOURCETYPE = '0'   ) R INNER JOIN   ( SELECT FID     FROM T_QING_PUBLISH      #2   ) P ON R.FSOURCEID = P.FID   GROUP BY R.FUSERID  ) R";
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(publishIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("FSOURCEID") + "AND");
        sql = sql.replace("#2", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(publishIds.size() + 2);
        params.addAll(publishIds);
        params.add(startTime);
        params.add(endTime);
        return (Integer)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("ACCESS_COUNT");
                }
                return 0;
            }
        });
    }

    public List<UserAccessModel> getNumberOfOperationsBySinglePublishAggUser(List<String> publishIds, Date startTime, Date endTime, String field, String order, Integer offset, final Integer pageSize) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT TOP %s,%s R.FUSERID, COUNT(CASE WHEN FOPERATIONTYPE = '0' THEN 1 ELSE NULL END) AS QING_VISIT, COUNT(CASE WHEN FOPERATIONTYPE = '2' THEN 1 ELSE NULL END) AS QING_EXPORT, COUNT(CASE WHEN FOPERATIONTYPE = '3' THEN 1 ELSE NULL END) AS QING_PRINT, COUNT(CASE WHEN FOPERATIONTYPE = '4' THEN 1 ELSE NULL END) AS QING_PUBLISH, COUNT(CASE WHEN FOPERATIONTYPE = '5' THEN 1 ELSE NULL END) AS QING_PUSH, COUNT(CASE WHEN FOPERATIONTYPE != '1' THEN 1 ELSE NULL END) AS QING_TOTAL FROM   ( SELECT FSOURCEID, FUSERID, FOPERATIONTYPE    FROM T_QING_OPERATION_RECORD    WHERE #1 (FOPERATIONTIME BETWEEN ? AND ?) AND FOPERATIONTYPE != '1'    AND FAPPTYPE = '0' AND FSOURCETYPE = '0'  ) R INNER JOIN  ( SELECT FID    FROM T_QING_PUBLISH    #2  ) P ON R.FSOURCEID = P.FID  GROUP BY R.FUSERID ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "qing_visit"), this.getSortDirection(order));
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(publishIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("FSOURCEID") + "AND");
        sql = sql.replace("#2", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.addAll(publishIds);
        params.add(startTime);
        params.add(endTime);
        List userAccessModels = (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<UserAccessModel>>(){

            public List<UserAccessModel> handle(ResultSet rs) throws SQLException {
                ArrayList<UserAccessModel> userAccessModels = new ArrayList<UserAccessModel>(pageSize);
                while (rs.next()) {
                    UserAccessModel userAccessModel = new UserAccessModel();
                    userAccessModel.setUserId(rs.getString("FUSERID"));
                    userAccessModel.setVisit(rs.getInt("QING_VISIT"));
                    userAccessModel.setExport(rs.getInt("QING_EXPORT"));
                    userAccessModel.setPrint(rs.getInt("QING_PRINT"));
                    userAccessModel.setPublish(rs.getInt("QING_PUBLISH"));
                    userAccessModel.setPush(rs.getInt("QING_PUSH"));
                    userAccessModel.setTotal(rs.getInt("QING_TOTAL"));
                    userAccessModels.add(userAccessModel);
                }
                return userAccessModels;
            }
        });
        HashSet<Long> fixUserIds = new HashSet<Long>(userAccessModels.size());
        for (UserAccessModel userAccessModel : userAccessModels) {
            fixUserIds.add(Long.parseLong(userAccessModel.getUserId()));
        }
        Map nameAndUserName = IntegratedHelper.getUserAndName(new ArrayList(fixUserIds));
        for (UserAccessModel userAccessModel : userAccessModels) {
            Map nameAndUserNameMap = (Map)nameAndUserName.get(userAccessModel.getUserId());
            userAccessModel.setUserName(nameAndUserNameMap.get("name") + "(" + nameAndUserNameMap.get("username") + ")");
        }
        return userAccessModels;
    }

    public Integer getOperationRecordCountBySinglePublishAndOperationType(List<String> publishIds, String operationType, Date startTime, Date endTime) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS ACCESS_COUNT FROM  ( SELECT FSOURCEID    FROM T_QING_OPERATION_RECORD    WHERE #1 #2 (FOPERATIONTIME BETWEEN ? AND ?) AND FAPPTYPE = '0'    AND FSOURCETYPE = '0'  ) R INNER JOIN  ( SELECT FID    FROM T_QING_PUBLISH    #3  ) P ON R.FSOURCEID = P.FID ";
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(publishIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("FSOURCEID") + "AND");
        sql = this.addOperationTypeFilter(sql, "#2", operationType);
        sql = sql.replace("#3", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.addAll(publishIds);
        params.add(startTime);
        params.add(endTime);
        return (Integer)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("ACCESS_COUNT");
                }
                return 0;
            }
        });
    }

    public List<OperationRecordVo> getOperationRecordBySinglePublishAndOperationType(List<String> publishIds, String operationType, Date startTime, Date endTime, String field, String order, Integer offset, final Integer pageSize) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT TOP %s,%s R.FSOURCEID, R.FOPERATIONTIME AS OPERATIONTIME, R.FOPERATIONTYPE, R.FUSERID FROM  ( SELECT FSOURCEID, FOPERATIONTIME, FOPERATIONTYPE, FUSERID    FROM T_QING_OPERATION_RECORD    WHERE #1 #2 (FOPERATIONTIME BETWEEN ? AND ?) AND FAPPTYPE = '0'    AND FSOURCETYPE = '0'  ) R INNER JOIN  ( SELECT FID    FROM T_QING_PUBLISH    #3  ) P ON R.FSOURCEID = P.FID ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "operationTime"), this.getSortDirection(order));
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(publishIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("FSOURCEID") + "AND");
        sql = this.addOperationTypeFilter(sql, "#2", operationType);
        sql = sql.replace("#3", this.addPresetAuthFilter("WHERE FCREATORID"));
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.addAll(publishIds);
        params.add(startTime);
        params.add(endTime);
        List operationRecordVos = (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<OperationRecordVo>>(){

            public List<OperationRecordVo> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<OperationRecordVo> operationRecordVos = new ArrayList<OperationRecordVo>(pageSize);
                while (rs.next()) {
                    OperationRecordVo operationRecordVo = new OperationRecordVo();
                    operationRecordVo.setSourceId(rs.getString("FSOURCEID"));
                    long operationtime = rs.getTimestamp("OPERATIONTIME").getTime();
                    operationRecordVo.setOperationTime(operationtime);
                    String operationTimeFormat = IntegratedHelper.formatDateTime(new Date(operationtime));
                    operationRecordVo.setOperationTimeFormat(operationTimeFormat);
                    operationRecordVo.setOperationType(rs.getString("FOPERATIONTYPE"));
                    operationRecordVo.setUserId(rs.getString("FUSERID"));
                    operationRecordVos.add(operationRecordVo);
                }
                return operationRecordVos;
            }
        });
        HashSet<Long> fixUserIds = new HashSet<Long>(operationRecordVos.size());
        for (OperationRecordVo operationRecordVo : operationRecordVos) {
            fixUserIds.add(Long.parseLong(operationRecordVo.getUserId()));
        }
        Map nameAndUserName = IntegratedHelper.getUserAndName(new ArrayList(fixUserIds));
        for (OperationRecordVo operationRecordVo : operationRecordVos) {
            Map nameAndUserNameMap = (Map)nameAndUserName.get(operationRecordVo.getUserId());
            operationRecordVo.setUserName(nameAndUserNameMap.get("name") + "(" + nameAndUserNameMap.get("username") + ")");
        }
        return operationRecordVos;
    }

    public Integer getOperationRecordCountByUserAndPublish(List<String> publishIds, String userId, String operationType, Date startTime, Date endTime) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(1) AS ACCESS_COUNT FROM T_QING_OPERATION_RECORD  WHERE #1 #2 FUSERID = ? AND (FOPERATIONTIME BETWEEN ? AND ?) AND FAPPTYPE = '0' AND FSOURCETYPE = '0' ";
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(publishIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("FSOURCEID") + "AND");
        sql = this.addOperationTypeFilter(sql, "#2", operationType);
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.addAll(publishIds);
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        return (Integer)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("ACCESS_COUNT");
                }
                return 0;
            }
        });
    }

    public List<OperationRecordVo> getOperationRecordByUserAndPublish(List<String> publishIds, String userId, String operationType, Date startTime, Date endTime, String field, String order, Integer offset, final Integer pageSize) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT TOP %s,%s R.FOPERATIONTIME AS OPERATIONTIME, R.FOPERATIONTYPE FROM T_QING_OPERATION_RECORD R WHERE #1 #2 R.FUSERID = ? AND (R.FOPERATIONTIME BETWEEN ? AND ?) AND FAPPTYPE = '0' AND FSOURCETYPE = '0' ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "operationTime"), this.getSortDirection(order));
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(publishIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("FSOURCEID") + "AND");
        sql = this.addOperationTypeFilter(sql, "#2", operationType);
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.addAll(publishIds);
        params.add(userId);
        params.add(startTime);
        params.add(endTime);
        return (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<OperationRecordVo>>(){

            public List<OperationRecordVo> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<OperationRecordVo> operationRecordVos = new ArrayList<OperationRecordVo>(pageSize);
                while (rs.next()) {
                    OperationRecordVo operationRecordVo = new OperationRecordVo();
                    long operationtime = rs.getTimestamp("OPERATIONTIME").getTime();
                    operationRecordVo.setOperationTime(operationtime);
                    String operationTimeFormat = IntegratedHelper.formatDateTime(new Date(operationtime));
                    operationRecordVo.setOperationTimeFormat(operationTimeFormat);
                    operationRecordVo.setOperationType(rs.getString("FOPERATIONTYPE"));
                    operationRecordVos.add(operationRecordVo);
                }
                return operationRecordVos;
            }
        });
    }

    private String addOperationTypeFilter(String sql, String replaceChar, String operationType) {
        int operationTypeInt = 1;
        if (StringUtils.isNotEmpty((CharSequence)operationType)) {
            try {
                operationTypeInt = Integer.parseInt(operationType);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((CharSequence)operationType)) {
            return sql.replace(replaceChar, " FOPERATIONTYPE != '" + operationTypeInt + "' AND");
        }
        return sql.replace(replaceChar, " FOPERATIONTYPE = '" + operationTypeInt + "' AND");
    }

    private String addPresetAuthFilter(String insertChar) throws IntegratedRuntimeException {
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole();
        if (isCurrentUserInQingAdminRole) {
            return "";
        }
        String presetUserId = IntegratedHelper.getPresetUserId();
        return insertChar + " != '" + presetUserId + "'";
    }

    private String fixPublishPathNames(String publishId, String pubType, String pubPath) throws SQLException {
        AbstractPublishTargetDomain publishTargetDomain;
        if (6 == Integer.parseInt(pubType)) {
            return Messages.getMLS((String)"emailPushConfiguration", (String)"\u90ae\u4ef6\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        }
        if (2 == Integer.parseInt(pubType) && !pubPath.equals("lightapp")) {
            return Messages.getMLS((String)"lappPushConfiguration", (String)"\u79fb\u52a8\u7aef\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        }
        if (StringUtils.isNotBlank((CharSequence)pubPath) && (publishTargetDomain = this.getPublishTargetDomain(Integer.valueOf(pubType))) != null) {
            try {
                return publishTargetDomain.loadPathNameByPath(pubPath, publishId);
            }
            catch (AbstractQingIntegratedException e) {
                throw new SQLException(e);
            }
        }
        return null;
    }

    public AbstractPublishTargetDomain getPublishTargetDomain(Integer type) {
        AbstractPublishTargetDomain publishTargetDomain;
        if (this.publishTargetDomainMap == null) {
            this.publishTargetDomainMap = new HashMap<Integer, AbstractPublishTargetDomain>(8);
        }
        if ((publishTargetDomain = this.publishTargetDomainMap.get(type)) == null) {
            publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain((QingContext)this.qingContext, null, (IDBExcuter)this.dbExcuter, null, (Integer)type);
            this.publishTargetDomainMap.put(type, publishTargetDomain);
        }
        return publishTargetDomain;
    }

    public List<String> getEmailTimedLogPublishId(List<String> emailConfigIds) throws AbstractQingIntegratedException, SQLException {
        if (emailConfigIds == null || emailConfigIds.size() <= 0) {
            return null;
        }
        String sql = "SELECT EL.FPUBLISHID FROM T_QING_PUB_EMAIL_CONF EC LEFT JOIN T_QING_PUB_EMAIL_SEND_LOG EL ON EL.FCONFIGID = EC.FID WHERE #1 EL.FPUBLISHID IS NOT NULL AND EL.FPUBLISHID != ' '";
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(emailConfigIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("EC.FID") + "AND");
        return (List)this.dbExcuter.query(sql, emailConfigIds.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> publishIds = new ArrayList<String>(10);
                while (rs.next()) {
                    publishIds.add(rs.getString("FPUBLISHID"));
                }
                return publishIds;
            }
        });
    }

    public List<String> getLappTimedLogPublishId(List<String> lappConfigIds) throws AbstractQingIntegratedException, SQLException {
        if (lappConfigIds == null || lappConfigIds.size() <= 0) {
            return null;
        }
        String sql = "SELECT PR.FPUBLISHID FROM T_QING_PUSH_CONFIG_INFO PC LEFT JOIN T_QING_PUSH_RECORD PR ON PC.FID = PR.FCONFIGID WHERE #1 PR.FPUBLISHID IS NOT NULL AND PR.FPUBLISHID != ' '";
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(lappConfigIds.size());
        sql = sql.replace("#1", inSqlConditionBuilder.build("PC.FID") + "AND");
        return (List)this.dbExcuter.query(sql, lappConfigIds.toArray(), (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> publishIds = new ArrayList<String>(10);
                while (rs.next()) {
                    publishIds.add(rs.getString("FPUBLISHID"));
                }
                return publishIds;
            }
        });
    }

    private String bytes2EmailNameRule(byte[] nameRuleBytes) throws SQLException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EmailNameRule nameRule = new EmailNameRule();
        try {
            outputStream.write(nameRuleBytes);
            if (outputStream.size() > 0) {
                IXmlElement NameRuleElement = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                nameRule.fromXml(NameRuleElement);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (XmlParsingException e) {
            throw new SQLException(e);
        }
        if (nameRule.getType() == EmailNameRule.NameRuleType.fixed) {
            return nameRule.getName();
        }
        return nameRule.getName() + "-" + Messages.getMLS((String)"systemDate", (String)"\u7cfb\u7edf\u65e5\u671f", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
    }

    private String getAccessAnalysisAggPublishCountSql() {
        String QUERY_NUMBEROFOPERATIONS_COUNT_BY_AGGPUBLISH = "SELECT COUNT(1) AS ACCESS_COUNT FROM (  SELECT P.FID  FROM   ( SELECT R.FSOURCEID     FROM T_QING_OPERATION_RECORD R     WHERE #P (R.FOPERATIONTIME BETWEEN ? AND ?) AND R.FOPERATIONTYPE != '1'     AND R.FAPPTYPE = '0' AND R.FSOURCETYPE = '0'    ) R INNER JOIN   ( SELECT P.FID     FROM T_QING_PUBLISH P     WHERE #2 P.FTYPE != '6' AND (P.FTYPE != '2'     OR (P.FTYPE = '2' AND P.FPATH = 'lightapp'))    ) P ON P.FID = R.FSOURCEID  GROUP BY P.FID UNION ALL  SELECT EC.FID  FROM   ( SELECT EL.FCONFIGID     FROM      ( SELECT P.FID        FROM         ( SELECT R.FSOURCEID           FROM T_QING_OPERATION_RECORD R           WHERE #E (R.FOPERATIONTIME BETWEEN ? AND ?) AND R.FOPERATIONTYPE != '1'           AND R.FAPPTYPE = '0' AND R.FSOURCETYPE = '0'         ) R INNER JOIN         ( SELECT P.FID           FROM T_QING_PUBLISH P           WHERE #2 P.FTYPE = '6'         ) P ON P.FID = R.FSOURCEID        GROUP BY P.FID      ) ET LEFT JOIN T_QING_PUB_EMAIL_SEND_LOG EL ON ET.FID = EL.FPUBLISHID       GROUP BY EL.FCONFIGID   ) OET LEFT JOIN T_QING_PUB_EMAIL_CONF EC ON OET.FCONFIGID = EC.FID WHERE EC.FID IS NOT NULL UNION ALL  SELECT LC.FID  FROM   ( SELECT LR.FCONFIGID     FROM      ( SELECT P.FID        FROM         ( SELECT R.FSOURCEID           FROM T_QING_OPERATION_RECORD R           WHERE #L (R.FOPERATIONTIME BETWEEN ? AND ?) AND R.FOPERATIONTYPE != '1'           AND R.FAPPTYPE = '0' AND R.FSOURCETYPE = '0'         ) R INNER JOIN         ( SELECT P.FID           FROM T_QING_PUBLISH P           WHERE #2 P.FTYPE = '2' AND P.FPATH != 'lightapp'         ) P ON P.FID = R.FSOURCEID        GROUP BY P.FID      ) LT LEFT JOIN T_QING_PUSH_RECORD LR ON LT.FID = LR.FPUBLISHID     GROUP BY LR.FCONFIGID   ) OLT LEFT JOIN T_QING_PUSH_CONFIG_INFO LC ON OLT.FCONFIGID = LC.FID WHERE LC.FID IS NOT NULL ) QOR ";
        return QUERY_NUMBEROFOPERATIONS_COUNT_BY_AGGPUBLISH;
    }

    private String getAccessAnalysisAggPublishSql() {
        String QUERY_NUMBEROFOPERATIONS_BY_AGGPUBLISH = "SELECT TOP %s,%s FID, FNAME, FLAPPNAMERULE, FEMAILNAMERULE, FPATH, FTYPE, FCREATORID, CREATETIME, SOURCETYPE, QING_VISIT, QING_EXPORT, QING_PRINT, QING_PUBLISH, QING_PUSH, QING_TOTAL FROM (  SELECT P.FID, TO_CHAR(P.FNAME) FNAME, TO_CHAR(NULL) FLAPPNAMERULE, NULL FEMAILNAMERULE, TO_CHAR(P.FPATH) FPATH,  TO_CHAR(P.FTYPE) FTYPE, P.FCREATORID, P.FCREATETIME AS CREATETIME, P.FSOURCE AS SOURCETYPE,  COUNT(CASE WHEN FOPERATIONTYPE = '0' THEN 1 ELSE NULL END) AS QING_VISIT,  COUNT(CASE WHEN FOPERATIONTYPE = '2' THEN 1 ELSE NULL END) AS QING_EXPORT,  COUNT(CASE WHEN FOPERATIONTYPE = '3' THEN 1 ELSE NULL END) AS QING_PRINT,  COUNT(CASE WHEN FOPERATIONTYPE = '4' THEN 1 ELSE NULL END) AS QING_PUBLISH,  COUNT(CASE WHEN FOPERATIONTYPE = '5' THEN 1 ELSE NULL END) AS QING_PUSH,  COUNT(CASE WHEN FOPERATIONTYPE != '1' THEN 1 ELSE NULL END) AS QING_TOTAL  FROM   ( SELECT R.FSOURCEID, R.FOPERATIONTYPE     FROM T_QING_OPERATION_RECORD R     WHERE #P (R.FOPERATIONTIME BETWEEN ? AND ?) AND R.FOPERATIONTYPE != '1'     AND R.FAPPTYPE = '0' AND R.FSOURCETYPE = '0'    ) R INNER JOIN   ( SELECT P.FID, P.FNAME, P.FPATH, P.FTYPE, P.FCREATORID, P.FCREATETIME, P.FSOURCE     FROM T_QING_PUBLISH P     WHERE #2 P.FTYPE != '6' AND (P.FTYPE != '2'     OR (P.FTYPE = '2' AND P.FPATH = 'lightapp'))    ) P ON P.FID = R.FSOURCEID  GROUP BY P.FID, P.FNAME, P.FPATH, P.FTYPE, P.FCREATORID, P.FCREATETIME, P.FSOURCE UNION ALL  SELECT EC.FID, TO_CHAR(NULL) FNAME, TO_CHAR(NULL) FLAPPNAMERULE, EC.FNAMERULE AS FEMAILNAMERULE, 'emailTimedPush' AS FPATH,  '6' AS FTYPE, EC.FUSERID AS FCREATORID, EC.FCREATETIME AS CREATETIME, EC.FPUBLISHSOURCETYPE AS SOURCETYPE,  QING_VISIT, QING_EXPORT, QING_PRINT, QING_PUBLISH, QING_PUSH, QING_TOTAL  FROM   ( SELECT EL.FCONFIGID, SUM(QING_VISIT) AS QING_VISIT, SUM(QING_EXPORT) AS QING_EXPORT, SUM(QING_PRINT) AS QING_PRINT,     SUM(QING_PUBLISH) AS QING_PUBLISH, SUM(QING_PUSH) AS QING_PUSH, SUM(QING_TOTAL) AS QING_TOTAL     FROM      ( SELECT P.FID, COUNT(CASE WHEN FOPERATIONTYPE = '0' THEN 1 ELSE NULL END) AS QING_VISIT,        COUNT(CASE WHEN FOPERATIONTYPE = '2' THEN 1 ELSE NULL END) AS QING_EXPORT,        COUNT(CASE WHEN FOPERATIONTYPE = '3' THEN 1 ELSE NULL END) AS QING_PRINT,        COUNT(CASE WHEN FOPERATIONTYPE = '4' THEN 1 ELSE NULL END) AS QING_PUBLISH,        COUNT(CASE WHEN FOPERATIONTYPE = '5' THEN 1 ELSE NULL END) AS QING_PUSH,        COUNT(CASE WHEN FOPERATIONTYPE != '1' THEN 1 ELSE NULL END) AS QING_TOTAL         FROM         ( SELECT R.FSOURCEID, R.FOPERATIONTYPE           FROM T_QING_OPERATION_RECORD R           WHERE #E (R.FOPERATIONTIME BETWEEN ? AND ?) AND R.FOPERATIONTYPE != '1'           AND R.FAPPTYPE = '0' AND R.FSOURCETYPE = '0'         ) R INNER JOIN         ( SELECT P.FID, P.FNAME, P.FPATH, P.FTYPE, P.FCREATORID, P.FCREATETIME           FROM T_QING_PUBLISH P           WHERE #2 P.FTYPE = '6'         ) P ON P.FID = R.FSOURCEID        GROUP BY P.FID      ) ET LEFT JOIN T_QING_PUB_EMAIL_SEND_LOG EL ON ET.FID = EL.FPUBLISHID       GROUP BY EL.FCONFIGID   ) OET LEFT JOIN T_QING_PUB_EMAIL_CONF EC ON OET.FCONFIGID = EC.FID WHERE EC.FID IS NOT NULL UNION ALL  SELECT LC.FID, TO_CHAR(LC.FNAME) FNAME, TO_CHAR(LC.FNAMERULE) AS FLAPPNAMERULE, NULL FEMAILNAMERULE, 'lappTimedPush' AS FPATH, '2' AS FTYPE,  LC.FUSERID AS FCREATORID, LC.FCREATETIME AS CREATETIME, LC.FSOURCETYPE AS SOURCETYPE,  QING_VISIT, QING_EXPORT, QING_PRINT, QING_PUBLISH, QING_PUSH, QING_TOTAL  FROM   ( SELECT LR.FCONFIGID, SUM(QING_VISIT) AS QING_VISIT, SUM(QING_EXPORT) AS QING_EXPORT, SUM(QING_PRINT) AS QING_PRINT,     SUM(QING_PUBLISH) AS QING_PUBLISH, SUM(QING_PUSH) AS QING_PUSH, SUM(QING_TOTAL) AS QING_TOTAL     FROM      ( SELECT P.FID, COUNT(CASE WHEN FOPERATIONTYPE = '0' THEN 1 ELSE NULL END) AS QING_VISIT,        COUNT(CASE WHEN FOPERATIONTYPE = '2' THEN 1 ELSE NULL END) AS QING_EXPORT,        COUNT(CASE WHEN FOPERATIONTYPE = '3' THEN 1 ELSE NULL END) AS QING_PRINT,        COUNT(CASE WHEN FOPERATIONTYPE = '4' THEN 1 ELSE NULL END) AS QING_PUBLISH,        COUNT(CASE WHEN FOPERATIONTYPE = '5' THEN 1 ELSE NULL END) AS QING_PUSH,        COUNT(CASE WHEN FOPERATIONTYPE != '1' THEN 1 ELSE NULL END) AS QING_TOTAL         FROM         ( SELECT R.FSOURCEID, R.FOPERATIONTYPE           FROM T_QING_OPERATION_RECORD R           WHERE #L (R.FOPERATIONTIME BETWEEN ? AND ?) AND R.FOPERATIONTYPE != '1'           AND R.FAPPTYPE = '0' AND R.FSOURCETYPE = '0'         ) R INNER JOIN         ( SELECT P.FID, P.FNAME, P.FPATH, P.FTYPE, P.FCREATORID, P.FCREATETIME           FROM T_QING_PUBLISH P           WHERE #2 P.FTYPE = '2' AND P.FPATH != 'lightapp'         ) P ON P.FID = R.FSOURCEID        GROUP BY P.FID      ) LT LEFT JOIN T_QING_PUSH_RECORD LR ON LT.FID = LR.FPUBLISHID     GROUP BY LR.FCONFIGID   ) OLT LEFT JOIN T_QING_PUSH_CONFIG_INFO LC ON OLT.FCONFIGID = LC.FID WHERE LC.FID IS NOT NULL ) QOR order by %s %s ";
        return QUERY_NUMBEROFOPERATIONS_BY_AGGPUBLISH;
    }
}

