/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.manage.resourcestatistics.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.data.model.runtime.compare.sqlcondition.InSqlConditionBuilder;
import com.kingdee.bos.qing.manage.resourcestatistics.dao.SqlConstant;
import com.kingdee.bos.qing.manage.resourcestatistics.model.ResourceColumnEnum;
import com.kingdee.bos.qing.manage.resourcestatistics.model.ResourceDetailModel;
import com.kingdee.bos.qing.manage.resourcestatistics.model.StatisticsVO;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.target.PublishTargetDomainFactory;
import com.kingdee.bos.qing.publish.target.email.model.EmailNameRule;
import com.kingdee.bos.qing.publish.target.lapp.LappSyncDomain;
import com.kingdee.bos.qing.publish.target.lapp.env.LappApiEnum;
import com.kingdee.bos.qing.publish.target.lapp.model.LappContext;
import com.kingdee.bos.qing.publish.target.lapp.model.PublishLappConfigVO;
import com.kingdee.bos.qing.publish.target.lapp.strategy.ILappStrategy;
import com.kingdee.bos.qing.publish.target.lapp.util.LappHelper;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StatisticsDao {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private boolean bPreset = false;
    private LappSyncDomain lappSyncDomain;
    private ILappStrategy lappStrategy;
    private IScheduleEngine scheduleEngine;
    private ITransactionManagement tx;
    private PublishLappConfigVO initPublishLappConfigVO;
    private LappContext lappContext;
    private Map<Integer, AbstractPublishTargetDomain> publishTargetDomainMap;
    private String LIGHT_APP_TYPE = "2";
    private Set<String> sortField = new HashSet<String>(18);

    public StatisticsDao(IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext, IScheduleEngine scheduleEngine) {
        this.sortField.addAll(Arrays.asList("subjectNum", "dsbNum", "publishNum", "pushConfigNum", "total", "FCREATETIME"));
        this.tx = tx;
        this.scheduleEngine = scheduleEngine;
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
    }

    private LappSyncDomain getLappSyncDomain() {
        if (this.lappSyncDomain == null) {
            this.lappSyncDomain = new LappSyncDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.lappSyncDomain;
    }

    private String getSortField(String field, String defaultField) {
        if (this.sortField.contains(field)) {
            return field;
        }
        return defaultField;
    }

    private String getSortDirection(String direction) {
        String defaultSortDirection = "DESC";
        if (StringUtils.isNotEmpty((CharSequence)direction) && !defaultSortDirection.equals(direction.toUpperCase())) {
            return "ASC";
        }
        return defaultSortDirection;
    }

    public List<StatisticsVO> queryResourcesByUserId(List<String> userIds, Integer offset, Integer pageSize, String field, String order) throws AbstractQingIntegratedException, SQLException {
        Object[] objectArray;
        String sql;
        String presetUserId = IntegratedHelper.getPresetUserId();
        if (userIds.size() == 0) {
            if (this.bPreset) {
                presetUserId = " ";
                sql = "SELECT    TOP %s,%s \tFUI.FUSERID , \tISNULL(QT.FSUBJECT, 0) AS SUBJECTNUM  , \tISNULL(QT.FDSB, 0) AS DSBNUM  , \tISNULL(QP.FPUBLISH, 0) AS PUBLISHNUM  , \tISNULL(FFS.FSUM, 0) AS PUSHCONFIGNUM  ,    (ISNULL(QT.FSUBJECT, 0) + ISNULL(QT.FDSB, 0) + ISNULL(QP.FPUBLISH, 0) + ISNULL(FFS.FSUM, 0)) as TOTAL FROM (SELECT FUSERID FROM (SELECT FUSERID FROM T_QING_THEME  UNION SELECT FCREATORID FROM T_QING_PUBLISH  UNION SELECT FUSERID FROM T_QING_PUSH_CONFIG_INFO  UNION SELECT FUSERID FROM T_QING_PUB_EMAIL_CONF ) FAUI WHERE #1 ) FUI LEFT JOIN (SELECT \tFUSERID , \tCOUNT(CASE WHEN FTYPE='0' THEN 1 ELSE NULL END) AS FSUBJECT , \tCOUNT(CASE WHEN FTYPE='1' THEN 1 ELSE NULL END) AS FDSB FROM T_QING_THEME \tGROUP BY FUSERID) QT ON QT.FUSERID = FUI.FUSERID  LEFT JOIN \t (SELECT FCREATORID AS FUSERID , \tCOUNT(FID) AS FPUBLISH FROM \tT_QING_PUBLISH  WHERE FSOURCE != 'extreport'    AND FTYPE != '6' AND FTYPE != '2' OR (FTYPE = '2' AND FPATH = 'lightapp')\tGROUP BY FCREATORID) QP ON \tQP.FUSERID  = FUI.FUSERID LEFT JOIN  (SELECT FUSERID ,    SUM(SUM1) AS FSUM FROM (SELECT FUSERID , \tCOUNT(FID) AS SUM1 FROM T_QING_PUSH_CONFIG_INFO \tGROUP BY FUSERID UNION ALL SELECT FUSERID ,    COUNT(FID) AS SUM1 FROM \tT_QING_PUB_EMAIL_CONF    GROUP BY FUSERID) FPC    GROUP BY FUSERID) FFS ON    FFS.FUSERID = FUI.FUSERID ORDER BY %s %s ".replace("#1", " FUSERID IS NOT NULL AND FUSERID != ? ");
            } else {
                sql = "SELECT    TOP %s,%s \tFUI.FUSERID , \tISNULL(QT.FSUBJECT, 0) AS SUBJECTNUM  , \tISNULL(QT.FDSB, 0) AS DSBNUM  , \tISNULL(QP.FPUBLISH, 0) AS PUBLISHNUM  , \tISNULL(FFS.FSUM, 0) AS PUSHCONFIGNUM  ,    (ISNULL(QT.FSUBJECT, 0) + ISNULL(QT.FDSB, 0) + ISNULL(QP.FPUBLISH, 0) + ISNULL(FFS.FSUM, 0)) as TOTAL FROM (SELECT FUSERID FROM (SELECT FUSERID FROM T_QING_THEME  UNION SELECT FCREATORID FROM T_QING_PUBLISH  UNION SELECT FUSERID FROM T_QING_PUSH_CONFIG_INFO  UNION SELECT FUSERID FROM T_QING_PUB_EMAIL_CONF ) FAUI WHERE #1 ) FUI LEFT JOIN (SELECT \tFUSERID , \tCOUNT(CASE WHEN FTYPE='0' THEN 1 ELSE NULL END) AS FSUBJECT , \tCOUNT(CASE WHEN FTYPE='1' THEN 1 ELSE NULL END) AS FDSB FROM T_QING_THEME \tGROUP BY FUSERID) QT ON QT.FUSERID = FUI.FUSERID  LEFT JOIN \t (SELECT FCREATORID AS FUSERID , \tCOUNT(FID) AS FPUBLISH FROM \tT_QING_PUBLISH  WHERE FSOURCE != 'extreport'    AND FTYPE != '6' AND FTYPE != '2' OR (FTYPE = '2' AND FPATH = 'lightapp')\tGROUP BY FCREATORID) QP ON \tQP.FUSERID  = FUI.FUSERID LEFT JOIN  (SELECT FUSERID ,    SUM(SUM1) AS FSUM FROM (SELECT FUSERID , \tCOUNT(FID) AS SUM1 FROM T_QING_PUSH_CONFIG_INFO \tGROUP BY FUSERID UNION ALL SELECT FUSERID ,    COUNT(FID) AS SUM1 FROM \tT_QING_PUB_EMAIL_CONF    GROUP BY FUSERID) FPC    GROUP BY FUSERID) FFS ON    FFS.FUSERID = FUI.FUSERID ORDER BY %s %s ".replace("#1", " FUSERID != ' ' AND FUSERID IS NOT NULL AND FUSERID != ? ");
            }
        } else {
            InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(userIds.size());
            sql = "SELECT    TOP %s,%s \tFUI.FUSERID , \tISNULL(QT.FSUBJECT, 0) AS SUBJECTNUM  , \tISNULL(QT.FDSB, 0) AS DSBNUM  , \tISNULL(QP.FPUBLISH, 0) AS PUBLISHNUM  , \tISNULL(FFS.FSUM, 0) AS PUSHCONFIGNUM  ,    (ISNULL(QT.FSUBJECT, 0) + ISNULL(QT.FDSB, 0) + ISNULL(QP.FPUBLISH, 0) + ISNULL(FFS.FSUM, 0)) as TOTAL FROM (SELECT FUSERID FROM (SELECT FUSERID FROM T_QING_THEME  UNION SELECT FCREATORID FROM T_QING_PUBLISH  UNION SELECT FUSERID FROM T_QING_PUSH_CONFIG_INFO  UNION SELECT FUSERID FROM T_QING_PUB_EMAIL_CONF ) FAUI WHERE #1 ) FUI LEFT JOIN (SELECT \tFUSERID , \tCOUNT(CASE WHEN FTYPE='0' THEN 1 ELSE NULL END) AS FSUBJECT , \tCOUNT(CASE WHEN FTYPE='1' THEN 1 ELSE NULL END) AS FDSB FROM T_QING_THEME \tGROUP BY FUSERID) QT ON QT.FUSERID = FUI.FUSERID  LEFT JOIN \t (SELECT FCREATORID AS FUSERID , \tCOUNT(FID) AS FPUBLISH FROM \tT_QING_PUBLISH  WHERE FSOURCE != 'extreport'    AND FTYPE != '6' AND FTYPE != '2' OR (FTYPE = '2' AND FPATH = 'lightapp')\tGROUP BY FCREATORID) QP ON \tQP.FUSERID  = FUI.FUSERID LEFT JOIN  (SELECT FUSERID ,    SUM(SUM1) AS FSUM FROM (SELECT FUSERID , \tCOUNT(FID) AS SUM1 FROM T_QING_PUSH_CONFIG_INFO \tGROUP BY FUSERID UNION ALL SELECT FUSERID ,    COUNT(FID) AS SUM1 FROM \tT_QING_PUB_EMAIL_CONF    GROUP BY FUSERID) FPC    GROUP BY FUSERID) FFS ON    FFS.FUSERID = FUI.FUSERID ORDER BY %s %s ".replace("#1", inSqlConditionBuilder.build("FUSERID"));
        }
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "subjectNum"), this.getSortDirection(order));
        if (userIds.size() > 0) {
            objectArray = userIds.toArray();
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = presetUserId;
        }
        List statisticsVOS = (List)this.dbExcuter.query(sql, objectArray, (ResultHandler)new ResultHandler<List<StatisticsVO>>(){

            public List<StatisticsVO> handle(ResultSet rs) throws SQLException {
                ArrayList<StatisticsVO> statisticsVOS = new ArrayList<StatisticsVO>(10);
                while (rs.next()) {
                    StatisticsVO statisticsVO = new StatisticsVO();
                    statisticsVO.setUserId(rs.getString("FUSERID"));
                    statisticsVO.setSubjectNum(rs.getInt("SUBJECTNUM"));
                    statisticsVO.setDsbNum(rs.getInt("DSBNUM"));
                    statisticsVO.setPublishNum(rs.getInt("PUBLISHNUM"));
                    statisticsVO.setPushConfigNum(rs.getInt("PUSHCONFIGNUM"));
                    statisticsVO.setTotal(rs.getInt("TOTAL"));
                    statisticsVOS.add(statisticsVO);
                }
                return statisticsVOS;
            }
        });
        ArrayList<Long> userList = new ArrayList<Long>(10);
        for (StatisticsVO statisticsVO : statisticsVOS) {
            userList.add(Long.valueOf(statisticsVO.getUserId()));
        }
        Map userAndNameMap = IntegratedHelper.getUserAndName(userList);
        for (int i = 0; i < statisticsVOS.size(); ++i) {
            String userId = ((StatisticsVO)statisticsVOS.get(i)).getUserId();
            Map userAndName = (Map)userAndNameMap.get(userId);
            if (userAndName == null) continue;
            ((StatisticsVO)statisticsVOS.get(i)).setUserAndName(userAndName.get("name") + "(" + userAndName.get("username") + ")");
        }
        return statisticsVOS;
    }

    public List<ResourceDetailModel> querySubjectOrDSBDetail(String userId, final String type, Integer offset, Integer pageSize, String field, String order) throws AbstractQingIntegratedException, SQLException {
        String sql = null;
        sql = type.equals("subject") ? "SELECT TOP %s,%s T.FUSERID AS FUSERID ,G.FNAME AS FPATH,T.FNAME AS FNAME,T.FCREATEDATE AS FCREATETIME FROM (T_QING_THEME T LEFT JOIN T_QING_THEME_GROUP G ON T.FTHEMEGROUPID = G.FID) WHERE T.FTYPE = '0' AND T.FUSERID = ? ORDER BY %s %s" : "SELECT TOP %s,%s T.FUSERID AS FUSERID ,G.FNAME AS FPATH,T.FNAME AS FNAME,T.FCREATEDATE AS FCREATETIME FROM (T_QING_THEME T LEFT JOIN T_QING_THEME_GROUP G ON T.FTHEMEGROUPID = G.FID) WHERE T.FTYPE = '1' AND T.FUSERID = ? ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "FCREATETIME"), this.getSortDirection(order));
        List models = (List)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<ResourceDetailModel>>(){

            public List<ResourceDetailModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ResourceDetailModel> res = new ArrayList<ResourceDetailModel>(16);
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                while (rs.next()) {
                    ResourceDetailModel model = new ResourceDetailModel();
                    long createtime = rs.getTimestamp("FCREATETIME").getTime();
                    model.setCreateTime(createtime);
                    String createTimeFormat = IntegratedHelper2.formatDateTime(new Date(createtime));
                    model.setCreateTimeFormat(createTimeFormat);
                    model.setName(rs.getString("FNAME"));
                    model.setPathName(rs.getString("FPATH"));
                    model.setUserId(rs.getString("FUSERID"));
                    if (type.equals("subject")) {
                        model.setType(ResourceColumnEnum.subject.name());
                    } else {
                        model.setType(ResourceColumnEnum.dsb.name());
                    }
                    res.add(model);
                }
                return res;
            }
        });
        this.fillModelUserName(models);
        return models;
    }

    public List<ResourceDetailModel> queryPublishDetail(String userId, Integer offset, Integer pageSize, String field, String order) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT TOP %s,%s FID, FCREATORID ,FNAME ,FCREATETIME ,FPATH ,FTYPE AS FTYPE FROM T_QING_PUBLISH T WHERE (FSOURCE != 'extreport' AND FTYPE != '6' AND FTYPE != '2'  OR (FTYPE = '2' AND FPATH = 'lightapp')) AND FCREATORID = ? ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "FCREATETIME"), this.getSortDirection(order));
        List models = (List)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<ResourceDetailModel>>(){

            public List<ResourceDetailModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ResourceDetailModel> res = new ArrayList<ResourceDetailModel>(16);
                ArrayList<ResourceDetailModel> arrLightApp = new ArrayList<ResourceDetailModel>(16);
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                while (rs.next()) {
                    ResourceDetailModel model = new ResourceDetailModel();
                    model.setFid(rs.getString("FID"));
                    model.setUserId(rs.getString("FCREATORID"));
                    long createtime = rs.getTimestamp("FCREATETIME").getTime();
                    model.setCreateTime(createtime);
                    String createTimeFormat = IntegratedHelper2.formatDateTime(new Date(createtime));
                    model.setCreateTimeFormat(createTimeFormat);
                    String name = rs.getString("FNAME");
                    if (rs.getString("FTYPE").equals(StatisticsDao.this.LIGHT_APP_TYPE)) {
                        model.setName(name.substring(0, name.length() - 36));
                        arrLightApp.add(model);
                    } else {
                        model.setName(name);
                    }
                    String pathNames = StatisticsDao.this.fillPublishPathNames(rs.getString("FID"), rs.getString("FTYPE"), rs.getString("FPATH"));
                    model.setPathName(pathNames);
                    model.setType(ResourceColumnEnum.publish.name());
                    res.add(model);
                }
                StatisticsDao.this.fixLightappPath(arrLightApp);
                return res;
            }
        });
        this.fillModelUserName(models);
        return models;
    }

    public List<ResourceDetailModel> queryPushDetail(String userId, Integer offset, Integer pageSize, String field, String order) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT TOP %s,%s FUSERID,FCREATETIME,FNAME,FNAMERULE,FTYPE FROM ((SELECT FUSERID,FCREATETIME,FNAME AS FNAME,null AS FNAMERULE,'2' AS FTYPE FROM T_QING_PUSH_CONFIG_INFO WHERE FUSERID = ?)UNION ALL  (SELECT FUSERID,FCREATETIME,null AS FNAME ,FNAMERULE AS FNAMERULE,'6' AS FTYPE FROM T_QING_PUB_EMAIL_CONF WHERE FUSERID = ?)) F ORDER BY %s %s";
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "FCREATETIME"), this.getSortDirection(order));
        List models = (List)this.dbExcuter.query(sql, new Object[]{userId, userId}, (ResultHandler)new ResultHandler<List<ResourceDetailModel>>(){

            public List<ResourceDetailModel> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<ResourceDetailModel> res = new ArrayList<ResourceDetailModel>(16);
                while (rs.next()) {
                    ResourceDetailModel model = new ResourceDetailModel();
                    model.setUserId(rs.getString("FUSERID"));
                    long createtime = rs.getTimestamp("FCREATETIME").getTime();
                    model.setCreateTime(createtime);
                    String createTimeFormat = IntegratedHelper2.formatDateTime(new Date(createtime));
                    model.setCreateTimeFormat(createTimeFormat);
                    if (StringUtils.isBlank((CharSequence)rs.getString("FNAME"))) {
                        EmailNameRule rule = StatisticsDao.this.bytes2NameRule(rs.getBytes("FNAMERULE"));
                        model.setName(rule.getName());
                    } else {
                        model.setName(rs.getString("FNAME"));
                    }
                    String publishPathNames = StatisticsDao.this.fillPublishPathNames(null, rs.getString("FTYPE"), null);
                    model.setPathName(publishPathNames);
                    model.setType(ResourceColumnEnum.pushConfig.name());
                    res.add(model);
                }
                return res;
            }
        });
        this.fillModelUserName(models);
        return models;
    }

    public List<ResourceDetailModel> queryALlTypeDetail(String userId, Integer offset, Integer pageSize, String field, String order) throws AbstractQingIntegratedException, SQLException {
        String sql = SqlConstant.QUERY_ALL_TYPE;
        sql = String.format(sql, pageSize, offset, this.getSortField(field, "FCREATETIME"), this.getSortDirection(order));
        List models = (List)this.dbExcuter.query(sql, new Object[]{userId, userId, userId, userId}, (ResultHandler)new ResultHandler<List<ResourceDetailModel>>(){

            public List<ResourceDetailModel> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<ResourceDetailModel> res = new ArrayList<ResourceDetailModel>(16);
                ArrayList<ResourceDetailModel> arrLightApp = new ArrayList<ResourceDetailModel>(16);
                while (rs.next()) {
                    ResourceDetailModel model = new ResourceDetailModel();
                    long createtime = rs.getTimestamp("FCREATETIME").getTime();
                    model.setCreateTime(createtime);
                    String createTimeFormat = IntegratedHelper2.formatDateTime(new Date(createtime));
                    model.setCreateTimeFormat(createTimeFormat);
                    model.setUserId(rs.getString("FUSERID"));
                    model.setFid(rs.getString("FID"));
                    String source = rs.getString("FSOURCE");
                    if (source.equals(ResourceColumnEnum.subOrdsb.name())) {
                        model.setName(rs.getString("FNAME"));
                        model.setPathName(rs.getString("FPATH"));
                        if (rs.getString("FTYPE").equals("0")) {
                            model.setType(ResourceColumnEnum.subject.name());
                        } else {
                            model.setType(ResourceColumnEnum.dsb.name());
                        }
                    } else if (source.equals(ResourceColumnEnum.publish.name())) {
                        model.setType(source);
                        String fname = rs.getString("FNAME");
                        if (rs.getString("FTYPE").equals(StatisticsDao.this.LIGHT_APP_TYPE)) {
                            model.setName(fname.substring(0, fname.length() - 36));
                            arrLightApp.add(model);
                        } else {
                            model.setName(fname);
                        }
                        String pathNames = StatisticsDao.this.fillPublishPathNames(rs.getString("FID"), rs.getString("FTYPE"), rs.getString("FPATH"));
                        model.setPathName(pathNames);
                    } else if (source.equals(ResourceColumnEnum.pushConfig.name())) {
                        if (StringUtils.isBlank((CharSequence)rs.getString("FNAME"))) {
                            EmailNameRule rule = StatisticsDao.this.bytes2NameRule(rs.getBytes("FNAMERULE"));
                            model.setName(rule.getName());
                        } else {
                            model.setName(rs.getString("FNAME"));
                        }
                        model.setType(source);
                        String publishPathNames = StatisticsDao.this.fillPublishPathNames(null, rs.getString("FTYPE"), null);
                        model.setPathName(publishPathNames);
                    }
                    res.add(model);
                }
                StatisticsDao.this.fixLightappPath(arrLightApp);
                return res;
            }
        });
        this.fillModelUserName(models);
        return models;
    }

    private void fillModelUserName(List<ResourceDetailModel> models) throws IntegratedRuntimeException {
        HashSet<Long> userIds = new HashSet<Long>(models.size());
        for (ResourceDetailModel model : models) {
            userIds.add(Long.valueOf(model.getUserId()));
        }
        Map userAndName = IntegratedHelper.getUserAndName(new ArrayList(userIds));
        for (ResourceDetailModel model : models) {
            Map nameAndUserNameMap = (Map)userAndName.get(model.getUserId());
            model.setUserName(nameAndUserNameMap.get("name") + "(" + nameAndUserNameMap.get("username") + ")");
        }
    }

    public Integer getResourcesCountById(List<String> userIds) throws AbstractQingIntegratedException, SQLException {
        Object[] objectArray;
        String sql;
        String presetUserId = IntegratedHelper.getPresetUserId();
        if (userIds.size() == 0) {
            if (this.bPreset) {
                presetUserId = "";
            }
            sql = "SELECT COUNT(1) RESOURCE_COUNT FROM (SELECT FUSERID FROM T_QING_THEME  UNION SELECT FCREATORID FROM T_QING_PUBLISH UNION SELECT FUSERID FROM T_QING_PUSH_CONFIG_INFO UNION SELECT FUSERID FROM T_QING_PUB_EMAIL_CONF) FAUI WHERE # ".replace("#", " FUSERID != ? ");
        } else {
            InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(userIds.size());
            sql = "SELECT COUNT(1) RESOURCE_COUNT FROM (SELECT FUSERID FROM T_QING_THEME  UNION SELECT FCREATORID FROM T_QING_PUBLISH UNION SELECT FUSERID FROM T_QING_PUSH_CONFIG_INFO UNION SELECT FUSERID FROM T_QING_PUB_EMAIL_CONF) FAUI WHERE # ".replace("#", inSqlConditionBuilder.build("FUSERID"));
        }
        if (userIds.size() > 0) {
            objectArray = userIds.toArray();
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = presetUserId;
        }
        return (Integer)this.dbExcuter.query(sql, objectArray, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("RESOURCE_COUNT");
                }
                return 0;
            }
        });
    }

    private String fillPublishPathNames(String publishId, String pubType, String pubPath) throws SQLException {
        if (StringUtils.isNotBlank((CharSequence)pubPath)) {
            AbstractPublishTargetDomain publishTargetDomain = this.getPublishTargetDomain(Integer.valueOf(pubType));
            if (publishTargetDomain != null) {
                try {
                    return publishTargetDomain.loadPathNameByPath(pubPath, publishId);
                }
                catch (AbstractQingIntegratedException e) {
                    throw new SQLException(e);
                }
            }
        } else {
            if (6 == Integer.parseInt(pubType)) {
                return Messages.getMLS((String)"emailPushConfiguration", (String)"\u90ae\u4ef6\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
            }
            if (2 == Integer.parseInt(pubType)) {
                return Messages.getMLS((String)"lappPushConfiguration", (String)"\u79fb\u52a8\u7aef\u5b9a\u65f6\u63a8\u9001\u914d\u7f6e", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
            }
        }
        return null;
    }

    public AbstractPublishTargetDomain getPublishTargetDomain(Integer type) {
        AbstractPublishTargetDomain publishTargetDomain;
        if (this.publishTargetDomainMap == null) {
            this.publishTargetDomainMap = new HashMap<Integer, AbstractPublishTargetDomain>(8);
        }
        if ((publishTargetDomain = this.publishTargetDomainMap.get(type)) == null) {
            publishTargetDomain = PublishTargetDomainFactory.createPublishTargetDomain((QingContext)this.qingContext, null, (IDBExcuter)this.dbExcuter, null, (Integer)type);
            this.publishTargetDomainMap.put(type, publishTargetDomain);
        }
        return publishTargetDomain;
    }

    private EmailNameRule bytes2NameRule(byte[] nameRuleBytes) throws SQLException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EmailNameRule nameRule = new EmailNameRule();
        try {
            outputStream.write(nameRuleBytes);
            if (outputStream.size() > 0) {
                IXmlElement NameRuleElement = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                nameRule.fromXml(NameRuleElement);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        catch (XmlParsingException e) {
            throw new SQLException(e);
        }
        return nameRule;
    }

    private void fixLightappPath(List<ResourceDetailModel> arrLightAppModel) {
        if (arrLightAppModel.size() == 0) {
            return;
        }
        ArrayList<String> publishIds = new ArrayList<String>(arrLightAppModel.size());
        for (int i = 0; i < arrLightAppModel.size(); ++i) {
            publishIds.add(arrLightAppModel.get(i).getFid());
        }
        String result = null;
        try {
            result = this.getAnalysisByPublishIds(publishIds);
            Map resultMap = (Map)JsonUtil.decodeFromString((String)result, Map.class);
            if (resultMap == null || resultMap.isEmpty()) {
                return;
            }
            List data = (List)resultMap.get("data");
            block3: for (int i = 0; i < arrLightAppModel.size(); ++i) {
                ResourceDetailModel operationRecordVo = arrLightAppModel.get(i);
                for (int j = 0; j < data.size(); ++j) {
                    Map analysisVo = (Map)data.get(j);
                    if (!((String)analysisVo.get("publishId")).equals(operationRecordVo.getFid())) continue;
                    String publishPath = Messages.getMLS((String)"lightapp", (String)"\u79fb\u52a8\u8f7b\u5e94\u7528", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING) + "\uff1a" + (String)analysisVo.get("directoryName");
                    operationRecordVo.setPathName(publishPath);
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"Access Light APP Failed", (Throwable)e);
        }
    }

    private String getAnalysisByPublishIds(List<String> fixPublishIds) throws AbstractQingException {
        this.getPublishLappConfigVO();
        String lappUserId = null;
        String lappUserType = null;
        if (this.lappContext != null && StringUtils.isNotEmpty((CharSequence)this.lappContext.getLappUserId())) {
            lappUserId = this.lappContext.getLappUserId();
            lappUserType = this.lappContext.getLappUserType();
        } else if (this.initPublishLappConfigVO != null) {
            lappUserId = this.initPublishLappConfigVO.getLappUserId();
            lappUserType = this.initPublishLappConfigVO.getLappUserType();
        }
        if (StringUtils.isEmpty(lappUserId) || StringUtils.isEmpty(lappUserType)) {
            return "{}";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("lappUserId", lappUserId);
        paramMap.put("lappUserType", lappUserType);
        paramMap.put("datacenterUUID", this.getLappSyncDomain().getSyncedDatacenterUUID());
        HashMap<String, String> publishIdsParams = new HashMap<String, String>();
        publishIdsParams.put("publishIds", JsonUtil.encodeToString(fixPublishIds));
        return LappHelper.postByForm((LappApiEnum)LappApiEnum.QING_LOAD_ANALYSIS_BY_ID_URL, null, publishIdsParams, paramMap);
    }

    private PublishLappConfigVO getPublishLappConfigVO() {
        if (this.initPublishLappConfigVO == null) {
            ArrayList publishLappConfigVOs = new ArrayList();
            this.lappContext = this.getLappStrategyImpl().getLappConext(publishLappConfigVOs, this.qingContext, this.dbExcuter, this.tx, this.scheduleEngine);
            for (PublishLappConfigVO publishLappConfigVO : publishLappConfigVOs) {
                if (!StringUtils.isNotBlank((CharSequence)publishLappConfigVO.getLappUserId()) || this.initPublishLappConfigVO != null) continue;
                this.initPublishLappConfigVO = publishLappConfigVO;
                break;
            }
        }
        return this.initPublishLappConfigVO;
    }

    private ILappStrategy getLappStrategyImpl() {
        this.lappStrategy = (ILappStrategy)CustomStrategyRegistrar.getStrategy(ILappStrategy.class);
        if (this.lappStrategy == null) {
            throw new RuntimeException("cannot found the implement of ILappStrategy.");
        }
        return this.lappStrategy;
    }
}

