/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.subject.domain;

import com.kingdee.bos.qing.common.cache.LinkageContext;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.entity.EntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.data.exception.entity.EntityPermissionServiceException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.linkage.ILinkageSourceSupporter;
import com.kingdee.bos.qing.linkage.LinkageSourceDomainFactory;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.domain.impl.SubjectManageDomain;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.message.domain.MessageDomain;
import com.kingdee.bos.qing.message.model.AppTypeEnum;
import com.kingdee.bos.qing.message.model.BizTypeEnum;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageTypeEnum;
import com.kingdee.bos.qing.message.model.vo.SaveMessageVo;
import com.kingdee.bos.qing.preparedata.model.MultiFileDataBO;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.subject.domain.SubjectRuntimeDomain;
import com.kingdee.bos.qing.subject.model.SubjectDataBO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubjectRuntimeDomain {
    protected QingContext qingContext;
    protected ITransactionManagement tx;
    protected IDBExcuter dbExcuter;
    private IThemeDao iThemeDao;
    private IThemeGroupDao iThemeGroupDao;
    private ISubjectDao iSubjectDao;
    private MessageDomain messageDomain;
    private SubjectManageDomain subjectManageDomain;

    public SubjectRuntimeDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    protected IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    protected ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    private MessageDomain getMessageDomain() {
        if (this.messageDomain == null) {
            this.messageDomain = new MessageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.messageDomain;
    }

    private SubjectManageDomain getSubjectManageDomain() {
        if (this.subjectManageDomain == null) {
            this.subjectManageDomain = new SubjectManageDomain(this.qingContext, this.tx, this.dbExcuter, null);
        }
        return this.subjectManageDomain;
    }

    public ThemePO getThemeByID(String themeId) throws AbstractQingIntegratedException, SQLException {
        return this.getThemeDao().getThemeByID(themeId);
    }

    public SubjectDataBO findNewData(String userId, String themeId) throws AbstractQingIntegratedException, SQLException {
        return this.getSubjectDao().findNewData(userId, themeId);
    }

    public LinkageContext getLinkageContext(Box box) {
        HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>(box.getSources().size());
        HashMap<String, List<AbstractEntity>> sourcesEntityMap = new HashMap<String, List<AbstractEntity>>();
        for (AbstractSource source : box.getSources()) {
            sourcesMap.put(source.getName(), source);
        }
        for (AbstractEntity entity : box.getEntities()) {
            List subEntities;
            if (entity instanceof Entity && this.isNeedCollectLinkageFormInfo(entity, sourcesMap)) {
                this.putSourcesEntityMap(entity, ((Entity)entity).getSource(), sourcesEntityMap);
                continue;
            }
            if (!(entity instanceof UnionEntity) || (subEntities = ((UnionEntity)entity).getChildren()).isEmpty() || !this.isNeedCollectLinkageFormInfo((AbstractEntity)subEntities.get(0), sourcesMap)) continue;
            String entitySourceName = ((Entity)subEntities.get(0)).getSource();
            this.putSourcesEntityMap(entity, entitySourceName, sourcesEntityMap);
        }
        return this.collectLinkageFormInfo(sourcesEntityMap, sourcesMap);
    }

    private void putSourcesEntityMap(AbstractEntity entity, String entitySourceName, Map<String, List<AbstractEntity>> sourcesEntityMap) {
        List<AbstractEntity> entityList = sourcesEntityMap.get(entitySourceName);
        if (CollectionUtils.isEmpty(entityList)) {
            entityList = new ArrayList<AbstractEntity>();
            entityList.add(entity);
            sourcesEntityMap.put(entitySourceName, entityList);
        } else {
            entityList.add(entity);
        }
    }

    private boolean isNeedCollectLinkageFormInfo(AbstractEntity entity, Map<String, AbstractSource> sourcesMap) {
        String entitySourceName = ((Entity)entity).getSource();
        AbstractSource entitySource = sourcesMap.get(entitySourceName);
        ILinkageSourceSupporter iLinkageSourceSupporter = LinkageSourceDomainFactory.getLinkageSourceDomain((AbstractSource)entitySource);
        return iLinkageSourceSupporter != null;
    }

    private LinkageContext collectLinkageFormInfo(Map<String, List<AbstractEntity>> sourcesEntityMap, Map<String, AbstractSource> sourcesMap) {
        LinkageContext linkageContext = new LinkageContext();
        for (Map.Entry<String, List<AbstractEntity>> entry : sourcesEntityMap.entrySet()) {
            AbstractSource entitySource = sourcesMap.get(entry.getKey());
            ILinkageSourceSupporter iLinkageSourceSupporter = LinkageSourceDomainFactory.getLinkageSourceDomain((AbstractSource)entitySource);
            if (iLinkageSourceSupporter == null) continue;
            iLinkageSourceSupporter.collectLinkageFormInfo(this.qingContext, linkageContext, entry.getValue());
        }
        return linkageContext;
    }

    public String checkPermission(Box box) throws UnSupportDataSourceException {
        Set<String> noPermissionExceptionSet = this.traverseEntity(box, CollectType.PERMISSION);
        if (!noPermissionExceptionSet.isEmpty()) {
            String paramMessage = StringUtils.join((Object[])noPermissionExceptionSet.toArray(), (char)',');
            String messageMls = Messages.getMLS((QingContext)this.qingContext, (String)"NoEntityPermission", (String)"\u7528\u6237\u201c$param1\u201d\u6ca1\u6709\u5b9e\u4f53\uff08$param2\uff09\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (Messages.ProjectName)Messages.ProjectName.MSERVICE_QING);
            return messageMls.replace("$param1", this.qingContext.getSystemVarStringValue(SystemVarType.USER_NAME)).replace("$param2", paramMessage);
        }
        return null;
    }

    public String checkSupportQingAnalysis(Box box) throws UnSupportDataSourceException {
        Set<String> notSupportQingAnalysis = this.traverseEntity(box, CollectType.SUPPORT);
        if (!notSupportQingAnalysis.isEmpty()) {
            String paramMessage = StringUtils.join((Object[])notSupportQingAnalysis.toArray(), (char)',');
            return String.format(Messages.getMLS((QingContext)this.qingContext, (String)"entityNotSupportQingAnalysis", (String)"\u4e1a\u52a1\u5b9e\u4f53\u3010 %s \u3011\u672a\u5f00\u542f\u201c\u652f\u6301\u8f7b\u5206\u6790\u201d\u8bbe\u7f6e\u9879\uff0c\u8bf7\u5728\u5f00\u53d1\u5e73\u53f0\u7684\u5bf9\u5e94\u8868\u5355\u4e2d\u8fdb\u884c\u8bbe\u7f6e  ", (Messages.ProjectName)Messages.ProjectName.QING_THEME), paramMessage);
        }
        return null;
    }

    private Set<String> traverseEntity(Box box, CollectType collectType) throws UnSupportDataSourceException {
        HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>(box.getSources().size());
        for (AbstractSource source : box.getSources()) {
            sourcesMap.put(source.getName(), source);
        }
        int size = box.getEntities().size();
        HashSet<String> resultSet = new HashSet<String>(size);
        for (AbstractEntity entity : box.getEntities()) {
            UnionEntity unionEntity;
            AbstractSource source = null;
            if (entity instanceof Entity) {
                source = (AbstractSource)sourcesMap.get(((Entity)entity).getSource());
                this.collectResult(collectType, resultSet, source, (Entity)entity);
                continue;
            }
            if (!(entity instanceof UnionEntity) || (unionEntity = (UnionEntity)entity).getEntityType() != EntityType.BIZ_UNION) continue;
            List entityChildren = unionEntity.getChildren();
            for (Entity child : entityChildren) {
                source = (AbstractSource)sourcesMap.get(child.getSource());
                this.collectResult(collectType, resultSet, source, child);
            }
        }
        return resultSet;
    }

    private void collectResult(CollectType collectType, Set<String> resultSet, AbstractSource source, Entity entity) throws UnSupportDataSourceException {
        AbstractDataSourceDomain domain = SourceDomainFactory.getSourceDomain((AbstractSource)source);
        switch (1.$SwitchMap$com$kingdee$bos$qing$subject$domain$SubjectRuntimeDomain$CollectType[collectType.ordinal()]) {
            case 1: {
                this.collectNonSupport(resultSet, entity, domain);
                break;
            }
            case 2: {
                this.collectNonPermission(resultSet, entity, domain);
                break;
            }
        }
    }

    private void collectNonSupport(Set<String> notSupportQingAnalysis, Entity entity, AbstractDataSourceDomain domain) {
        try {
            domain.checkSupportQingAnalysis(this.qingContext, entity);
        }
        catch (EntityNotSupportQingAnalysisException e) {
            notSupportQingAnalysis.add(e.getEntityFullPath());
        }
    }

    private void collectNonPermission(Set<String> noPermissionExceptionSet, Entity entity, AbstractDataSourceDomain domain) {
        try {
            domain.checkEntityPermission(this.qingContext, entity);
        }
        catch (NoEntityPermissionException e) {
            noPermissionExceptionSet.add(e.getEntityFullPath());
        }
        catch (EntityPermissionServiceException e) {
            noPermissionExceptionSet.add(e.getEntityFullPath());
        }
    }

    public Box loadModelIncludePreset(String userID, String themeID) throws AbstractQingIntegratedException, ModelParseException, SQLException, EncryptedLicenseCheckException {
        return this.getSubjectDao().loadSubjectModelIncludePreset(userID, themeID);
    }

    public void saveSubjectDataBo(MultiFileDataBO dataBO, List<IQingFile> dataFiles, String ownerId) throws AbstractQingIntegratedException, SQLException {
        List oldBoxFilePaths;
        List oldDataFilePaths;
        try {
            ISubjectDao subjectDao = this.getSubjectDao();
            SubjectDataBO subjectDataBO = (SubjectDataBO)dataBO;
            String themeID = subjectDataBO.getThemeID();
            List oldDataIds = subjectDao.findAllSubjectDataIds(ownerId, themeID);
            oldDataFilePaths = subjectDao.findAllDataPath(oldDataIds);
            oldBoxFilePaths = subjectDao.findAllScheduleBoxFile(themeID, ownerId);
            this.tx.beginRequired();
            subjectDao.saveSubjectDataBO(ownerId, subjectDataBO);
            for (String dataId : oldDataIds) {
                subjectDao.deleteSubjectData(dataId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            FileFactory.clearFile(dataFiles);
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            FileFactory.clearFile(dataFiles);
            throw e;
        }
        finally {
            this.tx.end();
        }
        for (String filePath : oldDataFilePaths) {
            IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)filePath);
            fileUpdater.deleteIgnoreUserId();
        }
        for (String oldBoxFilePath : oldBoxFilePaths) {
            IQingFileUpdater boxFileUpdater = FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)oldBoxFilePath);
            boxFileUpdater.deleteIgnoreUserId();
        }
    }

    public void saveMessage(List<String> receiverIdList, String messageTitle, String bizId, BizTypeEnum bizTypeEnum) {
        if (CollectionUtils.isEmpty(receiverIdList)) {
            return;
        }
        SaveMessageVo saveMessageVo = new SaveMessageVo();
        saveMessageVo.setMessageLevel(MessageLevelTypeEnum.NORMAL_LEVEL);
        saveMessageVo.setMessageType(MessageTypeEnum.BIZ_NEWS);
        saveMessageVo.setAppType(AppTypeEnum.qing);
        saveMessageVo.setMessageTitle(messageTitle);
        saveMessageVo.setBizId(bizId);
        saveMessageVo.setBizType(bizTypeEnum);
        saveMessageVo.setReceiverIdList(receiverIdList);
        try {
            this.getMessageDomain().saveMessageWithTx(saveMessageVo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkUserRelated(Box box) {
        return this.getSubjectManageDomain().checkUserRelated(box);
    }

    public boolean checkSubjectIsRejectPrepareData(String subjectId) {
        return this.getSubjectManageDomain().checkSubjectIsRejectPrepareData(subjectId);
    }
}

