/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.common.strategy.impl;

import com.kingdee.bos.boslayer.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.corelayer.IKBISubSystemTreeNode;
import com.kingdee.bos.corelayer.ISQLDesignerContext;
import com.kingdee.bos.corelayer.proxy.ISQLDesignerProxy;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.util.DesignerVOTranslator;
import com.kingdee.bos.extreport.common.resultset.ResultSetFactory;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import com.kingdee.cosmic.ctrl.common.datacenter.DataCenterDBType;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.entity.EntityHelper;
import kd.bos.mservice.extreport.designer.DataSetDesignerService;
import kd.bos.mservice.extreport.designer.domain.DataSetDesignerDomain;
import kd.bos.mservice.extreport.util.DataSetExecuteChecker;
import kd.bos.mservice.qing.util.AppUtil;

public class SQLDesinerProxyImpl
implements ISQLDesignerProxy {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private DataSetDesignerService dataSetDesignerService;
    private DataSetDesignerDomain dataSetDesignerDomain;

    public SQLDesinerProxyImpl(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    public DataSetDesignerService getDataSetDesignerService() {
        if (this.dataSetDesignerService == null) {
            this.dataSetDesignerService = new DataSetDesignerService();
            this.dataSetDesignerService.setQingContext(this.qingContext);
            this.dataSetDesignerService.setTx(this.tx);
            this.dataSetDesignerService.setDbExcuter(this.dbExcuter);
        }
        return this.dataSetDesignerService;
    }

    public DataSetDesignerDomain getDataSetDesignerDomain() {
        if (this.dataSetDesignerDomain == null) {
            this.dataSetDesignerDomain = new DataSetDesignerDomain();
            this.dataSetDesignerDomain.setQingContext(this.qingContext);
            this.dataSetDesignerDomain.setTx(this.tx);
            this.dataSetDesignerDomain.setDbExcuter(this.dbExcuter);
        }
        return this.dataSetDesignerDomain;
    }

    public KSQLReportInfo findDataSource(String dataSourceID) throws Exception {
        DesignerVO designerVO = this.getDataSetDesignerService().findDataSource(dataSourceID);
        return (KSQLReportInfo)DesignerVOTranslator.decode((DesignerVO)designerVO);
    }

    public KSQLReportInfo findDataSource(String groupID, String groupName, String dataSourceID, String dbsourcename, String userID) throws Exception {
        DesignerVO designerVO = this.getDataSetDesignerService().findDataSource(groupID, groupName, dataSourceID, dbsourcename, userID);
        return (KSQLReportInfo)DesignerVOTranslator.decode((DesignerVO)designerVO);
    }

    public List<Map<String, String>> getOutDBList() throws Exception {
        List<DesignerVO> outDBList = this.getDataSetDesignerService().getOutDBList();
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        Iterator<DesignerVO> iter = outDBList.iterator();
        while (iter.hasNext()) {
            HashMap db = (HashMap)DesignerVOTranslator.decode((DesignerVO)iter.next());
            String dbType = (String)db.get("dbtype");
            if (DataCenterDBType.getDBType((String)dbType) == null) continue;
            ret.add(db);
        }
        return ret;
    }

    public List<String> getSuperQuerySchemas() throws Exception {
        return this.getDataSetDesignerService().getSuperQuerySchemas();
    }

    public Map<String, String> getOutDBByDBName(String dbname) throws Exception {
        DesignerVO outDBList = this.getDataSetDesignerService().getOutDBByDBName(dbname);
        HashMap db = (HashMap)DesignerVOTranslator.decode((DesignerVO)outDBList);
        String dbType = (String)db.get("dbtype");
        if (DataCenterDBType.getDBType((String)dbType) != null) {
            return db;
        }
        return null;
    }

    public int checkDataSourceTouchable(String userId, String dbName) throws Exception {
        return this.getDataSetDesignerService().checkDataSourceTouchable(userId, dbName);
    }

    public String loadDataSetCreatorIdById(String dataSetID) throws Exception {
        return this.getDataSetDesignerService().loadDataSetCreatorIdById(dataSetID);
    }

    public String loadExtReportGroupFullPathById(String groupId) throws Exception {
        return this.getDataSetDesignerService().loadExtReportGroupFullPathById(groupId);
    }

    public String loadCreatorNameById(String creatorId) throws Exception {
        return this.getDataSetDesignerService().loadCreatorNameById(creatorId);
    }

    public String saveOrUpdate(KSQLReportInfo info) {
        throw new UnsupportedOperationException();
    }

    public IKBISubSystemTreeNode getSubSystemTree() throws Exception {
        List<DesignerVO> designerVOs = this.getDataSetDesignerService().getSubSystemTree();
        IBriefViewTreeNode ret = null;
        ret = (IBriefViewTreeNode)DesignerVOTranslator.decode((DesignerVO)designerVOs.get(0));
        return ret;
    }

    public IKBISubSystemTreeNode getSubSystemPresetTree() throws Exception {
        List<DesignerVO> designerVOs = this.getDataSetDesignerService().getSubSystemPresetTree();
        IBriefViewTreeNode ret = null;
        ret = (IBriefViewTreeNode)DesignerVOTranslator.decode((DesignerVO)designerVOs.get(0));
        return ret;
    }

    public ResultSet findUserOrgScopeInfo() {
        List<DesignerVO> queryList = this.getDataSetDesignerService().findUserOrgScopeInfo();
        return ResultSetFactory.createResultSet(queryList);
    }

    public String findInnerExtDSOutDBID(String reportId, String datasetAlias) {
        throw new UnsupportedOperationException();
    }

    public void releaseLock() {
        throw new UnsupportedOperationException();
    }

    public ISQLDesignerContext getContext() {
        throw new UnsupportedOperationException();
    }

    public boolean checkDBCenterPermission() {
        return this.getDataSetDesignerDomain().checkDBCenterPermission();
    }

    public boolean checkDBCenterPermissionByUserId(String userId) {
        return this.getDataSetDesignerDomain().checkDBCenterPermissionByUserId(userId);
    }

    public boolean checkDataSetIsPreset(String dataSetId) {
        return this.getDataSetDesignerDomain().checkDataSetIsPreset(dataSetId);
    }

    public boolean checkPresetManagePermission() {
        return this.getDataSetDesignerDomain().checkPresetManagePermission();
    }

    public Map<String, String> getBizMetaDBInfo(String dataCenterName) throws DataCenterNoPermissionException {
        DesignerVO bizMetaDBInfo = this.getDataSetDesignerDomain().getBizMetaDBInfo(dataCenterName);
        HashMap returnMap = (HashMap)DesignerVOTranslator.decode((DesignerVO)bizMetaDBInfo);
        return returnMap;
    }

    public int checkEntityPermissionByUserId(String creatorId, String entityName) {
        boolean isSupportQing;
        boolean hasPermission;
        try {
            hasPermission = EntityHelper.hasPermission((long)Long.parseLong(creatorId), (String)entityName);
            isSupportQing = EntityHelper.isSupportQingAnalysis((String)entityName);
        }
        catch (DataSetException e) {
            return 2;
        }
        if (!hasPermission) {
            return 1;
        }
        if (!isSupportQing) {
            return 3;
        }
        return 0;
    }

    public String checkDBCenterAppPerm(String appNumber) {
        try {
            AppUtil.checkAppPerm((String)appNumber);
        }
        catch (AbstractQingException e) {
            return e.getMessage();
        }
        return null;
    }

    public boolean checkDataSetExecutableById(String dataSetId) {
        return DataSetExecuteChecker.checkDataSetExecutableById(dataSetId);
    }
}

