/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.data.domain;

import com.kingdee.bos.datawizard.edd.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoExisitException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetRejectException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputState;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterAppPermException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.EntityNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.EntityNoSupportQingException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.EntityParseErrorException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.InvalidParamInputException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DataSetDefineModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.tobi.util.ExtFilterParamUtil;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.extreport.utils.JsonUtil;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.bizmeta.AbstractBizMetaSourceDomain;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.report.ext.web.scheme.po.ExtFilterScheme;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.data.exception.RptDataExeException;
import kd.bos.mservice.extreport.data.exception.RptSourceLoadException;
import kd.bos.mservice.extreport.data.model.RptDataSource;
import kd.bos.mservice.extreport.data.model.RptFilterValue;
import kd.bos.mservice.extreport.data.util.RptSourceUtil;
import kd.bos.mservice.extreport.designer.domain.ExtFilterSchemeDomain;
import kd.bos.mservice.extreport.designer.domain.ExtReportDomain;
import kd.bos.mservice.extreport.manage.dao.IExtReportDao;
import kd.bos.mservice.extreport.manage.dao.impl.ExtReportDaoImpl;
import kd.bos.mservice.extreport.runtime.domain.RuntimeDomain;
import kd.bos.mservice.extreport.runtime.exception.DataSetInvalidParamException;
import kd.bos.mservice.extreport.runtime.exception.ExtReportNoPermissionException;
import kd.bos.mservice.qingshared.common.db.DBExcuterImpl;
import kd.bos.mservice.qingshared.common.db.TransactionManagementImpl;

public class RptDataSourceDomain
extends AbstractBizMetaSourceDomain {
    private IDBExcuter dbExecutor;
    private ITransactionManagement tx;
    private ExtReportDomain extReportMetaDomain;
    private CommonPublishDomain commonPublishDomain;
    private ExtFilterSchemeDomain filterSchemeDomain;
    private IExtReportDao extReportDao;

    private IDBExcuter getDbExecutor() {
        if (this.dbExecutor == null) {
            this.dbExecutor = DBExcuterImpl.getInstance();
        }
        return this.dbExecutor;
    }

    private ITransactionManagement getTx() {
        if (this.tx == null) {
            this.tx = TransactionManagementImpl.getInstance();
        }
        return this.tx;
    }

    private ExtReportDomain getExtReportMetaDomain(QingContext qingContext) {
        if (this.extReportMetaDomain == null) {
            this.extReportMetaDomain = new ExtReportDomain();
            this.extReportMetaDomain.setQingContext(qingContext);
            this.extReportMetaDomain.setTx(this.getTx());
            this.extReportMetaDomain.setDbExcuter(this.getDbExecutor());
        }
        return this.extReportMetaDomain;
    }

    private CommonPublishDomain getCommonPublishDomain(QingContext qingContext) {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(qingContext, this.getTx(), this.getDbExecutor());
        }
        return this.commonPublishDomain;
    }

    private ExtFilterSchemeDomain getFilterSchemeDomain(QingContext qingContext) {
        if (this.filterSchemeDomain == null) {
            this.filterSchemeDomain = new ExtFilterSchemeDomain();
            this.filterSchemeDomain.setQingContext(qingContext);
            this.filterSchemeDomain.setTx(this.getTx());
            this.filterSchemeDomain.setDbExcuter(this.getDbExecutor());
        }
        return this.filterSchemeDomain;
    }

    private IExtReportDao getExtReportDao() {
        if (this.extReportDao == null) {
            this.extReportDao = new ExtReportDaoImpl(this.getDbExecutor());
        }
        return this.extReportDao;
    }

    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException {
        FolderNode root = new FolderNode();
        RptDataSource rptDataSource = (RptDataSource)source;
        String publishId = rptDataSource.getPublishId();
        List<ExtDataSet> dataSetList = this.getDataSetList(qingContext, publishId);
        for (ExtDataSet dataSet : dataSetList) {
            String define = dataSet.getDefine();
            DataSetDefineModel defineModel = DataSetDefineModel.parseDefine((String)define);
            LeafNode leafNode = new LeafNode();
            leafNode.setType("rptDataSet");
            assert (defineModel != null);
            leafNode.setName(dataSet.getName());
            leafNode.setDisplayName(dataSet.getAlias());
            leafNode.setCommentInfo(define);
            leafNode.setId(defineModel.getId());
            root.addChild((AbstractNode)leafNode);
        }
        return root;
    }

    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        ResultSet resultSet = this.doExecuteDataSet(qingContext, runtimeEntity, null);
        if (resultSet != null) {
            try {
                resultSet.last();
                return resultSet.getRow();
            }
            catch (SQLException e) {
                throw new RptDataExeException((Throwable)e);
            }
        }
        return 0L;
    }

    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractSourceException {
        HashMap<String, String> logMap = new HashMap<String, String>(2);
        ResultSet resultSet = this.doExecuteDataSet(qingContext, runtimeEntity, logMap);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        try {
            Map<String, Integer> nameIndexMap = this.makeColumnIndexMap(resultSet.getMetaData());
            while (resultSet.next() && result.size() < rows) {
                Object[] data = RptDataSourceDomain.getOutputData(resultSet, runtimeEntity, nameIndexMap, true);
                result.add(data);
            }
        }
        catch (SQLException e) {
            throw new RptDataExeException((Throwable)e);
        }
        IRuntimeFilter unPushdownFilter = runtimeEntity.getUnPushdownableFilter();
        String unPushdownFilterContent = "";
        if (unPushdownFilter != null) {
            unPushdownFilterContent = unPushdownFilter.getUnpushdownFilterExpress();
        }
        PreviewDataModel previewDataModel = new PreviewDataModel(result);
        String ql = (String)logMap.get("sql");
        if (ql == null) {
            ql = (String)logMap.get("oql");
        }
        previewDataModel.setSqlContent(ql);
        previewDataModel.setUnPushdownFilterContent(unPushdownFilterContent);
        return previewDataModel;
    }

    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String associateName) throws AbstractSourceException {
        RptDataSource rptDataSource = (RptDataSource)source;
        String publishId = rptDataSource.getPublishId();
        List<ExtDataSet> dataSetList = this.getDataSetList(qingContext, publishId);
        ExtDataSet target = null;
        DataSetDefineModel defineModel = null;
        String define = null;
        for (ExtDataSet dataSet : dataSetList) {
            define = dataSet.getDefine();
            defineModel = DataSetDefineModel.parseDefine((String)define);
            if (!defineModel.getId().equals(associateName)) continue;
            target = dataSet;
            break;
        }
        if (target == null) {
            return null;
        }
        Entity entity = RptSourceUtil.buildEntity(target);
        return DesigntimeDataObject.createSingleDataObject((Entity)entity);
    }

    private List<ExtDataSet> getDataSetList(QingContext qingContext, String publishId) throws RptSourceLoadException {
        Book book;
        try {
            PublishPO publishPO = this.getCommonPublishDomain(qingContext).loadPublishInfo(publishId);
            byte[] data = this.getExtReportMetaDomain(qingContext).findReportContentByUuid(publishPO.getTagId());
            book = BookIOUtil.unpack((byte[])data);
        }
        catch (Exception e) {
            throw new RptSourceLoadException((Throwable)e);
        }
        return RptSourceUtil.getExtDataSets((Book)book);
    }

    public void checkSourceLegality(QingContext qingContext, AbstractSource source, List<Entity> entityArrayList, AbstractDataSourceDomain domain) {
        RptDataSource rptDataSource = (RptDataSource)source;
        String publishId = rptDataSource.getPublishId();
        try {
            this.checkPublishedStatus(qingContext, publishId);
        }
        catch (Exception e) {
            this.setEntityErrorState(qingContext, entityArrayList, EntityErrorState.RPT_PUBLISH_NO_PERMISSION);
            return;
        }
        for (Entity entity : entityArrayList) {
            String msg;
            EntityErrorInfo entityErrorInfo;
            CtrlDesignQueryModel model = null;
            try {
                model = KSQLReportBO.initModel((Object)qingContext, (String)entity.getName(), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                ExtReportOutDBBO.checkDataSetByDataSetIdAndModel((Object)qingContext, (CtrlDesignQueryModel)model, (String)entity.getName());
            }
            catch (ExtDataSetNoExisitException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_NOT_EXIST);
                msg = EntityErrorState.RPT_DATASET_NOT_EXIST.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (ExtDataSetNoPermissionException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_NO_PERMISSION);
                msg = EntityErrorState.RPT_DATASET_NO_PERMISSION.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (DataCenterNoPermissionException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_NO_PERMISSION);
                msg = EntityErrorState.RPT_DATASET_NO_PERMISSION.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (DataCenterAppPermException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_NO_PERMISSION);
                msg = EntityErrorState.RPT_DATASET_NO_PERMISSION.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (SuperQueryNoPermissionException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.SUPER_QUERY_NO_SCHEMA_PERM);
                msg = EntityErrorState.SUPER_QUERY_NO_SCHEMA_PERM.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (EntityNoPermissionException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_NO_PERMISSION);
                msg = EntityErrorState.RPT_DATASET_NO_PERMISSION.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (EntityNoSupportQingException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_NO_PERMISSION);
                msg = EntityErrorState.RPT_DATASET_NO_PERMISSION.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (EntityParseErrorException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_NO_PERMISSION);
                msg = EntityErrorState.RPT_DATASET_NO_PERMISSION.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
            catch (ExtDataSetRejectException e) {
                entityErrorInfo = new EntityErrorInfo(EntityErrorState.RPT_DATASET_REJECT);
                msg = EntityErrorState.RPT_DATASET_REJECT.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
        }
    }

    protected boolean isDataFieldUnique(QingContext qingContext, RuntimeEntity runtimeEntity, RuntimeProperty fieldName) {
        return true;
    }

    public String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws DataSourcePersistenceException, AbstractSourceException, InterruptedException {
        ResultSet resultSet = this.doExecuteDataSet(qingContext, runtimeEntity, null);
        ServerRequestInvokeContext serverRequestInvokeContext = ServerRequestInvokeContext.get();
        try {
            Map<String, Integer> nameIndexMap = this.makeColumnIndexMap(resultSet.getMetaData());
            while (resultSet.next()) {
                ServerRequestInvokeContext.staticCheckInterrupt((ServerRequestInvokeContext)serverRequestInvokeContext);
                Object[] data = RptDataSourceDomain.getOutputData(resultSet, runtimeEntity, nameIndexMap, false);
                dataSourceWriter.writeData(data);
                if (progressProcessor != null) {
                    progressProcessor.writeOneRow();
                    if (progressProcessor.isDataLimit()) {
                        return null;
                    }
                }
                if (progressProcessor == null) continue;
                progressProcessor.dealOneRow();
            }
        }
        catch (SQLException e) {
            throw new RptDataExeException((Throwable)e);
        }
        return null;
    }

    private ResultSet doExecuteDataSet(QingContext qingContext, RuntimeEntity entity, Map<String, String> logMap) throws RptDataExeException {
        String dataSetId = entity.getName();
        RptDataSource source = (RptDataSource)entity.getSource();
        return this.doExecuteDataSet(qingContext, dataSetId, source, logMap);
    }

    private ResultSet doExecuteDataSet(QingContext qingContext, String dataSetId, RptDataSource dataSource, Map<String, String> logMap) throws RptDataExeException {
        String filterValues = dataSource.getFilterValues();
        String publishId = dataSource.getPublishId();
        try {
            if (StringUtils.isEmpty((CharSequence)filterValues)) {
                filterValues = this.buildDefaultValues(qingContext, publishId);
            }
            CtrlDesignQueryModel model = KSQLReportBO.initModel((Object)qingContext, (String)dataSetId, null);
            CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
            List parameters = commonQuery.getParameters();
            this.processDefault(qingContext, parameters);
            Map<String, String> valueMap = RuntimeDomain.getParamMap(parameters, filterValues, "value", false);
            Map<String, String> aliasMap = RuntimeDomain.getParamMap(parameters, filterValues, "text", false);
            HashMap<String, DesignParameter> executeParams = new HashMap<String, DesignParameter>(parameters.size());
            for (DesignParameter parameter : parameters) {
                String name = parameter.getName();
                String valueAlias = aliasMap.get(name);
                DesignDataType designDataType = parameter.getDesignDataType();
                String value = valueMap.get(name);
                if (parameter.getInputState() == InputState.HIDDEN) {
                    value = parameter.getDefaultValue();
                }
                if (value == null) {
                    value = parameter.getDefaultValue();
                    valueAlias = parameter.getDefaultAlias();
                }
                try {
                    RunReportParam.isValidInput((DesignParameter)parameter, (String)value);
                }
                catch (InvalidParamInputException e) {
                    throw new DataSetInvalidParamException(e.getMessage(), e.getCause());
                }
                if (value != null) {
                    parameter.setCurentValue(value);
                }
                DesignParameter dp = new DesignParameter();
                dp.setName(name);
                dp.setCurentValue(value);
                dp.setCurentValueAlias(valueAlias);
                dp.setDesignDataType(designDataType);
                executeParams.put(name, dp);
            }
            RunReportParam.getExecuteParam((List)parameters, executeParams);
            RunReportParam.putDefalutListParamsMap((Object)qingContext, executeParams);
            ExtReportOutDBBO.checkDataSetByDataSetIdAndModel((Object)qingContext, (CtrlDesignQueryModel)model, (String)dataSetId);
            Map mapResult = CtrlDesignDataExecutor.execute((Object)qingContext, (CtrlDesignQueryModel)model, executeParams, logMap, (int)0, (int)-1, (boolean)false, null);
            return (ResultSet)mapResult.get("6xx8xxRowset");
        }
        catch (Exception e) {
            throw new RptDataExeException((Throwable)e);
        }
    }

    private void processDefault(QingContext qingContext, List<DesignParameter> parameters) throws CtrlReportException {
        LinkedHashMap mapDesignParameter = new LinkedHashMap();
        RunReportParam.putDefalutListParamsMap((Object)qingContext, mapDesignParameter);
        for (DesignParameter parameter : parameters) {
            RunReportParam.processDefaultValue((Object)qingContext, (DesignParameter)parameter, parameters, mapDesignParameter);
        }
    }

    private Map<String, Integer> makeColumnIndexMap(ResultSetMetaData metaData) throws SQLException {
        int columnCount = metaData.getColumnCount();
        HashMap<String, Integer> nameIndexMap = new HashMap<String, Integer>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            nameIndexMap.put(metaData.getColumnName(i).toUpperCase(), i);
        }
        return nameIndexMap;
    }

    private String buildDefaultValues(QingContext qingContext, String publishId) throws AbstractQingIntegratedException, SQLException, IOException, XmlParsingException {
        String filterXml;
        PublishPO publishPO = this.getCommonPublishDomain(qingContext).loadPublishInfo(publishId);
        if (publishPO == null) {
            return null;
        }
        String filterValues = null;
        ExtFilterScheme lastUseFilterScheme = this.getFilterSchemeDomain(qingContext).findLastUseFilterScheme(publishPO.getTagId());
        if (lastUseFilterScheme != null && StringUtils.isNotEmpty((CharSequence)(filterXml = lastUseFilterScheme.getContent()))) {
            byte[] filterBytes = filterXml.getBytes("utf-8");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(filterBytes);
            IXmlElement fieldsNode = XmlUtil.loadRootElement((InputStream)inputStream);
            List children = fieldsNode.getChildren();
            ArrayList<RptFilterValue> filterValueList = new ArrayList<RptFilterValue>(children.size());
            for (IXmlElement child : children) {
                if (!"field".equals(child.getName())) continue;
                RptFilterValue filterValue = new RptFilterValue();
                String name = child.getAttribute("name");
                String dataType = child.getAttribute("dataType");
                filterValue.setParamName(name);
                DesignDataType designDataType = DesignDataType.getDataType((int)Integer.parseInt(dataType));
                if (designDataType != null) {
                    filterValue.setDataType(ExtFilterParamUtil.translateDataType((DesignDataType)designDataType).name());
                }
                ArrayList<RptFilterValue.ParamValue> paramValues = new ArrayList<RptFilterValue.ParamValue>();
                String value = child.getAttribute("value");
                String valueAlias = child.getAttribute("valueAlias");
                if (value != null && valueAlias != null) {
                    String[] values = value.split("0xx1xx");
                    String[] alias = valueAlias.split("0xx1xx");
                    for (int i = 0; i < values.length; ++i) {
                        RptFilterValue.ParamValue paramValue = new RptFilterValue.ParamValue();
                        paramValue.setValue(values[i]);
                        paramValue.setText(alias[i]);
                        paramValues.add(paramValue);
                    }
                }
                filterValue.setParamVars(paramValues);
                filterValueList.add(filterValue);
            }
            filterValues = JsonUtil.encodeToString(filterValueList);
        }
        return filterValues;
    }

    private static Object[] getOutputData(ResultSet resultSet, RuntimeEntity runtimeEntity, Map<String, Integer> nameIndexMap, boolean isPreview) throws SQLException {
        if (resultSet != null) {
            List outputProperties = runtimeEntity.getOutputProperties();
            int columnSize = outputProperties.size();
            Object[] oneRowData = new Object[columnSize];
            for (int columnIndxe = 0; columnIndxe < columnSize; ++columnIndxe) {
                Object value;
                RuntimeProperty property = (RuntimeProperty)outputProperties.get(columnIndxe);
                Integer index = nameIndexMap.get(property.getName().toUpperCase());
                if (index == null || index < 1 || (value = resultSet.getObject(index)) == null) continue;
                if (isPreview) {
                    if (value instanceof Calendar) {
                        value = ((Calendar)value).getTimeInMillis();
                    } else if (value instanceof Date) {
                        value = ((Date)value).getTime();
                    } else if (value instanceof Long) {
                        value = value.toString();
                    }
                }
                oneRowData[columnIndxe] = value;
            }
            return oneRowData;
        }
        return new Object[0];
    }

    private void checkPublishedStatus(QingContext qingContext, String publishId) throws AbstractQingIntegratedException, SQLException, PublishNotFoundException, ExtReportNoPermissionException {
        PublishPO publishPO = this.getCommonPublishDomain(qingContext).checkPublishExist(publishId);
        ExtReportVO extReportVO = this.getExtReportDao().loadExtReportByID(publishPO.getTagId());
        String creatorId = extReportVO.getCreatorId();
        String systemId = IntegratedHelper.getPresetUserId();
        String msg = null;
        if (!systemId.equals(creatorId)) {
            boolean authRight = this.getCommonPublishDomain(qingContext).checkPublishAuthRight(publishPO);
            if (!authRight) {
                msg = MserviceRptMessages.getLangMessage((II18nContext)qingContext.getIi18nContext(), (String)"reportNotPresetAuthorizedToView", (String)"\u60a8\u6ca1\u6709\u8be5\u53d1\u5e03\u8bb0\u5f55\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002");
            }
        } else if (systemId.equals(creatorId) && !IntegratedHelper.checkExtReportPresetManagePermission((QingContext)qingContext)) {
            msg = MserviceRptMessages.getLangMessage((II18nContext)qingContext.getIi18nContext(), (String)"reportNotPresetAuthorizedToView", (String)"\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u62a5\u8868\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002");
        }
        if (msg != null) {
            throw new ExtReportNoPermissionException(msg);
        }
    }
}

