/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.datasource.processor;

import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.extreport.utils.CloseUtil;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.superquery.SuperQueryNoDbPermException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.exception.FieldDuplicateException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.common.strategy.BatchTransferUtil;
import kd.bos.mservice.extreport.dataset.datasource.processor.AbstractDataSourceProcessor;
import kd.bos.mservice.extreport.dataset.domain.ExtReportDataSetDesignerDomain;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.bo.ParameterBO;
import kd.bos.mservice.extreport.dataset.model.po.SQLDataSetModel;
import kd.bos.mservice.extreport.util.DataSetExecuteChecker;

public abstract class AbstractSQLProcessor
extends AbstractDataSourceProcessor {
    protected ExtReportDataSetDesignerDomain extReportDataSetDesignerDomain;

    protected ExtReportDataSetDesignerDomain getExtReportDataSetDesignerDomain() {
        if (this.extReportDataSetDesignerDomain == null) {
            this.extReportDataSetDesignerDomain = new ExtReportDataSetDesignerDomain(this.context, this.dbExcuter, this.tx);
        }
        return this.extReportDataSetDesignerDomain;
    }

    protected AbstractSQLProcessor(QingContext context, IDBExcuter dbExcuter, ITransactionManagement tx, DataSetModelBO model, Map<String, ParameterBO> parameterMap, boolean isRun) {
        super(context, dbExcuter, tx, model, parameterMap, isRun);
    }

    protected void extractMacros() throws ExtMacroException {
        super.execMacroParams(((SQLDataSetModel)this.modelBO.getDataSetModel()).getSql());
    }

    protected ResultSet doExecute() throws SuperQueryNoPermissionException, DataSetException, AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException, UnSupportDataSourceException {
        ResultSet rs;
        AbstractSource source = this.getExtReportDataSetDesignerDomain().getSource(((SQLDataSetModel)this.modelBO.getDataSetModel()).getDataSourceType(), ((SQLDataSetModel)this.modelBO.getDataSetModel()).getDataSourceName(), this.modelBO.getCreatorId());
        DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource((AbstractSource)source);
        IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource((AbstractSource)source);
        AbstractDBSourceJDBCAdapter jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance((AbstractSource)dbSource);
        jdbcAdapter.setConnectionFactory(connFactory);
        String sql = ((SQLDataSetModel)this.modelBO.getDataSetModel()).getSql();
        try {
            sql = DataSetExecuteChecker.formatSql(sql, this.modelBO.getDataSetID());
            rs = jdbcAdapter.executeQuery(this.context, dbSource, sql, null);
        }
        catch (SuperQueryNoDbPermException e) {
            throw new SuperQueryNoPermissionException((Throwable)e);
        }
        catch (Exception e) {
            throw new DataSetException(MserviceRptMessages.getMLS((String)"sqlExecError", (String)"sql\u6267\u884c\u5f02\u5e38\uff0csql\u5185\u5bb9\uff1a\n#1\u3002").replace("#1", ((SQLDataSetModel)this.modelBO.getDataSetModel()).getSql()), DataSetErrorCodeEnum.SQL_EXEC_EXCEPTION, (Throwable)e);
        }
        try {
            ResultSet e = BatchTransferUtil.createResultSet((ResultSet)rs, (int)this.rows);
            return e;
        }
        catch (FieldDuplicateException e) {
            String fieldName = e.getMessage();
            String errorMessage = DataSetErrorCodeEnum.DUPLICATED_FIELD_NAME_EXCEPTION.getMessage();
            errorMessage = errorMessage.replace("#1", fieldName);
            throw new DataSetException(errorMessage, DataSetErrorCodeEnum.DUPLICATED_FIELD_NAME_EXCEPTION);
        }
        catch (Exception e) {
            throw new DataSetException(MserviceRptMessages.getMLS((String)"sqlParsingExecError", (String)"sql\u89e3\u6790\u6267\u884c\u7ed3\u679c\u5f02\u5e38\u3002"), DataSetErrorCodeEnum.ANALYSIS_RESULTSET_EXCEPTION, (Throwable)e);
        }
        finally {
            CloseUtil.close((ResultSet)rs);
        }
    }
}

