/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.datasource.processor;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import java.io.IOException;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.mservice.extreport.dataset.datasource.param.ParamAnalysisHelper;
import kd.bos.mservice.extreport.dataset.datasource.processor.AbstractSQLProcessor;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.bo.ParameterBO;
import kd.bos.mservice.extreport.dataset.model.po.SQLDataSetModel;

public class DialectSQLProcessor
extends AbstractSQLProcessor {
    private static final Pattern OUTDBLINK_PATTERN = Pattern.compile("[a-z0-9_]+@[a-z0-9_]+", 2);

    public DialectSQLProcessor(QingContext context, IDBExcuter dbExcuter, ITransactionManagement tx, DataSetModelBO model, Map<String, ParameterBO> parameterMap, boolean isRun) {
        super(context, dbExcuter, tx, model, parameterMap, isRun);
    }

    protected void buildContent() throws DataSetException, AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException {
        String sql = super.commonBuild(((SQLDataSetModel)this.modelBO.getDataSetModel()).getSql());
        DBSource.DBType dbType = this.getExtReportDataSetDesignerDomain().getDBType(this.modelBO);
        ArrayList<Map.Entry<String, String>> outDBLinkTables = new ArrayList<Map.Entry<String, String>>(8);
        sql = this.collectOutDBLinkInfo(outDBLinkTables, sql);
        for (Map.Entry entry : this.parameterMap.entrySet()) {
            ParameterBO dp = (ParameterBO)entry.getValue();
            String value = dp.getCurrentValue();
            if (value == null || !value.startsWith("@ExtRpt")) continue;
            dp.setCurrentValue(((ParameterBO)this.parameterMap.get(value.substring(1))).getCurrentValue());
            dp.setCurrentValueAlias(((ParameterBO)this.parameterMap.get(value.substring(1))).getCurrentValueAlias());
        }
        sql = ParamAnalysisHelper.replaceVariantDialect((String)sql, (Map)this.parameterMap, (DBSource.DBType)dbType, (boolean)this.isRun);
        for (Map.Entry entry : outDBLinkTables) {
            sql = sql.replaceFirst((String)entry.getKey(), (String)entry.getValue());
        }
        ((SQLDataSetModel)this.modelBO.getDataSetModel()).setSql(sql);
    }

    private String collectOutDBLinkInfo(List<Map.Entry<String, String>> outDBLinkTables, String sql) {
        StringBuilder temp = new StringBuilder();
        int bIndex = 0;
        Matcher m = OUTDBLINK_PATTERN.matcher(sql);
        while (m.find()) {
            String outDBLink = m.group();
            temp.append(sql, bIndex, m.start());
            temp.append(" ");
            String tmpTableRes = "tmpTableRes" + outDBLink.hashCode();
            temp.append(tmpTableRes);
            temp.append(" ");
            bIndex = m.end();
            AbstractMap.SimpleEntry<String, String> tempTable = new AbstractMap.SimpleEntry<String, String>(tmpTableRes, outDBLink);
            outDBLinkTables.add(tempTable);
        }
        temp.append(sql.substring(bIndex));
        return temp.toString();
    }
}

