/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.datasource.processor;

import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.framework.core.util.Messages;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.ksql.DbType;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.dataset.constant.ParamDataType;
import kd.bos.mservice.extreport.dataset.datasource.DataSourceFactory;
import kd.bos.mservice.extreport.dataset.datasource.db.RptDesignKsqlSolver;
import kd.bos.mservice.extreport.dataset.datasource.db.TimeFilterModel;
import kd.bos.mservice.extreport.dataset.datasource.db.parse.AbstractSQLParser;
import kd.bos.mservice.extreport.dataset.datasource.processor.AbstractSQLProcessor;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.bo.ParameterBO;
import kd.bos.mservice.extreport.dataset.model.po.SQLDataSetModel;
import kd.bos.mservice.extreport.util.StringUtils;
import org.apache.log4j.Logger;

public class KSQLProcessor
extends AbstractSQLProcessor {
    private static final Logger logger = Logger.getLogger(KSQLProcessor.class);
    private static final String BEGIN_0XX_1XX = "BEGIN0XX1XX";
    private static final String END_0XX_1XX = " OR (END0XX1XX IS NULL)";

    public KSQLProcessor(QingContext context, IDBExcuter dbExcuter, ITransactionManagement tx, DataSetModelBO model, Map<String, ParameterBO> parameterMap, boolean isRun) {
        super(context, dbExcuter, tx, model, parameterMap, isRun);
    }

    protected void buildContent() throws DataSetException, AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException {
        String ksql = super.commonBuild(((SQLDataSetModel)this.modelBO.getDataSetModel()).getSql());
        DBSource.DBType dbType = this.getExtReportDataSetDesignerDomain().getDBType(this.modelBO);
        HashMap<String, String> dateTypeMap = new HashMap<String, String>(8);
        ksql = this.recordTempDate(ksql, dateTypeMap);
        try {
            ksql = RptDesignKsqlSolver.solve((String)ksql, (Map)this.parameterMap, dateTypeMap, (DBSource.DBType)dbType);
            for (String key : dateTypeMap.keySet()) {
                ParameterBO parameterBO = (ParameterBO)this.parameterMap.get(key);
                parameterBO.setCurrentValue("");
            }
        }
        catch (Exception e) {
            String message;
            logger.error((Object)("Occur error when build ksql: " + e.getMessage()), (Throwable)e);
            if (e.getCause() != null && (message = e.getCause().getMessage()).contains("ksql disable select *")) {
                throw new DataSetException(DataSetErrorCodeEnum.KSQL_DISABLE_SELECT_ALL_EXCEPTION);
            }
            throw new DataSetException(Messages.getMLS((String)"failParseSQL", (String)"\u89e3\u6790SQL\u8bed\u53e5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7b26\u5408KSQL\u8bed\u6cd5") + e.getMessage(), (Throwable)e);
        }
        if (!(ksql = this.parseTime(dbType, ksql)).startsWith("/*dialect*/")) {
            try {
                ksql = "/*dialect*/" + TransUtil.translate((String)ksql, (int)DbType.getValue((String)dbType.name()));
            }
            catch (SqlTranslateException e) {
                logger.error((Object)("Occur error when translate ksql: " + e.getMessage()), (Throwable)e);
                throw new DataSetException(Messages.getMLS((String)"failTranslateKSQLToExternalDataCenter", (String)"\u8fde\u63a5\u5230\u5916\u90e8\u6570\u636e\u4e2d\u5fc3\u7684KSQL\u7ffb\u8bd1\u5931\u8d25") + e.getMessage(), (Throwable)e);
            }
        }
        ((SQLDataSetModel)this.modelBO.getDataSetModel()).setSql(ksql);
    }

    private String parseTime(DBSource.DBType dbType, String ksql) throws DataSetException {
        int beginInd = ksql.indexOf(BEGIN_0XX_1XX);
        if (beginInd == -1) {
            return ksql;
        }
        try {
            ksql = "/*dialect*/" + TransUtil.translate((String)ksql, (int)DbType.getValue((String)dbType.name()));
        }
        catch (SqlTranslateException e) {
            throw new DataSetException(MserviceRptMessages.getMLS((String)"KSQLTransError", (String)"KSQL\u7ffb\u8bd1\u5931\u8d25\u3002") + e.getMessage(), (Throwable)e);
        }
        return this.filter(dbType, ksql);
    }

    public String filter(DBSource.DBType dbType, String sql) {
        int beginInd = sql.toUpperCase().indexOf(BEGIN_0XX_1XX);
        AbstractSQLParser sqlParse = DataSourceFactory.getSQLParse((DBSource.DBType)dbType);
        while (beginInd != -1) {
            StringBuilder where = new StringBuilder();
            int endInd = sql.toUpperCase().indexOf(END_0XX_1XX);
            String temp = sql.substring(beginInd, endInd).trim();
            String sourceReplace = sql.substring(beginInd, endInd + END_0XX_1XX.length());
            String calcStr = CtrlDesignUtil.getCalcStr((String)temp);
            String[] arr = CtrlDesignUtil.splitByCalcStr((String)temp, (String)calcStr);
            String field = arr[0];
            if (field.contains("\".")) {
                temp = sql.substring(beginInd - 1, endInd).trim();
                sourceReplace = sql.substring(beginInd - 1, endInd + END_0XX_1XX.length());
            }
            arr = CtrlDesignUtil.splitByCalcStr((String)temp, (String)calcStr);
            field = StringUtils.replaceFirst((String)arr[0], (String)BEGIN_0XX_1XX, (String)"");
            arr[2] = CtrlDesignUtil.filterToDateStr((String)arr[2].toUpperCase());
            sqlParse.appendFilter(where, new TimeFilterModel(field, arr[1], arr[2]));
            sql = StringUtils.replaceFirst((String)sql, (String)sourceReplace, (String)where.toString());
            beginInd = sql.toUpperCase().indexOf(BEGIN_0XX_1XX);
        }
        return sql;
    }

    private String recordTempDate(String content, Map<String, String> dateTypeMap) {
        String sqlNoSpace = StringUtils.removeSpace((String)content).toLowerCase(Locale.ENGLISH);
        Set paramEntries = this.parameterMap.entrySet();
        for (Map.Entry entry : paramEntries) {
            String name = (String)entry.getKey();
            ParameterBO param = (ParameterBO)entry.getValue();
            boolean ignoreNull = param.getParameter().isIgnoreNull();
            String value = StringUtils.getObjectString((Object)param.getCurrentValue());
            boolean isDateTime = false;
            param.setCurrentValue(value);
            ParamDataType dataType = param.getParameter().getDataType();
            if (dataType.getType() == ParamDataType.DATE.getType()) {
                boolean isDateToDateTime = sqlNoSpace.contains("{ts'@" + name.toLowerCase() + "'}");
                isDateTime = true;
                if (StringUtils.isEmpty((CharSequence)value) && ignoreNull) {
                    dateTypeMap.put(name, null);
                } else if (isDateToDateTime && !value.endsWith("01:02:03")) {
                    value = value + " " + "01:02:03";
                    param.setCurrentValue(value);
                }
            } else if (dataType.getType() == ParamDataType.DATETIME.getType()) {
                isDateTime = true;
                if (StringUtils.isEmpty((CharSequence)value)) {
                    value = "";
                    param.setCurrentValue(value);
                    if (ignoreNull) {
                        dateTypeMap.put(name, null);
                    }
                }
            } else if (dataType.getType() == ParamDataType.TIME.getType()) {
                if (StringUtils.isEmpty((CharSequence)value) && ignoreNull) {
                    dateTypeMap.put(name, null);
                }
                isDateTime = true;
            }
            if (!isDateTime) continue;
            String oldvalue = "'@" + name + "'";
            String newValue = "'" + value + "'";
            if (StringUtils.isEmpty((CharSequence)param.getCurrentValue())) {
                oldvalue = "{ts" + oldvalue + "}";
                newValue = "NULL";
            }
            content = StringUtils.replace((String)content, (String)oldvalue, (String)newValue);
        }
        return content;
    }
}

