/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.datasource.processor;

import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.common.strategy.BatchTransferUtil;
import kd.bos.mservice.extreport.dataset.constant.ParamDataType;
import kd.bos.mservice.extreport.dataset.datasource.param.ParamAnalysisHelper;
import kd.bos.mservice.extreport.dataset.datasource.processor.AbstractDataSourceProcessor;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.bo.ParameterBO;
import kd.bos.mservice.extreport.dataset.model.po.OQLDataSetModel;
import kd.bos.mservice.extreport.util.DataSetExecuteChecker;
import kd.bos.mservice.extreport.util.StringUtils;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.oql.q.expr.QInfo;

public class OQLProcessor
extends AbstractDataSourceProcessor {
    public OQLProcessor(QingContext context, IDBExcuter dbExcuter, ITransactionManagement tx, DataSetModelBO model, Map<String, ParameterBO> parameterMap, boolean isRun) {
        super(context, dbExcuter, tx, model, parameterMap, isRun);
    }

    protected void buildContent() throws DataSetException {
        OQLDataSetModel oqlDataSetModel = (OQLDataSetModel)this.modelBO.getDataSetModel();
        String oql = super.commonBuild(oqlDataSetModel.getOql());
        oql = this.mockEmptyParam(oql);
        oql = this.applyParameterMap(oql);
        oqlDataSetModel.setOql(oql);
    }

    protected ResultSet doExecute() throws DataSetException {
        String oql = ((OQLDataSetModel)this.modelBO.getDataSetModel()).getOql();
        try {
            QInfo qInfo = QInfo.parse((String)oql, (boolean)false);
            if (this.rows != -1 && (qInfo.getTop() == -1 || qInfo.getTop() > this.rows)) {
                qInfo.setTop(this.rows);
            }
            oql = DataSetExecuteChecker.formatSql(qInfo.toString(), this.modelBO.getDataSetID());
        }
        catch (Exception e) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.context.getIi18nContext(), (String)"failedToParseOql", (String)"\u89e3\u6790OQL\u5931\u8d25");
            throw new DataSetException(msg, DataSetErrorCodeEnum.USABLE_ENTITIES_PARSE_EXCEPTION, (Throwable)e);
        }
        DataSet dataset = null;
        try {
            ORMImpl ormImpl = new ORMImpl();
            dataset = ormImpl.queryDataSet(UUID.randomUUID().toString(), oql, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message.contains("duplicate field")) {
                String[] messages = e.getMessage().split("\"");
                String fieldName = messages[messages.length - 1];
                String errorMessage = DataSetErrorCodeEnum.DUPLICATED_FIELD_NAME_EXCEPTION.getMessage();
                errorMessage = errorMessage.replace("#1", fieldName);
                throw new DataSetException(errorMessage, DataSetErrorCodeEnum.DUPLICATED_FIELD_NAME_EXCEPTION);
            }
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.context.getIi18nContext(), (String)"failedToExecuteOQL", (String)"\u6267\u884cOQL\u5931\u8d25");
            throw new DataSetException(msg + ",oql content:\n" + oql, DataSetErrorCodeEnum.OQL_EXEC_EXCEPTION, (Throwable)e);
        }
        catch (Exception e) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.context.getIi18nContext(), (String)"failedToExecuteOQL", (String)"\u6267\u884cOQL\u5931\u8d25");
            throw new DataSetException(msg + ",oql content:\n" + oql, DataSetErrorCodeEnum.OQL_EXEC_EXCEPTION, (Throwable)e);
        }
        try {
            ResultSet e = BatchTransferUtil.createResultSet((DataSet)dataset);
            return e;
        }
        catch (Exception e) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.context.getIi18nContext(), (String)"failedToParseDataSet", (String)"\u89e3\u6790DataSet\u5931\u8d25");
            throw new DataSetException(msg, DataSetErrorCodeEnum.ANALYSIS_RESULTSET_EXCEPTION, (Throwable)e);
        }
        finally {
            if (dataset != null) {
                dataset.close();
            }
        }
    }

    protected void extractMacros() throws ExtMacroException {
        super.execMacroParams(((OQLDataSetModel)this.modelBO.getDataSetModel()).getOql());
    }

    private String mockEmptyParam(String oql) {
        while (oql.indexOf(64) != -1) {
            int startPos = oql.indexOf("@");
            String oAfter = oql.substring(startPos + 1);
            String paramName = ParamAnalysisHelper.getRealParamNameBySymbol((String)("@" + oAfter), (char)'@');
            String cachedParamName = ParamAnalysisHelper.containsKeyIgnoreCase((Map)this.parameterMap, (String)paramName);
            if (StringUtils.isEmpty((CharSequence)cachedParamName)) {
                ParameterBO parameterBO = ParamAnalysisHelper.mockParam((String)paramName);
                this.parameterMap.put(paramName, parameterBO);
                this.parameterMap.put(paramName + "_text", parameterBO);
            }
            oql = oql.replaceFirst("@", "3xx4xx");
        }
        return oql.replaceAll("3xx4xx", "@");
    }

    private String applyParameterMap(String content) throws DataSetException {
        int index = -1;
        while (content.indexOf("@") > index) {
            index = content.indexOf("@");
            String oqlBefore = content.substring(0, index + 1);
            String oqlAfter = content.substring(index + 1);
            String paramName = ParamAnalysisHelper.getRealParamNameBySymbol((String)("@" + oqlAfter), (char)'@');
            String paramKey = ParamAnalysisHelper.containsKeyIgnoreCase((Map)this.parameterMap, (String)paramName);
            ++index;
            ParameterBO param = null;
            if (StringUtils.isNotEmpty((CharSequence)paramKey)) {
                param = (ParameterBO)this.parameterMap.get(paramKey);
            }
            if (param == null) continue;
            content = oqlBefore + this.processOqlIgnoreNull(oqlAfter, param);
            String curentValue = param.getCurrentValue();
            if (curentValue == null) {
                curentValue = "";
            }
            String replaceString = "";
            if (StringUtils.isEmpty((CharSequence)curentValue)) {
                if (ParamDataType.TXT.getType() != param.getParameter().getDataType().getType()) {
                    replaceString = "null";
                }
                content = StringUtils.replaceFirst((String)content, (String)("@" + paramName), (String)replaceString);
                continue;
            }
            if (curentValue.contains("0xx1xx")) {
                content = this.appendMultiParams(content, "@" + paramName, param, oqlBefore, oqlAfter);
                continue;
            }
            content = this.appendSingleParam(content, "@" + paramName, param);
        }
        return content.replace("'null'", "null");
    }

    private String appendSingleParam(String content, String replaceValue, ParameterBO param) {
        StringBuilder valueString = new StringBuilder();
        ParamDataType dataType = param.getParameter().getDataType();
        switch (dataType) {
            case DATE: 
            case DATETIME: {
                valueString.append("to_date('").append(param.getCurrentValue()).append("')");
                break;
            }
            case TIME: {
                valueString.append("to_date('1970-01-01 ").append(param.getCurrentValue()).append("')");
                break;
            }
            default: {
                valueString.append(param.getCurrentValue());
            }
        }
        return StringUtils.replaceFirst((String)content, (String)replaceValue, (String)valueString.toString());
    }

    private String appendMultiParams(String content, String replaceValue, ParameterBO param, String oqlBefore, String oqlAfter) {
        String currentValue = param.getCurrentValue();
        String[] valueList = currentValue.split("0xx1xx");
        boolean hasComma = false;
        if (oqlBefore.contains("('@") && oqlAfter.contains("'")) {
            hasComma = true;
        }
        if (currentValue.endsWith("0xx1xx") && hasComma) {
            valueList = Arrays.copyOf(valueList, valueList.length + 1);
            valueList[valueList.length - 1] = "";
        }
        StringBuilder valueString = new StringBuilder();
        for (int index = 0; index < valueList.length; ++index) {
            ParamDataType dataType = param.getParameter().getDataType();
            String value = valueList[index];
            if (StringUtils.isEmpty((CharSequence)value) && ParamDataType.TXT.getType() != dataType.getType()) {
                value = "null";
            }
            switch (dataType) {
                case TXT: {
                    if (hasComma) {
                        if (index == 0) {
                            valueString.append(value).append("'");
                            break;
                        }
                        if (index < valueList.length - 1) {
                            valueString.append("'").append(value).append("'");
                            break;
                        }
                        valueString.append("'").append(value);
                        break;
                    }
                    valueString.append(value);
                    break;
                }
                case DATE: 
                case DATETIME: {
                    valueString.append("to_date('").append(value).append("')");
                    break;
                }
                case TIME: {
                    valueString.append("to_date('1970-01-01 ").append(value).append("')");
                    break;
                }
                default: {
                    valueString.append(value);
                }
            }
            if (index >= valueList.length - 1) continue;
            valueString.append(",");
        }
        return StringUtils.replaceFirst((String)content, (String)replaceValue, (String)valueString.toString());
    }

    private String processOqlIgnoreNull(String oqlAfter, ParameterBO param) throws DataSetException {
        boolean isFindIgnoreTag = false;
        int wh = oqlAfter.indexOf("?");
        int art = oqlAfter.indexOf("@");
        if (wh != -1 && art != -1 && wh < art || wh != -1 && art == -1) {
            isFindIgnoreTag = true;
        }
        if (isFindIgnoreTag) {
            oqlAfter = StringUtils.isEmpty((CharSequence)param.getCurrentValue()) ? StringUtils.replaceFirst((String)oqlAfter, (String)" ? ", (String)" null ") : StringUtils.replaceFirst((String)oqlAfter, (String)" ? ", (String)" \"0\" ");
        }
        if (!isFindIgnoreTag && !param.getParameter().getCtrl().isRequired() && param.getParameter().isIgnoreNull()) {
            throw new DataSetException(MserviceRptMessages.getMLS((String)"allowEmptyTips", (String)"\u65b9\u8a00dialect\u67e5\u8be2\u7684Where\u5b50\u53e5\uff0c\u5982\u679c\u53c2\u6570\u5141\u8bb8\u7a7a\uff0c\u4e3a\u8fbe\u5230\u5ffd\u7565\u53c2\u6570\u7684\u76ee\u7684\uff0c\u8bf7\u52a0\u5165\" or ? = null\""));
        }
        return oqlAfter;
    }
}

