/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.domain;

import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.framework.sysvar.vo.SystemVariant;
import com.kingdee.bos.framework.sysvar.vo.SystemVariantDataType;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBTableCreator;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.SuperQuerySource;
import com.kingdee.bos.qing.data.model.runtime.Field;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.dbmanage.domain.DBConnectionDomain;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.dbmanage.model.DBConnectionPO;
import com.kingdee.bos.qing.macro.model.vo.PreviewData;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.common.util.ThreadLocalUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.dataset.constant.DataSetModeCheckInfo;
import kd.bos.mservice.extreport.dataset.constant.DataSetModelCheckType;
import kd.bos.mservice.extreport.dataset.constant.DataSetType;
import kd.bos.mservice.extreport.dataset.constant.DataSourceType;
import kd.bos.mservice.extreport.dataset.constant.OutputColumnDataType;
import kd.bos.mservice.extreport.dataset.constant.SqlType;
import kd.bos.mservice.extreport.dataset.datasource.DataSetProcessor;
import kd.bos.mservice.extreport.dataset.datasource.param.ParamExecutor;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.ModelCacheUtil;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.bo.ParameterBO;
import kd.bos.mservice.extreport.dataset.model.check.DataSetModelCheckResult;
import kd.bos.mservice.extreport.dataset.model.check.DataSetModelCheckerChain;
import kd.bos.mservice.extreport.dataset.model.check.impl.DataSourceCheckerFactory;
import kd.bos.mservice.extreport.dataset.model.entity.EntityHelper;
import kd.bos.mservice.extreport.dataset.model.entity.EntityMeta;
import kd.bos.mservice.extreport.dataset.model.entity.EntityPreviewData;
import kd.bos.mservice.extreport.dataset.model.po.AbstractDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.DatSetModelFactory;
import kd.bos.mservice.extreport.dataset.model.po.OQLDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.SQLDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.outputcolumn.OutputColumn;
import kd.bos.mservice.extreport.dataset.model.vo.DataSourceCheckerVO;
import kd.bos.mservice.extreport.dataset.model.vo.DataSourceTableObjectVO;
import kd.bos.mservice.extreport.dataset.model.vo.DatasetModelVO;
import kd.bos.mservice.extreport.dataset.model.vo.FieldNode;
import kd.bos.mservice.extreport.dataset.model.vo.OutDBVO;
import kd.bos.mservice.extreport.designer.domain.DataSetDesignerDomain;
import kd.bos.mservice.extreport.designer.var.SystemVar;
import kd.bos.mservice.extreport.designer.var.VarAdapter;
import kd.bos.mservice.extreport.manage.domain.DataSetManageDomain;
import kd.bos.mservice.extreport.manage.model.DataSetVO;
import kd.bos.mservice.extreport.util.DataCenterUtil;
import kd.bos.mservice.qing.data.model.ERPCloudDBCenterSource;
import kd.bos.mservice.qing.util.IntegratedHelperImpl;
import kd.bos.mservice.qingshared.customservice.BizSourceConversionStrategyImpl;

public class ExtReportDataSetDesignerDomain
implements IDBAccessable,
IQingContextable {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private DataSetDesignerDomain dataSetDesignerDomain;
    private DataSetManageDomain dataSetManageDomain;
    private DBConnectionDomain dbConnectionDomain;
    private DataSetModelCheckerChain dataSetModelCheckerChain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public ExtReportDataSetDesignerDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    public DataSetDesignerDomain getDataSetDesignerDomain() {
        if (this.dataSetDesignerDomain == null) {
            this.dataSetDesignerDomain = new DataSetDesignerDomain();
            this.dataSetDesignerDomain.setDbExcuter(this.dbExcuter);
            this.dataSetDesignerDomain.setTx(this.tx);
            this.dataSetDesignerDomain.setQingContext(this.qingContext);
        }
        return this.dataSetDesignerDomain;
    }

    public DataSetManageDomain getDataSetManageDomain() {
        if (this.dataSetManageDomain == null) {
            this.dataSetManageDomain = new DataSetManageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.dataSetManageDomain;
    }

    private DBConnectionDomain getDBConnectionDomain() {
        if (this.dbConnectionDomain == null) {
            this.dbConnectionDomain = new DBConnectionDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.dbConnectionDomain;
    }

    private DataSetModelCheckerChain getDataSetModelCheckerChain() {
        if (this.dataSetModelCheckerChain == null) {
            this.dataSetModelCheckerChain = new DataSetModelCheckerChain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.dataSetModelCheckerChain;
    }

    public DatasetModelVO loadModel(String dataSetId) throws Exception {
        DatasetModelVO datasetModelVO = new DatasetModelVO();
        AbstractDataSetModel dataSetModel = this.initDataSetModel(dataSetId);
        datasetModelVO.setDataSetModel(dataSetModel);
        ThreadLocalUtil.set((String)"colChangeCheck", (Object)true);
        Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkResultMap = this.checkModel(dataSetId, dataSetModel);
        ThreadLocalUtil.remove((String)"colChangeCheck");
        datasetModelVO.setCheckResult(checkResultMap);
        return datasetModelVO;
    }

    public AbstractDataSetModel saveModel(String dataSetId, String modelCacheId, AbstractDataSetModel dataSetModel) throws Exception {
        String message;
        DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetId);
        if (dataSetVO == null) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_NOT_FOUND_EXCEPTION);
        }
        Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkTypeSetMap = this.checkModel(this.initDataSetModelBO(dataSetVO, dataSetModel), true);
        if (MapUtils.isNotEmpty(checkTypeSetMap) && (message = this.getErrorMessage(checkTypeSetMap)) != null) {
            throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_CHECK_EXCEPTION);
        }
        List<OutputColumn> outputColumnList = this.getOutputColumns(this.initDataSetModelBO(dataSetVO, dataSetModel), false);
        dataSetModel.setOutputColumns(outputColumnList);
        dataSetModel.setDataSetName(dataSetVO.getDataSetName());
        IXmlElement xmlNode = dataSetModel.toXml(this.qingContext, this.dbExcuter, this.tx);
        byte[] data = XmlUtil.toByteArray((IXmlElement)xmlNode);
        ExtReportVO extReportVO = new ExtReportVO();
        extReportVO.setExtReportID(dataSetId);
        extReportVO.setExtReportName(dataSetVO.getDataSetName());
        extReportVO.setExtReportGroupID(dataSetVO.getDataSetGroupID());
        extReportVO.setDataSetType(dataSetVO.getType());
        extReportVO.setDescription(dataSetVO.getDescription());
        this.getDataSetManageDomain().saveOrUpdate(extReportVO, data, this.qingContext.getUserId());
        dataSetModel = this.initDataSetModel(dataSetId);
        if (StringUtils.isNotEmpty((CharSequence)modelCacheId)) {
            ModelCacheUtil.updateCacheModel((String)modelCacheId, (AbstractDataSetModel)dataSetModel);
        }
        return dataSetModel;
    }

    private String getErrorMessage(Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkTypeSetMap) {
        if (checkTypeSetMap.containsKey((Object)DataSetModelCheckType.AVAILABLE)) {
            checkTypeSetMap.remove((Object)DataSetModelCheckType.AVAILABLE);
        }
        if (MapUtils.isNotEmpty(checkTypeSetMap)) {
            return checkTypeSetMap.values().iterator().next().iterator().next().getMessage();
        }
        return null;
    }

    public Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkModel(String dataSetId, AbstractDataSetModel dataSetModel) throws Exception {
        return this.checkModel(this.initDataSetModelBO(dataSetId, dataSetModel), false);
    }

    private Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkModel(DataSetModelBO dataSetModelBO, boolean suspendable) throws Exception {
        EnumMap<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkResult = new EnumMap<DataSetModelCheckType, Set<DataSetModelCheckResult>>(DataSetModelCheckType.class);
        DataSetModelCheckerChain thisDataSetModelCheckerChain = this.getDataSetModelCheckerChain();
        thisDataSetModelCheckerChain.setSuspendable(suspendable);
        thisDataSetModelCheckerChain.checkModel(dataSetModelBO, checkResult);
        return checkResult;
    }

    public boolean checkDataCenterPermission(String dataSetId) {
        return this.getDataSetDesignerDomain().checkDBCenterPermissionByUserId(this.qingContext.getUserId()) || this.getDataSetDesignerDomain().checkDataSetIsPreset(dataSetId);
    }

    public DataSourceCheckerVO checkDataSourcePermission(String appId, String dataSetId) throws IntegratedRuntimeException {
        DataSourceCheckerVO dataSourceCheckerVO = new DataSourceCheckerVO();
        boolean hasDBManagePerm = IntegratedHelper.checkDBManagePermission((QingContext)this.qingContext, (String)appId);
        dataSourceCheckerVO.setHasDBManagePerm(hasDBManagePerm);
        boolean hasDataCenterPerm = this.checkDataCenterPermission(dataSetId);
        dataSourceCheckerVO.setHasDataCenterPerm(hasDataCenterPerm);
        Map<String, String> schemas = null;
        try {
            schemas = this.getSuperQuerySchemaList();
            dataSourceCheckerVO.setSchemas(schemas);
            dataSourceCheckerVO.setHasSuperQuerySchema(MapUtils.isNotEmpty(schemas));
        }
        catch (AbstractQingException e) {
            dataSourceCheckerVO.setHasSuperQuerySchema(false);
            if (e.getErrorCode() == 3201007) {
                dataSourceCheckerVO.setSuperQueryNotDeployed(true);
            }
        }
        catch (Exception ignore) {
            dataSourceCheckerVO.setHasSuperQuerySchema(false);
        }
        return dataSourceCheckerVO;
    }

    public List<OutDBVO> getOutDBList() throws DataSetException {
        List dbConnections = null;
        try {
            dbConnections = this.getDBConnectionDomain().loadDBConnections(this.qingContext.getUserId());
        }
        catch (Exception e) {
            throw new DataSetException((Throwable)e);
        }
        ArrayList<OutDBVO> outDBList = new ArrayList<OutDBVO>(dbConnections.size());
        int serialNo = 1;
        for (DBConnection dbConnection : dbConnections) {
            OutDBVO outDBVO = new OutDBVO();
            outDBVO.setName(dbConnection.getName());
            outDBVO.setId(dbConnection.getId());
            AbstractSource source = dbConnection.getDbSource();
            if (source instanceof DBSource) {
                DBSource dbsource = (DBSource)source;
                DBSource.DBType type = dbsource.getDbType();
                String dbTypeStr = this.getDBTypeStr(type);
                if (StringUtils.isEmpty((CharSequence)dbTypeStr)) continue;
                outDBVO.setDbType(dbTypeStr);
                outDBVO.setAddress(dbsource.getDbAddress() + ":" + dbsource.getDbPort() + ":" + dbsource.getDbName());
                outDBVO.setUserName(dbsource.getUserName());
            } else if (source instanceof SuperQuerySource) {
                SuperQuerySource dataSource = (SuperQuerySource)source;
                outDBVO.setDbType("superQuery");
                outDBVO.setAddress(dataSource.getDbAddress());
                outDBVO.setUserName(dataSource.getUserName());
            }
            outDBVO.setSerialNo(serialNo++);
            outDBList.add(outDBVO);
        }
        return outDBList;
    }

    public void checkOutDBByName(String name) throws AbstractQingIntegratedException, SQLException, DataSetException {
        int result = this.getDataSetDesignerDomain().checkDataSourceTouchable(this.qingContext.getUserId(), name);
        if (result == 8099002) {
            String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION1.getMessage().replace("#1", name);
            throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION1);
        }
        if (result == 8099007) {
            String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION2.getMessage().replace("#1", name);
            throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION2);
        }
    }

    public Map<String, String> getSuperQuerySchemaList() throws AbstractSourceException, AbstractQingIntegratedException {
        DBSource dbSource = DataCenterUtil.createDBSource((SuperQuerySource)new SuperQuerySource());
        AbstractDBSourceJDBCAdapter jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance((AbstractSource)dbSource);
        jdbcAdapter.setConnectionFactory(BizSourceConversionStrategyImpl.createConnFactory((DBSource)dbSource));
        return jdbcAdapter.getUsableSchemas(this.qingContext, dbSource);
    }

    public AbstractNode getUsableEntities() throws DataSetException {
        return EntityHelper.getUsableEntities((String)this.qingContext.getUserId());
    }

    public EntityPreviewData getEntityPreviewData(String tableName) throws DataSetException {
        String[] path = StringUtils.split((String)tableName, (char)'\u0001');
        if (path.length > 2) {
            return EntityHelper.queryEntityData((String)path[2], (boolean)false);
        }
        return null;
    }

    public long getEntityDataCount(String tableName) throws DataSetException {
        String[] path = StringUtils.split((String)tableName, (char)'\u0001');
        if (path.length > 2) {
            EntityPreviewData entityPreviewData = EntityHelper.queryEntityData((String)path[2], (boolean)true);
            return entityPreviewData.getTotalRowCount();
        }
        return 0L;
    }

    public DataSourceTableObjectVO getUsableTableObject(String dataSetId, AbstractDataSetModel dataSetModel) throws AbstractQingException, SQLException, XmlParsingException, IOException {
        DataSetType dataSetType = dataSetModel.getDataSetType();
        DataSourceType dataSourceType = null;
        String dataSourceName = null;
        DataSourceTableObjectVO tableObject = new DataSourceTableObjectVO();
        DataSetModelBO dataSetModelBO = this.initDataSetModelBO(dataSetId, dataSetModel);
        this.checkDataSource(dataSetModelBO);
        if (DataSetType.OQL_DATA_SET == dataSetType) {
            OQLDataSetModel oqlDataSetModel = (OQLDataSetModel)dataSetModel;
            dataSourceName = oqlDataSetModel.getEntityName();
            tableObject.setDataSourceNameAlias(dataSourceName);
            EntityMeta entityMeta = EntityHelper.getEntityMeta((String)dataSourceName);
            FolderNode root = entityMeta.getTableNode();
            tableObject.setTableNode((AbstractNode)root);
            if (CollectionUtils.isNotEmpty((Collection)root.getChildren())) {
                tableObject.setDataSourceNameAlias(((AbstractNode)root.getChildren().get(0)).getDisplayName());
            }
        } else if (DataSetType.SQL_DATA_SET == dataSetType) {
            SQLDataSetModel sqlDataSetModel = (SQLDataSetModel)dataSetModel;
            dataSourceType = sqlDataSetModel.getDataSourceType();
            dataSourceName = sqlDataSetModel.getDataSourceName();
            tableObject.setDataSourceNameAlias(dataSourceName);
            AbstractSource source = this.getSource(dataSourceType, dataSourceName, dataSetModelBO.getCreatorId());
            DBSource dbSource = this.getDBSource(source);
            if (source instanceof ERPCloudDBCenterSource) {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)dataSourceName);
                if (appInfo != null) {
                    String appName = appInfo.getName().getLocaleValue();
                    String cloudName = IntegratedHelperImpl.getCloudNameById((String)appInfo.getCloudId());
                    tableObject.setDataSourceNameAlias(cloudName + "/" + appName);
                }
            } else if (source instanceof SuperQuerySource && dataSourceType == DataSourceType.SUPER_QUERY) {
                Map<String, String> schemaList = this.getSuperQuerySchemaList();
                tableObject.setDataSourceNameAlias(schemaList.get(dataSourceName));
            }
            AbstractDBSourceJDBCAdapter jdbcAdapter = this.getDBSourceJDBCAdapter(source, dbSource);
            AbstractNode node = jdbcAdapter.getUsableEntities(this.qingContext, (AbstractSource)dbSource);
            if (node instanceof FolderNode) {
                tableObject.setTableNode(node);
            }
        }
        tableObject.setDataSetType(dataSetType == null ? -1 : dataSetType.getValue());
        tableObject.setDataSourceType(dataSourceType == null ? -1 : dataSourceType.getType());
        tableObject.setDataSourceName(dataSourceName);
        return tableObject;
    }

    public void checkOutDBConnection(DataSetModelBO dataSetModelBO) throws AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException, AbstractSourceException {
        SQLDataSetModel sqlDataSetModel = (SQLDataSetModel)dataSetModelBO.getDataSetModel();
        DataSourceType dataSourceType = sqlDataSetModel.getDataSourceType();
        String dataSourceName = sqlDataSetModel.getDataSourceName();
        AbstractSource source = this.getSource(dataSourceType, dataSourceName, dataSetModelBO.getCreatorId());
        DBSource dbSource = this.getDBSource(source);
        AbstractDBSourceJDBCAdapter jdbcAdapter = this.getDBSourceJDBCAdapter(source, dbSource);
        jdbcAdapter.checkConnection(this.qingContext, (AbstractSource)dbSource);
    }

    public List<AbstractNode> getTableFields(DataSetType dataSetType, DataSourceType dataSourceType, String dataSourceName, List<String> tableNames) throws AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException, UnSupportDataSourceException, AbstractMacroException, AbstractDBSourceException {
        if (DataSetType.SQL_DATA_SET == dataSetType) {
            AbstractSource source = this.getSource(dataSourceType, dataSourceName, this.qingContext.getUserId());
            DBSource dbSource = this.getDBSource(source);
            AbstractDBSourceJDBCAdapter jdbcAdapter = this.getDBSourceJDBCAdapter(source, dbSource);
            ArrayList<AbstractNode> roots = new ArrayList<AbstractNode>(tableNames.size());
            for (String tableName : tableNames) {
                AbstractDBTableCreator dbTableCreator = jdbcAdapter.createDBTableCreator(dbSource, tableName);
                Table qingTable = dbTableCreator.getTablePeer(this.qingContext);
                FolderNode root = new FolderNode();
                root.setName(tableName);
                List qingTableFields = qingTable.getFields();
                qingTableFields.addAll(qingTable.getOtherFields());
                if (!qingTableFields.isEmpty()) {
                    for (Field qingField : qingTableFields) {
                        String qingFieldName = qingField.getName();
                        FieldNode fieldNode = new FieldNode();
                        fieldNode.setTableName(tableName);
                        fieldNode.setName(qingFieldName);
                        fieldNode.setDisplayName(qingFieldName);
                        fieldNode.setCommentInfo(qingFieldName);
                        fieldNode.setType(qingField.getRawDataType());
                        root.addChild((AbstractNode)fieldNode);
                    }
                }
                roots.add((AbstractNode)root);
            }
            return roots;
        }
        return Collections.emptyList();
    }

    public DatasetModelVO getOutputColumns(String dataSetId, AbstractDataSetModel dataSetModel, boolean isNeedCheck) throws Exception {
        DataSetModelBO dataSetModelBO = this.initDataSetModelBO(dataSetId, dataSetModel);
        if (isNeedCheck) {
            this.checkDataSource(dataSetModelBO);
        }
        DatasetModelVO datasetModelVO = this.getOutputColumns(dataSetModelBO, false, true);
        AbstractDataSetModel dirtyModel = datasetModelVO.getDataSetModel();
        dataSetModel.setOutputColumns(dirtyModel.getOutputColumns());
        datasetModelVO.setDataSetModel(dataSetModel);
        return datasetModelVO;
    }

    public DatasetModelVO getOutputColumns(DataSetModelBO dataSetModelBO, boolean isThrow, boolean isReName) throws Exception {
        AbstractDataSetModel dataSetModel = dataSetModelBO.getDataSetModel();
        DatasetModelVO datasetModelVO = new DatasetModelVO();
        datasetModelVO.setDataSetModel(dataSetModel);
        List modelOutputColumns = dataSetModel.getOutputColumns();
        HashMap<String, OutputColumn> mapNameModelOutputColumns = new HashMap<String, OutputColumn>(8);
        HashSet<String> allAlias = new HashSet<String>(8);
        if (CollectionUtils.isNotEmpty((Collection)modelOutputColumns)) {
            for (OutputColumn modelOutputColumn : modelOutputColumns) {
                mapNameModelOutputColumns.put(modelOutputColumn.getName(), modelOutputColumn);
            }
        }
        DataSetType dataSetType = dataSetModel.getDataSetType();
        List<ParameterBO> parameterBOList = dataSetModelBO.getParameterBOList();
        Map executeParams = ParamExecutor.emptyDefaultValue(parameterBOList);
        boolean isRun = false;
        ParamExecutor.addInnerDefaultParams((QingContext)this.qingContext, (Map)executeParams, (boolean)isRun);
        ResultSet resultSet = DataSetProcessor.processDataSet((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (DataSetModelBO)dataSetModelBO, (Map)executeParams, (int)0, (boolean)isRun);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int count = resultSetMetaData.getColumnCount();
        ArrayList<OutputColumn> outputColumnList = new ArrayList<OutputColumn>(count);
        for (int i = 0; i < count; ++i) {
            String toCheckAlias;
            OutputColumn column = new OutputColumn();
            String name = resultSetMetaData.getColumnName(i + 1);
            column.setName(name);
            if (DataSetType.OQL_DATA_SET == dataSetType) {
                if (mapNameModelOutputColumns.containsKey(name)) {
                    column.setAlias(((OutputColumn)mapNameModelOutputColumns.get(name)).getAlias());
                } else {
                    column.setAlias(name);
                }
                toCheckAlias = column.getAlias().replace(".", "");
            } else {
                if (mapNameModelOutputColumns.containsKey(name)) {
                    column.setAlias(((OutputColumn)mapNameModelOutputColumns.get(name)).getAlias());
                } else {
                    column.setAlias(name.length() > 32 ? name.substring(0, 32) : name);
                }
                toCheckAlias = column.getAlias();
            }
            if (!Pattern.matches("^([\u4e00-\u9fa5a-zA-Z_])[\u4e00-\u9fa5a-zA-Z0-9_]*$", toCheckAlias)) {
                String code = DataSetModeCheckInfo.OUTPUT_COLUMNS_NAME_EXP.getCode();
                String message = column.getAlias() + ":" + MserviceRptMessages.getMLS((String)"nameRules", (String)"\u540d\u79f0\u53ea\u80fd\u7531\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934");
                if (isThrow) {
                    throw new DataSetException(message, Integer.parseInt(code));
                }
                if (isReName) {
                    String newName = this.getNewOutputColumnNameAlias(column.getAlias(), allAlias, dataSetType);
                    column.setAlias(newName);
                } else {
                    datasetModelVO.addCheckResult(DataSetModelCheckType.OUTPUT_COLUMN, new DataSetModelCheckResult(code, message));
                }
            }
            if (allAlias.contains(column.getAlias())) {
                String newName = this.getNewOutputColumnNameAlias(column.getAlias(), allAlias, dataSetType);
                column.setAlias(newName);
            }
            allAlias.add(column.getAlias());
            int columnType = resultSetMetaData.getColumnType(i + 1);
            OutputColumnDataType columnDataType = OutputColumnDataType.fromJdbcType((int)columnType);
            column.setDataType(columnDataType);
            outputColumnList.add(column);
        }
        dataSetModel.setOutputColumns(outputColumnList);
        return datasetModelVO;
    }

    private String getNewOutputColumnNameAlias(String alias, Set<String> allAlias, DataSetType dataSetType) throws DataSetException {
        String patternStr;
        boolean isBeginIllegal;
        boolean bl = isBeginIllegal = !Pattern.matches("^[\u4e00-\u9fa5a-zA-Z_].*", alias);
        if (isBeginIllegal) {
            alias = "_" + alias.substring(1);
        }
        boolean isNeedCheckLen = false;
        if (DataSetType.OQL_DATA_SET == dataSetType) {
            patternStr = "[^\\u4e00-\\u9fa5A-Za-z0-9_.]";
        } else {
            patternStr = "[^\\u4e00-\\u9fa5A-Za-z0-9_]";
            isNeedCheckLen = true;
        }
        alias = alias.replaceAll(patternStr, "_");
        alias = alias.replaceAll("_+", "_");
        if (isNeedCheckLen && alias.length() > 32) {
            alias = alias.substring(0, 32);
        }
        int count = 0;
        String basicAlias = alias;
        while (allAlias.contains(alias)) {
            if (isNeedCheckLen && alias.length() >= 32) {
                basicAlias = alias.substring(0, 32 - String.valueOf(count).length());
            }
            alias = basicAlias + count;
            if (++count < 999) continue;
            String code = DataSetModeCheckInfo.OUTPUT_COLUMNS_NAME_EXP.getCode();
            String message = alias + ":" + MserviceRptMessages.getMLS((String)"nameRules", (String)"\u540d\u79f0\u53ea\u80fd\u7531\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934");
            throw new DataSetException(message, Integer.parseInt(code));
        }
        return alias;
    }

    public List<OutputColumn> getOutputColumns(DataSetModelBO dataSetModelBO, boolean isThrowElseReName) throws Exception {
        return this.getOutputColumns(dataSetModelBO, isThrowElseReName, !isThrowElseReName).getDataSetModel().getOutputColumns();
    }

    public void checkDataSource(String dataSetId, AbstractDataSetModel dataSetModel) throws DataSetException {
        DataSetModelBO dataSetModelBO = this.initDataSetModelBO(dataSetId, dataSetModel);
        this.checkDataSource(dataSetModelBO);
    }

    private void checkDataSource(DataSetModelBO dataSetModelBO) throws DataSetException {
        try {
            DataSourceCheckerFactory.checkDataSource((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (DataSetModelBO)dataSetModelBO);
        }
        catch (DataSetException e) {
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION1.getCode() || e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NOT_EXIST_EXCEPTION.getCode()) {
                String dataSourceName = ((SQLDataSetModel)dataSetModelBO.getDataSetModel()).getDataSourceName();
                String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION1.getMessage().replace("#1", dataSourceName);
                throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION1);
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION2.getCode() || e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_PERMISSION_EXCEPTION.getCode()) {
                String dataSourceName = ((SQLDataSetModel)dataSetModelBO.getDataSetModel()).getDataSourceName();
                String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION2.getMessage().replace("#1", dataSourceName);
                throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION2);
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATA_SET_REJECT_EXEC_EXCEPTION.getCode()) {
                return;
            }
            throw e;
        }
    }

    private AbstractDBSourceJDBCAdapter getDBSourceJDBCAdapter(AbstractSource source, DBSource dbSource) throws UnSupportDataSourceException {
        AbstractDBSourceJDBCAdapter jdbcAdapter = null;
        jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance((AbstractSource)dbSource);
        IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource((AbstractSource)source);
        jdbcAdapter.setConnectionFactory(connFactory);
        return jdbcAdapter;
    }

    public AbstractSource getSource(DataSourceType dataSourceType, String dataSourceName, String creatorId) throws AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException {
        ERPCloudDBCenterSource source = null;
        if (DataSourceType.DATA_CENTER == dataSourceType) {
            source = DataCenterUtil.createDBCenterSourceByExactName((String)dataSourceName);
        } else if (DataSourceType.SUPER_QUERY == dataSourceType) {
            source = new SuperQuerySource();
            ((SuperQuerySource)source).setSchema(dataSourceName);
            ((SuperQuerySource)source).setOwnerId(creatorId);
        } else {
            DBConnectionPO connectionPO = this.getDBConnectionDomain().loadDBConnectionByDBName(dataSourceName);
            if (connectionPO == null) {
                return null;
            }
            DBConnection connection = connectionPO.toDBConnection();
            source = connection.getDbSource();
            if (source instanceof SuperQuerySource) {
                ((SuperQuerySource)source).setOwnerId(connection.getCreatorId());
            }
        }
        return source;
    }

    private DBSource getDBSource(AbstractSource source) {
        return AbstractDBSourceJDBCAdapter.createDBSourceBySource((AbstractSource)source);
    }

    public DBSource.DBType getDBType(DataSetModelBO modelBO) throws AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException {
        DBSource.DBType dbType = null;
        SQLDataSetModel model = (SQLDataSetModel)modelBO.getDataSetModel();
        DataSourceType dataSourceType = model.getDataSourceType();
        String sourceName = model.getDataSourceName();
        if (dataSourceType == DataSourceType.DATA_CENTER) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)sourceName);
            String sourceDbRoute = appInfo.getDbRoute();
            DBRoute dbRoute = DBRoute.of((String)sourceDbRoute);
            dbType = BizSourceConversionStrategyImpl.getDbType((DBRoute)dbRoute);
        } else if (dataSourceType == DataSourceType.OUT_DB) {
            AbstractSource source = this.getSource(dataSourceType, sourceName, modelBO.getCreatorId());
            if (source instanceof DBSource) {
                dbType = ((DBSource)source).getDbType();
            } else if (source instanceof SuperQuerySource) {
                dbType = DBSource.DBType.FLYDB;
            }
        } else if (dataSourceType == DataSourceType.SUPER_QUERY || dataSourceType == DataSourceType.USER_SUPER_QUERY) {
            dbType = DBSource.DBType.FLYDB;
        }
        return dbType;
    }

    private String getDBTypeStr(DBSource.DBType dbType) {
        switch (dbType) {
            case ORACLE: {
                return "ORACLE";
            }
            case SQLSERVER: {
                return "SQL Server";
            }
            case MYSQL: {
                return "MySQL";
            }
            case DB2: {
                return "DB2";
            }
            case DM: {
                return "DM";
            }
            case POSTGRESQL: {
                return "Postgre SQL";
            }
            case GREENPLUM: {
                return "Greenplum";
            }
        }
        return null;
    }

    public DataSetVO loadDataSet(String groupID, String groupName, String dataSetID, String dbsourcename, String userID) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isEmpty((CharSequence)userID)) {
            userID = this.qingContext.getUserId();
        }
        return this.getDataSetManageDomain().loadDataSet(groupID, groupName, dataSetID, dbsourcename, userID);
    }

    public AbstractDataSetModel initDataSetModel(DataSetVO dataSetVO) throws DataSetException {
        try {
            DataSetType dataSetType = DataSetType.getDateSetType((String)dataSetVO.getType());
            AbstractDataSetModel dataSetModel = (AbstractDataSetModel)DatSetModelFactory.getDataSetModelImpl((DataSetType)dataSetType);
            this.getDataSetDesignerDomain().setModelContent(dataSetModel, dataSetVO.getDataSetID());
            return this.initDataSetDBType(dataSetModel, dataSetVO);
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_MODEL_INITIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    private AbstractDataSetModel initDataSetDBType(AbstractDataSetModel dataSetModel, DataSetVO dataSetVO) throws AbstractQingIntegratedException, SQLException, ModelParseException, XmlParsingException, IOException {
        AbstractSource source;
        SQLDataSetModel sqlDataSetModel;
        if (dataSetModel instanceof SQLDataSetModel && (sqlDataSetModel = (SQLDataSetModel)dataSetModel).getDBType() == null && sqlDataSetModel.getDataSourceType() == DataSourceType.OUT_DB && sqlDataSetModel.getSqlType() == SqlType.SQL && (source = this.getSource(sqlDataSetModel.getDataSourceType(), sqlDataSetModel.getDataSourceName(), dataSetVO.getCreatorId())) instanceof DBSource) {
            DBSource.DBType dbType = ((DBSource)source).getDbType();
            sqlDataSetModel.setDBType(this.getDBTypeStr(dbType));
        }
        return dataSetModel;
    }

    public AbstractDataSetModel initDataSetModel(String dataSetId) throws DataSetException {
        try {
            DataSetVO dataSetVO = this.loadDataSetInfo(dataSetId);
            return this.initDataSetModel(dataSetVO);
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_MODEL_INITIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    public DataSetModelBO initDataSetModelBO(DataSetVO dataSetVO) throws DataSetException {
        try {
            DataSetType dataSetType = DataSetType.getDateSetType((String)dataSetVO.getType());
            AbstractDataSetModel dataSetModel = (AbstractDataSetModel)DatSetModelFactory.getDataSetModelImpl((DataSetType)dataSetType);
            this.getDataSetDesignerDomain().setModelContent(dataSetModel, dataSetVO.getDataSetID());
            DataSetModelBO modelBO = new DataSetModelBO(dataSetModel, this.qingContext, this.tx, this.dbExcuter);
            modelBO.setDataSetID(dataSetVO.getDataSetID());
            modelBO.setDataSetName(dataSetVO.getDataSetName());
            modelBO.setCreatorId(dataSetVO.getCreatorId());
            modelBO.setDescription(dataSetVO.getDescription());
            return modelBO;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_MODEL_INITIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    public DataSetModelBO initDataSetModelBO(String dataSetId) throws DataSetException {
        try {
            DataSetVO dataSetVO = this.loadDataSetInfo(dataSetId);
            return this.initDataSetModelBO(dataSetVO);
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_MODEL_INITIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    public DataSetModelBO initDataSetModelBO(DataSetVO dataSetVO, AbstractDataSetModel dataSetModel) throws DataSetException {
        try {
            DataSetModelBO modelBO = new DataSetModelBO(dataSetModel, this.qingContext, this.tx, this.dbExcuter);
            modelBO.setDataSetID(dataSetVO.getDataSetID());
            modelBO.setDataSetName(dataSetVO.getDataSetName());
            modelBO.setCreatorId(dataSetVO.getCreatorId());
            modelBO.setDescription(dataSetVO.getDescription());
            return modelBO;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_MODEL_INITIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    public DataSetModelBO initDataSetModelBO(String dataSetId, AbstractDataSetModel dataSetModel) throws DataSetException {
        try {
            DataSetVO dataSetVO = this.loadDataSetInfo(dataSetId);
            return this.initDataSetModelBO(dataSetVO, dataSetModel);
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_MODEL_INITIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    public DataSetModelBO initDataSetModelFromXml(String xmlString, DataSetVO dataSetVO) throws DataSetException {
        try {
            DataSetType dataSetType = DataSetType.getDateSetType((String)dataSetVO.getType());
            AbstractDataSetModel dataSetModel = (AbstractDataSetModel)DatSetModelFactory.getDataSetModelImpl((DataSetType)dataSetType);
            xmlString = xmlString.replaceAll("\\\\\"", "\"").replaceAll("\\\\t", " ").replaceAll("\\\\n", "\n").replaceAll("\\\\r", " ").replaceAll("  ", " ");
            ByteArrayInputStream contentInputStream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            IXmlElement xmlNode = XmlUtil.loadRootElement((InputStream)contentInputStream);
            dataSetModel.fromXml(xmlNode);
            DataSetModelBO modelBO = new DataSetModelBO(dataSetModel, this.qingContext, this.tx, this.dbExcuter);
            modelBO.setDataSetID(dataSetVO.getDataSetID());
            modelBO.setDataSetName(dataSetVO.getDataSetName());
            modelBO.setCreatorId(dataSetVO.getCreatorId());
            modelBO.setDescription(dataSetVO.getDescription());
            return modelBO;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_MODEL_INITIALIZATION_EXCEPTION, (Throwable)e);
        }
    }

    private DataSetVO loadDataSetInfo(String dataSetId) throws AbstractQingIntegratedException, SQLException, DataSetException {
        DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetId);
        if (dataSetVO == null) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_NOT_FOUND_EXCEPTION);
        }
        String creatorId = dataSetVO.getCreatorId();
        if (IntegratedHelper.getPresetUserId().equals(creatorId) && !this.getDataSetDesignerDomain().checkPresetManagePermission()) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_NO_PRESET_PERMISSION);
        }
        return dataSetVO;
    }

    public String cacheDataSetModel(String dataSetId, AbstractDataSetModel model) {
        String dataSetModelCacheId = ModelCacheUtil.getDataSetCacheId((String)"qingrpt_ds_edit", (String)this.qingContext.getUserId(), (String)dataSetId);
        return ModelCacheUtil.cacheModel((String)dataSetModelCacheId, (AbstractDataSetModel)model);
    }

    public List<SystemVariant> loadSystemVar(String searchText) {
        ArrayList<SystemVariant> systemVariants = new ArrayList<SystemVariant>(1);
        for (SystemVar systemVar : VarAdapter.getSystemVars()) {
            SystemVariantDataType systemVariantDataType;
            SystemVarType systemVarType = systemVar.getSystemVarType();
            SystemVariantDataType systemVariantDataType2 = systemVariantDataType = systemVarType.isCollectionType() ? SystemVariantDataType.LIST : SystemVariantDataType.STRING;
            if (!systemVar.getName().toLowerCase().contains(searchText) && !systemVar.getAlias().toLowerCase().contains(searchText)) continue;
            systemVariants.add(new SystemVariant(systemVar.getName(), systemVar.getAlias(), systemVariantDataType));
        }
        return systemVariants;
    }

    public HashMap<String, Integer> loadSystemVarPageIndexByName(String sysName, int pageSize) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        int index = 0;
        List<SystemVariant> result = this.loadSystemVar("");
        int sysSize = result.size();
        for (int i = 0; i < sysSize; ++i) {
            SystemVariant macro = result.get(i);
            if (!sysName.equals(macro.getName())) continue;
            index = i;
        }
        resultMap.put("index", index / pageSize + 1);
        resultMap.put("count", sysSize);
        return resultMap;
    }

    public List<SystemVariant> loadSelectSysVarsByarrName(List<String> arrName) {
        ArrayList<SystemVariant> systemVariants = new ArrayList<SystemVariant>(1);
        for (int i = 0; i < arrName.size(); ++i) {
            String sysName = arrName.get(i);
            for (SystemVar systemVar : VarAdapter.getSystemVars()) {
                if (!sysName.equals(systemVar.getName())) continue;
                SystemVarType systemVarType = systemVar.getSystemVarType();
                SystemVariantDataType systemVariantDataType = systemVarType.isCollectionType() ? SystemVariantDataType.LIST : SystemVariantDataType.STRING;
                systemVariants.add(new SystemVariant(systemVar.getName(), systemVar.getAlias(), systemVariantDataType));
            }
        }
        return systemVariants;
    }

    public Map<String, Object> loadSystemVar(Integer pageSize, Integer targetPage, String searchText) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<SystemVariant> systemVariants = new ArrayList<SystemVariant>(1);
        ArrayList resultVariants = new ArrayList(pageSize);
        for (int i = 0; i < VarAdapter.getSystemVars().length; ++i) {
            SystemVariantDataType systemVariantDataType;
            SystemVar systemVar = VarAdapter.getSystemVars()[i];
            SystemVarType systemVarType = systemVar.getSystemVarType();
            SystemVariantDataType systemVariantDataType2 = systemVariantDataType = systemVarType.isCollectionType() ? SystemVariantDataType.LIST : SystemVariantDataType.STRING;
            if (!systemVar.getName().toLowerCase().contains(searchText.toLowerCase()) && !systemVar.getAlias().toLowerCase().contains(searchText.toLowerCase())) continue;
            systemVariants.add(new SystemVariant(systemVar.getName(), systemVar.getAlias(), systemVariantDataType));
        }
        int size = systemVariants.size();
        for (int count = (targetPage - 1) * pageSize; count < pageSize * targetPage; ++count) {
            if (count >= size) continue;
            resultVariants.add(systemVariants.get(count));
        }
        result.put("totalRow", size);
        result.put("currentPage", targetPage);
        result.put("pageSize", pageSize);
        result.put("systemVar", resultVariants);
        return result;
    }

    public PreviewData previewDataSysVar(String sysName) {
        PreviewData previewData = new PreviewData();
        ArrayList<String> allColumnValuesList = new ArrayList<String>(10);
        previewData.addField(sysName);
        for (SystemVar systemVar : VarAdapter.getSystemVars()) {
            if (!systemVar.getAlias().equals(sysName)) continue;
            SystemVarType systemVarType = systemVar.getSystemVarType();
            if (systemVarType.isCollectionType()) {
                Collection values = (Collection)this.qingContext.getSystemVar(systemVarType);
                for (Object value : values) {
                    if (value == null) continue;
                    allColumnValuesList.add(value.toString());
                }
                continue;
            }
            allColumnValuesList.add(this.qingContext.getSystemVarStringValue(systemVarType));
        }
        int totalCount = allColumnValuesList.size();
        previewData.setTotalRowCount(totalCount);
        int previewCount = totalCount;
        if (previewCount > 100) {
            previewCount = 100;
        }
        if (totalCount > 0) {
            for (int j = 0; j < previewCount; ++j) {
                PreviewData.Row row = previewData.createRow();
                PreviewData.Column column = row.createColumn();
                column.setValue(allColumnValuesList.get(j));
            }
        }
        return previewData;
    }

    public void checkDataSetExist(String dataSetId) throws DataSetException, AbstractQingIntegratedException, SQLException {
        DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetId);
        if (dataSetVO == null) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theDatasetDoesNotExist", (String)"\u8be5\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
            throw new DataSetException(msg, DataSetErrorCodeEnum.DATASET_NOT_FOUND_EXCEPTION);
        }
    }
}

