/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.domain;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.BlobBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.model.ExtMacroValue;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.industry.MacroUtil;
import com.kingdee.bos.datawizard.edd.web.filter.CtrlType;
import com.kingdee.bos.datawizard.edd.web.filter.ReportParamDescription;
import com.kingdee.bos.datawizard.edd.web.vo.TableRowSet;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StackTraceUtil;
import com.kingdee.bos.report.ext.web.scheme.po.ExtFilterScheme;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.dataset.constant.ParamBindSourceType;
import kd.bos.mservice.extreport.dataset.constant.ParamCtrlState;
import kd.bos.mservice.extreport.dataset.constant.ParamCtrlType;
import kd.bos.mservice.extreport.dataset.constant.ParamDataType;
import kd.bos.mservice.extreport.dataset.constant.ParamF7TreeType;
import kd.bos.mservice.extreport.dataset.ctrl.AbstractBindSourceCtrlTranslation;
import kd.bos.mservice.extreport.dataset.ctrl.AbstractCtrlTranslation;
import kd.bos.mservice.extreport.dataset.ctrl.CtrlTranslateFactory;
import kd.bos.mservice.extreport.dataset.ctrl.F7ParameterSupplier;
import kd.bos.mservice.extreport.dataset.datasource.DataSetProcessor;
import kd.bos.mservice.extreport.dataset.datasource.DataSourceFactory;
import kd.bos.mservice.extreport.dataset.datasource.param.AbstractParameterSupplier;
import kd.bos.mservice.extreport.dataset.datasource.param.ParamAnalysisHelper;
import kd.bos.mservice.extreport.dataset.datasource.param.ParamExecutor;
import kd.bos.mservice.extreport.dataset.datasource.processor.IDataSourceProcessor;
import kd.bos.mservice.extreport.dataset.domain.ExtReportDataSetDesignerDomain;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.ModelCacheUtil;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.bo.Entry;
import kd.bos.mservice.extreport.dataset.model.bo.ParameterBO;
import kd.bos.mservice.extreport.dataset.model.bo.TreeNodeEntry;
import kd.bos.mservice.extreport.dataset.model.bo.resultSet.MacroResultSet;
import kd.bos.mservice.extreport.dataset.model.bo.resultSet.SysVarResultSet;
import kd.bos.mservice.extreport.dataset.model.check.impl.DataSourceCheckerFactory;
import kd.bos.mservice.extreport.dataset.model.po.AbstractDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.OQLDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.SQLDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.outputcolumn.OutputColumn;
import kd.bos.mservice.extreport.dataset.model.po.parameter.Parameter;
import kd.bos.mservice.extreport.dataset.model.po.parameter.ctrl.AbstractBindSourceCtrl;
import kd.bos.mservice.extreport.dataset.model.po.parameter.ctrl.AbstractCtrl;
import kd.bos.mservice.extreport.dataset.model.po.parameter.ctrl.F7Ctrl;
import kd.bos.mservice.extreport.designer.domain.ExtFilterSchemeDomain;
import kd.bos.mservice.extreport.manage.model.DataSetVO;
import kd.bos.mservice.extreport.old.analysis.web.solution.filter.FilterScheme;
import kd.bos.mservice.extreport.old.analysis.web.solution.filter.ShareStrategy;
import kd.bos.mservice.extreport.old.rpts.web.filter.FilterSchemeInfo;
import kd.bos.mservice.extreport.old.rpts.web.vo.FilterInfo;
import kd.bos.mservice.extreport.runtime.exception.DataSetExecuteException;
import kd.bos.mservice.extreport.runtime.exception.ExtMacroNotExistsException;
import kd.bos.mservice.extreport.runtime.model.vo.DataSetRuntimeInfo;
import kd.bos.mservice.extreport.util.DateUtil;
import kd.bos.mservice.extreport.util.StringUtils;
import org.apache.log4j.Logger;

public class ExtReportDataSetRuntimeDomain {
    private static final Logger logger = Logger.getLogger(ExtReportDataSetRuntimeDomain.class);
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private ExtReportDataSetDesignerDomain extReportDataSetDesignerDomain;
    private ExtFilterSchemeDomain filterSchemeDomain;
    public static final String FILTER_FIELDS = "fields";
    public static final String FILTER_FIELD = "field";

    public QingContext getQingContext() {
        return this.qingContext;
    }

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public ITransactionManagement getTx() {
        return this.tx;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public IDBExcuter getDbExcuter() {
        return this.dbExcuter;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public ExtReportDataSetRuntimeDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    private ExtReportDataSetDesignerDomain getExtReportDataSetDesignerDomain() {
        if (this.extReportDataSetDesignerDomain == null) {
            this.extReportDataSetDesignerDomain = new ExtReportDataSetDesignerDomain(this.qingContext, this.dbExcuter, this.tx);
        }
        return this.extReportDataSetDesignerDomain;
    }

    private ExtFilterSchemeDomain getFilterSchemeDomain() {
        if (this.filterSchemeDomain == null) {
            this.filterSchemeDomain = new ExtFilterSchemeDomain();
            this.filterSchemeDomain.setQingContext(this.qingContext);
            this.filterSchemeDomain.setTx(this.tx);
            this.filterSchemeDomain.setDbExcuter(this.dbExcuter);
        }
        return this.filterSchemeDomain;
    }

    public Map<String, Object> applyDataSetFilter(String dataSetId, String cacheId, int limit, String paramValues) throws Exception {
        AbstractDataSetModel model = ModelCacheUtil.getCachedModel((String)cacheId);
        if (model == null) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_EXPIRE_EXCEPTION);
        }
        DataSetModelBO modelBO = this.getExtReportDataSetDesignerDomain().initDataSetModelBO(dataSetId, model);
        modelBO.setCheckExecutable(false);
        return this.applyDataSetFilter(modelBO, limit, paramValues);
    }

    public Map<String, Object> applyDataSetFilter(DataSetModelBO modelBO, int limit, String paramValues) throws Exception {
        ResultSet resultSet;
        AbstractDataSetModel dataSetModel = modelBO.getDataSetModel();
        if (dataSetModel.isEmpty()) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_NO_CONTENT_EXCEPTION);
        }
        DataSourceCheckerFactory.checkDataSource((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (DataSetModelBO)modelBO);
        Map<String, ParameterBO> executeParams = this.prepareParams(modelBO.getParameterBOList(), paramValues);
        try {
            resultSet = DataSetProcessor.processDataSet((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (DataSetModelBO)modelBO, executeParams, (int)limit, (boolean)true);
        }
        catch (ExtMacroException e) {
            throw new ExtMacroNotExistsException(e.getErrorCode(), (Throwable)e, e.getErrorMessage());
        }
        catch (SuperQueryNoPermissionException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"checkExecutionStatement", (String)"\u6570\u636e\u96c6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u8bed\u53e5");
            String content = "";
            if (dataSetModel instanceof SQLDataSetModel) {
                content = ((SQLDataSetModel)dataSetModel).getSql();
                throw new DataSetExecuteException(msg + "|||\nSqlContent\uff1a \n" + content + "\n\n" + StackTraceUtil.getStackTrace((Throwable)e));
            }
            if (dataSetModel instanceof OQLDataSetModel) {
                content = ((OQLDataSetModel)dataSetModel).getOql();
                throw new DataSetExecuteException(msg + "|||\nOqlContent\uff1a \n" + content + "\n\n" + StackTraceUtil.getStackTrace((Throwable)e));
            }
            throw new DataSetExecuteException(msg + "\n" + StackTraceUtil.getStackTrace((Throwable)e));
        }
        return this.buildDataSetResult(modelBO, resultSet);
    }

    private Map<String, ParameterBO> prepareParams(List<ParameterBO> parameterBOs, String paramString) throws ExtMacroException, DataSetException {
        ParamExecutor.execDefault((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, parameterBOs);
        LinkedHashMap<String, ParameterBO> assignedParams = new LinkedHashMap<String, ParameterBO>(8);
        ParamExecutor.addInnerDefaultParams((QingContext)this.qingContext, assignedParams);
        Map paramMap = ParamExecutor.parseParamString(parameterBOs, (String)paramString, (String)"value");
        if (CollectionUtils.isNotEmpty(parameterBOs)) {
            for (ParameterBO param : parameterBOs) {
                String name = param.getParameter().getName();
                String runtimeValue = (String)paramMap.get(name);
                ParamCtrlState ctrlState = param.getParameter().getCtrl().getCtrlState();
                if (ctrlState == ParamCtrlState.HIDDEN && (runtimeValue = param.getParameter().getCtrl().getDefaultValue()) != null) {
                    runtimeValue = ParamAnalysisHelper.replaceMultiValues((String)runtimeValue);
                }
                runtimeValue = this.replaceMacroOrSysVar(runtimeValue, assignedParams);
                param.checkValid(runtimeValue);
                paramMap.put(name, runtimeValue);
            }
        }
        assignedParams.putAll(ParamExecutor.assignCurrentValue(parameterBOs, (Map)paramMap));
        return assignedParams;
    }

    private String replaceMacroOrSysVar(String oriVal, Map<String, ParameterBO> sysVars) throws ExtMacroException {
        if (StringUtils.isEmpty((CharSequence)oriVal)) {
            return oriVal;
        }
        List<String> values = this.addEmptyElement(oriVal);
        for (int i = 0; i < values.size(); ++i) {
            ExtMacroValue macroValue;
            String value = values.get(i);
            if (value.startsWith("@Ext")) {
                ParameterBO parameterBO = sysVars.get(value.substring(1));
                if (parameterBO != null) {
                    values.set(i, parameterBO.getCurrentValue());
                    continue;
                }
                values.set(i, "");
                continue;
            }
            if (!value.startsWith("$") || (macroValue = MacroUtil.loadFirstFieldMacroValues((Object)this.qingContext, (String)value.substring(1), (int)-1)) == null) continue;
            List macroValues = (List)macroValue.getAllColumnValues().get(0);
            if (!macroValues.isEmpty()) {
                List stringMacroValues = macroValues.stream().map(Object::toString).collect(Collectors.toList());
                values.set(i, String.join((CharSequence)"0xx1xx", stringMacroValues));
                continue;
            }
            values.set(i, "");
        }
        return String.join((CharSequence)"0xx1xx", values);
    }

    private List<String> addEmptyElement(String oriVal) {
        String[] values = oriVal.split("0xx1xx");
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(values));
        if (oriVal.endsWith("0xx1xx")) {
            valueList.add("");
        }
        return valueList;
    }

    private Map<String, Object> buildDataSetResult(DataSetModelBO modelBO, ResultSet resultSet) throws SQLException {
        int len = resultSet.getMetaData().getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(8);
        ArrayList<String> columnAlias = new ArrayList<String>(8);
        Map<String, OutputColumn> nameAlisaMap = this.getNameAlisaMapFromModel(modelBO);
        HashSet<Integer> excludedCols = new HashSet<Integer>(8);
        for (int i = 0; i < len; ++i) {
            String columnName = resultSet.getMetaData().getColumnName(i + 1).toUpperCase(Locale.ENGLISH);
            if (nameAlisaMap.isEmpty()) {
                columnNames.add(columnName);
                columnAlias.add(columnName);
                continue;
            }
            OutputColumn column = nameAlisaMap.get(columnName);
            if (column == null) {
                excludedCols.add(i + 1);
                columnNames.add(columnName);
                columnAlias.add(columnName);
                continue;
            }
            columnNames.add(column.getName());
            columnAlias.add(column.getAlias());
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("columnNames", columnNames);
        resultMap.put("resultList", this.setDataToList(resultSet, excludedCols, columnNames));
        resultMap.put("columnAlias", columnAlias);
        resultMap.put("excludedCols", excludedCols);
        String queryContent = "";
        AbstractDataSetModel dataSetModel = modelBO.getDataSetModel();
        if (dataSetModel instanceof SQLDataSetModel) {
            queryContent = ((SQLDataSetModel)dataSetModel).getSql();
        } else if (dataSetModel instanceof OQLDataSetModel) {
            queryContent = ((OQLDataSetModel)dataSetModel).getOql();
        }
        resultMap.put("queryContent", queryContent);
        return resultMap;
    }

    private Map<String, OutputColumn> getNameAlisaMapFromModel(DataSetModelBO modelBO) {
        List outputs;
        HashMap<String, OutputColumn> map = new HashMap<String, OutputColumn>(8);
        AbstractDataSetModel dataSetModel = modelBO.getDataSetModel();
        if (dataSetModel != null && (outputs = dataSetModel.getOutputColumns()) != null && !outputs.isEmpty()) {
            for (OutputColumn oc : outputs) {
                map.put(oc.getName().toUpperCase(), oc);
            }
        }
        return map;
    }

    private List<Map<String, Object>> setDataToList(ResultSet rs, Set<Integer> excludedCols, List<String> fullCols) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        ResultSetMetaData metaData = rs.getMetaData();
        int len = metaData.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>(len);
            for (int i = 1; i <= len; ++i) {
                if (excludedCols.contains(i)) {
                    map.put(fullCols.get(i - 1), "");
                    continue;
                }
                Object obj = rs.getObject(i);
                int type = metaData.getColumnType(i);
                obj = obj == null ? "" : (type == 12 || type == 16 || type == 4 || type == 8 || type == 6 || type == 2 || type == -6 || type == 3 || type == 5 || type == 1 || type == -1 || type == -5 || type == -16 || type == -9 || type == -15 ? String.valueOf(obj) : (type == 91 ? ((DateFormat)DateUtil.SDF_YYYY_MM_DD.get()).format(obj) : (type == 92 ? ((DateFormat)DateUtil.SDF_TIME.get()).format(obj) : (type == 93 ? ((DateFormat)DateUtil.SDF_YYYY_MM_DD_HH_MM_SS.get()).format(obj) : obj.toString()))));
                map.put(metaData.getColumnName(i).toLowerCase(), obj);
            }
            result.add(map);
        }
        return result;
    }

    public DataSetRuntimeInfo loadDataSetInfo(String dataSetId, String cacheId) throws Exception {
        DataSetRuntimeInfo dataSetRuntimeInfo = new DataSetRuntimeInfo();
        AbstractDataSetModel model = null;
        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
            model = ModelCacheUtil.getCachedModel((String)cacheId);
        }
        if (model == null) {
            model = this.getExtReportDataSetDesignerDomain().initDataSetModel(dataSetId);
            String dataSetModelCacheId = ModelCacheUtil.getDataSetCacheId((String)"qingrpt_ds_run", (String)this.qingContext.getUserId(), (String)dataSetId);
            cacheId = ModelCacheUtil.cacheModel((String)dataSetModelCacheId, (AbstractDataSetModel)model);
        }
        dataSetRuntimeInfo.setCacheId(cacheId);
        DataSetModelBO modelBO = this.getExtReportDataSetDesignerDomain().initDataSetModelBO(dataSetId, model);
        AbstractDataSetModel dataSetModel = modelBO.getDataSetModel();
        dataSetRuntimeInfo.setDataSetId(dataSetId);
        List parameters = dataSetModel.getParameters();
        dataSetRuntimeInfo.setHasFilter(parameters != null && !parameters.isEmpty());
        dataSetRuntimeInfo.setHasModel(!dataSetModel.isEmpty());
        return dataSetRuntimeInfo;
    }

    public FilterInfo getDataSetFilterAndSchemaList(String dataSetId, String cacheId) throws DataSetException, ExtMacroNotExistsException, SuperQueryNoPermissionException {
        try {
            AbstractDataSetModel model = ModelCacheUtil.getCachedModel((String)cacheId);
            if (model == null) {
                throw new DataSetException(DataSetErrorCodeEnum.DATASET_EXPIRE_EXCEPTION);
            }
            DataSetModelBO modelBO = this.getExtReportDataSetDesignerDomain().initDataSetModelBO(dataSetId, model);
            List<ParameterBO> parameterBOList = modelBO.getParameterBOList();
            FilterInfo filterInfo = new FilterInfo();
            ParamExecutor.execDefault((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, parameterBOList);
            List<ReportParamDescription> paramDescriptions = this.translateParams(parameterBOList, dataSetId, null);
            filterInfo.setParamList(paramDescriptions);
            Map<String, List<String>> paramRef = this.buildParamRef(paramDescriptions);
            ArrayList<FilterSchemeInfo> schemeList = new ArrayList<FilterSchemeInfo>(10);
            FilterSchemeInfo filterSchemeInfo = new FilterSchemeInfo();
            FilterScheme defaultFilterScheme = ExtReportDataSetRuntimeDomain.getDefaultFilterScheme(parameterBOList);
            filterSchemeInfo.setCaption(defaultFilterScheme.getCaption());
            filterSchemeInfo.setValue(defaultFilterScheme.toString());
            schemeList.add(filterSchemeInfo);
            this.getFilterSchemesNotDefault(dataSetId, ShareStrategy.USER_ONLY, schemeList, paramDescriptions, parameterBOList);
            filterInfo.setSchemeList(schemeList);
            filterInfo.setShareStrategy(ShareStrategy.USER_ONLY.ordinal());
            ExtFilterScheme lastUseScheme = this.getFilterSchemeDomain().findLastUseFilterScheme(dataSetId);
            if (lastUseScheme != null) {
                filterInfo.setHasDefaultEnter(true);
                filterInfo.setDefaultEnter(lastUseScheme.getName());
            }
            filterInfo.setAssociate(paramRef);
            return filterInfo;
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (SuperQueryNoPermissionException e) {
            throw e;
        }
        catch (ExtMacroException e) {
            throw new ExtMacroNotExistsException(e.getErrorCode(), (Throwable)e, e.getErrorMessage());
        }
        catch (RuntimeException e) {
            if (MacroResultSet.class.getName().equals(e.getStackTrace()[0].getClassName())) {
                throw new ExtMacroNotExistsException(8099008, (Throwable)e, e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_FILTER_SCHEMA_EXEC_EXCEPTION, (Throwable)e);
        }
    }

    public List<ReportParamDescription> translateParams(List<ParameterBO> parameterBOs, String reportId, Map<String, String> sqlDbMap) throws DataSetException, ExtMacroException, SuperQueryNoPermissionException {
        ArrayList<ReportParamDescription> paramList = new ArrayList<ReportParamDescription>(10);
        int size = -1;
        if (parameterBOs != null && (size = parameterBOs.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                ReportParamDescription param;
                ParamCtrlType ctrlType;
                ParameterBO parameterBO = parameterBOs.get(i);
                AbstractCtrl ctrl = parameterBO.getParameter().getCtrl();
                if (ctrl == null || ParamCtrlType.EMPTY == (ctrlType = ctrl.getCtrlType()) || ParamCtrlType.SEPARATOR == ctrlType) continue;
                AbstractCtrlTranslation ctrlTranslation = CtrlTranslateFactory.getCtrlTranslation((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (ParamCtrlType)ctrlType);
                try {
                    param = ctrlTranslation.buildReportParamTemplate(parameterBO, reportId, sqlDbMap, parameterBOs);
                }
                catch (DataSetException e) {
                    throw e;
                }
                catch (ExtMacroException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (SuperQueryNoPermissionException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Object)MserviceRptMessages.getMLS((String)"parameterParsingError", (String)"\u53c2\u6570\u89e3\u6790\u9519\u8bef"), (Throwable)e);
                    throw new DataSetException(DataSetErrorCodeEnum.ANALYSIS_PARAMS_EXCEPTION, (Throwable)e);
                }
                paramList.add(param);
            }
        }
        return paramList;
    }

    private Map<String, List<String>> buildParamRef(List<ReportParamDescription> paramList) {
        HashMap<String, List<String>> paramRef = new HashMap<String, List<String>>();
        for (ReportParamDescription define : paramList) {
            String name = define.getName();
            List relations = define.getRelations();
            if (relations == null || relations.isEmpty()) continue;
            Iterator iter = relations.iterator();
            while (iter.hasNext()) {
                if (!name.equals(iter.next())) continue;
                iter.remove();
            }
            if (relations.isEmpty()) continue;
            paramRef.put(name, relations);
        }
        return paramRef;
    }

    private static FilterScheme getDefaultFilterScheme(List<ParameterBO> parameterBOList) {
        int paramSize = parameterBOList != null ? parameterBOList.size() : 0;
        Object[] defaultValueParams = new Object[paramSize];
        Object[] defaultCaptionParams = new Object[paramSize];
        Object[] nameParams = new Object[paramSize];
        int size = -1;
        int j = 0;
        if (parameterBOList != null && (size = parameterBOList.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                ParamCtrlType ctrlType;
                ParameterBO parameterBO = parameterBOList.get(i);
                AbstractCtrl ctrl = parameterBO.getParameter().getCtrl();
                if (ctrl == null || ParamCtrlType.EMPTY == (ctrlType = ctrl.getCtrlType()) || ParamCtrlType.SEPARATOR == ctrlType) continue;
                nameParams[j] = parameterBO.getParameter().getName();
                String value = ctrl.getDefaultValue();
                String alias = ctrl.getDefaultAlias() != null ? ctrl.getDefaultAlias() : value;
                defaultValueParams[j] = Collections.singletonList(value);
                defaultCaptionParams[j] = Collections.singletonList(alias);
                ++j;
            }
        }
        return FilterScheme.createFilterScheme((String)MserviceRptMessages.getMLS((String)"defaultScheme", (String)"\u9ed8\u8ba4\u65b9\u6848"), (Object[])defaultValueParams, (Object[])defaultCaptionParams, null, null, (Object[])nameParams);
    }

    private void getFilterSchemesNotDefault(String schemaBiztagId, ShareStrategy shareStrategy, List<FilterSchemeInfo> schemeList, List<ReportParamDescription> paramDescList, List<ParameterBO> parameterBOList) throws AbstractQingIntegratedException, SQLException, XmlParsingException, IOException, DataSetException, NoSuchFieldException, IllegalAccessException {
        int shareStrategyFlag = shareStrategy.ordinal();
        List schemes = this.getFilterSchemeDomain().findFilterSchemes(schemaBiztagId, shareStrategyFlag);
        if (schemes != null && !schemes.isEmpty()) {
            HashMap<String, ReportParamDescription> paramDescMap = new HashMap<String, ReportParamDescription>(paramDescList.size());
            for (ReportParamDescription paramDesc : paramDescList) {
                paramDescMap.put(paramDesc.getName(), paramDesc);
            }
            for (ExtFilterScheme scheme : schemes) {
                String name = scheme.getName();
                String whereValue = scheme.getContent();
                Map<String, ParameterBO> parameterBOMap = this.changWhereValueToMapParams(whereValue, parameterBOList);
                Object[] defaultValueParams = new Object[paramDescMap.size()];
                Object[] defaultCaptionParams = new Object[paramDescMap.size()];
                Object[] nameParams = new Object[paramDescMap.size()];
                int index = 0;
                Iterator iterator = paramDescMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String value = "";
                    String text = "";
                    Map.Entry entry = iterator.next();
                    ReportParamDescription paramDescription = (ReportParamDescription)entry.getValue();
                    ParameterBO parameterBO = parameterBOMap.get(paramDescription.getName());
                    if (parameterBO != null) {
                        AbstractCtrl ctrl = parameterBO.getParameter().getCtrl();
                        ctrl.setDefaultValue(parameterBO.getCurrentValue());
                        ctrl.setDefaultAlias(parameterBO.getCurrentValueAlias());
                        Object oldParamDescDefaultValue = paramDescription.getDefaultValue();
                        if (ctrl instanceof AbstractBindSourceCtrl) {
                            AbstractBindSourceCtrlTranslation bindSourceCtrlTranslation = (AbstractBindSourceCtrlTranslation)CtrlTranslateFactory.getCtrlTranslation((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (ParamCtrlType)ctrl.getCtrlType());
                            bindSourceCtrlTranslation.transDefaultValueOnly(parameterBO, null, null, parameterBOList);
                        }
                        paramDescription.setDefaultValue(oldParamDescDefaultValue);
                        value = ctrl.getDefaultValue();
                        text = ctrl.getDefaultAlias();
                        nameParams[index] = parameterBO.getParameter().getName();
                    } else {
                        nameParams[index] = paramDescription.getName();
                    }
                    defaultValueParams[index] = Collections.singletonList(value);
                    defaultCaptionParams[index] = Collections.singletonList(text);
                    ++index;
                }
                FilterScheme filterScheme = FilterScheme.createFilterScheme((String)name, (Object[])defaultValueParams, (Object[])defaultCaptionParams, (ShareStrategy)ShareStrategy.toShareStrategy((int)scheme.getShareStrategy()), (String)schemaBiztagId, (Object[])nameParams);
                FilterSchemeInfo schemeInfo = new FilterSchemeInfo();
                schemeInfo.setCaption(filterScheme.getCaption());
                schemeInfo.setValue(filterScheme.toString());
                schemeInfo.setShareStrategy(filterScheme.getShareStrategy().ordinal());
                schemeList.add(schemeInfo);
            }
        }
        for (ReportParamDescription paramDesc : paramDescList) {
            if (!CtrlType.F7.name().equals(paramDesc.getCtrlType())) continue;
            paramDesc.setSuppliedValue(null);
        }
    }

    public Map<String, ParameterBO> changWhereValueToMapParams(String whereValue, List<ParameterBO> parameterBOList) throws IOException, XmlParsingException {
        LinkedHashMap<String, ParameterBO> paramMap = new LinkedHashMap<String, ParameterBO>(8);
        if (null != whereValue && whereValue.length() > 0) {
            HashMap<String, ParameterBO> mapParameterBO = new HashMap<String, ParameterBO>(parameterBOList.size());
            for (ParameterBO parameterBO : parameterBOList) {
                mapParameterBO.put(parameterBO.getParameter().getName(), parameterBO);
            }
            IXmlElement root = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(whereValue.getBytes("utf-8")));
            boolean lowVersion = false;
            String version = StringUtils.getObjectString((Object)root.getAttribute("version"));
            if (version.length() == 0) {
                lowVersion = true;
            }
            List lst = root.getChildren();
            for (IXmlElement et : lst) {
                ParameterBO parameterBO;
                String name = StringUtils.getObjectString((Object)et.getAttribute("name"));
                String value = StringUtils.getObjectString((Object)et.getAttribute("value"));
                String valueAlias = StringUtils.getObjectString((Object)et.getAttribute("valueAlias"));
                String dataType = CtrlReportUtil.getObjectString((Object)et.getAttribute("dataType"));
                if (lowVersion) {
                    if (!StringUtils.isEmpty((CharSequence)value) && value.contains(";")) {
                        value = StringUtils.replace((String)value, (String)";", (String)"0xx1xx");
                    }
                    if (!StringUtils.isEmpty((CharSequence)valueAlias) && valueAlias.contains(";")) {
                        valueAlias = StringUtils.replace((String)valueAlias, (String)";", (String)"0xx1xx");
                    }
                }
                if ((parameterBO = (ParameterBO)mapParameterBO.get(name)) == null) {
                    parameterBO = new ParameterBO(new Parameter());
                    if (StringUtils.isNotEmpty((CharSequence)dataType)) {
                        parameterBO.getParameter().setDataType(ParamDataType.getDataType((int)Integer.parseInt(dataType)));
                    }
                }
                parameterBO.setCurrentValue(value);
                parameterBO.setCurrentValueAlias(valueAlias);
                paramMap.put(name, parameterBO);
            }
        }
        return paramMap;
    }

    public TableRowSet getDataSetDelaySuppliedValue(String cacheId, String paramName, String textName, String valueName, String xmlContent, String paramValues) throws DataSetException, ExtMacroException, SQLException, SuperQueryNoPermissionException, AbstractQingIntegratedException {
        AbstractDataSetModel dataSetModel = ModelCacheUtil.getCachedModel((String)cacheId);
        if (dataSetModel == null) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_EXPIRE_EXCEPTION);
        }
        DataSetModelBO dataSetModelBO = new DataSetModelBO(dataSetModel, this.qingContext, this.tx, this.dbExcuter);
        Map<String, String> params = this.parseParamValues(paramValues);
        AbstractCtrl ctrl = null;
        List<ParameterBO> parameterBOList = dataSetModelBO.getParameterBOList();
        ParameterBO currentParamBO = null;
        List outputColumns = null;
        for (ParameterBO parameterBO : parameterBOList) {
            AbstractBindSourceCtrl.AbstractSource bindSource;
            Parameter parameter = parameterBO.getParameter();
            if (!paramName.equals(parameter.getName())) continue;
            currentParamBO = parameterBO;
            ctrl = parameter.getCtrl();
            List relateParams = null;
            if (ctrl instanceof AbstractBindSourceCtrl && (bindSource = ((AbstractBindSourceCtrl)ctrl).getBindSource()) instanceof AbstractBindSourceCtrl.DataSetSource) {
                AbstractBindSourceCtrl.DataSetSource bindDataSource = (AbstractBindSourceCtrl.DataSetSource)bindSource;
                DataSetVO dataSetVO = this.getExtReportDataSetDesignerDomain().loadDataSet(bindDataSource.getGroupId(), bindDataSource.getGroupName(), bindDataSource.getId(), bindDataSource.getName(), bindDataSource.getUserId());
                if (dataSetVO == null) {
                    throw new DataSetException(DataSetErrorCodeEnum.DATASET_NOT_FOUND_EXCEPTION);
                }
                DataSetModelBO bindModelBO = this.getExtReportDataSetDesignerDomain().initDataSetModelFromXml(xmlContent, dataSetVO);
                DataSourceCheckerFactory.checkDataSource((QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (DataSetModelBO)bindModelBO);
                relateParams = bindModelBO.getDataSetModel().getParameters();
                outputColumns = bindModelBO.getDataSetModel().getOutputColumns();
                currentParamBO.setModelXml(xmlContent);
            }
            Parameter[][] supplierParams = parameterBO.getSupplierParams(relateParams);
            for (Parameter[] supplier : supplierParams) {
                if (supplier[0] == null || supplier[1] == null) continue;
                String disKey = supplier[0].getName();
                String sourceKey = supplier[1].getName();
                if (!params.containsKey(sourceKey)) continue;
                String value = params.get(sourceKey);
                params.put(disKey, value);
            }
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(8);
        ArrayList<Integer> noPermissionIndex = new ArrayList<Integer>(8);
        LinkedHashMap<String, String> fieldAliasMap = new LinkedHashMap<String, String>(8);
        if (currentParamBO != null) {
            this.execBindSource(currentParamBO, outputColumns, resultList, noPermissionIndex, fieldAliasMap, params);
        }
        TableRowSet rowSet = new TableRowSet();
        if (resultList.isEmpty()) {
            rowSet.setEntryList(resultList);
            rowSet.setNoPermFieldIndexs(noPermissionIndex);
            return rowSet;
        }
        if (ctrl instanceof F7Ctrl) {
            List<TreeNodeEntry> f7Result = this.getF7Result(textName, valueName, (F7Ctrl)ctrl, resultList, fieldAliasMap, noPermissionIndex);
            rowSet.setEntryList(f7Result);
            rowSet.setHead(fieldAliasMap);
            rowSet.setNoPermFieldIndexs(noPermissionIndex);
        } else {
            ArrayList<Entry> entryList = new ArrayList<Entry>(resultList.size());
            for (Map map : resultList) {
                String text = StringUtils.getObjectString(map.get(textName.toLowerCase()));
                String value = StringUtils.getObjectString(map.get(valueName.toLowerCase()));
                Entry entry = new Entry(value, text);
                entryList.add(entry);
            }
            rowSet.setEntryList(entryList);
            rowSet.setNoPermFieldIndexs(noPermissionIndex);
        }
        return rowSet;
    }

    private List<TreeNodeEntry> getF7Result(String textName, String valueName, F7Ctrl ctrl, List<Map<String, Object>> resultList, Map<String, String> fieldAliasMap, List<Integer> noPermissionIndex) {
        Set hiddenFields = ctrl.getHiddenFields();
        ArrayList hiddenFieldsList = new ArrayList(0);
        if (hiddenFields != null && !hiddenFields.isEmpty()) {
            hiddenFieldsList.addAll(hiddenFields);
        }
        HashSet noPermField = new HashSet(noPermissionIndex.size());
        ArrayList<String> fields = new ArrayList<String>(fieldAliasMap.keySet());
        for (Integer index : noPermissionIndex) {
            noPermField.add(fields.get(index));
        }
        ArrayList<TreeNodeEntry> entryList = new ArrayList<TreeNodeEntry>(resultList.size());
        boolean flag = false;
        for (Map<String, Object> row : resultList) {
            String text = StringUtils.getObjectString((Object)row.get(textName.toLowerCase()));
            String value = StringUtils.getObjectString((Object)row.get(valueName.toLowerCase()));
            TreeNodeEntry entry = new TreeNodeEntry(value, text);
            for (String hiddenField : hiddenFieldsList) {
                row.remove(hiddenField.toLowerCase());
                if (flag) continue;
                fieldAliasMap.remove(hiddenField.toLowerCase());
                noPermField.remove(hiddenField.toLowerCase());
            }
            flag = true;
            entry.setRows(row);
            entryList.add(entry);
        }
        ArrayList<Integer> newNoPermIndex = new ArrayList<Integer>(fieldAliasMap.size());
        fields = new ArrayList<String>(fieldAliasMap.keySet());
        for (int i = 0; i < fields.size(); ++i) {
            if (!noPermField.contains(fields.get(i))) continue;
            newNoPermIndex.add(i);
        }
        noPermissionIndex.clear();
        noPermissionIndex.addAll(newNoPermIndex);
        String currentNodeIdName = valueName.toLowerCase();
        String parentNodeIdName = "parentnodeid";
        ParamF7TreeType treeType = ctrl.getTreeType();
        ParamBindSourceType bindSourceType = ctrl.getBindSourceType();
        switch (treeType) {
            case NOT_TREE: {
                break;
            }
            case PARENT_CHILD: {
                if (bindSourceType == ParamBindSourceType.SYSTEM) {
                    currentNodeIdName = "id";
                    parentNodeIdName = "parentId";
                    break;
                }
                currentNodeIdName = ctrl.getCurrentField().toLowerCase();
                parentNodeIdName = ctrl.getParentField().toLowerCase();
                break;
            }
            case LONG_NUMBER: {
                String longNumberName = ctrl.getLongNumberField();
                String nodeSeparator = ctrl.getSeparator();
                this.translateLongNumberTreeType(resultList, longNumberName, nodeSeparator, currentNodeIdName, parentNodeIdName);
                break;
            }
        }
        for (int i = 0; i < entryList.size(); ++i) {
            TreeNodeEntry entry = (TreeNodeEntry)entryList.get(i);
            Map<String, Object> mapitem = resultList.get(i);
            entry.setId(StringUtils.getObjectString((Object)mapitem.get(currentNodeIdName)));
            entry.setParentId(StringUtils.getObjectString((Object)mapitem.get(parentNodeIdName)));
        }
        this.setParentIdNull(entryList);
        return entryList;
    }

    private void setParentIdNull(List<TreeNodeEntry> entryList) {
        for (TreeNodeEntry entry : entryList) {
            if (!entry.getId().equals(entry.getParentId())) continue;
            entry.setParentId(null);
        }
    }

    private void execBindSource(ParameterBO currentParamBO, List<OutputColumn> outputColumns, List<Map<String, Object>> resultList, List<Integer> noPermissionIndex, Map<String, String> fieldMap, Map<String, String> paramValues) throws DataSetException, ExtMacroException, SuperQueryNoPermissionException, SQLException, AbstractQingIntegratedException {
        AbstractCtrl ctrl = currentParamBO.getParameter().getCtrl();
        if (!(ctrl instanceof AbstractBindSourceCtrl)) {
            return;
        }
        IDataSourceProcessor processor = DataSourceFactory.getDataSourceProcessor((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (ITransactionManagement)this.tx, (ParameterBO)currentParamBO, (AbstractParameterSupplier)new F7ParameterSupplier(this.qingContext, this.dbExcuter, this.tx, currentParamBO, paramValues), (boolean)true);
        ResultSet resultSet = null;
        try {
            resultSet = processor.process(-1);
        }
        catch (ExtMacroException e) {
            throw e;
        }
        catch (SuperQueryNoPermissionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(DataSetErrorCodeEnum.EXEC_BIND_SOURCE_EXCEPTION, (Throwable)e);
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (resultSet instanceof MacroResultSet) {
            List noPermissions = ((MacroResultSet)resultSet).getNoPermissionIndex();
            if (noPermissions != null && !noPermissions.isEmpty()) {
                noPermissionIndex.addAll(noPermissions);
            }
        } else if (resultSet instanceof SysVarResultSet) {
            outputColumns = new ArrayList<OutputColumn>(4);
            OutputColumn column = new OutputColumn();
            column.setName("id");
            column.setAlias("ID");
            outputColumns.add(column);
            column = new OutputColumn();
            column.setName("number");
            column.setAlias(MserviceRptMessages.getMLS((String)"organizationCode", (String)"\u7ec4\u7ec7\u7f16\u7801"));
            outputColumns.add(column);
            column = new OutputColumn();
            column.setName("name");
            column.setAlias(MserviceRptMessages.getMLS((String)"organizationName", (String)"\u7ec4\u7ec7\u540d\u79f0"));
            outputColumns.add(column);
            if (ctrl instanceof F7Ctrl) {
                HashSet<String> hiddenFields = ((F7Ctrl)ctrl).getHiddenFields();
                if (hiddenFields == null) {
                    hiddenFields = new HashSet<String>(2);
                }
                hiddenFields.add("parentid");
                ((F7Ctrl)ctrl).setHiddenFields(hiddenFields);
            }
        }
        int columnCount = metaData.getColumnCount();
        while (resultSet.next()) {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                Object obj = resultSet.getObject(i);
                int type = metaData.getColumnType(i);
                if (type == 2004) {
                    obj = BlobBO.readBlob((ResultSet)resultSet, (int)i);
                }
                row.put(metaData.getColumnName(i).toLowerCase(), StringUtils.getObjectString((Object)obj));
            }
            resultList.add(row);
        }
        LinkedHashMap<String, OutputColumn> nameAlisaMap = new LinkedHashMap<String, OutputColumn>(4);
        if (outputColumns != null && !outputColumns.isEmpty()) {
            for (OutputColumn column : outputColumns) {
                nameAlisaMap.put(column.getName().toLowerCase(), column);
            }
        }
        for (int i = 0; i < columnCount; ++i) {
            String columnName = metaData.getColumnName(i + 1).toLowerCase();
            OutputColumn column = (OutputColumn)nameAlisaMap.get(columnName);
            if (column == null) {
                fieldMap.put(columnName, columnName);
                continue;
            }
            fieldMap.put(columnName, column.getAlias());
        }
    }

    private Map<String, String> parseParamValues(String paramValues) {
        HashMap<String, String> params = new HashMap<String, String>(8);
        JsonElement paramValuesJsonElement = JsonParser.parseString((String)paramValues);
        if (paramValuesJsonElement.isJsonArray()) {
            JsonArray jsonArray = paramValuesJsonElement.getAsJsonArray();
            int length = jsonArray.size();
            for (int index = 0; index < length; ++index) {
                String paramValue;
                JsonObject jsonObject;
                JsonElement vs;
                JsonElement o = jsonArray.get(index);
                if (!o.isJsonObject() || !(vs = (jsonObject = o.getAsJsonObject()).get("paramValues")).isJsonArray()) continue;
                JsonArray vsArray = vs.getAsJsonArray();
                String paramName = jsonObject.get("paramName").getAsString();
                if (vsArray.size() == 1) {
                    paramValue = "";
                    if (!vsArray.get(0).isJsonNull()) {
                        paramValue = vsArray.get(0).getAsString();
                    }
                    params.put(paramName, paramValue);
                    continue;
                }
                if (vsArray.size() <= 1) continue;
                paramValue = vsArray.get(0).getAsString();
                StringBuilder sb = new StringBuilder();
                sb.append(paramValue);
                int length2 = vsArray.size();
                for (int index2 = 1; index2 < length2; ++index2) {
                    sb.append("0xx1xx");
                    sb.append(vsArray.get(index2).getAsString());
                }
                params.put(paramName, sb.toString());
            }
        }
        return params;
    }

    public void translateLongNumberTreeType(List<Map<String, Object>> rowList, String longnumbeName, String nodeSeparator, String currentNodeIdName, String parentNodeIdName) {
        if (rowList == null) {
            return;
        }
        longnumbeName = longnumbeName.toLowerCase();
        currentNodeIdName = currentNodeIdName.toLowerCase();
        parentNodeIdName = parentNodeIdName.toLowerCase();
        for (Map<String, Object> map : rowList) {
            String longNumber = StringUtils.getObjectString((Object)map.get(longnumbeName));
            map.put(currentNodeIdName, longNumber);
            int lastIndex = longNumber.lastIndexOf(nodeSeparator);
            if (longNumber.lastIndexOf(nodeSeparator) < 0) {
                map.put(parentNodeIdName, "");
                continue;
            }
            String parentLongNumber = longNumber.substring(0, lastIndex);
            map.put(parentNodeIdName, parentLongNumber);
        }
    }

    public String[] analysisParamJson(JsonElement oJson, String type, int index) {
        JsonObject jsonObject = oJson.getAsJsonObject();
        JsonElement jsonElement = jsonObject.get(type);
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        jsonElement = jsonArray.get(index);
        jsonArray = jsonElement.getAsJsonArray();
        int count = jsonArray.size();
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            String str;
            ret[i] = str = jsonArray.get(i).getAsString();
        }
        return ret;
    }

    public FilterSchemeInfo saveDataSetFilterScheme(String dataSetId, List<ParameterBO> boList, String schemeName, ShareStrategy shareStrategy, boolean isDefaultChange, Object[] valueParams, Object[] captionParams, Object[] nameParams) throws SQLException, AbstractQingIntegratedException, JAXBException {
        FilterSchemeInfo info = new FilterSchemeInfo();
        if (schemeName.contains("script") || schemeName.contains("iframe") || schemeName.contains("<") || schemeName.contains(">")) {
            info.setInvalid(true);
            return info;
        }
        FilterScheme scheme = FilterScheme.createFilterScheme((String)schemeName, (Object[])valueParams, (Object[])captionParams, (ShareStrategy)shareStrategy, (String)dataSetId, (Object[])nameParams);
        ExtFilterScheme extFilterScheme = new ExtFilterScheme();
        extFilterScheme.setName(schemeName);
        extFilterScheme.setOwnerId(this.getOwnerId(shareStrategy.ordinal()));
        extFilterScheme.setReportId(dataSetId);
        extFilterScheme.setShareStrategy(shareStrategy.ordinal());
        extFilterScheme.setNextDirectlyInto(isDefaultChange);
        LinkedHashMap<String, ParameterBO> parameterBOMap = new LinkedHashMap<String, ParameterBO>(boList.size());
        for (ParameterBO param : boList) {
            parameterBOMap.put(param.getParameter().getName(), param);
        }
        int count = nameParams.length;
        LinkedHashMap<String, ParameterBO> paramValues = new LinkedHashMap<String, ParameterBO>(count);
        for (int index = 0; index < count; ++index) {
            String paramName = (String)nameParams[index];
            Parameter parameter = new Parameter();
            ParameterBO parameterBO = new ParameterBO(parameter);
            parameter.setName(paramName);
            parameter.setDataType(((ParameterBO)parameterBOMap.get(paramName)).getParameter().getDataType());
            List valueParam = (List)valueParams[index];
            StringBuilder currentValue = new StringBuilder();
            for (String value : valueParam) {
                if (currentValue.length() > 0) {
                    currentValue.append("0xx1xx");
                }
                currentValue.append(value);
            }
            parameterBO.setCurrentValue(currentValue.toString());
            List captionParam = (List)captionParams[index];
            StringBuilder currentAlias = new StringBuilder();
            for (String caption : captionParam) {
                if (currentAlias.length() > 0) {
                    currentAlias.append("0xx1xx");
                }
                currentAlias.append(caption);
            }
            parameterBO.setCurrentValueAlias(currentAlias.toString());
            paramValues.put(paramName, parameterBO);
        }
        String content = this.toFilterSolutionXml(paramValues);
        extFilterScheme.setContent(content);
        this.getFilterSchemeDomain().saveOrUpdateFilterScheme(extFilterScheme);
        info.setCaption(schemeName);
        info.setValue(scheme.toString());
        info.setShareStrategy(extFilterScheme.getShareStrategy());
        return info;
    }

    private String getOwnerId(int shareStrategy) {
        String ownerId = null;
        if (ShareStrategy.ALL.ordinal() != shareStrategy && ShareStrategy.USER_ONLY.ordinal() == shareStrategy) {
            ownerId = this.qingContext.getUserId();
        }
        return ownerId;
    }

    public String toFilterSolutionXml(Map<String, ParameterBO> parameterBOMap) {
        IXmlElement e = XmlUtil.createNode((String)FILTER_FIELDS);
        e.setAttribute("version", "2");
        Set<Map.Entry<String, ParameterBO>> entrySet = parameterBOMap.entrySet();
        for (Map.Entry<String, ParameterBO> entry : entrySet) {
            ParameterBO p = entry.getValue();
            String paramName = p.getParameter().getName();
            String paramValue = StringUtils.getObjectString((Object)p.getCurrentValue());
            String paramValueAlias = StringUtils.getObjectString((Object)p.getCurrentValueAlias());
            String paramType = String.valueOf(p.getParameter().getDataType().getType());
            IXmlElement et = XmlUtil.createNode((String)FILTER_FIELD);
            et.setAttribute("dataType", paramType);
            et.setAttribute("name", paramName);
            et.setAttribute("value", paramValue);
            et.setAttribute("valueAlias", paramValueAlias);
            e.addChild(et);
        }
        String xmlStr = XmlUtil.toString((IXmlElement)e);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + xmlStr;
    }

    public boolean delDataSetFilterScheme(String dataSetId, String filterName, ShareStrategy shareStrategy) throws AbstractQingIntegratedException, SQLException {
        return this.getFilterSchemeDomain().deleteFilterSchemeByFilterName(dataSetId, filterName, shareStrategy);
    }
}

