/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.model.bo;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.ParameterBO;
import kd.bos.mservice.extreport.dataset.model.po.AbstractDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.OQLDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.SQLDataSetModel;
import kd.bos.mservice.extreport.dataset.model.po.parameter.Parameter;

public class DataSetModelBO {
    private AbstractDataSetModel dataSetModel;
    private String dataSetID;
    private String dataSetName;
    private String description;
    private String creatorId;
    private List<ParameterBO> parameterBOList;
    private boolean isCheckExecutable = true;

    public DataSetModelBO(AbstractDataSetModel dataSetModel, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExecuter) throws DataSetException, AbstractQingIntegratedException, SQLException {
        this.dataSetModel = dataSetModel.copy();
        List parameters = this.dataSetModel.getParameters();
        if (parameters != null) {
            HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>(parameters.size());
            for (Parameter parameter : parameters) {
                parameterMap.put(parameter.getName(), parameter);
            }
            AbstractDataSetModel.ParamRelationRootModel paramRelationRootModel = this.dataSetModel.getParamRelationRootModel();
            if (paramRelationRootModel == null) {
                paramRelationRootModel = new AbstractDataSetModel.ParamRelationRootModel();
                paramRelationRootModel.initParamRelationFromModel(this.dataSetModel, qingContext, tx, dbExecuter);
            }
            this.parameterBOList = new ArrayList<ParameterBO>(parameters.size());
            for (Parameter parameter : parameters) {
                Parameter[] relates;
                ParameterBO parameterBO = new ParameterBO(parameter);
                Parameter[][] suppliers = paramRelationRootModel.fetchSupplierParams(parameter.getName());
                if (suppliers != null && suppliers.length > 0) {
                    for (Parameter[] supplier : suppliers) {
                        if (supplier[1] != null) {
                            parameterBO.addSupplierParam(supplier[0], (Parameter)parameterMap.get(supplier[1].getName()));
                            continue;
                        }
                        parameterBO.addSupplierParam(supplier[0], null);
                    }
                }
                if ((relates = paramRelationRootModel.fetchRelatedParams(parameter.getName())) != null && relates.length > 0) {
                    for (Parameter relateParam : relates) {
                        parameterBO.addRelatedParam((Parameter)parameterMap.get(relateParam.getName()));
                    }
                }
                this.parameterBOList.add(parameterBO);
            }
        }
    }

    public String makeSql() {
        if (this.dataSetModel instanceof SQLDataSetModel) {
            return ((SQLDataSetModel)this.dataSetModel).getSql();
        }
        if (this.dataSetModel instanceof OQLDataSetModel) {
            return ((OQLDataSetModel)this.dataSetModel).getOql();
        }
        throw new UnsupportedOperationException("Not support for the type: " + this.dataSetModel.getDataSetType());
    }

    public String getDataSetID() {
        return this.dataSetID;
    }

    public void setDataSetID(String dataSetID) {
        this.dataSetID = dataSetID;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public AbstractDataSetModel getDataSetModel() {
        return this.dataSetModel;
    }

    public List<ParameterBO> getParameterBOList() {
        return this.parameterBOList;
    }

    public void setCheckExecutable(boolean isCheckExecutable) {
        this.isCheckExecutable = isCheckExecutable;
    }

    public boolean isCheckExecutable() {
        return this.isCheckExecutable;
    }
}

