/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.model.check.impl;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.dataset.constant.DataSetModeCheckInfo;
import kd.bos.mservice.extreport.dataset.constant.DataSetModelCheckType;
import kd.bos.mservice.extreport.dataset.constant.DataSetType;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.check.AbstractDataSetModelChecker;
import kd.bos.mservice.extreport.dataset.model.check.DataSetModelCheckResult;
import kd.bos.mservice.extreport.dataset.model.check.DataSetModelCheckerChain;
import kd.bos.mservice.extreport.dataset.model.po.AbstractDataSetModel;
import kd.bos.mservice.extreport.util.DataSetExecuteChecker;

public abstract class DataSourceChecker
extends AbstractDataSetModelChecker {
    public void checkModel(DataSetModelBO dataSetModelBO, Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkResultMap, DataSetModelCheckerChain dataSetModelCheckerChain) throws AbstractQingException, SQLException {
        if (dataSetModelBO.getDataSetModel().isEmpty()) {
            this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_UNDEFINED));
        } else {
            this.checkDataSource(dataSetModelBO, checkResultMap);
        }
        super.checkModel(dataSetModelBO, checkResultMap, dataSetModelCheckerChain);
    }

    public abstract void checkDataSource(DataSetModelBO var1, Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> var2) throws AbstractQingException, SQLException;

    protected void checkDataSource(DataSetModelBO dataSetModelBO) throws DataSetException {
        boolean isCheckExecutable = dataSetModelBO.isCheckExecutable();
        if (!DataSetExecuteChecker.checkDataSetExecutableById(dataSetModelBO.getDataSetID()) && isCheckExecutable) {
            String message = MserviceRptMessages.getMLS((String)"suggestInfo3", (String)"\u8bf7\u4f18\u5316\u6570\u636e\u96c6\u540e\uff0c");
            String executableMsg = DataSetErrorCodeEnum.DATA_SET_REJECT_EXEC_EXCEPTION.getMessage();
            executableMsg = String.format(executableMsg, message);
            throw new DataSetException(executableMsg, DataSetErrorCodeEnum.DATA_SET_REJECT_EXEC_EXCEPTION.getCode());
        }
    }

    protected boolean isSqlDataSetModel(DataSetModelBO dataSetModelBO) {
        return this.getDataSetType(dataSetModelBO) == DataSetType.SQL_DATA_SET;
    }

    protected boolean isQqlDataSetModel(DataSetModelBO dataSetModelBO) {
        return this.getDataSetType(dataSetModelBO) == DataSetType.OQL_DATA_SET;
    }

    private DataSetType getDataSetType(DataSetModelBO dataSetModelBO) {
        AbstractDataSetModel dataSetModel = dataSetModelBO.getDataSetModel();
        return dataSetModel.getDataSetType();
    }
}

