/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.model.check.impl;

import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.Map;
import java.util.Set;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.dataset.constant.DataSetModeCheckInfo;
import kd.bos.mservice.extreport.dataset.constant.DataSetModelCheckType;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.check.DataSetModelCheckResult;
import kd.bos.mservice.extreport.dataset.model.check.impl.DataSourceChecker;
import kd.bos.mservice.extreport.dataset.model.entity.EntityHelper;
import kd.bos.mservice.extreport.dataset.model.po.OQLDataSetModel;

public class OQLDataSetModelDataSourceChecker
extends DataSourceChecker {
    @Override
    public void checkDataSource(DataSetModelBO dataSetModelBO, Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkResultMap) {
        try {
            this.checkDataSource(dataSetModelBO);
        }
        catch (DataSetException e) {
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATA_SET_REJECT_EXEC_EXCEPTION.getCode()) {
                String message = MserviceRptMessages.getMLS((String)"suggestInfo1", (String)"\u8bf7\u4f18\u5316\u67e5\u8be2\u8bed\u53e5\u540e\uff0c");
                String executableMsg = DataSetModeCheckInfo.DATASET_EXECUTABLE.getMsg();
                executableMsg = String.format(executableMsg, message);
                this.addCheckResult(checkResultMap, DataSetModelCheckType.AVAILABLE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATASET_EXECUTABLE.getCode(), executableMsg));
            }
            this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(String.valueOf(e.getErrorCode()), e.getMessage()));
        }
    }

    @Override
    public void checkDataSource(DataSetModelBO dataSetModelBO) throws DataSetException {
        if (this.isQqlDataSetModel(dataSetModelBO) && !IntegratedHelper.getPresetUserId().equals(dataSetModelBO.getCreatorId())) {
            boolean isSupportQing;
            OQLDataSetModel oqlDataSetModel = (OQLDataSetModel)dataSetModelBO.getDataSetModel();
            String entityName = oqlDataSetModel.getEntityName();
            String parsedEntityName = oqlDataSetModel.parseEntityName(oqlDataSetModel.getOql());
            if (StringUtils.isNotBlank((CharSequence)parsedEntityName) && !entityName.equals(parsedEntityName)) {
                entityName = parsedEntityName;
            }
            if (!(isSupportQing = EntityHelper.isSupportQingAnalysis((String)entityName))) {
                String message = DataSetErrorCodeEnum.DATASET_ENTITY_NO_SUPPORT_QING.getMessage().replace("#1", entityName);
                throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_ENTITY_NO_SUPPORT_QING);
            }
            boolean hasPermission = EntityHelper.hasPermission((long)Long.parseLong(dataSetModelBO.getCreatorId()), (String)entityName);
            if (!hasPermission) {
                String message = DataSetErrorCodeEnum.DATASET_NO_ENTITY_PERMISSION.getMessage().replace("#1", entityName);
                throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_ENTITY_PERMISSION);
            }
        }
        super.checkDataSource(dataSetModelBO);
    }
}

