/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.model.check.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.SuperQuerySource;
import com.kingdee.bos.qing.util.IntegratedHelper;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.dataset.constant.DataSetModeCheckInfo;
import kd.bos.mservice.extreport.dataset.constant.DataSetModelCheckType;
import kd.bos.mservice.extreport.dataset.constant.DataSourceType;
import kd.bos.mservice.extreport.dataset.domain.ExtReportDataSetDesignerDomain;
import kd.bos.mservice.extreport.dataset.exception.DataSetErrorCodeEnum;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.bo.DataSetModelBO;
import kd.bos.mservice.extreport.dataset.model.check.DataSetModelCheckResult;
import kd.bos.mservice.extreport.dataset.model.check.impl.DataSourceChecker;
import kd.bos.mservice.extreport.dataset.model.po.SQLDataSetModel;
import kd.bos.mservice.extreport.designer.domain.DataSetDesignerDomain;
import kd.bos.mservice.qing.util.AppUtil;

public class SQLDataSetModelDataSourceChecker
extends DataSourceChecker {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private ExtReportDataSetDesignerDomain extReportDataSetDesignerDomain;
    private DataSetDesignerDomain dataSetDesignerDomain;

    public SQLDataSetModelDataSourceChecker(QingContext qingContext, ITransactionManagement tx, IDBExcuter idbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.dbExcuter = idbExcuter;
    }

    private ExtReportDataSetDesignerDomain getExtReportDataSetDesignerDomain() {
        if (this.extReportDataSetDesignerDomain == null) {
            this.extReportDataSetDesignerDomain = new ExtReportDataSetDesignerDomain(this.qingContext, this.dbExcuter, this.tx);
        }
        return this.extReportDataSetDesignerDomain;
    }

    private DataSetDesignerDomain getDataSetDesignerDomain() {
        if (this.dataSetDesignerDomain == null) {
            this.dataSetDesignerDomain = new DataSetDesignerDomain();
            this.dataSetDesignerDomain.setQingContext(this.qingContext);
            this.dataSetDesignerDomain.setDbExcuter(this.dbExcuter);
            this.dataSetDesignerDomain.setTx(this.tx);
        }
        return this.dataSetDesignerDomain;
    }

    @Override
    public void checkDataSource(DataSetModelBO dataSetModelBO, Map<DataSetModelCheckType, Set<DataSetModelCheckResult>> checkResultMap) throws AbstractQingException, SQLException {
        try {
            this.checkDataSource(dataSetModelBO);
        }
        catch (DataSetException e) {
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_DATA_CENTER_PERMISSION.getCode()) {
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_DATA_CENTER_NO_PERM));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_DATA_CENTER_APP_EXP.getCode()) {
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_DATA_CENTER_APP_EXP.getCode(), e.getMessage()));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_SUPER_QUERY_PERMISSION.getCode()) {
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_SUPER_QUERY_NO_PERM.getCode(), e.getMessage()));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_SUPER_QUERY_PERMISSION2.getCode()) {
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_SUPER_QUERY_NO_PERM2.getCode(), e.getMessage()));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NOT_EXIST_EXCEPTION.getCode()) {
                String dataSourceName = ((SQLDataSetModel)dataSetModelBO.getDataSetModel()).getDataSourceName();
                String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION1.getMessage().replace("#1", dataSourceName);
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_OUT_DB_NO_PERM1.getCode(), message));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_PERMISSION_EXCEPTION.getCode()) {
                String dataSourceName = ((SQLDataSetModel)dataSetModelBO.getDataSetModel()).getDataSourceName();
                String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION2.getMessage().replace("#1", dataSourceName);
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_OUT_DB_NO_PERM2.getCode(), message));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION3.getCode()) {
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_OUT_DB_NO_PERM3.getCode(), e.getMessage()));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION.getCode()) {
                this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATA_SOURCE_OUT_DB_NO_PERM));
            }
            if (e.getErrorCode() == DataSetErrorCodeEnum.DATA_SET_REJECT_EXEC_EXCEPTION.getCode()) {
                String message = MserviceRptMessages.getMLS((String)"suggestInfo1", (String)"\u8bf7\u4f18\u5316\u67e5\u8be2\u8bed\u53e5\u540e\uff0c");
                String executableMsg = DataSetModeCheckInfo.DATASET_EXECUTABLE.getMsg();
                executableMsg = String.format(executableMsg, message);
                this.addCheckResult(checkResultMap, DataSetModelCheckType.AVAILABLE, new DataSetModelCheckResult(DataSetModeCheckInfo.DATASET_EXECUTABLE.getCode(), executableMsg));
            }
            this.addCheckResult(checkResultMap, DataSetModelCheckType.DATA_SOURCE, new DataSetModelCheckResult(String.valueOf(e.getErrorCode()), e.getMessage()));
        }
    }

    @Override
    public void checkDataSource(DataSetModelBO dataSetModelBO) throws DataSetException {
        if (this.isSqlDataSetModel(dataSetModelBO) && !IntegratedHelper.getPresetUserId().equals(dataSetModelBO.getCreatorId())) {
            SQLDataSetModel sqlDataSetModel = (SQLDataSetModel)dataSetModelBO.getDataSetModel();
            DataSourceType dataSourceType = sqlDataSetModel.getDataSourceType();
            String dataSourceName = sqlDataSetModel.getDataSourceName();
            if (DataSourceType.DATA_CENTER == dataSourceType) {
                this.checkDataCenter(dataSetModelBO, dataSourceName);
            } else if (DataSourceType.SUPER_QUERY == dataSourceType) {
                this.checkSuperQuery(dataSetModelBO, dataSourceName);
            } else {
                this.checkOutDB(dataSetModelBO, dataSourceName);
            }
        }
        super.checkDataSource(dataSetModelBO);
    }

    private void checkDataCenter(DataSetModelBO dataSetModelBO, String dataCenterName) throws DataSetException {
        String createrId = dataSetModelBO.getCreatorId();
        if (!this.getDataSetDesignerDomain().checkDBCenterPermissionByUserId(createrId)) {
            throw new DataSetException(DataSetErrorCodeEnum.DATASET_NO_DATA_CENTER_PERMISSION);
        }
        try {
            AppUtil.checkAppPerm((String)dataCenterName);
        }
        catch (AbstractQingException e) {
            throw new DataSetException(e.getMessage(), DataSetErrorCodeEnum.DATASET_DATA_CENTER_APP_EXP);
        }
    }

    private void checkSuperQuery(DataSetModelBO dataSetModelBO, String schemaName) throws DataSetException {
        SuperQuerySource source = new SuperQuerySource();
        source.setSchema(schemaName);
        DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource((AbstractSource)source);
        AbstractDBSourceJDBCAdapter jdbcAdapter = null;
        try {
            jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance((AbstractSource)dbSource);
        }
        catch (UnSupportDataSourceException e) {
            throw new DataSetException(e.getMessage(), (Throwable)e);
        }
        IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource((AbstractSource)source);
        try {
            if (jdbcAdapter != null) {
                jdbcAdapter.setConnectionFactory(connFactory);
                jdbcAdapter.checkConnection(this.qingContext, (AbstractSource)dbSource);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                int errorCode = ((SQLException)cause).getErrorCode();
                if (errorCode == 1089 || errorCode == 1067) {
                    String message = DataSetErrorCodeEnum.DATASET_NO_SUPER_QUERY_PERMISSION.getMessage().replace("#1", schemaName);
                    throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_SUPER_QUERY_PERMISSION);
                }
                if (errorCode == 20002) {
                    throw new DataSetException(DataSetErrorCodeEnum.DATASET_NO_SUPER_QUERY_PERMISSION2);
                }
            }
            throw new DataSetException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkOutDB(DataSetModelBO dataSetModelBO, String outDBName) throws DataSetException {
        String creatorId = dataSetModelBO.getCreatorId();
        int result = 0;
        try {
            result = this.getDataSetDesignerDomain().checkDataSourceTouchable(creatorId, outDBName);
        }
        catch (AbstractQingIntegratedException e) {
            throw new DataSetException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DataSetException((Throwable)e);
        }
        if (result == 0) {
            try {
                this.getExtReportDataSetDesignerDomain().checkOutDBConnection(dataSetModelBO);
            }
            catch (Exception e) {
                String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION3.getMessage().replace("#1", outDBName);
                throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION3);
            }
        }
        String message = DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION.getMessage();
        if (result == 8099002) {
            message = MserviceRptMessages.getMLS((String)"dataSourceDeletedInPublic", (String)"\u6570\u636e\u6e90\"#1\"\u5df2\u5728\"\u516c\u5171\u6570\u636e\u6e90\"\u4e2d\u5220\u9664, \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002").replace("#1", outDBName);
            throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NOT_EXIST_EXCEPTION);
        }
        if (result == 8099007) {
            String creatorName = creatorId;
            try {
                creatorName = IntegratedHelper.getUserName((String)creatorId);
            }
            catch (IntegratedRuntimeException integratedRuntimeException) {
                // empty catch block
            }
            message = MserviceRptMessages.getMLS((String)"dataSourceUnauthorizedForCreator", (String)"\u6570\u636e\u6e90\"#1\"\u5df2\u5728\"\u516c\u5171\u6570\u636e\u6e90\"\u4e2d\u53d6\u6d88\u6388\u6743\u7ed9\u6570\u636e\u96c6\u521b\u5efa\u4eba\"#2\", \u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002").replace("#1", outDBName).replace("#2", creatorName);
            throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_PERMISSION_EXCEPTION);
        }
        throw new DataSetException(message, DataSetErrorCodeEnum.DATASET_NO_OUT_DB_PERMISSION);
    }
}

