/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.dataset.model.po;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import java.lang.reflect.InvocationTargetException;
import kd.bos.mservice.extreport.dataset.constant.DataSetType;
import kd.bos.mservice.extreport.dataset.constant.DataSourceType;
import kd.bos.mservice.extreport.dataset.constant.SqlType;
import kd.bos.mservice.extreport.dataset.model.po.AbstractDataSetModel;
import kd.bos.mservice.extreport.util.StringUtils;

public class SQLDataSetModel
extends AbstractDataSetModel {
    private DataSourceType dataSourceType;
    private String dataSourceName;
    private SqlType sqlType;
    private String dbType;
    private String sql;

    public SQLDataSetModel() {
        super(DataSetType.SQL_DATA_SET);
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getFullDataSourceName() {
        return this.dataSourceType.getPrefix() + this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    public String getDBType() {
        return this.dbType;
    }

    public void setDBType(String dbType) {
        this.dbType = dbType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.dataSourceName);
    }

    public void fromXml(IXmlElement xml) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        IXmlElement query = xml.getChild("Query");
        String outDB = query.getAttribute("OutDB");
        this.setDataSourceType(DataSourceType.getDataSourceType((String)outDB));
        if (StringUtils.isNotEmpty((CharSequence)outDB)) {
            this.setDataSourceName(outDB.substring(this.getDataSourceType().getPrefix().length()));
        } else {
            this.setDataSourceType(DataSourceType.DATA_CENTER);
            this.setDataSourceName("qing_rpt");
        }
        IXmlElement contentXml = query.getChild("Content");
        String sContent = contentXml.getText();
        sContent = sContent.trim();
        boolean isSqlDialect = sContent.startsWith("/*dialect*/");
        if (isSqlDialect || DataSourceType.isSuperQuery((DataSourceType)this.dataSourceType)) {
            this.setSqlType(SqlType.SQL);
            if (isSqlDialect) {
                this.setSql(sContent.substring("/*dialect*/".length()));
            } else {
                this.setSql(sContent);
            }
        } else {
            this.setSqlType(SqlType.KSQL);
            this.setSql(sContent);
        }
        super.fromXml(xml);
    }

    protected IXmlElement toXml() {
        IXmlElement xml = super.toXml();
        IXmlElement query = XmlUtil.createNode((String)"Query");
        query.setAttribute("version", "1.0");
        query.setAttribute("type", "sql.custom");
        query.addChild(XmlUtil.createNode((String)"Columns"));
        query.addChild(XmlUtil.createNode((String)"Tables"));
        query.addChild(XmlUtil.createNode((String)"Joins"));
        query.addChild(XmlUtil.createNode((String)"Orders"));
        IXmlElement filter = XmlUtil.createNode((String)"Filter");
        filter.addCData("");
        query.addChild(filter);
        IXmlElement content = XmlUtil.createNode((String)"Content");
        if (SqlType.SQL == this.sqlType && !DataSourceType.isSuperQuery((DataSourceType)this.dataSourceType)) {
            content.addCData("/*dialect*/" + this.sql);
        } else {
            content.addCData(this.sql);
        }
        query.addChild(content);
        query.setAttribute("goodOutput", "true");
        query.setAttribute("OutDB", this.dataSourceType.getFullDataSourceName(this.dataSourceName));
        xml.addChild(query);
        return xml;
    }
}

